/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;

public abstract class Sensor<E extends EntityLiving> {
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final int DEFAULT_SCAN_RATE = 20;
    protected static final int TARGETING_RANGE = 16;
    private static final PathfinderTargetCondition TARGET_CONDITIONS = PathfinderTargetCondition.forNonCombat().range(16.0);
    private static final PathfinderTargetCondition TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreInvisibilityTesting();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS = PathfinderTargetCondition.forCombat().range(16.0);
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = PathfinderTargetCondition.forCombat().range(16.0).ignoreInvisibilityTesting();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = PathfinderTargetCondition.forCombat().range(16.0).ignoreLineOfSight();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = PathfinderTargetCondition.forCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final int scanRate;
    private long timeToTick;

    public Sensor(int var0) {
        this.scanRate = var0;
        this.timeToTick = RANDOM.nextInt(var0);
    }

    public Sensor() {
        this(20);
    }

    public final void tick(WorldServer var0, E var1) {
        if (--this.timeToTick <= 0L) {
            this.timeToTick = this.scanRate;
            this.doTick(var0, var1);
        }
    }

    protected abstract void doTick(WorldServer var1, E var2);

    public abstract Set<MemoryModuleType<?>> requires();

    public static boolean isEntityTargetable(EntityLiving var0, EntityLiving var1) {
        if (var0.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var1)) {
            return TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1);
        }
        return TARGET_CONDITIONS.test(var0, var1);
    }

    public static boolean isEntityAttackable(EntityLiving var0, EntityLiving var1) {
        if (var0.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var1)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1);
        }
        return ATTACK_TARGET_CONDITIONS.test(var0, var1);
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(EntityLiving var0, EntityLiving var1) {
        if (var0.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var1)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.test(var0, var1);
        }
        return ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.test(var0, var1);
    }
}

