/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class SensorPiglinSpecific
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT});
    }

    @Override
    protected void doTick(WorldServer var02, EntityLiving var1) {
        EntityPiglinAbstract var17;
        BehaviorController<?> var2 = var1.getBrain();
        var2.setMemory(MemoryModuleType.NEAREST_REPELLENT, SensorPiglinSpecific.findNearestRepellent(var02, var1));
        Optional<Object> var3 = Optional.empty();
        Optional<Object> var4 = Optional.empty();
        Optional<Object> var5 = Optional.empty();
        Optional<Object> var6 = Optional.empty();
        Optional<Object> var7 = Optional.empty();
        Optional<Object> var8 = Optional.empty();
        Optional<Object> var9 = Optional.empty();
        int var10 = 0;
        ArrayList var11 = Lists.newArrayList();
        ArrayList var12 = Lists.newArrayList();
        NearestVisibleLivingEntities var13 = var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (EntityLiving var15 : var13.findAll(var0 -> true)) {
            if (var15 instanceof EntityHoglin) {
                EntityLiving var16 = (EntityHoglin)var15;
                if (((EntityAgeable)var16).isBaby() && var5.isEmpty()) {
                    var5 = Optional.of(var16);
                    continue;
                }
                if (!((EntityHoglin)var16).isAdult()) continue;
                ++var10;
                if (!var4.isEmpty() || !((EntityHoglin)var16).canBeHunted()) continue;
                var4 = Optional.of(var16);
                continue;
            }
            if (var15 instanceof EntityPiglinBrute) {
                var17 = (EntityPiglinBrute)var15;
                var11.add(var17);
                continue;
            }
            if (var15 instanceof EntityPiglin) {
                EntityPiglin var18 = (EntityPiglin)var15;
                if (var18.isBaby() && var6.isEmpty()) {
                    var6 = Optional.of(var18);
                    continue;
                }
                if (!var18.isAdult()) continue;
                var11.add(var18);
                continue;
            }
            if (var15 instanceof EntityHuman) {
                EntityHuman var19 = (EntityHuman)var15;
                if (var8.isEmpty() && !PiglinAI.isWearingGold(var19) && var1.canAttack(var15)) {
                    var8 = Optional.of(var19);
                }
                if (!var9.isEmpty() || var19.isSpectator() || !PiglinAI.isPlayerHoldingLovedItem(var19)) continue;
                var9 = Optional.of(var19);
                continue;
            }
            if (var3.isEmpty() && (var15 instanceof EntitySkeletonWither || var15 instanceof EntityWither)) {
                var3 = Optional.of((EntityInsentient)var15);
                continue;
            }
            if (!var7.isEmpty() || !PiglinAI.isZombified(var15.getType())) continue;
            var7 = Optional.of(var15);
        }
        List<EntityLiving> var14 = var2.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).orElse((List<EntityLiving>)ImmutableList.of());
        for (EntityLiving var16 : var14) {
            if (!(var16 instanceof EntityPiglinAbstract) || !(var17 = (EntityPiglinAbstract)var16).isAdult()) continue;
            var12.add(var17);
        }
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS, var3);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, var4);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, var5);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, var7);
        var2.setMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, var8);
        var2.setMemory(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, var9);
        var2.setMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS, var12);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, var11);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, var11.size());
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, var10);
    }

    private static Optional<BlockPosition> findNearestRepellent(WorldServer var0, EntityLiving var12) {
        return BlockPosition.findClosestMatch(var12.blockPosition(), 8, 4, var1 -> SensorPiglinSpecific.isValidRepellent(var0, var1));
    }

    private static boolean isValidRepellent(WorldServer var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        boolean var3 = var2.is(TagsBlock.PIGLIN_REPELLENTS);
        if (var3 && var2.is(Blocks.SOUL_CAMPFIRE)) {
            return BlockCampfire.isLitCampfire(var2);
        }
        return var3;
    }
}

