/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;

public class SensorVillagerHostiles
extends NearestVisibleLivingEntitySensor {
    private static final ImmutableMap<EntityTypes<?>, Float> ACCEPTABLE_DISTANCE_FROM_HOSTILES = ImmutableMap.builder().put(EntityTypes.DROWNED, (Object)Float.valueOf(8.0f)).put(EntityTypes.EVOKER, (Object)Float.valueOf(12.0f)).put(EntityTypes.HUSK, (Object)Float.valueOf(8.0f)).put(EntityTypes.ILLUSIONER, (Object)Float.valueOf(12.0f)).put(EntityTypes.PILLAGER, (Object)Float.valueOf(15.0f)).put(EntityTypes.RAVAGER, (Object)Float.valueOf(12.0f)).put(EntityTypes.VEX, (Object)Float.valueOf(8.0f)).put(EntityTypes.VINDICATOR, (Object)Float.valueOf(10.0f)).put(EntityTypes.ZOGLIN, (Object)Float.valueOf(10.0f)).put(EntityTypes.ZOMBIE, (Object)Float.valueOf(8.0f)).put(EntityTypes.ZOMBIE_VILLAGER, (Object)Float.valueOf(8.0f)).build();

    @Override
    protected boolean isMatchingEntity(EntityLiving var0, EntityLiving var1) {
        return this.isHostile(var1) && this.isClose(var0, var1);
    }

    private boolean isClose(EntityLiving var0, EntityLiving var1) {
        float var2 = ((Float)ACCEPTABLE_DISTANCE_FROM_HOSTILES.get(var1.getType())).floatValue();
        return var1.distanceToSqr(var0) <= (double)(var2 * var2);
    }

    @Override
    protected MemoryModuleType<EntityLiving> getMemory() {
        return MemoryModuleType.NEAREST_HOSTILE;
    }

    private boolean isHostile(EntityLiving var0) {
        return ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey(var0.getType());
    }
}

