/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class VillageSiege
implements MobSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int zombiesToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    @Override
    public int tick(WorldServer worldserver, boolean flag, boolean flag1) {
        if (!worldserver.isDay() && flag) {
            float f2 = worldserver.getTimeOfDay(0.0f);
            if ((double)f2 == 0.5) {
                State state = this.siegeState = worldserver.random.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.siegeState == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.hasSetupSiege) {
                if (!this.tryToSetupSiege(worldserver)) {
                    return 0;
                }
                this.hasSetupSiege = true;
            }
            if (this.nextSpawnTime > 0) {
                --this.nextSpawnTime;
                return 0;
            }
            this.nextSpawnTime = 2;
            if (this.zombiesToSpawn > 0) {
                this.trySpawn(worldserver);
                --this.zombiesToSpawn;
            } else {
                this.siegeState = State.SIEGE_DONE;
            }
            return 1;
        }
        this.siegeState = State.SIEGE_DONE;
        this.hasSetupSiege = false;
        return 0;
    }

    private boolean tryToSetupSiege(WorldServer worldserver) {
        for (EntityHuman entityHuman : worldserver.players()) {
            BlockPosition blockposition;
            if (entityHuman.isSpectator() || !worldserver.isVillage(blockposition = entityHuman.blockPosition()) || worldserver.getBiome(blockposition).is(BiomeTags.WITHOUT_ZOMBIE_SIEGES)) continue;
            for (int i2 = 0; i2 < 10; ++i2) {
                float f2 = worldserver.random.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = blockposition.getX() + MathHelper.floor(MathHelper.cos(f2) * 32.0f);
                this.spawnY = blockposition.getY();
                this.spawnZ = blockposition.getZ() + MathHelper.floor(MathHelper.sin(f2) * 32.0f);
                if (this.findRandomSpawnPos(worldserver, new BlockPosition(this.spawnX, this.spawnY, this.spawnZ)) == null) continue;
                this.nextSpawnTime = 0;
                this.zombiesToSpawn = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void trySpawn(WorldServer worldserver) {
        Vec3D vec3d = this.findRandomSpawnPos(worldserver, new BlockPosition(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3d != null) {
            EntityZombie entityzombie;
            try {
                entityzombie = new EntityZombie(worldserver);
                entityzombie.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entityzombie.blockPosition()), EnumMobSpawn.EVENT, null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to create zombie for village siege at {}", (Object)vec3d, (Object)exception);
                return;
            }
            entityzombie.moveTo(vec3d.x, vec3d.y, vec3d.z, worldserver.random.nextFloat() * 360.0f, 0.0f);
            worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.VILLAGE_INVASION);
        }
    }

    @Nullable
    private Vec3D findRandomSpawnPos(WorldServer worldserver, BlockPosition blockposition) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int k2;
            int l2;
            int j2 = blockposition.getX() + worldserver.random.nextInt(16) - 8;
            BlockPosition blockposition1 = new BlockPosition(j2, l2 = worldserver.getHeight(HeightMap.Type.WORLD_SURFACE, j2, k2 = blockposition.getZ() + worldserver.random.nextInt(16) - 8), k2);
            if (!worldserver.isVillage(blockposition1) || !EntityMonster.checkMonsterSpawnRules(EntityTypes.ZOMBIE, worldserver, EnumMobSpawn.EVENT, blockposition1, worldserver.random)) continue;
            return Vec3D.atBottomCenterOf(blockposition1);
        }
        return null;
    }

    private static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

