/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float FLAP_DEGREES_PER_TICK = 120.32113f;
    public static final int TICKS_PER_FLAP = MathHelper.ceil(1.4959966f);
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityBee.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Integer> DATA_REMAINING_ANGER_TIME = DataWatcher.defineId(EntityBee.class, DataWatcherRegistry.INT);
    private static final int FLAG_ROLL = 2;
    private static final int FLAG_HAS_STUNG = 4;
    private static final int FLAG_HAS_NECTAR = 8;
    private static final int STING_DEATH_COUNTDOWN = 1200;
    private static final int TICKS_BEFORE_GOING_TO_KNOWN_FLOWER = 2400;
    private static final int TICKS_WITHOUT_NECTAR_BEFORE_GOING_HOME = 3600;
    private static final int MIN_ATTACK_DIST = 4;
    private static final int MAX_CROPS_GROWABLE = 10;
    private static final int POISON_SECONDS_NORMAL = 10;
    private static final int POISON_SECONDS_HARD = 18;
    private static final int TOO_FAR_DISTANCE = 32;
    private static final int HIVE_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int PATHFIND_TO_HIVE_WHEN_CLOSER_THAN = 16;
    private static final int HIVE_SEARCH_DISTANCE = 20;
    public static final String TAG_CROPS_GROWN_SINCE_POLLINATION = "CropsGrownSincePollination";
    public static final String TAG_CANNOT_ENTER_HIVE_TICKS = "CannotEnterHiveTicks";
    public static final String TAG_TICKS_SINCE_POLLINATION = "TicksSincePollination";
    public static final String TAG_HAS_STUNG = "HasStung";
    public static final String TAG_HAS_NECTAR = "HasNectar";
    public static final String TAG_FLOWER_POS = "flower_pos";
    public static final String TAG_HIVE_POS = "hive_pos";
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;
    private float rollAmount;
    private float rollAmountO;
    private int timeSinceSting;
    int ticksWithoutNectarSinceExitingHive;
    public int stayOutOfHiveCountdown;
    private int numCropsGrownSincePollination;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_HIVE = 200;
    int remainingCooldownBeforeLocatingNewHive;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_FLOWER = 200;
    int remainingCooldownBeforeLocatingNewFlower;
    @Nullable
    BlockPosition savedFlowerPos;
    @Nullable
    public BlockPosition hivePos;
    k beePollinateGoal;
    e goToHiveGoal;
    private f goToKnownFlowerGoal;
    private int underWaterTicks;

    public EntityBee(EntityTypes<? extends EntityBee> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.remainingCooldownBeforeLocatingNewFlower = MathHelper.nextInt(this.random, 20, 60);
        this.moveControl = new ControllerMoveFlying(this, 20, true);
        this.lookControl = new j(this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    public float getWalkTargetValue(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.getBlockState(blockposition).isAir() ? 10.0f : 0.0f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new b(this, 1.4f, true));
        this.goalSelector.addGoal(1, new d());
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.is(TagsItem.BEE_FOOD), false));
        this.beePollinateGoal = new k();
        this.goalSelector.addGoal(4, this.beePollinateGoal);
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.25));
        this.goalSelector.addGoal(5, new i());
        this.goToHiveGoal = new e();
        this.goalSelector.addGoal(5, this.goToHiveGoal);
        this.goToKnownFlowerGoal = new f();
        this.goalSelector.addGoal(6, this.goToKnownFlowerGoal);
        this.goalSelector.addGoal(7, new g());
        this.goalSelector.addGoal(8, new l());
        this.goalSelector.addGoal(9, new PathfinderGoalFloat(this));
        this.targetSelector.addGoal(1, new h(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new c(this));
        this.targetSelector.addGoal(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.addAdditionalSaveData(nbttagcompound, true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        super.addAdditionalSaveData(nbttagcompound);
        if (includeAll && this.hasHive()) {
            nbttagcompound.put(TAG_HIVE_POS, GameProfileSerializer.writeBlockPos(this.getHivePos()));
        }
        if (includeAll && this.hasSavedFlowerPos()) {
            nbttagcompound.put(TAG_FLOWER_POS, GameProfileSerializer.writeBlockPos(this.getSavedFlowerPos()));
        }
        nbttagcompound.putBoolean(TAG_HAS_NECTAR, this.hasNectar());
        nbttagcompound.putBoolean(TAG_HAS_STUNG, this.hasStung());
        nbttagcompound.putInt(TAG_TICKS_SINCE_POLLINATION, this.ticksWithoutNectarSinceExitingHive);
        nbttagcompound.putInt(TAG_CANNOT_ENTER_HIVE_TICKS, this.stayOutOfHiveCountdown);
        nbttagcompound.putInt(TAG_CROPS_GROWN_SINCE_POLLINATION, this.numCropsGrownSincePollination);
        this.addPersistentAngerSaveData(nbttagcompound);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.hivePos = GameProfileSerializer.readBlockPos(nbttagcompound, TAG_HIVE_POS).orElse(null);
        this.savedFlowerPos = GameProfileSerializer.readBlockPos(nbttagcompound, TAG_FLOWER_POS).orElse(null);
        super.readAdditionalSaveData(nbttagcompound);
        this.setHasNectar(nbttagcompound.getBoolean(TAG_HAS_NECTAR));
        this.setHasStung(nbttagcompound.getBoolean(TAG_HAS_STUNG));
        this.ticksWithoutNectarSinceExitingHive = nbttagcompound.getInt(TAG_TICKS_SINCE_POLLINATION);
        this.stayOutOfHiveCountdown = nbttagcompound.getInt(TAG_CANNOT_ENTER_HIVE_TICKS);
        this.numCropsGrownSincePollination = nbttagcompound.getInt(TAG_CROPS_GROWN_SINCE_POLLINATION);
        this.readPersistentAngerSaveData(this.level(), nbttagcompound);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        DamageSource damagesource = this.damageSources().sting(this);
        boolean flag = entity.hurt(damagesource, (int)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE));
        if (flag) {
            World world = this.level();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.doPostAttackEffects(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.setStingerCount(entityliving.getStingerCount() + 1);
                int b0 = 0;
                if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                    b0 = 10;
                } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    entityliving.addEffect(new MobEffect(MobEffects.POISON, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.setHasStung(true);
            this.stopBeingAngry();
            this.playSound(SoundEffects.BEE_STING, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.random.nextFloat() < 0.05f) {
            for (int i2 = 0; i2 < this.random.nextInt(2) + 1; ++i2) {
                this.spawnFluidParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), Particles.FALLING_NECTAR);
            }
        }
        this.updateRollAmount();
    }

    private void spawnFluidParticle(World world, double d0, double d1, double d2, double d3, double d4, ParticleParam particleparam) {
        world.addParticle(particleparam, MathHelper.lerp(world.random.nextDouble(), d0, d1), d4, MathHelper.lerp(world.random.nextDouble(), d2, d3), 0.0, 0.0, 0.0);
    }

    void pathfindRandomlyTowards(BlockPosition blockposition) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.atBottomCenterOf(blockposition);
        int b0 = 0;
        BlockPosition blockposition1 = this.blockPosition();
        int i2 = (int)vec3d.y - blockposition1.getY();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.distManhattan(blockposition);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.getPosTowards(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.navigation.setMaxVisitedNodesMultiplier(0.5f);
            this.navigation.moveTo(vec3d1.x, vec3d1.y, vec3d1.z, 1.0);
        }
    }

    @Nullable
    public BlockPosition getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    public void setSavedFlowerPos(BlockPosition blockposition) {
        this.savedFlowerPos = blockposition;
    }

    @VisibleForDebug
    public int getTravellingTicks() {
        return Math.max(this.goToHiveGoal.travellingTicks, this.goToKnownFlowerGoal.travellingTicks);
    }

    @VisibleForDebug
    public List<BlockPosition> getBlacklistedHives() {
        return this.goToHiveGoal.blacklistedTargets;
    }

    private boolean isTiredOfLookingForNectar() {
        return this.ticksWithoutNectarSinceExitingHive > 3600;
    }

    boolean wantsToEnterHive() {
        if (this.stayOutOfHiveCountdown <= 0 && !this.beePollinateGoal.isPollinating() && !this.hasStung() && this.getTarget() == null) {
            boolean flag = this.isTiredOfLookingForNectar() || this.level().isRaining() || this.level().isNight() || this.hasNectar();
            return flag && !this.isHiveNearFire();
        }
        return false;
    }

    public void setStayOutOfHiveCountdown(int i2) {
        this.stayOutOfHiveCountdown = i2;
    }

    public float getRollAmount(float f2) {
        return MathHelper.lerp(f2, this.rollAmountO, this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    @Override
    protected void customServerAiStep() {
        boolean flag = this.hasStung();
        this.underWaterTicks = this.isInWaterOrBubble() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
        if (flag) {
            ++this.timeSinceSting;
            if (this.timeSinceSting % 5 == 0 && this.random.nextInt(MathHelper.clamp(1200 - this.timeSinceSting, 1, 1200)) == 0) {
                this.hurt(this.damageSources().generic(), this.getHealth());
            }
        }
        if (!this.hasNectar()) {
            ++this.ticksWithoutNectarSinceExitingHive;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((WorldServer)this.level(), false);
        }
    }

    public void resetTicksWithoutNectarSinceExitingHive() {
        this.ticksWithoutNectarSinceExitingHive = 0;
    }

    private boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        TileEntity tileentity = this.level().getBlockEntity(this.hivePos);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).isFireNearby();
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int i2) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, i2);
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    private boolean doesHiveHaveSpace(BlockPosition blockposition) {
        TileEntity tileentity = this.level().getBlockEntity(blockposition);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).isFull() : false;
    }

    @VisibleForDebug
    public boolean hasHive() {
        return this.hivePos != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition getHivePos() {
        return this.hivePos;
    }

    @VisibleForDebug
    public PathfinderGoalSelector getGoalSelector() {
        return this.goalSelector;
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendBeeInfo(this);
    }

    int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            if (this.remainingCooldownBeforeLocatingNewFlower > 0) {
                --this.remainingCooldownBeforeLocatingNewFlower;
            }
            boolean flag = this.isAngry() && !this.hasStung() && this.getTarget() != null && this.getTarget().distanceToSqr(this) < 4.0;
            this.setRolling(flag);
            if (this.tickCount % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        if (this.isTooFarAway(this.hivePos)) {
            return false;
        }
        TileEntity tileentity = this.level().getBlockEntity(this.hivePos);
        return tileentity != null && tileentity.getType() == TileEntityTypes.BEEHIVE;
    }

    public boolean hasNectar() {
        return this.getFlag(8);
    }

    public void setHasNectar(boolean flag) {
        if (flag) {
            this.resetTicksWithoutNectarSinceExitingHive();
        }
        this.setFlag(8, flag);
    }

    public boolean hasStung() {
        return this.getFlag(4);
    }

    public void setHasStung(boolean flag) {
        this.setFlag(4, flag);
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean flag) {
        this.setFlag(2, flag);
    }

    boolean isTooFarAway(BlockPosition blockposition) {
        return !this.closerThan(blockposition, 32);
    }

    private void setFlag(int i2, boolean flag) {
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) | i2));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) & ~i2));
        }
    }

    private boolean getFlag(int i2) {
        return (this.entityData.get(DATA_FLAGS_ID) & i2) != 0;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.FLYING_SPEED, 0.6f).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.FOLLOW_RANGE, 48.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean isStableDestination(BlockPosition blockposition) {
                return !this.level.getBlockState(blockposition.below()).isAir();
            }

            @Override
            public void tick() {
                if (!EntityBee.this.beePollinateGoal.isPollinating()) {
                    super.tick();
                }
            }
        };
        navigationflying.setCanOpenDoors(false);
        navigationflying.setCanFloat(false);
        navigationflying.setCanPassDoors(true);
        return navigationflying;
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.BEE_FOOD);
    }

    boolean isFlowerValid(BlockPosition blockposition) {
        return this.level().isLoaded(blockposition) && this.level().getBlockState(blockposition).is(TagsBlock.FLOWERS);
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return null;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.BEE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BEE_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    @Nullable
    public EntityBee getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.BEE.create(worldserver);
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    @Override
    public boolean isFlying() {
        return !this.onGround();
    }

    public void dropOffNectar() {
        this.setHasNectar(false);
        this.resetNumCropsGrownSincePollination();
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        boolean result = super.hurt(damagesource, f2);
        if (result && !this.level().isClientSide) {
            this.beePollinateGoal.stopPollinating();
        }
        return result;
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> tagkey) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.5f * this.getEyeHeight(), this.getBbWidth() * 0.2f);
    }

    boolean closerThan(BlockPosition blockposition, int i2) {
        return blockposition.closerThan(this.blockPosition(), i2);
    }

    public void setHivePos(BlockPosition blockposition) {
        this.hivePos = blockposition;
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entityinsentient) {
            super(entityinsentient);
        }

        @Override
        public void tick() {
            if (!EntityBee.this.isAngry()) {
                super.tick();
            }
        }

        @Override
        protected boolean resetXRotOnTick() {
            return !EntityBee.this.beePollinateGoal.isPollinating();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature entitycreature, double d0, boolean flag) {
            super(entitycreature, d0, flag);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean canBeeUse() {
            TileEntity tileentity;
            if (EntityBee.this.hasHive() && EntityBee.this.wantsToEnterHive() && EntityBee.this.hivePos.closerToCenterThan(EntityBee.this.position(), 2.0) && (tileentity = EntityBee.this.level().getBlockEntity(EntityBee.this.hivePos)) instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                if (!tileentitybeehive.isFull()) {
                    return true;
                }
                EntityBee.this.hivePos = null;
            }
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            TileEntity tileentity = EntityBee.this.level().getBlockEntity(EntityBee.this.hivePos);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.addOccupant(EntityBee.this);
            }
        }
    }

    private class k
    extends a {
        private static final int MIN_POLLINATION_TICKS = 400;
        private static final int MIN_FIND_FLOWER_RETRY_COOLDOWN = 20;
        private static final int MAX_FIND_FLOWER_RETRY_COOLDOWN = 60;
        private final Predicate<IBlockData> VALID_POLLINATION_BLOCKS;
        private static final double ARRIVAL_THRESHOLD = 0.1;
        private static final int POSITION_CHANGE_CHANCE = 25;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private int successfulPollinatingTicks;
        private int lastSoundPlayedTick;
        private boolean pollinating;
        @Nullable
        private Vec3D hoverPos;
        private int pollinatingTicks;
        private static final int MAX_POLLINATING_TICKS = 600;

        k() {
            this.VALID_POLLINATION_BLOCKS = iblockdata -> iblockdata.hasProperty(BlockProperties.WATERLOGGED) && iblockdata.getValue(BlockProperties.WATERLOGGED).booleanValue() ? false : (iblockdata.is(TagsBlock.FLOWERS) ? (iblockdata.is(Blocks.SUNFLOWER) ? iblockdata.getValue(BlockTallPlant.HALF) == BlockPropertyDoubleBlockHalf.UPPER : true) : false);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            if (EntityBee.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (EntityBee.this.hasNectar()) {
                return false;
            }
            if (EntityBee.this.level().isRaining()) {
                return false;
            }
            Optional<BlockPosition> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                EntityBee.this.savedFlowerPos = optional.get();
                EntityBee.this.navigation.moveTo((double)EntityBee.this.savedFlowerPos.getX() + 0.5, (double)EntityBee.this.savedFlowerPos.getY() + 0.5, (double)EntityBee.this.savedFlowerPos.getZ() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.remainingCooldownBeforeLocatingNewFlower = MathHelper.nextInt(EntityBee.this.random, 20, 60);
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            if (!this.pollinating) {
                return false;
            }
            if (!EntityBee.this.hasSavedFlowerPos()) {
                return false;
            }
            if (EntityBee.this.level().isRaining()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return EntityBee.this.random.nextFloat() < 0.2f;
            }
            if (EntityBee.this.tickCount % 20 == 0 && !EntityBee.this.isFlowerValid(EntityBee.this.savedFlowerPos)) {
                EntityBee.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        private boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 400;
        }

        boolean isPollinating() {
            return this.pollinating;
        }

        void stopPollinating() {
            this.pollinating = false;
        }

        @Override
        public void start() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.pollinating = true;
            EntityBee.this.resetTicksWithoutNectarSinceExitingHive();
        }

        @Override
        public void stop() {
            if (this.hasPollinatedLongEnough()) {
                EntityBee.this.setHasNectar(true);
            }
            this.pollinating = false;
            EntityBee.this.navigation.stop();
            EntityBee.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            ++this.pollinatingTicks;
            if (this.pollinatingTicks > 600) {
                EntityBee.this.savedFlowerPos = null;
            } else {
                Vec3D vec3d = Vec3D.atBottomCenterOf(EntityBee.this.savedFlowerPos).add(0.0, 0.6f, 0.0);
                if (vec3d.distanceTo(EntityBee.this.position()) > 1.0) {
                    this.hoverPos = vec3d;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = vec3d;
                    }
                    boolean flag = EntityBee.this.position().distanceTo(this.hoverPos) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.pollinatingTicks > 600) {
                        EntityBee.this.savedFlowerPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.random.nextInt(25) == 0;
                            if (flag2) {
                                this.hoverPos = new Vec3D(vec3d.x() + (double)this.getOffset(), vec3d.y(), vec3d.z() + (double)this.getOffset());
                                EntityBee.this.navigation.stop();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.getLookControl().setLookAt(vec3d.x(), vec3d.y(), vec3d.z());
                        }
                        if (flag1) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                        if (EntityBee.this.random.nextFloat() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                            this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                            EntityBee.this.playSound(SoundEffects.BEE_POLLINATE, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void setWantedPos() {
            EntityBee.this.getMoveControl().setWantedPosition(this.hoverPos.x(), this.hoverPos.y(), this.hoverPos.z(), 0.35f);
        }

        private float getOffset() {
            return (EntityBee.this.random.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> findNearbyFlower() {
            return this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 5.0);
        }

        private Optional<BlockPosition> findNearestBlock(Predicate<IBlockData> predicate, double d0) {
            BlockPosition blockposition = EntityBee.this.blockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= d0) {
                int j2 = 0;
                while ((double)j2 < d0) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.setWithOffset(blockposition, k2, i2 - 1, l2);
                            if (blockposition.closerThan(blockposition_mutableblockposition, d0) && predicate.test(EntityBee.this.level().getBlockState(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.remainingCooldownBeforeLocatingNewHive == 0 && !EntityBee.this.hasHive() && EntityBee.this.wantsToEnterHive();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            EntityBee.this.remainingCooldownBeforeLocatingNewHive = 200;
            List<BlockPosition> list = this.findNearbyHivesWithSpace();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.goToHiveGoal.clearBlacklist();
                    EntityBee.this.hivePos = list.get(0);
                    return;
                } while (EntityBee.this.goToHiveGoal.isTargetBlacklisted(blockposition = iterator.next()));
                EntityBee.this.hivePos = blockposition;
            }
        }

        private List<BlockPosition> findNearbyHivesWithSpace() {
            BlockPosition blockposition = EntityBee.this.blockPosition();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.level()).getPoiManager();
            Stream<VillagePlaceRecord> stream = villageplace.getInRange(holder -> holder.is(PoiTypeTags.BEE_HOME), blockposition, 20, VillagePlace.Occupancy.ANY);
            return stream.map(VillagePlaceRecord::getPos).filter(EntityBee.this::doesHiveHaveSpace).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.distSqr(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int MAX_TRAVELLING_TICKS = 600;
        int travellingTicks;
        private static final int MAX_BLACKLISTED_TARGETS = 3;
        final List<BlockPosition> blacklistedTargets;
        @Nullable
        private PathEntity lastPath;
        private static final int TICKS_BEFORE_HIVE_DROP = 60;
        private int ticksStuck;

        e() {
            this.travellingTicks = EntityBee.this.random.nextInt(10);
            this.blacklistedTargets = Lists.newArrayList();
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.hivePos != null && !EntityBee.this.hasRestriction() && EntityBee.this.wantsToEnterHive() && !this.hasReachedTarget(EntityBee.this.hivePos) && EntityBee.this.level().getBlockState(EntityBee.this.hivePos).is(TagsBlock.BEEHIVES);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void start() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.start();
        }

        @Override
        public void stop() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            EntityBee.this.navigation.stop();
            EntityBee.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        @Override
        public void tick() {
            if (EntityBee.this.hivePos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.adjustedTickDelay(600)) {
                    this.dropAndBlacklistHive();
                } else if (!EntityBee.this.navigation.isInProgress()) {
                    if (!EntityBee.this.closerThan(EntityBee.this.hivePos, 16)) {
                        if (EntityBee.this.isTooFarAway(EntityBee.this.hivePos)) {
                            this.dropHive();
                        } else {
                            EntityBee.this.pathfindRandomlyTowards(EntityBee.this.hivePos);
                        }
                    } else {
                        boolean flag = this.pathfindDirectlyTowards(EntityBee.this.hivePos);
                        if (!flag) {
                            this.dropAndBlacklistHive();
                        } else if (this.lastPath != null && EntityBee.this.navigation.getPath().sameAs(this.lastPath)) {
                            ++this.ticksStuck;
                            if (this.ticksStuck > 60) {
                                this.dropHive();
                                this.ticksStuck = 0;
                            }
                        } else {
                            this.lastPath = EntityBee.this.navigation.getPath();
                        }
                    }
                }
            }
        }

        private boolean pathfindDirectlyTowards(BlockPosition blockposition) {
            EntityBee.this.navigation.setMaxVisitedNodesMultiplier(10.0f);
            EntityBee.this.navigation.moveTo(blockposition.getX(), blockposition.getY(), blockposition.getZ(), 2, 1.0);
            return EntityBee.this.navigation.getPath() != null && EntityBee.this.navigation.getPath().canReach();
        }

        boolean isTargetBlacklisted(BlockPosition blockposition) {
            return this.blacklistedTargets.contains(blockposition);
        }

        private void blacklistTarget(BlockPosition blockposition) {
            this.blacklistedTargets.add(blockposition);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        private void dropAndBlacklistHive() {
            if (EntityBee.this.hivePos != null) {
                this.blacklistTarget(EntityBee.this.hivePos);
            }
            this.dropHive();
        }

        private void dropHive() {
            EntityBee.this.hivePos = null;
            EntityBee.this.remainingCooldownBeforeLocatingNewHive = 200;
        }

        private boolean hasReachedTarget(BlockPosition blockposition) {
            if (EntityBee.this.closerThan(blockposition, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.navigation.getPath();
            return pathentity != null && pathentity.getTarget().equals(blockposition) && pathentity.canReach() && pathentity.isDone();
        }
    }

    public class f
    extends a {
        private static final int MAX_TRAVELLING_TICKS = 600;
        int travellingTicks;

        f() {
            this.travellingTicks = EntityBee.this.random.nextInt(10);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.savedFlowerPos != null && !EntityBee.this.hasRestriction() && this.wantsToGoToKnownFlower() && EntityBee.this.isFlowerValid(EntityBee.this.savedFlowerPos) && !EntityBee.this.closerThan(EntityBee.this.savedFlowerPos, 2);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void start() {
            this.travellingTicks = 0;
            super.start();
        }

        @Override
        public void stop() {
            this.travellingTicks = 0;
            EntityBee.this.navigation.stop();
            EntityBee.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        @Override
        public void tick() {
            if (EntityBee.this.savedFlowerPos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.adjustedTickDelay(600)) {
                    EntityBee.this.savedFlowerPos = null;
                } else if (!EntityBee.this.navigation.isInProgress()) {
                    if (EntityBee.this.isTooFarAway(EntityBee.this.savedFlowerPos)) {
                        EntityBee.this.savedFlowerPos = null;
                    } else {
                        EntityBee.this.pathfindRandomlyTowards(EntityBee.this.savedFlowerPos);
                    }
                }
            }
        }

        private boolean wantsToGoToKnownFlower() {
            return EntityBee.this.ticksWithoutNectarSinceExitingHive > 2400;
        }
    }

    private class g
    extends a {
        static final int GROW_CHANCE = 30;

        g() {
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.getCropsGrownSincePollination() >= 10 ? false : (EntityBee.this.random.nextFloat() < 0.3f ? false : EntityBee.this.hasNectar() && EntityBee.this.isHiveValid());
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void tick() {
            if (EntityBee.this.random.nextInt(this.adjustedTickDelay(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.blockPosition().below(i2);
                    IBlockData iblockdata = EntityBee.this.level().getBlockState(blockposition);
                    Block block = iblockdata.getBlock();
                    IBlockData iblockdata1 = null;
                    if (!iblockdata.is(TagsBlock.BEE_GROWABLES)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.isMaxAge(iblockdata)) {
                            iblockdata1 = blockcrops.getStateForAge(blockcrops.getAge(iblockdata) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.getValue(BlockStem.AGE);
                        if (j2 < 7) {
                            iblockdata1 = (IBlockData)iblockdata.setValue(BlockStem.AGE, j2 + 1);
                        }
                    } else if (iblockdata.is(Blocks.SWEET_BERRY_BUSH)) {
                        int j3 = iblockdata.getValue(BlockSweetBerryBush.AGE);
                        if (j3 < 3) {
                            iblockdata1 = (IBlockData)iblockdata.setValue(BlockSweetBerryBush.AGE, j3 + 1);
                        }
                    } else if (iblockdata.is(Blocks.CAVE_VINES) || iblockdata.is(Blocks.CAVE_VINES_PLANT)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.getBlock())).performBonemeal((WorldServer)EntityBee.this.level(), EntityBee.this.random, blockposition, iblockdata);
                    }
                    if (iblockdata1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, iblockdata1)) continue;
                    EntityBee.this.level().levelEvent(2011, blockposition, 15);
                    EntityBee.this.level().setBlockAndUpdate(blockposition, iblockdata1);
                    EntityBee.this.incrementNumCropsGrownSincePollination();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int WANDER_THRESHOLD = 22;

        l() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return EntityBee.this.navigation.isDone() && EntityBee.this.random.nextInt(10) == 0;
        }

        @Override
        public boolean canContinueToUse() {
            return EntityBee.this.navigation.isInProgress();
        }

        @Override
        public void start() {
            Vec3D vec3d = this.findPos();
            if (vec3d != null) {
                EntityBee.this.navigation.moveTo(EntityBee.this.navigation.createPath(BlockPosition.containing(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D findPos() {
            Vec3D vec3d;
            if (EntityBee.this.isHiveValid() && !EntityBee.this.closerThan(EntityBee.this.hivePos, 22)) {
                Vec3D vec3d1 = Vec3D.atCenterOf(EntityBee.this.hivePos);
                vec3d = vec3d1.subtract(EntityBee.this.position()).normalize();
            } else {
                vec3d = EntityBee.this.getViewVector(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.getPos(EntityBee.this, 8, 7, vec3d.x, vec3d.z, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.getPos(EntityBee.this, 8, 4, -2, vec3d.x, vec3d.z, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean canContinueToUse() {
            return EntityBee.this.isAngry() && super.canContinueToUse();
        }

        @Override
        protected void alertOther(EntityInsentient entityinsentient, EntityLiving entityliving) {
            if (entityinsentient instanceof EntityBee && this.mob.hasLineOfSight(entityliving)) {
                entityinsentient.setTarget(entityliving, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee entitybee) {
            super(entitybee, EntityHuman.class, 10, true, false, entitybee::isAngryAt);
        }

        @Override
        public boolean canUse() {
            return this.beeCanTarget() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            boolean flag = this.beeCanTarget();
            if (flag && this.mob.getTarget() != null) {
                return super.canContinueToUse();
            }
            this.targetMob = null;
            return false;
        }

        private boolean beeCanTarget() {
            EntityBee entitybee = (EntityBee)this.mob;
            return entitybee.isAngry() && !entitybee.hasStung();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean canBeeUse();

        public abstract boolean canBeeContinueToUse();

        @Override
        public boolean canUse() {
            return this.canBeeUse() && !EntityBee.this.isAngry();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canBeeContinueToUse() && !EntityBee.this.isAngry();
        }
    }
}

