/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> DATA_TYPE_ID = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_SITTING = 1;
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final int FLAG_SLEEPING = 32;
    private static final int FLAG_FACEPLANTED = 64;
    private static final int FLAG_DEFENDING = 128;
    public static final DataWatcherObject<Optional<UUID>> DATA_TRUSTED_ID_0 = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.OPTIONAL_UUID);
    public static final DataWatcherObject<Optional<UUID>> DATA_TRUSTED_ID_1 = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.OPTIONAL_UUID);
    static final Predicate<EntityItem> ALLOWED_ITEMS = entityitem -> !entityitem.hasPickUpDelay() && entityitem.isAlive();
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.getLastHurtMob() != null && entityliving.getLastHurtMobTimestamp() < entityliving.tickCount + 600;
    };
    static final Predicate<Entity> STALKABLE_PREY = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> AVOID_PLAYERS = entity -> !entity.isDiscrete() && IEntitySelector.NO_CREATIVE_OR_SPECTATOR.test((Entity)entity);
    private static final int MIN_TICKS_BEFORE_EAT = 600;
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.FOX.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    private PathfinderGoal landTargetGoal;
    private PathfinderGoal turtleEggTargetGoal;
    private PathfinderGoal fishTargetGoal;
    private float interestedAngle;
    private float interestedAngleO;
    float crouchAmount;
    float crouchAmountO;
    private int ticksSinceEaten;

    public EntityFox(EntityTypes<? extends EntityFox> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.lookControl = new k();
        this.moveControl = new m();
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_TRUSTED_ID_0, Optional.empty());
        datawatcher_a.define(DATA_TRUSTED_ID_1, Optional.empty());
        datawatcher_a.define(DATA_TYPE_ID, 0);
        datawatcher_a.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    protected void registerGoals() {
        this.landTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.turtleEggTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.BABY_ON_LAND_SELECTOR);
        this.fishTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.goalSelector.addGoal(0, new g());
        this.goalSelector.addGoal(0, new ClimbOnTopOfPowderSnowGoal(this, this.level()));
        this.goalSelector.addGoal(1, new b());
        this.goalSelector.addGoal(2, new n(2.2));
        this.goalSelector.addGoal(3, new e(this, this, 1.0));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> AVOID_PLAYERS.test((Entity)entityliving) && !this.trusts(entityliving.getUUID()) && !this.isDefending()));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).isTame() && !this.isDefending()));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.isDefending()));
        this.goalSelector.addGoal(5, new u());
        this.goalSelector.addGoal(6, new o());
        this.goalSelector.addGoal(6, new s(1.25));
        this.goalSelector.addGoal(7, new l((double)1.2f, true));
        this.goalSelector.addGoal(7, new t());
        this.goalSelector.addGoal(8, new h(this, this, this, 1.25));
        this.goalSelector.addGoal(9, new q(32, 200));
        this.goalSelector.addGoal(10, new f((double)1.2f, 12, 1));
        this.goalSelector.addGoal(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.addGoal(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(11, new p());
        this.goalSelector.addGoal(12, new j(this, EntityHuman.class, 24.0f));
        this.goalSelector.addGoal(13, new r());
        this.targetSelector.addGoal(3, new a(EntityLiving.class, false, false, entityliving -> TRUSTED_TARGET_SELECTOR.test((Entity)entityliving) && !this.trusts(entityliving.getUUID())));
    }

    @Override
    public SoundEffect getEatingSound(ItemStack itemstack) {
        return SoundEffects.FOX_EAT;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            EntityLiving entityliving;
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.finishUsingItem(this.level(), this);
                    if (!itemstack1.isEmpty()) {
                        this.setItemSlot(EnumItemSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playSound(this.getEatingSound(itemstack), 1.0f, 1.0f);
                    this.level().broadcastEntityEvent(this, (byte)45);
                }
            }
            if ((entityliving = this.getTarget()) == null || !entityliving.isAlive()) {
                this.setIsCrouching(false);
                this.setIsInterested(false);
            }
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        if (this.isDefending() && this.random.nextFloat() < 0.05f) {
            this.playSound(SoundEffects.FOX_AGGRO, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    private boolean canEat(ItemStack itemstack) {
        return itemstack.has(DataComponents.FOOD) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.nextFloat() < 0.2f) {
            float f2 = randomsource.nextFloat();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.EMERALD) : (f2 < 0.2f ? new ItemStack(Items.EGG) : (f2 < 0.4f ? (randomsource.nextBoolean() ? new ItemStack(Items.RABBIT_FOOT) : new ItemStack(Items.RABBIT_HIDE)) : (f2 < 0.6f ? new ItemStack(Items.WHEAT) : (f2 < 0.8f ? new ItemStack(Items.LEATHER) : new ItemStack(Items.FEATHER)))));
            this.setItemSlot(EnumItemSlot.MAINHAND, itemstack);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 45) {
            ItemStack itemstack = this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!itemstack.isEmpty()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
                    this.level().addParticle(new ParticleParamItem(Particles.ITEM, itemstack), this.getX() + this.getLookAngle().x / 2.0, this.getY(), this.getZ() + this.getLookAngle().z / 2.0, vec3d.x, vec3d.y + 0.05, vec3d.z);
                }
            }
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.FOLLOW_RANGE, 32.0).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.SAFE_FALL_DISTANCE, 5.0);
    }

    @Override
    @Nullable
    public EntityFox getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        EntityFox entityfox = EntityTypes.FOX.create(worldserver);
        if (entityfox != null) {
            entityfox.setVariant(this.random.nextBoolean() ? this.getVariant() : ((EntityFox)entityageable).getVariant());
        }
        return entityfox;
    }

    public static boolean checkFoxSpawnRules(EntityTypes<EntityFox> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(TagsBlock.FOXES_SPAWNABLE_ON) && EntityFox.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        Holder<BiomeBase> holder = worldaccess.getBiome(this.blockPosition());
        Type entityfox_type = Type.byBiome(holder);
        boolean flag = false;
        if (groupdataentity instanceof i) {
            i entityfox_i = (i)groupdataentity;
            entityfox_type = entityfox_i.type;
            if (entityfox_i.getGroupSize() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new i(entityfox_type);
        }
        this.setVariant(entityfox_type);
        if (flag) {
            this.setAge(-24000);
        }
        if (worldaccess instanceof WorldServer) {
            this.setTargetGoals();
        }
        this.populateDefaultEquipmentSlots(worldaccess.getRandom(), difficultydamagescaler);
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    private void setTargetGoals() {
        if (this.getVariant() == Type.RED) {
            this.targetSelector.addGoal(4, this.landTargetGoal);
            this.targetSelector.addGoal(4, this.turtleEggTargetGoal);
            this.targetSelector.addGoal(6, this.fishTargetGoal);
        } else {
            this.targetSelector.addGoal(4, this.fishTargetGoal);
            this.targetSelector.addGoal(6, this.landTargetGoal);
            this.targetSelector.addGoal(6, this.turtleEggTargetGoal);
        }
    }

    @Override
    protected void usePlayerItem(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        if (this.isFood(itemstack)) {
            this.playSound(this.getEatingSound(itemstack), 1.0f, 1.0f);
        }
        super.usePlayerItem(entityhuman, enumhand, itemstack);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(entitypose);
    }

    @Override
    public Type getVariant() {
        return Type.byId(this.entityData.get(DATA_TYPE_ID));
    }

    @Override
    public void setVariant(Type entityfox_type) {
        this.entityData.set(DATA_TYPE_ID, entityfox_type.getId());
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(this.entityData.get(DATA_TRUSTED_ID_0).orElse(null));
        list.add(this.entityData.get(DATA_TRUSTED_ID_1).orElse(null));
        return list;
    }

    void addTrustedUUID(@Nullable UUID uuid) {
        if (this.entityData.get(DATA_TRUSTED_ID_0).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.ofNullable(uuid));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        List<UUID> list = this.getTrustedUUIDs();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.createUUID(uuid));
        }
        nbttagcompound.put("Trusted", nbttaglist);
        nbttagcompound.putBoolean("Sleeping", this.isSleeping());
        nbttagcompound.putString("Type", this.getVariant().getSerializedName());
        nbttagcompound.putBoolean("Sitting", this.isSitting());
        nbttagcompound.putBoolean("Crouching", this.isCrouching());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getList("Trusted", 11);
        for (NBTBase nbtbase : nbttaglist) {
            this.addTrustedUUID(GameProfileSerializer.loadUUID(nbtbase));
        }
        this.setSleeping(nbttagcompound.getBoolean("Sleeping"));
        this.setVariant(Type.byName(nbttagcompound.getString("Type")));
        this.setSitting(nbttagcompound.getBoolean("Sitting"));
        this.setIsCrouching(nbttagcompound.getBoolean("Crouching"));
        if (this.level() instanceof WorldServer) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean flag) {
        this.setFlag(1, flag);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    void setFaceplanted(boolean flag) {
        this.setFlag(64, flag);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean flag) {
        this.setFlag(128, flag);
    }

    @Override
    public boolean isSleeping() {
        return this.getFlag(32);
    }

    public void setSleeping(boolean flag) {
        this.setFlag(32, flag);
    }

    private void setFlag(int i2, boolean flag) {
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) | i2));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) & ~i2));
        }
    }

    private boolean getFlag(int i2) {
        return (this.entityData.get(DATA_FLAGS_ID) & i2) != 0;
    }

    @Override
    public boolean canTakeItem(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        return !this.getItemBySlot(enumitemslot).isEmpty() ? false : enumitemslot == EnumItemSlot.MAINHAND && super.canTakeItem(itemstack);
    }

    @Override
    public boolean canHoldItem(ItemStack itemstack) {
        ItemStack itemstack1 = this.getItemBySlot(EnumItemSlot.MAINHAND);
        return itemstack1.isEmpty() || this.ticksSinceEaten > 0 && itemstack.has(DataComponents.FOOD) && !itemstack1.has(DataComponents.FOOD);
    }

    private void spitOutItem(ItemStack itemstack) {
        if (!itemstack.isEmpty() && !this.level().isClientSide) {
            EntityItem entityitem = new EntityItem(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, itemstack);
            entityitem.setPickUpDelay(40);
            entityitem.setThrower(this);
            this.playSound(SoundEffects.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity(entityitem);
        }
    }

    private void dropItemStack(ItemStack itemstack) {
        EntityItem entityitem = new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
        this.level().addFreshEntity(entityitem);
    }

    @Override
    protected void pickUpItem(EntityItem entityitem) {
        ItemStack itemstack = entityitem.getItem();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, itemstack.getCount() - 1, !this.canHoldItem(itemstack)).isCancelled()) {
            itemstack = entityitem.getItem();
            int i2 = itemstack.getCount();
            if (i2 > 1) {
                this.dropItemStack(itemstack.split(i2 - 1));
            }
            this.spitOutItem(this.getItemBySlot(EnumItemSlot.MAINHAND));
            this.onItemPickup(entityitem);
            this.setItemSlot(EnumItemSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EnumItemSlot.MAINHAND);
            this.take(entityitem, itemstack.getCount());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            this.ticksSinceEaten = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isEffectiveAi()) {
            boolean flag = this.isInWater();
            if (flag || this.getTarget() != null || this.level().isThundering()) {
                this.wakeUp();
            }
            if (flag || this.isSleeping()) {
                this.setSitting(false);
            }
            if (this.isFaceplanted() && this.level().random.nextFloat() < 0.2f) {
                BlockPosition blockposition = this.blockPosition();
                IBlockData iblockdata = this.level().getBlockState(blockposition);
                this.level().levelEvent(2001, blockposition, Block.getId(iblockdata));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.isCrouching()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.FOX_FOOD);
    }

    @Override
    protected void onOffspringSpawnedFromEgg(EntityHuman entityhuman, EntityInsentient entityinsentient) {
        ((EntityFox)entityinsentient).addTrustedUUID(entityhuman.getUUID());
    }

    public boolean isPouncing() {
        return this.getFlag(16);
    }

    public void setIsPouncing(boolean flag) {
        this.setFlag(16, flag);
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public void setIsCrouching(boolean flag) {
        this.setFlag(4, flag);
    }

    @Override
    public boolean isCrouching() {
        return this.getFlag(4);
    }

    public void setIsInterested(boolean flag) {
        this.setFlag(8, flag);
    }

    public boolean isInterested() {
        return this.getFlag(8);
    }

    public float getHeadRollAngle(float f2) {
        return MathHelper.lerp(f2, this.interestedAngleO, this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float getCrouchAmount(float f2) {
        return MathHelper.lerp(f2, this.crouchAmountO, this.crouchAmount);
    }

    @Override
    public void setTarget(@Nullable EntityLiving entityliving) {
        if (this.isDefending() && entityliving == null) {
            this.setDefending(false);
        }
        super.setTarget(entityliving);
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDefending(false);
        this.setFaceplanted(false);
    }

    boolean canMove() {
        return !this.isSleeping() && !this.isSitting() && !this.isFaceplanted();
    }

    @Override
    public void playAmbientSound() {
        SoundEffect soundeffect = this.getAmbientSound();
        if (soundeffect == SoundEffects.FOX_SCREECH) {
            this.playSound(soundeffect, 2.0f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        List<Entity> list;
        if (this.isSleeping()) {
            return SoundEffects.FOX_SLEEP;
        }
        if (!this.level().isDay() && this.random.nextFloat() < 0.1f && (list = this.level().getEntitiesOfClass(EntityHuman.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0), IEntitySelector.NO_SPECTATORS)).isEmpty()) {
            return SoundEffects.FOX_SCREECH;
        }
        return SoundEffects.FOX_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.FOX_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.FOX_DEATH;
    }

    boolean trusts(UUID uuid) {
        return this.getTrustedUUIDs().contains(uuid);
    }

    @Override
    protected void dropAllDeathLoot(WorldServer worldserver, DamageSource damagesource) {
        ItemStack itemstack = this.getItemBySlot(EnumItemSlot.MAINHAND);
        if (!itemstack.isEmpty()) {
            this.spawnAtLocation(itemstack);
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        }
        super.dropAllDeathLoot(worldserver, damagesource);
    }

    public static boolean isPathClear(EntityFox entityfox, EntityLiving entityliving) {
        double d0 = entityliving.getZ() - entityfox.getZ();
        double d1 = entityliving.getX() - entityfox.getX();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (entityfox.level().getBlockState(BlockPosition.containing(entityfox.getX() + d4, entityfox.getY() + (double)j2, entityfox.getZ() + d3)).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.55f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void tick() {
            if (!EntityFox.this.isSleeping()) {
                super.tick();
            }
        }

        @Override
        protected boolean resetXRotOnTick() {
            return !EntityFox.this.isPouncing() && !EntityFox.this.isCrouching() && !EntityFox.this.isInterested() && !EntityFox.this.isFaceplanted();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void tick() {
            if (EntityFox.this.canMove()) {
                super.tick();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void start() {
            super.start();
            EntityFox.this.clearStates();
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.isInWater() && EntityFox.this.getFluidHeight(TagsFluid.WATER) > 0.25 || EntityFox.this.isInLava();
        }
    }

    private class b
    extends PathfinderGoal {
        int countdown;

        public b() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.isFaceplanted();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canUse() && this.countdown > 0;
        }

        @Override
        public void start() {
            this.countdown = this.adjustedTickDelay(40);
        }

        @Override
        public void stop() {
            EntityFox.this.setFaceplanted(false);
        }

        @Override
        public void tick() {
            --this.countdown;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean shouldPanic() {
            return !EntityFox.this.isDefending() && super.shouldPanic();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, EntityFox entityfox, double d0) {
            super(entityfox, d0);
        }

        @Override
        public void start() {
            ((EntityFox)this.animal).clearStates();
            ((EntityFox)this.partner).clearStates();
            super.start();
        }

        @Override
        protected void breed() {
            WorldServer worldserver = (WorldServer)this.level;
            EntityFox entityfox = (EntityFox)this.animal.getBreedOffspring(worldserver, this.partner);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.animal.getLoveCause();
                EntityPlayer entityplayer1 = this.partner.getLoveCause();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.addTrustedUUID(entityplayer.getUUID());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.addTrustedUUID(entityplayer1.getUUID());
                }
                entityfox.setAge(-24000);
                entityfox.moveTo(this.animal.getX(), this.animal.getY(), this.animal.getZ(), 0.0f, 0.0f);
                int experience = this.animal.getRandom().nextInt(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.animal, this.partner, entityplayer, this.animal.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.awardStat(StatisticList.ANIMALS_BRED);
                    CriterionTriggers.BRED_ANIMALS.trigger(entityplayer2, this.animal, this.partner, entityfox);
                }
                this.animal.setAge(6000);
                this.partner.setAge(6000);
                this.animal.resetLove();
                this.partner.resetLove();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.level.broadcastEntityEvent(this.animal, (byte)18);
                if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && experience > 0) {
                    this.level.addFreshEntity(new EntityExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), experience));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            if (EntityFox.this.isSleeping()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.getTarget();
            return entityliving != null && entityliving.isAlive() && STALKABLE_PREY.test(entityliving) && EntityFox.this.distanceToSqr(entityliving) > 36.0 && !EntityFox.this.isCrouching() && !EntityFox.this.isInterested() && !EntityFox.this.jumping;
        }

        @Override
        public void start() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setFaceplanted(false);
        }

        @Override
        public void stop() {
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null && EntityFox.isPathClear(EntityFox.this, entityliving)) {
                EntityFox.this.setIsInterested(true);
                EntityFox.this.setIsCrouching(true);
                EntityFox.this.getNavigation().stop();
                EntityFox.this.getLookControl().setLookAt(entityliving, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
            } else {
                EntityFox.this.setIsInterested(false);
                EntityFox.this.setIsCrouching(false);
            }
        }

        @Override
        public void tick() {
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null) {
                EntityFox.this.getLookControl().setLookAt(entityliving, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
                if (EntityFox.this.distanceToSqr(entityliving) <= 36.0) {
                    EntityFox.this.setIsInterested(true);
                    EntityFox.this.setIsCrouching(true);
                    EntityFox.this.getNavigation().stop();
                } else {
                    EntityFox.this.getNavigation().moveTo(entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean canUse() {
            if (!EntityFox.this.isFullyCrouched()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null && entityliving.isAlive()) {
                if (entityliving.getMotionDirection() != entityliving.getDirection()) {
                    return false;
                }
                boolean flag = EntityFox.isPathClear(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.getNavigation().createPath(entityliving, 0);
                    EntityFox.this.setIsCrouching(false);
                    EntityFox.this.setIsInterested(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null && entityliving.isAlive()) {
                double d0 = EntityFox.this.getDeltaMovement().y;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.getXRot()) >= 15.0f || !EntityFox.this.onGround()) && !EntityFox.this.isFaceplanted();
            }
            return false;
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }

        @Override
        public void start() {
            EntityFox.this.setJumping(true);
            EntityFox.this.setIsPouncing(true);
            EntityFox.this.setIsInterested(false);
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null) {
                EntityFox.this.getLookControl().setLookAt(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.getX() - EntityFox.this.getX(), entityliving.getY() - EntityFox.this.getY(), entityliving.getZ() - EntityFox.this.getZ()).normalize();
                EntityFox.this.setDeltaMovement(EntityFox.this.getDeltaMovement().add(vec3d.x * 0.8, 0.9, vec3d.z * 0.8));
            }
            EntityFox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            EntityFox.this.setIsCrouching(false);
            EntityFox.this.crouchAmount = 0.0f;
            EntityFox.this.crouchAmountO = 0.0f;
            EntityFox.this.setIsInterested(false);
            EntityFox.this.setIsPouncing(false);
        }

        @Override
        public void tick() {
            EntityLiving entityliving = EntityFox.this.getTarget();
            if (entityliving != null) {
                EntityFox.this.getLookControl().setLookAt(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.isFaceplanted()) {
                Vec3D vec3d = EntityFox.this.getDeltaMovement();
                if (vec3d.y * vec3d.y < (double)0.03f && EntityFox.this.getXRot() != 0.0f) {
                    EntityFox.this.setXRot(MathHelper.rotLerp(0.2f, EntityFox.this.getXRot(), 0.0f));
                } else {
                    double d0 = vec3d.horizontalDistance();
                    double d1 = Math.signum(-vec3d.y) * Math.acos(d0 / vec3d.length()) * 57.2957763671875;
                    EntityFox.this.setXRot((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.distanceTo(entityliving) <= 2.0f) {
                EntityFox.this.doHurtTarget(entityliving);
            } else if (EntityFox.this.getXRot() > 0.0f && EntityFox.this.onGround() && (float)EntityFox.this.getDeltaMovement().y != 0.0f && EntityFox.this.level().getBlockState(EntityFox.this.blockPosition()).is(Blocks.SNOW)) {
                EntityFox.this.setXRot(60.0f);
                EntityFox.this.setTarget(null);
                EntityFox.this.setFaceplanted(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int interval;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.interval = s.reducedTickDelay(100);
        }

        @Override
        public boolean canUse() {
            if (!EntityFox.this.isSleeping() && this.mob.getTarget() == null) {
                if (EntityFox.this.level().isThundering() && EntityFox.this.level().canSeeSky(this.mob.blockPosition())) {
                    return this.setWantedPos();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPosition blockposition = this.mob.blockPosition();
                return EntityFox.this.level().isDay() && EntityFox.this.level().canSeeSky(blockposition) && !((WorldServer)EntityFox.this.level()).isVillage(blockposition) && this.setWantedPos();
            }
            return false;
        }

        @Override
        public void start() {
            EntityFox.this.clearStates();
            super.start();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void checkAndPerformAttack(EntityLiving entityliving) {
            if (this.canPerformAttack(entityliving)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget(entityliving);
                EntityFox.this.playSound(SoundEffects.FOX_BITE, 1.0f, 1.0f);
            }
        }

        @Override
        public void start() {
            EntityFox.this.setIsInterested(false);
            super.start();
        }

        @Override
        public boolean canUse() {
            return !EntityFox.this.isSitting() && !EntityFox.this.isSleeping() && !EntityFox.this.isCrouching() && !EntityFox.this.isFaceplanted() && super.canUse();
        }
    }

    private class t
    extends d {
        private static final int WAIT_TIME_BEFORE_SLEEP = t.reducedTickDelay(140);
        private int countdown;

        public t() {
            this.countdown = EntityFox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP));
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.xxa == 0.0f && EntityFox.this.yya == 0.0f && EntityFox.this.zza == 0.0f ? this.canSleep() || EntityFox.this.isSleeping() : false;
        }

        @Override
        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return EntityFox.this.level().isDay() && this.hasShelter() && !this.alertable() && !EntityFox.this.isInPowderSnow;
        }

        @Override
        public void stop() {
            this.countdown = EntityFox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            EntityFox.this.clearStates();
        }

        @Override
        public void start() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setIsCrouching(false);
            EntityFox.this.setIsInterested(false);
            EntityFox.this.setJumping(false);
            EntityFox.this.setSleeping(true);
            EntityFox.this.getNavigation().stop();
            EntityFox.this.getMoveControl().setWantedPosition(EntityFox.this.getX(), EntityFox.this.getY(), EntityFox.this.getZ(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox fox;

        public h(EntityFox entityFox, EntityFox entityfox, EntityFox entityfox1, double d0) {
            super(entityfox1, d0);
            this.fox = entityfox1;
        }

        @Override
        public boolean canUse() {
            return !this.fox.isDefending() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return !this.fox.isDefending() && super.canContinueToUse();
        }

        @Override
        public void start() {
            this.fox.clearStates();
            super.start();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void start() {
            EntityFox.this.clearStates();
            super.start();
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.canFoxMove();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !EntityFox.this.isSleeping() && !EntityFox.this.isSitting() && !EntityFox.this.isDefending() && EntityFox.this.getTarget() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double acceptedDistance() {
            return 2.0;
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.getBlockState(blockposition);
            return iblockdata.is(Blocks.SWEET_BERRY_BUSH) && iblockdata.getValue(BlockSweetBerryBush.AGE) >= 2 || CaveVines.hasGlowBerries(iblockdata);
        }

        @Override
        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && EntityFox.this.random.nextFloat() < 0.05f) {
                EntityFox.this.playSound(SoundEffects.FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            if (EntityFox.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                IBlockData iblockdata = EntityFox.this.level().getBlockState(this.blockPos);
                if (iblockdata.is(Blocks.SWEET_BERRY_BUSH)) {
                    this.pickSweetBerries(iblockdata);
                } else if (CaveVines.hasGlowBerries(iblockdata)) {
                    this.pickGlowBerry(iblockdata);
                }
            }
        }

        private void pickGlowBerry(IBlockData iblockdata) {
            CaveVines.use(EntityFox.this, iblockdata, EntityFox.this.level(), this.blockPos);
        }

        private void pickSweetBerries(IBlockData iblockdata) {
            int i2 = iblockdata.getValue(BlockSweetBerryBush.AGE);
            iblockdata.setValue(BlockSweetBerryBush.AGE, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.blockPos, (IBlockData)iblockdata.setValue(BlockSweetBerryBush.AGE, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.level().random.nextInt(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (itemstack.isEmpty()) {
                EntityFox.this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.SWEET_BERRIES));
                --j2;
            }
            if (j2 > 0) {
                Block.popResource(EntityFox.this.level(), this.blockPos, new ItemStack(Items.SWEET_BERRIES, j2));
            }
            EntityFox.this.playSound(SoundEffects.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            EntityFox.this.level().setBlock(this.blockPos, (IBlockData)iblockdata.setValue(BlockSweetBerryBush.AGE, 1), 2);
            EntityFox.this.level().gameEvent(GameEvent.BLOCK_CHANGE, this.blockPos, GameEvent.a.of(EntityFox.this));
        }

        @Override
        public boolean canUse() {
            return !EntityFox.this.isSleeping() && super.canUse();
        }

        @Override
        public void start() {
            this.ticksWaited = 0;
            EntityFox.this.setSitting(false);
            super.start();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (!EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (EntityFox.this.getTarget() == null && EntityFox.this.getLastHurtByMob() == null) {
                if (!EntityFox.this.canMove()) {
                    return false;
                }
                if (EntityFox.this.getRandom().nextInt(p.reducedTickDelay(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.level().getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty();
            }
            return false;
        }

        @Override
        public void tick() {
            List<EntityItem> list = EntityFox.this.level().getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                EntityFox.this.getNavigation().moveTo(list.get(0), (double)1.2f);
            }
        }

        @Override
        public void start() {
            List<EntityItem> list = EntityFox.this.level().getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                EntityFox.this.getNavigation().moveTo(list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient entityinsentient, Class oclass, float f2) {
            super(entityinsentient, oclass, f2);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !EntityFox.this.isFaceplanted() && !EntityFox.this.isInterested();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && !EntityFox.this.isFaceplanted() && !EntityFox.this.isInterested();
        }
    }

    private class r
    extends d {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public r() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.getLastHurtByMob() == null && EntityFox.this.getRandom().nextFloat() < 0.02f && !EntityFox.this.isSleeping() && EntityFox.this.getTarget() == null && EntityFox.this.getNavigation().isDone() && !this.alertable() && !EntityFox.this.isPouncing() && !EntityFox.this.isCrouching();
        }

        @Override
        public boolean canContinueToUse() {
            return this.looksRemaining > 0;
        }

        @Override
        public void start() {
            this.resetLook();
            this.looksRemaining = 2 + EntityFox.this.getRandom().nextInt(3);
            EntityFox.this.setSitting(true);
            EntityFox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            EntityFox.this.setSitting(false);
        }

        @Override
        public void tick() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            EntityFox.this.getLookControl().setLookAt(EntityFox.this.getX() + this.relX, EntityFox.this.getEyeY(), EntityFox.this.getZ() + this.relZ, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
        }

        private void resetLook() {
            double d0 = Math.PI * 2 * EntityFox.this.getRandom().nextDouble();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = this.adjustedTickDelay(80 + EntityFox.this.getRandom().nextInt(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving trustedLastHurtBy;
        @Nullable
        private EntityLiving trustedLastHurt;
        private int timestamp;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean canUse() {
            if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.getTrustedUUIDs()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.level() instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.level()).getEntity(uuid)) instanceof EntityLiving)) continue;
                this.trustedLastHurt = entityliving = (EntityLiving)entity;
                this.trustedLastHurtBy = entityliving.getLastHurtByMob();
                int i2 = entityliving.getLastHurtByMobTimestamp();
                return i2 != this.timestamp && this.canAttack(this.trustedLastHurtBy, this.targetConditions);
            }
            return false;
        }

        @Override
        public void start() {
            this.setTarget(this.trustedLastHurtBy);
            this.target = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.getLastHurtByMobTimestamp();
            }
            EntityFox.this.playSound(SoundEffects.FOX_AGGRO, 1.0f, 1.0f);
            EntityFox.this.setDefending(true);
            EntityFox.this.wakeUp();
            super.start();
        }
    }

    public static enum Type implements INamable
    {
        RED(0, "red"),
        SNOW(1, "snow");

        public static final INamable.a<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;

        private Type(int i2, String s2) {
            this.id = i2;
            this.name = s2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String s2) {
            return CODEC.byName(s2, RED);
        }

        public static Type byId(int i2) {
            return BY_ID.apply(i2);
        }

        public static Type byBiome(Holder<BiomeBase> holder) {
            return holder.is(BiomeTags.SPAWNS_SNOW_FOXES) ? SNOW : RED;
        }

        static {
            CODEC = INamable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::getId, Type.values(), ByIdMap.a.ZERO);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type type;

        public i(Type entityfox_type) {
            super(false);
            this.type = entityfox_type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        @Override
        public boolean test(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).isTame() : (entityliving instanceof EntityHuman && (entityliving.isSpectator() || ((EntityHuman)entityliving).isCreative()) ? false : (EntityFox.this.trusts(entityliving.getUUID()) ? false : !entityliving.isSleeping() && !entityliving.isDiscrete()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition alertableTargeting;

        d() {
            this.alertableTargeting = PathfinderTargetCondition.forCombat().range(12.0).ignoreLineOfSight().selector(new c());
        }

        protected boolean hasShelter() {
            BlockPosition blockposition = BlockPosition.containing(EntityFox.this.getX(), EntityFox.this.getBoundingBox().maxY, EntityFox.this.getZ());
            return !EntityFox.this.level().canSeeSky(blockposition) && EntityFox.this.getWalkTargetValue(blockposition) >= 0.0f;
        }

        protected boolean alertable() {
            return !EntityFox.this.level().getNearbyEntities(EntityLiving.class, this.alertableTargeting, EntityFox.this, EntityFox.this.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

