/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> DATA_TYPE = DataWatcher.defineId(EntityMushroomCow.class, DataWatcherRegistry.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    public SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> entitytypes, World world) {
        super((EntityTypes<? extends EntityCow>)entitytypes, world);
    }

    @Override
    public float getWalkTargetValue(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.getBlockState(blockposition.below()).is(Blocks.MYCELIUM) ? 10.0f : iworldreader.getPathfindingCostFromLightLevels(blockposition);
    }

    public static boolean checkMushroomSpawnRules(EntityTypes<EntityMushroomCow> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(TagsBlock.MOOSHROOMS_SPAWNABLE_ON) && EntityMushroomCow.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    @Override
    public void thunderHit(WorldServer worldserver, EntityLightning entitylightning) {
        UUID uuid = entitylightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Type.RED ? Type.BROWN : Type.RED);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEffects.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_TYPE, Type.RED.type);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.BOWL) && !this.isBaby()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.stewEffects != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.SUSPICIOUS_STEW);
                itemstack1.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                itemstack1 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack itemstack2 = ItemLiquidUtil.createFilledResult(itemstack, entityhuman, itemstack1, false);
            entityhuman.setItemInHand(enumhand, itemstack2);
            SoundEffect soundeffect = flag ? SoundEffects.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEffects.MOOSHROOM_MILK;
            this.playSound(soundeffect, 1.0f, 1.0f);
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                return EnumInteractionResult.PASS;
            }
            this.shear(SoundCategory.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, entityhuman);
            if (!this.level().isClientSide) {
                itemstack.hurtAndBreak(1, entityhuman, EntityMushroomCow.getSlotForHand(enumhand));
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.getVariant() == Type.BROWN && itemstack.is(TagsItem.SMALL_FLOWERS)) {
            if (this.stewEffects != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.level().addParticle(Particles.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<SuspiciousStewEffects> optional = this.getEffectsFromItemStack(itemstack);
                if (optional.isEmpty()) {
                    return EnumInteractionResult.PASS;
                }
                itemstack.consume(1, entityhuman);
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.level().addParticle(Particles.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = optional.get();
                this.playSound(SoundEffects.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(entityhuman, enumhand);
    }

    @Override
    public void shear(SoundCategory soundcategory) {
        EntityCow entitycow;
        this.level().playSound((EntityHuman)null, this, SoundEffects.MOOSHROOM_SHEAR, soundcategory, 1.0f, 1.0f);
        if (!this.level().isClientSide() && (entitycow = EntityTypes.COW.create(this.level())) != null) {
            ((WorldServer)this.level()).sendParticles(Particles.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            entitycow.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            entitycow.setHealth(this.getHealth());
            entitycow.yBodyRot = this.yBodyRot;
            if (this.hasCustomName()) {
                entitycow.setCustomName(this.getCustomName());
                entitycow.setCustomNameVisible(this.isCustomNameVisible());
            }
            if (this.isPersistenceRequired()) {
                entitycow.setPersistenceRequired();
            }
            entitycow.setInvulnerable(this.isInvulnerable());
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitycow, EntityTransformEvent.TransformReason.SHEARED).isCancelled()) {
                return;
            }
            this.level().addFreshEntity(entitycow, CreatureSpawnEvent.SpawnReason.SHEARED);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            for (int i2 = 0; i2 < 5; ++i2) {
                EntityItem entityitem = new EntityItem(this.level(), this.getX(), this.getY(1.0), this.getZ(), new ItemStack(this.getVariant().blockState.getBlock()));
                EntityDropItemEvent event = new EntityDropItemEvent((Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.level().addFreshEntity(entityitem);
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.stewEffects).ifSuccess(nbtbase -> nbttagcompound.put(TAG_STEW_EFFECTS, (NBTBase)nbtbase));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setVariant(Type.byType(nbttagcompound.getString("Type")));
        if (nbttagcompound.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get(TAG_STEW_EFFECTS)).ifSuccess(suspicioussteweffects -> {
                this.stewEffects = suspicioussteweffects;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack itemstack) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.tryGet(itemstack.getItem());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.getSuspiciousEffects()) : Optional.empty();
    }

    @Override
    public void setVariant(Type entitymushroomcow_type) {
        this.entityData.set(DATA_TYPE, entitymushroomcow_type.type);
    }

    @Override
    public Type getVariant() {
        return Type.byType(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public EntityMushroomCow getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        EntityMushroomCow entitymushroomcow = EntityTypes.MOOSHROOM.create(worldserver);
        if (entitymushroomcow != null) {
            entitymushroomcow.setVariant(this.getOffspringType((EntityMushroomCow)entityageable));
        }
        return entitymushroomcow;
    }

    private Type getOffspringType(EntityMushroomCow entitymushroomcow) {
        Type entitymushroomcow_type1;
        Type entitymushroomcow_type = this.getVariant();
        Type entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = entitymushroomcow.getVariant()) && this.random.nextInt(1024) == 0 ? (entitymushroomcow_type == Type.BROWN ? Type.RED : Type.BROWN) : (this.random.nextBoolean() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    public static enum Type implements INamable
    {
        RED("red", Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final INamable.a<Type> CODEC;
        final String type;
        final IBlockData blockState;

        private Type(String s2, IBlockData iblockdata) {
            this.type = s2;
            this.blockState = iblockdata;
        }

        public IBlockData getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static Type byType(String s2) {
            return CODEC.byName(s2, RED);
        }

        static {
            CODEC = INamable.fromEnum(Type::values);
        }
    }
}

