/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityPanda
extends EntityAnimal {
    private static final DataWatcherObject<Integer> UNHAPPY_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> SNEEZE_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> EAT_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Byte> MAIN_GENE_ID = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> HIDDEN_GENE_ID = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    static final PathfinderTargetCondition BREED_TARGETING = PathfinderTargetCondition.forNonCombat().range(8.0);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.PANDA.getDimensions().scale(0.5f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, 0.40625f, 0.0f));
    private static final int FLAG_SNEEZE = 2;
    private static final int FLAG_ROLL = 4;
    private static final int FLAG_SIT = 8;
    private static final int FLAG_ON_BACK = 16;
    private static final int EAT_TICK_INTERVAL = 5;
    public static final int TOTAL_ROLL_STEPS = 32;
    private static final int TOTAL_UNHAPPY_TIME = 32;
    boolean gotBamboo;
    boolean didBite;
    public int rollCounter;
    private Vec3D rollDelta;
    private float sitAmount;
    private float sitAmountO;
    private float onBackAmount;
    private float onBackAmountO;
    private float rollAmount;
    private float rollAmountO;
    g lookAtPlayerGoal;
    static final Predicate<EntityItem> PANDA_ITEMS = entityitem -> {
        ItemStack itemstack = entityitem.getItem();
        return (itemstack.is(Blocks.BAMBOO.asItem()) || itemstack.is(Blocks.CAKE.asItem())) && entityitem.isAlive() && !entityitem.hasPickUpDelay();
    };

    public EntityPanda(EntityTypes<? extends EntityPanda> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.moveControl = new h(this);
        if (!this.isBaby()) {
            this.setCanPickUpLoot(true);
        }
    }

    @Override
    public boolean canTakeItem(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        return !this.getItemBySlot(enumitemslot).isEmpty() ? false : enumitemslot == EnumItemSlot.MAINHAND && super.canTakeItem(itemstack);
    }

    public int getUnhappyCounter() {
        return this.entityData.get(UNHAPPY_COUNTER);
    }

    public void setUnhappyCounter(int i2) {
        this.entityData.set(UNHAPPY_COUNTER, i2);
    }

    public boolean isSneezing() {
        return this.getFlag(2);
    }

    public boolean isSitting() {
        return this.getFlag(8);
    }

    public void sit(boolean flag) {
        this.setFlag(8, flag);
    }

    public boolean isOnBack() {
        return this.getFlag(16);
    }

    public void setOnBack(boolean flag) {
        this.setFlag(16, flag);
    }

    public boolean isEating() {
        return this.entityData.get(EAT_COUNTER) > 0;
    }

    public void eat(boolean flag) {
        this.entityData.set(EAT_COUNTER, flag ? 1 : 0);
    }

    private int getEatCounter() {
        return this.entityData.get(EAT_COUNTER);
    }

    private void setEatCounter(int i2) {
        this.entityData.set(EAT_COUNTER, i2);
    }

    public void sneeze(boolean flag) {
        this.setFlag(2, flag);
        if (!flag) {
            this.setSneezeCounter(0);
        }
    }

    public int getSneezeCounter() {
        return this.entityData.get(SNEEZE_COUNTER);
    }

    public void setSneezeCounter(int i2) {
        this.entityData.set(SNEEZE_COUNTER, i2);
    }

    public Gene getMainGene() {
        return Gene.byId(this.entityData.get(MAIN_GENE_ID).byteValue());
    }

    public void setMainGene(Gene entitypanda_gene) {
        if (entitypanda_gene.getId() > 6) {
            entitypanda_gene = Gene.getRandom(this.random);
        }
        this.entityData.set(MAIN_GENE_ID, (byte)entitypanda_gene.getId());
    }

    public Gene getHiddenGene() {
        return Gene.byId(this.entityData.get(HIDDEN_GENE_ID).byteValue());
    }

    public void setHiddenGene(Gene entitypanda_gene) {
        if (entitypanda_gene.getId() > 6) {
            entitypanda_gene = Gene.getRandom(this.random);
        }
        this.entityData.set(HIDDEN_GENE_ID, (byte)entitypanda_gene.getId());
    }

    public boolean isRolling() {
        return this.getFlag(4);
    }

    public void roll(boolean flag) {
        this.setFlag(4, flag);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(UNHAPPY_COUNTER, 0);
        datawatcher_a.define(SNEEZE_COUNTER, 0);
        datawatcher_a.define(MAIN_GENE_ID, (byte)0);
        datawatcher_a.define(HIDDEN_GENE_ID, (byte)0);
        datawatcher_a.define(DATA_ID_FLAGS, (byte)0);
        datawatcher_a.define(EAT_COUNTER, 0);
    }

    private boolean getFlag(int i2) {
        return (this.entityData.get(DATA_ID_FLAGS) & i2) != 0;
    }

    private void setFlag(int i2, boolean flag) {
        byte b0 = this.entityData.get(DATA_ID_FLAGS);
        if (flag) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 | i2));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 & ~i2));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putString("MainGene", this.getMainGene().getSerializedName());
        nbttagcompound.putString("HiddenGene", this.getHiddenGene().getSerializedName());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setMainGene(Gene.byName(nbttagcompound.getString("MainGene")));
        this.setHiddenGene(Gene.byName(nbttagcompound.getString("HiddenGene")));
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        EntityPanda entitypanda = EntityTypes.PANDA.create(worldserver);
        if (entitypanda != null) {
            if (entityageable instanceof EntityPanda) {
                EntityPanda entitypanda1 = (EntityPanda)entityageable;
                entitypanda.setGeneFromParents(this, entitypanda1);
            }
            entitypanda.setAttributes();
        }
        return entitypanda;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new i(this, 2.0));
        this.goalSelector.addGoal(2, new d(this, 1.0));
        this.goalSelector.addGoal(3, new b(this, (double)1.2f, true));
        this.goalSelector.addGoal(4, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.is(TagsItem.PANDA_FOOD), false));
        this.goalSelector.addGoal(6, new c<EntityHuman>(this, EntityHuman.class, 8.0f, 2.0, 2.0));
        this.goalSelector.addGoal(6, new c<EntityMonster>(this, EntityMonster.class, 4.0f, 2.0, 2.0));
        this.goalSelector.addGoal(7, new k());
        this.goalSelector.addGoal(8, new f(this));
        this.goalSelector.addGoal(8, new l(this));
        this.lookAtPlayerGoal = new g(this, EntityHuman.class, 6.0f);
        this.goalSelector.addGoal(9, this.lookAtPlayerGoal);
        this.goalSelector.addGoal(10, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(12, new j(this));
        this.goalSelector.addGoal(13, new PathfinderGoalFollowParent(this, 1.25));
        this.goalSelector.addGoal(14, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.targetSelector.addGoal(1, new e(this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.15f).add(GenericAttributes.ATTACK_DAMAGE, 6.0);
    }

    public Gene getVariant() {
        return Gene.getVariantFromGenes(this.getMainGene(), this.getHiddenGene());
    }

    public boolean isLazy() {
        return this.getVariant() == Gene.LAZY;
    }

    public boolean isWorried() {
        return this.getVariant() == Gene.WORRIED;
    }

    public boolean isPlayful() {
        return this.getVariant() == Gene.PLAYFUL;
    }

    public boolean isBrown() {
        return this.getVariant() == Gene.BROWN;
    }

    public boolean isWeak() {
        return this.getVariant() == Gene.WEAK;
    }

    @Override
    public boolean isAggressive() {
        return this.getVariant() == Gene.AGGRESSIVE;
    }

    @Override
    public boolean canBeLeashed() {
        return false;
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (!this.isAggressive()) {
            this.didBite = true;
        }
        return super.doHurtTarget(entity);
    }

    @Override
    public void playAttackSound() {
        this.playSound(SoundEffects.PANDA_BITE, 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        EntityLiving entityliving;
        super.tick();
        if (this.isWorried()) {
            if (this.level().isThundering() && !this.isInWater()) {
                this.sit(true);
                this.eat(false);
            } else if (!this.isEating()) {
                this.sit(false);
            }
        }
        if ((entityliving = this.getTarget()) == null) {
            this.gotBamboo = false;
            this.didBite = false;
        }
        if (this.getUnhappyCounter() > 0) {
            if (entityliving != null) {
                this.lookAt(entityliving, 90.0f, 90.0f);
            }
            if (this.getUnhappyCounter() == 29 || this.getUnhappyCounter() == 14) {
                this.playSound(SoundEffects.PANDA_CANT_BREED, 1.0f, 1.0f);
            }
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        if (this.isSneezing()) {
            this.setSneezeCounter(this.getSneezeCounter() + 1);
            if (this.getSneezeCounter() > 20) {
                this.sneeze(false);
                this.afterSneeze();
            } else if (this.getSneezeCounter() == 1) {
                this.playSound(SoundEffects.PANDA_PRE_SNEEZE, 1.0f, 1.0f);
            }
        }
        if (this.isRolling()) {
            this.handleRoll();
        } else {
            this.rollCounter = 0;
        }
        if (this.isSitting()) {
            this.setXRot(0.0f);
        }
        this.updateSitAmount();
        this.handleEating();
        this.updateOnBackAnimation();
        this.updateRollAmount();
    }

    public boolean isScared() {
        return this.isWorried() && this.level().isThundering();
    }

    private void handleEating() {
        if (!this.isEating() && this.isSitting() && !this.isScared() && !this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() && this.random.nextInt(80) == 1) {
            this.eat(true);
        } else if (this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() || !this.isSitting()) {
            this.eat(false);
        }
        if (this.isEating()) {
            this.addEatingParticles();
            if (!this.level().isClientSide && this.getEatCounter() > 80 && this.random.nextInt(20) == 1) {
                if (this.getEatCounter() > 100 && this.isFoodOrCake(this.getItemBySlot(EnumItemSlot.MAINHAND))) {
                    if (!this.level().isClientSide) {
                        this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                        this.gameEvent(GameEvent.EAT);
                    }
                    this.sit(false);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void addEatingParticles() {
        if (this.getEatCounter() % 5 == 0) {
            this.playSound(SoundEffects.PANDA_EAT, 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            for (int i2 = 0; i2 < 6; ++i2) {
                Vec3D vec3d = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                vec3d = vec3d.xRot(-this.getXRot() * ((float)Math.PI / 180));
                vec3d = vec3d.yRot(-this.getYRot() * ((float)Math.PI / 180));
                double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
                Vec3D vec3d1 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.random.nextFloat() - 0.5) * 0.4);
                vec3d1 = vec3d1.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                vec3d1 = vec3d1.add(this.getX(), this.getEyeY() + 1.0, this.getZ());
                this.level().addParticle(new ParticleParamItem(Particles.ITEM, this.getItemBySlot(EnumItemSlot.MAINHAND)), vec3d1.x, vec3d1.y, vec3d1.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
            }
        }
    }

    private void updateSitAmount() {
        this.sitAmountO = this.sitAmount;
        this.sitAmount = this.isSitting() ? Math.min(1.0f, this.sitAmount + 0.15f) : Math.max(0.0f, this.sitAmount - 0.19f);
    }

    private void updateOnBackAnimation() {
        this.onBackAmountO = this.onBackAmount;
        this.onBackAmount = this.isOnBack() ? Math.min(1.0f, this.onBackAmount + 0.15f) : Math.max(0.0f, this.onBackAmount - 0.19f);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.15f) : Math.max(0.0f, this.rollAmount - 0.19f);
    }

    public float getSitAmount(float f2) {
        return MathHelper.lerp(f2, this.sitAmountO, this.sitAmount);
    }

    public float getLieOnBackAmount(float f2) {
        return MathHelper.lerp(f2, this.onBackAmountO, this.onBackAmount);
    }

    public float getRollAmount(float f2) {
        return MathHelper.lerp(f2, this.rollAmountO, this.rollAmount);
    }

    private void handleRoll() {
        ++this.rollCounter;
        if (this.rollCounter > 32) {
            this.roll(false);
        } else if (!this.level().isClientSide) {
            Vec3D vec3d = this.getDeltaMovement();
            if (this.rollCounter == 1) {
                float f2 = this.getYRot() * ((float)Math.PI / 180);
                float f1 = this.isBaby() ? 0.1f : 0.2f;
                this.rollDelta = new Vec3D(vec3d.x + (double)(-MathHelper.sin(f2) * f1), 0.0, vec3d.z + (double)(MathHelper.cos(f2) * f1));
                this.setDeltaMovement(this.rollDelta.add(0.0, 0.27, 0.0));
            } else if ((float)this.rollCounter != 7.0f && (float)this.rollCounter != 15.0f && (float)this.rollCounter != 23.0f) {
                this.setDeltaMovement(this.rollDelta.x, vec3d.y, this.rollDelta.z);
            } else {
                this.setDeltaMovement(0.0, this.onGround() ? 0.27 : vec3d.y, 0.0);
            }
        }
    }

    private void afterSneeze() {
        Vec3D vec3d = this.getDeltaMovement();
        World world = this.level();
        world.addParticle(Particles.SNEEZE, this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.sin(this.yBodyRot * ((float)Math.PI / 180)), this.getEyeY() - (double)0.1f, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.cos(this.yBodyRot * ((float)Math.PI / 180)), vec3d.x, 0.0, vec3d.z);
        this.playSound(SoundEffects.PANDA_SNEEZE, 1.0f, 1.0f);
        List<EntityPanda> list = world.getEntitiesOfClass(EntityPanda.class, this.getBoundingBox().inflate(10.0));
        for (EntityPanda entitypanda : list) {
            if (entitypanda.isBaby() || !entitypanda.onGround() || entitypanda.isInWater() || !entitypanda.canPerformAction()) continue;
            entitypanda.jumpFromGround();
        }
        if (!world.isClientSide() && world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            WorldServer worldserver = (WorldServer)world;
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(LootTables.PANDA_SNEEZE);
            LootParams lootparams = new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.GIFT);
            ObjectArrayList<ItemStack> list1 = loottable.getRandomItems(lootparams);
            for (ItemStack itemstack : list1) {
                this.spawnAtLocation(itemstack);
            }
        }
    }

    @Override
    protected void pickUpItem(EntityItem entityitem) {
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() || !PANDA_ITEMS.test(entityitem)).isCancelled()) {
            this.onItemPickup(entityitem);
            ItemStack itemstack = entityitem.getItem();
            this.setItemSlot(EnumItemSlot.MAINHAND, itemstack);
            this.setGuaranteedDrop(EnumItemSlot.MAINHAND);
            this.take(entityitem, itemstack.getCount());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (!this.level().isClientSide) {
            this.sit(false);
        }
        return super.hurt(damagesource, f2);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        this.setMainGene(Gene.getRandom(randomsource));
        this.setHiddenGene(Gene.getRandom(randomsource));
        this.setAttributes();
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(0.2f);
        }
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    public void setGeneFromParents(EntityPanda entitypanda, @Nullable EntityPanda entitypanda1) {
        if (entitypanda1 == null) {
            if (this.random.nextBoolean()) {
                this.setMainGene(entitypanda.getOneOfGenesRandomly());
                this.setHiddenGene(Gene.getRandom(this.random));
            } else {
                this.setMainGene(Gene.getRandom(this.random));
                this.setHiddenGene(entitypanda.getOneOfGenesRandomly());
            }
        } else if (this.random.nextBoolean()) {
            this.setMainGene(entitypanda.getOneOfGenesRandomly());
            this.setHiddenGene(entitypanda1.getOneOfGenesRandomly());
        } else {
            this.setMainGene(entitypanda1.getOneOfGenesRandomly());
            this.setHiddenGene(entitypanda.getOneOfGenesRandomly());
        }
        if (this.random.nextInt(32) == 0) {
            this.setMainGene(Gene.getRandom(this.random));
        }
        if (this.random.nextInt(32) == 0) {
            this.setHiddenGene(Gene.getRandom(this.random));
        }
    }

    private Gene getOneOfGenesRandomly() {
        return this.random.nextBoolean() ? this.getMainGene() : this.getHiddenGene();
    }

    public void setAttributes() {
        if (this.isWeak()) {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(10.0);
        }
        if (this.isLazy()) {
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(0.07f);
        }
    }

    void tryToSit() {
        if (!this.isInWater()) {
            this.setZza(0.0f);
            this.getNavigation().stop();
            this.sit(true);
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (this.isScared()) {
            return EnumInteractionResult.PASS;
        }
        if (this.isOnBack()) {
            this.setOnBack(false);
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.isFood(itemstack)) {
            if (this.getTarget() != null) {
                this.gotBamboo = true;
            }
            if (this.isBaby()) {
                this.usePlayerItem(entityhuman, enumhand, itemstack);
                this.ageUp((int)((float)(-this.getAge() / 20) * 0.1f), true);
            } else if (!this.level().isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.usePlayerItem(entityhuman, enumhand, itemstack);
                this.setInLove(entityhuman);
            } else {
                if (this.level().isClientSide || this.isSitting() || this.isInWater()) {
                    return EnumInteractionResult.PASS;
                }
                this.tryToSit();
                this.eat(true);
                ItemStack itemstack1 = this.getItemBySlot(EnumItemSlot.MAINHAND);
                if (!itemstack1.isEmpty() && !entityhuman.hasInfiniteMaterials()) {
                    this.spawnAtLocation(itemstack1);
                }
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(itemstack.getItem(), 1));
                this.usePlayerItem(entityhuman, enumhand, itemstack);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return this.isAggressive() ? SoundEffects.PANDA_AGGRESSIVE_AMBIENT : (this.isWorried() ? SoundEffects.PANDA_WORRIED_AMBIENT : SoundEffects.PANDA_AMBIENT);
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        this.playSound(SoundEffects.PANDA_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.PANDA_FOOD);
    }

    private boolean isFoodOrCake(ItemStack itemstack) {
        return this.isFood(itemstack) || itemstack.is(Blocks.CAKE.asItem());
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.PANDA_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.PANDA_HURT;
    }

    public boolean canPerformAction() {
        return !this.isOnBack() && !this.isScared() && !this.isEating() && !this.isRolling() && !this.isSitting();
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(entitypose);
    }

    private static class h
    extends ControllerMove {
        private final EntityPanda panda;

        public h(EntityPanda entitypanda) {
            super(entitypanda);
            this.panda = entitypanda;
        }

        @Override
        public void tick() {
            if (this.panda.canPerformAction()) {
                super.tick();
            }
        }
    }

    public static enum Gene implements INamable
    {
        NORMAL(0, "normal", false),
        LAZY(1, "lazy", false),
        WORRIED(2, "worried", false),
        PLAYFUL(3, "playful", false),
        BROWN(4, "brown", true),
        WEAK(5, "weak", true),
        AGGRESSIVE(6, "aggressive", false);

        public static final INamable.a<Gene> CODEC;
        private static final IntFunction<Gene> BY_ID;
        private static final int MAX_GENE = 6;
        private final int id;
        private final String name;
        private final boolean isRecessive;

        private Gene(int i2, String s2, boolean flag) {
            this.id = i2;
            this.name = s2;
            this.isRecessive = flag;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public boolean isRecessive() {
            return this.isRecessive;
        }

        static Gene getVariantFromGenes(Gene entitypanda_gene, Gene entitypanda_gene1) {
            return entitypanda_gene.isRecessive() ? (entitypanda_gene == entitypanda_gene1 ? entitypanda_gene : NORMAL) : entitypanda_gene;
        }

        public static Gene byId(int i2) {
            return BY_ID.apply(i2);
        }

        public static Gene byName(String s2) {
            return CODEC.byName(s2, NORMAL);
        }

        public static Gene getRandom(RandomSource randomsource) {
            int i2 = randomsource.nextInt(16);
            return i2 == 0 ? LAZY : (i2 == 1 ? WORRIED : (i2 == 2 ? PLAYFUL : (i2 == 4 ? AGGRESSIVE : (i2 < 9 ? WEAK : (i2 < 11 ? BROWN : NORMAL)))));
        }

        static {
            CODEC = INamable.fromEnum(Gene::values);
            BY_ID = ByIdMap.continuous(Gene::getId, Gene.values(), ByIdMap.a.ZERO);
        }
    }

    private static class i
    extends PathfinderGoalPanic {
        private final EntityPanda panda;

        public i(EntityPanda entitypanda, double d0) {
            super((EntityCreature)entitypanda, d0, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES);
            this.panda = entitypanda;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.panda.isSitting()) {
                this.panda.getNavigation().stop();
                return false;
            }
            return super.canContinueToUse();
        }
    }

    private static class d
    extends PathfinderGoalBreed {
        private final EntityPanda panda;
        private int unhappyCooldown;

        public d(EntityPanda entitypanda, double d0) {
            super(entitypanda, d0);
            this.panda = entitypanda;
        }

        @Override
        public boolean canUse() {
            if (super.canUse() && this.panda.getUnhappyCounter() == 0) {
                if (!this.canFindBamboo()) {
                    if (this.unhappyCooldown <= this.panda.tickCount) {
                        this.panda.setUnhappyCounter(32);
                        this.unhappyCooldown = this.panda.tickCount + 600;
                        if (this.panda.isEffectiveAi()) {
                            EntityHuman entityhuman = this.level.getNearestPlayer(BREED_TARGETING, this.panda);
                            this.panda.lookAtPlayerGoal.setTarget(entityhuman);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean canFindBamboo() {
            BlockPosition blockposition = this.panda.blockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int j2 = 0; j2 < 8; ++j2) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.setWithOffset(blockposition, k2, i2, l2);
                            if (this.level.getBlockState(blockposition_mutableblockposition).is(Blocks.BAMBOO)) {
                                return true;
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                }
            }
            return false;
        }
    }

    private static class b
    extends PathfinderGoalMeleeAttack {
        private final EntityPanda panda;

        public b(EntityPanda entitypanda, double d0, boolean flag) {
            super(entitypanda, d0, flag);
            this.panda = entitypanda;
        }

        @Override
        public boolean canUse() {
            return this.panda.canPerformAction() && super.canUse();
        }
    }

    private static class c<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityPanda panda;

        public c(EntityPanda entitypanda, Class<T> oclass, float f2, double d0, double d1) {
            super(entitypanda, oclass, f2, d0, d1, IEntitySelector.NO_SPECTATORS::test);
            this.panda = entitypanda;
        }

        @Override
        public boolean canUse() {
            return this.panda.isWorried() && this.panda.canPerformAction() && super.canUse();
        }
    }

    private class k
    extends PathfinderGoal {
        private int cooldown;

        public k() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (this.cooldown <= EntityPanda.this.tickCount && !EntityPanda.this.isBaby() && !EntityPanda.this.isInWater() && EntityPanda.this.canPerformAction() && EntityPanda.this.getUnhappyCounter() <= 0) {
                List<EntityItem> list = EntityPanda.this.level().getEntitiesOfClass(EntityItem.class, EntityPanda.this.getBoundingBox().inflate(6.0, 6.0, 6.0), PANDA_ITEMS);
                return !list.isEmpty() || !EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty();
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return !EntityPanda.this.isInWater() && (EntityPanda.this.isLazy() || EntityPanda.this.random.nextInt(k.reducedTickDelay(600)) != 1) ? EntityPanda.this.random.nextInt(k.reducedTickDelay(2000)) != 1 : false;
        }

        @Override
        public void tick() {
            if (!EntityPanda.this.isSitting() && !EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.tryToSit();
            }
        }

        @Override
        public void start() {
            List<EntityItem> list = EntityPanda.this.level().getEntitiesOfClass(EntityItem.class, EntityPanda.this.getBoundingBox().inflate(8.0, 8.0, 8.0), PANDA_ITEMS);
            if (!list.isEmpty() && EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.getNavigation().moveTo(list.get(0), (double)1.2f);
            } else if (!EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.tryToSit();
            }
            this.cooldown = 0;
        }

        @Override
        public void stop() {
            ItemStack itemstack = EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!itemstack.isEmpty()) {
                EntityPanda.this.spawnAtLocation(itemstack);
                EntityPanda.this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                int i2 = EntityPanda.this.isLazy() ? EntityPanda.this.random.nextInt(50) + 10 : EntityPanda.this.random.nextInt(150) + 10;
                this.cooldown = EntityPanda.this.tickCount + i2 * 20;
            }
            EntityPanda.this.sit(false);
        }
    }

    private static class f
    extends PathfinderGoal {
        private final EntityPanda panda;
        private int cooldown;

        public f(EntityPanda entitypanda) {
            this.panda = entitypanda;
        }

        @Override
        public boolean canUse() {
            return this.cooldown < this.panda.tickCount && this.panda.isLazy() && this.panda.canPerformAction() && this.panda.random.nextInt(f.reducedTickDelay(400)) == 1;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.panda.isInWater() && (this.panda.isLazy() || this.panda.random.nextInt(f.reducedTickDelay(600)) != 1) ? this.panda.random.nextInt(f.reducedTickDelay(2000)) != 1 : false;
        }

        @Override
        public void start() {
            this.panda.setOnBack(true);
            this.cooldown = 0;
        }

        @Override
        public void stop() {
            this.panda.setOnBack(false);
            this.cooldown = this.panda.tickCount + 200;
        }
    }

    private static class l
    extends PathfinderGoal {
        private final EntityPanda panda;

        public l(EntityPanda entitypanda) {
            this.panda = entitypanda;
        }

        @Override
        public boolean canUse() {
            return this.panda.isBaby() && this.panda.canPerformAction() ? (this.panda.isWeak() && this.panda.random.nextInt(l.reducedTickDelay(500)) == 1 ? true : this.panda.random.nextInt(l.reducedTickDelay(6000)) == 1) : false;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            this.panda.sneeze(true);
        }
    }

    private static class g
    extends PathfinderGoalLookAtPlayer {
        private final EntityPanda panda;

        public g(EntityPanda entitypanda, Class<? extends EntityLiving> oclass, float f2) {
            super(entitypanda, oclass, f2);
            this.panda = entitypanda;
        }

        public void setTarget(EntityLiving entityliving) {
            this.lookAt = entityliving;
        }

        @Override
        public boolean canContinueToUse() {
            return this.lookAt != null && super.canContinueToUse();
        }

        @Override
        public boolean canUse() {
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                return false;
            }
            if (this.lookAt == null) {
                this.lookAt = this.lookAtType == EntityHuman.class ? this.mob.level().getNearestPlayer(this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate(this.lookDistance, 3.0, this.lookDistance), entityliving -> true), this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            }
            return this.panda.canPerformAction() && this.lookAt != null;
        }

        @Override
        public void tick() {
            if (this.lookAt != null) {
                super.tick();
            }
        }
    }

    private static class j
    extends PathfinderGoal {
        private final EntityPanda panda;

        public j(EntityPanda entitypanda) {
            this.panda = entitypanda;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP));
        }

        @Override
        public boolean canUse() {
            if ((this.panda.isBaby() || this.panda.isPlayful()) && this.panda.onGround()) {
                int j2;
                if (!this.panda.canPerformAction()) {
                    return false;
                }
                float f2 = this.panda.getYRot() * ((float)Math.PI / 180);
                float f1 = -MathHelper.sin(f2);
                float f22 = MathHelper.cos(f2);
                int i2 = (double)Math.abs(f1) > 0.5 ? MathHelper.sign(f1) : 0;
                int n2 = j2 = (double)Math.abs(f22) > 0.5 ? MathHelper.sign(f22) : 0;
                return this.panda.level().getBlockState(this.panda.blockPosition().offset(i2, -1, j2)).isAir() ? true : (this.panda.isPlayful() && this.panda.random.nextInt(j.reducedTickDelay(60)) == 1 ? true : this.panda.random.nextInt(j.reducedTickDelay(500)) == 1);
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            this.panda.roll(true);
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }
    }

    private static class e
    extends PathfinderGoalHurtByTarget {
        private final EntityPanda panda;

        public e(EntityPanda entitypanda, Class<?> ... aclass) {
            super(entitypanda, aclass);
            this.panda = entitypanda;
        }

        @Override
        public boolean canContinueToUse() {
            if (!this.panda.gotBamboo && !this.panda.didBite) {
                return super.canContinueToUse();
            }
            this.panda.setTarget(null);
            return false;
        }

        @Override
        protected void alertOther(EntityInsentient entityinsentient, EntityLiving entityliving) {
            if (entityinsentient instanceof EntityPanda && entityinsentient.isAggressive()) {
                entityinsentient.setTarget(entityliving, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }
}

