/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntityRabbit
extends EntityAnimal
implements VariantHolder<Variant> {
    public static final double STROLL_SPEED_MOD = 0.6;
    public static final double BREED_SPEED_MOD = 0.8;
    public static final double FOLLOW_SPEED_MOD = 1.0;
    public static final double FLEE_SPEED_MOD = 2.2;
    public static final double ATTACK_SPEED_MOD = 1.4;
    private static final DataWatcherObject<Integer> DATA_TYPE_ID = DataWatcher.defineId(EntityRabbit.class, DataWatcherRegistry.INT);
    private static final MinecraftKey KILLER_BUNNY = MinecraftKey.withDefaultNamespace("killer_bunny");
    private static final int DEFAULT_ATTACK_POWER = 3;
    private static final int EVIL_ATTACK_POWER_INCREMENT = 5;
    private static final MinecraftKey EVIL_ATTACK_POWER_MODIFIER = MinecraftKey.withDefaultNamespace("evil");
    private static final int EVIL_ARMOR_VALUE = 8;
    private static final int MORE_CARROTS_DELAY = 40;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    int moreCarrotTicks;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.jumpControl = new ControllerJumpRabbit(this);
        this.moveControl = new ControllerMoveRabbit(this);
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new ClimbOnTopOfPowderSnowGoal(this, this.level()));
        this.goalSelector.addGoal(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 0.8));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.is(TagsItem.RABBIT_FOOD), false));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.goalSelector.addGoal(5, new PathfinderGoalEatCarrots(this));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.goalSelector.addGoal(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float getJumpPower() {
        PathEntity pathentity;
        float f2 = 0.3f;
        if (this.horizontalCollision || this.moveControl.hasWanted() && this.moveControl.getWantedY() > this.getY() + 0.5) {
            f2 = 0.5f;
        }
        if ((pathentity = this.navigation.getPath()) != null && !pathentity.isDone()) {
            Vec3D vec3d = pathentity.getNextEntityPos(this);
            if (vec3d.y > this.getY() + 0.5) {
                f2 = 0.5f;
            }
        }
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            f2 = 0.2f;
        }
        return super.getJumpPower(f2 / 0.42f);
    }

    @Override
    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.moveControl.getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent(this, (byte)1);
        }
    }

    public float getJumpCompletion(float f2) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + f2) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double d0) {
        this.getNavigation().setSpeedModifier(d0);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), d0);
    }

    @Override
    public void setJumping(boolean flag) {
        super.setJumping(flag);
        if (flag) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_TYPE_ID, Variant.BROWN.id);
    }

    @Override
    public void customServerAiStep() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.random.nextInt(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
        if (this.onGround()) {
            ControllerJumpRabbit entityrabbit_controllerjumprabbit;
            EntityLiving entityliving;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (this.getVariant() == Variant.EVIL && this.jumpDelayTicks == 0 && (entityliving = this.getTarget()) != null && this.distanceToSqr(entityliving) < 16.0) {
                this.facePoint(entityliving.getX(), entityliving.getZ());
                this.moveControl.setWantedPosition(entityliving.getX(), entityliving.getY(), entityliving.getZ(), this.moveControl.getSpeedModifier());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!(entityrabbit_controllerjumprabbit = (ControllerJumpRabbit)this.jumpControl).wantJump()) {
                if (this.moveControl.hasWanted() && this.jumpDelayTicks == 0) {
                    PathEntity pathentity = this.navigation.getPath();
                    Vec3D vec3d = new Vec3D(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                    if (pathentity != null && !pathentity.isDone()) {
                        vec3d = pathentity.getNextEntityPos(this);
                    }
                    this.facePoint(vec3d.x, vec3d.z);
                    this.startJumping();
                }
            } else if (!entityrabbit_controllerjumprabbit.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround();
    }

    @Override
    public boolean canSpawnSprintParticle() {
        return false;
    }

    private void facePoint(double d0, double d1) {
        this.setYRot((float)(MathHelper.atan2(d1 - this.getZ(), d0 - this.getX()) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((ControllerJumpRabbit)this.jumpControl).setCanJump(true);
    }

    private void disableJumpControl() {
        ((ControllerJumpRabbit)this.jumpControl).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.moveControl.getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 3.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt("RabbitType", this.getVariant().id);
        nbttagcompound.putInt("MoreCarrotTicks", this.moreCarrotTicks);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setVariant(Variant.byId(nbttagcompound.getInt("RabbitType")));
        this.moreCarrotTicks = nbttagcompound.getInt("MoreCarrotTicks");
    }

    protected SoundEffect getJumpSound() {
        return SoundEffects.RABBIT_JUMP;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.RABBIT_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.RABBIT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.RABBIT_DEATH;
    }

    @Override
    public void playAttackSound() {
        if (this.getVariant() == Variant.EVIL) {
            this.playSound(SoundEffects.RABBIT_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public SoundCategory getSoundSource() {
        return this.getVariant() == Variant.EVIL ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public EntityRabbit getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        block2: {
            block3: {
                entityrabbit = EntityTypes.RABBIT.create(worldserver);
                if (entityrabbit == null) break block2;
                entityrabbit_variant = EntityRabbit.getRandomRabbitVariant(worldserver, this.blockPosition());
                if (this.random.nextInt(20) == 0) break block3;
                if (!(entityageable instanceof EntityRabbit)) ** GOTO lbl-1000
                entityrabbit1 = (EntityRabbit)entityageable;
                if (this.random.nextBoolean()) {
                    entityrabbit_variant = entityrabbit1.getVariant();
                } else lbl-1000:
                // 2 sources

                {
                    entityrabbit_variant = this.getVariant();
                }
            }
            entityrabbit.setVariant(entityrabbit_variant);
        }
        return entityrabbit;
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.RABBIT_FOOD);
    }

    @Override
    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_TYPE_ID));
    }

    @Override
    public void setVariant(Variant entityrabbit_variant) {
        if (entityrabbit_variant == Variant.EVIL) {
            this.getAttribute(GenericAttributes.ARMOR).setBaseValue(8.0);
            this.goalSelector.addGoal(4, new PathfinderGoalMeleeAttack(this, 1.4, true));
            this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
            this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).addOrUpdateTransientModifier(new AttributeModifier(EVIL_ATTACK_POWER_MODIFIER, 5.0, AttributeModifier.Operation.ADD_VALUE));
            if (!this.hasCustomName()) {
                this.setCustomName(IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("entity", KILLER_BUNNY)));
            }
        } else {
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).removeModifier(EVIL_ATTACK_POWER_MODIFIER);
        }
        this.entityData.set(DATA_TYPE_ID, entityrabbit_variant.id);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        Variant entityrabbit_variant = EntityRabbit.getRandomRabbitVariant(worldaccess, this.blockPosition());
        if (groupdataentity instanceof GroupDataRabbit) {
            entityrabbit_variant = ((GroupDataRabbit)groupdataentity).variant;
        } else {
            groupdataentity = new GroupDataRabbit(entityrabbit_variant);
        }
        this.setVariant(entityrabbit_variant);
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    private static Variant getRandomRabbitVariant(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        Holder<BiomeBase> holder = generatoraccess.getBiome(blockposition);
        int i2 = generatoraccess.getRandom().nextInt(100);
        return holder.is(BiomeTags.SPAWNS_WHITE_RABBITS) ? (i2 < 80 ? Variant.WHITE : Variant.WHITE_SPLOTCHED) : (holder.is(BiomeTags.SPAWNS_GOLD_RABBITS) ? Variant.GOLD : (i2 < 50 ? Variant.BROWN : (i2 < 90 ? Variant.SALT : Variant.BLACK)));
    }

    public static boolean checkRabbitSpawnRules(EntityTypes<EntityRabbit> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(TagsBlock.RABBITS_SPAWNABLE_ON) && EntityRabbit.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    boolean wantsMoreFood() {
        return this.moreCarrotTicks <= 0;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 1) {
            this.spawnSprintParticle();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit rabbit;
        private boolean canJump;

        public ControllerJumpRabbit(EntityRabbit entityrabbit) {
            super(entityrabbit);
            this.rabbit = entityrabbit;
        }

        public boolean wantJump() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean flag) {
            this.canJump = flag;
        }

        @Override
        public void tick() {
            if (this.jump) {
                this.rabbit.startJumping();
                this.jump = false;
            }
        }
    }

    private static class ControllerMoveRabbit
    extends ControllerMove {
        private final EntityRabbit rabbit;
        private double nextJumpSpeed;

        public ControllerMoveRabbit(EntityRabbit entityrabbit) {
            super(entityrabbit);
            this.rabbit = entityrabbit;
        }

        @Override
        public void tick() {
            if (this.rabbit.onGround() && !this.rabbit.jumping && !((ControllerJumpRabbit)this.rabbit.jumpControl).wantJump()) {
                this.rabbit.setSpeedModifier(0.0);
            } else if (this.hasWanted()) {
                this.rabbit.setSpeedModifier(this.nextJumpSpeed);
            }
            super.tick();
        }

        @Override
        public void setWantedPosition(double d0, double d1, double d2, double d3) {
            if (this.rabbit.isInWater()) {
                d3 = 1.5;
            }
            super.setWantedPosition(d0, d1, d2, d3);
            if (d3 > 0.0) {
                this.nextJumpSpeed = d3;
            }
        }
    }

    private static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit rabbit;

        public PathfinderGoalRabbitPanic(EntityRabbit entityrabbit, double d0) {
            super(entityrabbit, d0);
            this.rabbit = entityrabbit;
        }

        @Override
        public void tick() {
            super.tick();
            this.rabbit.setSpeedModifier(this.speedModifier);
        }
    }

    private static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit rabbit;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit entityrabbit, Class<T> oclass, float f2, double d0, double d1) {
            super(entityrabbit, oclass, f2, d0, d1);
            this.rabbit = entityrabbit;
        }

        @Override
        public boolean canUse() {
            return this.rabbit.getVariant() != Variant.EVIL && super.canUse();
        }
    }

    private static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public PathfinderGoalEatCarrots(EntityRabbit entityrabbit) {
            super(entityrabbit, 0.7f, 16);
            this.rabbit = entityrabbit;
        }

        @Override
        public boolean canUse() {
            if (this.nextStartTick <= 0) {
                if (!this.rabbit.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.wantsMoreFood();
            }
            return super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canRaid && super.canContinueToUse();
        }

        @Override
        public void tick() {
            super.tick();
            this.rabbit.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, this.blockPos.getY() + 1, (double)this.blockPos.getZ() + 0.5, 10.0f, this.rabbit.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                World world = this.rabbit.level();
                BlockPosition blockposition = this.blockPos.above();
                IBlockData iblockdata = world.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (this.canRaid && block instanceof BlockCarrots) {
                    int i2 = iblockdata.getValue(BlockCarrots.AGE);
                    if (i2 == 0) {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.rabbit, blockposition, Blocks.AIR.defaultBlockState())) {
                            return;
                        }
                        world.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 2);
                        world.destroyBlock(blockposition, true, this.rabbit);
                    } else {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.rabbit, blockposition, (IBlockData)iblockdata.setValue(BlockCarrots.AGE, i2 - 1))) {
                            return;
                        }
                        world.setBlock(blockposition, (IBlockData)iblockdata.setValue(BlockCarrots.AGE, i2 - 1), 2);
                        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(this.rabbit));
                        world.levelEvent(2001, blockposition, Block.getId(iblockdata));
                    }
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.nextStartTick = 10;
            }
        }

        @Override
        protected boolean isValidTarget(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.getBlockState(blockposition);
            if (iblockdata.is(Blocks.FARMLAND) && this.wantsToRaid && !this.canRaid && (iblockdata = iworldreader.getBlockState(blockposition.above())).getBlock() instanceof BlockCarrots && ((BlockCarrots)iblockdata.getBlock()).isMaxAge(iblockdata)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    public static enum Variant implements INamable
    {
        BROWN(0, "brown"),
        WHITE(1, "white"),
        BLACK(2, "black"),
        WHITE_SPLOTCHED(3, "white_splotched"),
        GOLD(4, "gold"),
        SALT(5, "salt"),
        EVIL(99, "evil");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        final int id;
        private final String name;

        private Variant(int i2, String s2) {
            this.id = i2;
            this.name = s2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static Variant byId(int i2) {
            return BY_ID.apply(i2);
        }

        static {
            BY_ID = ByIdMap.sparse(Variant::id, Variant.values(), BROWN);
            CODEC = INamable.fromEnum(Variant::values);
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final Variant variant;

        public GroupDataRabbit(Variant entityrabbit_variant) {
            super(1.0f);
            this.variant = entityrabbit_variant;
        }
    }
}

