/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> DATA_PUMPKIN_ID = DataWatcher.defineId(EntitySnowman.class, DataWatcherRegistry.BYTE);
    private static final byte PUMPKIN_FLAG = 16;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> entitytypes, World world) {
        super((EntityTypes<? extends EntityGolem>)entitytypes, world);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.goalSelector.addGoal(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(4, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 4.0).add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_PUMPKIN_ID, (byte)16);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putBoolean("Pumpkin", this.hasPumpkin());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        if (nbttagcompound.contains("Pumpkin")) {
            this.setPumpkin(nbttagcompound.getBoolean("Pumpkin"));
        }
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
                this.hurt(this.damageSources().melting(), 1.0f);
            }
            if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            IBlockData iblockdata = Blocks.SNOW.defaultBlockState();
            for (int i2 = 0; i2 < 4; ++i2) {
                int j2 = MathHelper.floor(this.getX() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.floor(this.getY());
                int l2 = MathHelper.floor(this.getZ() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (!this.level().getBlockState(blockposition).isAir() || !iblockdata.canSurvive(this.level(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, this)) continue;
                this.level().gameEvent(GameEvent.BLOCK_PLACE, blockposition, GameEvent.a.of(this, iblockdata));
            }
        }
    }

    @Override
    public void performRangedAttack(EntityLiving entityliving, float f2) {
        EntitySnowball entitysnowball = new EntitySnowball(this.level(), this);
        double d0 = entityliving.getEyeY() - (double)1.1f;
        double d1 = entityliving.getX() - this.getX();
        double d2 = d0 - entitysnowball.getY();
        double d3 = entityliving.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.shoot(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.playSound(SoundEffects.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity(entitysnowball);
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                return EnumInteractionResult.PASS;
            }
            this.shear(SoundCategory.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, entityhuman);
            if (!this.level().isClientSide) {
                itemstack.hurtAndBreak(1, entityhuman, EntitySnowman.getSlotForHand(enumhand));
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void shear(SoundCategory soundcategory) {
        this.level().playSound((EntityHuman)null, this, SoundEffects.SNOW_GOLEM_SHEAR, soundcategory, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.setPumpkin(false);
            this.forceDrops = true;
            this.spawnAtLocation(new ItemStack(Items.CARVED_PUMPKIN), this.getEyeHeight());
            this.forceDrops = false;
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.hasPumpkin();
    }

    public boolean hasPumpkin() {
        return (this.entityData.get(DATA_PUMPKIN_ID) & 0x10) != 0;
    }

    public void setPumpkin(boolean flag) {
        byte b0 = this.entityData.get(DATA_PUMPKIN_ID);
        if (flag) {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 | 0x10));
        } else {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.SNOW_GOLEM_DEATH;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.75f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }
}

