/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityDamageEvent;

public class Camel
extends EntityHorseAbstract
implements IJumpable,
ISaddleable {
    public static final float BABY_SCALE = 0.45f;
    public static final int DASH_COOLDOWN_TICKS = 55;
    public static final int MAX_HEAD_Y_ROT = 30;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    public static final DataWatcherObject<Boolean> DASH = DataWatcher.defineId(Camel.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Long> LAST_POSE_CHANGE_TICK = DataWatcher.defineId(Camel.class, DataWatcherRegistry.LONG);
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntitySize SITTING_DIMENSIONS = EntitySize.scalable(EntityTypes.CAMEL.getWidth(), EntityTypes.CAMEL.getHeight() - 1.43f).withEyeHeight(0.845f);
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;

    public Camel(EntityTypes<? extends Camel> entitytypes, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)entitytypes, world);
        this.moveControl = new c();
        this.lookControl = new b();
        Navigation navigation = (Navigation)this.getNavigation();
        navigation.setCanFloat(true);
        navigation.setCanWalkOverFences(true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putLong("LastPoseTick", this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        long i2 = nbttagcompound.getLong("LastPoseTick");
        if (i2 < 0L) {
            this.setPose(EntityPose.SITTING);
        }
        this.resetLastPoseChangeTick(i2);
    }

    public static AttributeProvider.Builder createAttributes() {
        return Camel.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 32.0).add(GenericAttributes.MOVEMENT_SPEED, 0.09f).add(GenericAttributes.JUMP_STRENGTH, 0.42f).add(GenericAttributes.STEP_HEIGHT, 1.5);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DASH, false);
        datawatcher_a.define(LAST_POSE_CHANGE_TICK, 0L);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        CamelAi.initMemories(this, worldaccess.getRandom());
        this.resetLastPoseChangeTickToFullStand(worldaccess.getLevel().getGameTime());
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    protected BehaviorController.b<Camel> brainProvider() {
        return CamelAi.brainProvider();
    }

    @Override
    protected void registerGoals() {
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> dynamic) {
        return CamelAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return entitypose == EntityPose.SITTING ? SITTING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(entitypose);
    }

    @Override
    protected void customServerAiStep() {
        ((World)this.level()).getProfiler().push("camelBrain");
        BehaviorController<?> behaviorcontroller = this.getBrain();
        behaviorcontroller.tick((WorldServer)this.level(), this);
        ((World)this.level()).getProfiler().pop();
        ((World)this.level()).getProfiler().push("camelActivityUpdate");
        CamelAi.updateActivity(this);
        ((World)this.level()).getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 50 && (this.onGround() || this.isInLiquid() || this.isPassenger())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                ((World)this.level()).playSound((EntityHuman)null, this.blockPosition(), SoundEffects.CAMEL_DASH_READY, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (((World)this.level()).isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody();
        }
        if (this.isCamelSitting() && this.isInWater()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isCamelVisuallySitting()) {
            this.sitUpAnimationState.stop();
            this.dashAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.dashAnimationState.animateWhen(this.isDashing(), this.tickCount);
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    @Override
    protected void updateWalkAnimation(float f2) {
        float f1 = this.getPose() == EntityPose.STANDING && !this.dashAnimationState.isStarted() ? Math.min(f2 * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f1, 0.2f);
    }

    @Override
    public void travel(Vec3D vec3d) {
        if (this.refuseToMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            vec3d = vec3d.multiply(0.0, 1.0, 0.0);
        }
        super.travel(vec3d);
    }

    @Override
    protected void tickRidden(EntityHuman entityhuman, Vec3D vec3d) {
        super.tickRidden(entityhuman, vec3d);
        if (entityhuman.zza > 0.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    public boolean refuseToMove() {
        return this.isCamelSitting() || this.isInPoseTransition();
    }

    @Override
    protected float getRiddenSpeed(EntityHuman entityhuman) {
        float f2 = entityhuman.isSprinting() && this.getJumpCooldown() == 0 ? 0.1f : 0.0f;
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) + f2;
    }

    @Override
    protected Vec2F getRiddenRotation(EntityLiving entityliving) {
        return this.refuseToMove() ? new Vec2F(this.getXRot(), this.getYRot()) : super.getRiddenRotation(entityliving);
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman entityhuman, Vec3D vec3d) {
        return this.refuseToMove() ? Vec3D.ZERO : super.getRiddenInput(entityhuman, vec3d);
    }

    @Override
    public boolean canJump() {
        return !this.refuseToMove() && super.canJump();
    }

    @Override
    public void onPlayerJump(int i2) {
        if (this.isSaddled() && this.dashCooldown <= 0 && this.onGround()) {
            super.onPlayerJump(i2);
        }
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected void executeRidersJump(float f2, Vec3D vec3d) {
        double d0 = this.getJumpPower();
        this.addDeltaMovement(this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale((double)(22.2222f * f2) * this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()).add(0.0, (double)(1.4285f * f2) * d0, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.hasImpulse = true;
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean flag) {
        this.entityData.set(DASH, flag);
    }

    @Override
    public void handleStartJump(int i2) {
        this.makeSound(SoundEffects.CAMEL_DASH);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.CAMEL_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAMEL_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.CAMEL_HURT;
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.is(TagsBlock.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEffects.CAMEL_STEP_SAND, 1.0f, 1.0f);
        } else {
            this.playSound(SoundEffects.CAMEL_STEP, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.CAMEL_FOOD);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (entityhuman.isSecondaryUseActive() && !this.isBaby()) {
            this.openCustomInventoryScreen(entityhuman);
            return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
        }
        EnumInteractionResult enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand);
        if (enuminteractionresult.consumesAction()) {
            return enuminteractionresult;
        }
        if (this.isFood(itemstack)) {
            return this.fedFood(entityhuman, itemstack);
        }
        if (this.getPassengers().size() < 2 && !this.isBaby()) {
            this.doPlayerRide(entityhuman);
        }
        return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
    }

    @Override
    public boolean handleLeashAtDistance(Entity entity, float f2) {
        if (f2 > 6.0f && this.isCamelSitting() && !this.isInPoseTransition() && this.canCamelChangePose()) {
            this.standUp();
        }
        return true;
    }

    public boolean canCamelChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isCamelSitting() ? EntityPose.STANDING : EntityPose.SITTING);
    }

    @Override
    protected boolean handleEating(EntityHuman entityhuman, ItemStack itemstack) {
        SoundEffect soundeffect;
        boolean flag2;
        boolean flag1;
        boolean flag;
        if (!this.isFood(itemstack)) {
            return false;
        }
        boolean bl = flag = this.getHealth() < this.getMaxHealth();
        if (flag) {
            this.heal(2.0f);
        }
        boolean bl2 = flag1 = this.isTamed() && this.getAge() == 0 && this.canFallInLove();
        if (flag1) {
            this.setInLove(entityhuman);
        }
        if (flag2 = this.isBaby()) {
            ((World)this.level()).addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!((World)this.level()).isClientSide) {
                this.ageUp(10);
            }
        }
        if (!(flag || flag1 || flag2)) {
            return false;
        }
        if (!this.isSilent() && (soundeffect = this.getEatingSound()) != null) {
            ((World)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.gameEvent(GameEvent.EAT);
        return true;
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    @Override
    public boolean canMate(EntityAnimal entityanimal) {
        if (entityanimal != this && entityanimal instanceof Camel) {
            Camel camel = (Camel)entityanimal;
            if (this.canParent() && camel.canParent()) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    @Override
    @Nullable
    public Camel getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.CAMEL.create(worldserver);
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.CAMEL_EAT;
    }

    @Override
    public boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.standUpInstantly();
        return true;
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity entity, EntitySize entitysize, float f2) {
        int i2 = Math.max(this.getPassengers().indexOf(entity), 0);
        boolean flag = i2 == 0;
        float f1 = 0.5f;
        float f22 = (float)(this.isRemoved() ? (double)0.01f : this.getBodyAnchorAnimationYOffset(flag, 0.0f, entitysize, f2));
        if (this.getPassengers().size() > 1) {
            if (!flag) {
                f1 = -0.7f;
            }
            if (entity instanceof EntityAnimal) {
                f1 += 0.2f;
            }
        }
        return new Vec3D(0.0, f22, f1 * f2).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.45f : 1.0f;
    }

    private double getBodyAnchorAnimationYOffset(boolean flag, float f2, EntitySize entitysize, float f1) {
        double d0 = entitysize.height() - 0.375f * f1;
        float f22 = f1 * 1.43f;
        float f3 = f22 - f1 * 0.2f;
        float f4 = f22 - f3;
        boolean flag1 = this.isInPoseTransition();
        boolean flag2 = this.isCamelSitting();
        if (flag1) {
            float f5;
            int j2;
            int i2;
            int n2 = i2 = flag2 ? 40 : 52;
            if (flag2) {
                j2 = 28;
                f5 = flag ? 0.5f : 0.1f;
            } else {
                j2 = flag ? 24 : 32;
                f5 = flag ? 0.6f : 0.35f;
            }
            float f6 = MathHelper.clamp((float)this.getPoseTime() + f2, 0.0f, (float)i2);
            boolean flag3 = f6 < (float)j2;
            float f7 = flag3 ? f6 / (float)j2 : (f6 - (float)j2) / (float)(i2 - j2);
            float f8 = f22 - f5 * f3;
            d0 += flag2 ? (double)MathHelper.lerp(f7, flag3 ? f22 : f8, flag3 ? f8 : f4) : (double)MathHelper.lerp(f7, flag3 ? f4 - f22 : f4 - f8, flag3 ? f4 - f8 : 0.0f);
        }
        if (flag2 && !flag1) {
            d0 += (double)f4;
        }
        return d0;
    }

    @Override
    public Vec3D getLeashOffset(float f2) {
        EntitySize entitysize = this.getDimensions(this.getPose());
        float f1 = this.getAgeScale();
        return new Vec3D(0.0, this.getBodyAnchorAnimationYOffset(true, f2, entitysize, f1) - (double)(0.2f * f1), entitysize.width() * 0.56f);
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() <= 2;
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public boolean isCamelSitting() {
        return this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isCamelVisuallySitting() {
        return this.getPoseTime() < 0L != this.isCamelSitting();
    }

    public boolean isInPoseTransition() {
        long i2 = this.getPoseTime();
        return i2 < (long)(this.isCamelSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isCamelSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (!this.isCamelSitting()) {
            this.makeSound(SoundEffects.CAMEL_SIT);
            this.setPose(EntityPose.SITTING);
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-((World)this.level()).getGameTime());
        }
    }

    public void standUp() {
        if (this.isCamelSitting()) {
            this.makeSound(SoundEffects.CAMEL_STAND);
            this.setPose(EntityPose.STANDING);
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(((World)this.level()).getGameTime());
        }
    }

    public void standUpInstantly() {
        this.setPose(EntityPose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(((World)this.level()).getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long i2) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, i2);
    }

    private void resetLastPoseChangeTickToFullStand(long i2) {
        this.resetLastPoseChangeTick(Math.max(0L, i2 - 52L - 1L));
    }

    public long getPoseTime() {
        return ((World)this.level()).getGameTime() - Math.abs(this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    public SoundEffect getSaddleSoundEvent() {
        return SoundEffects.CAMEL_SADDLE;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (!this.firstTick && DASH.equals(datawatcherobject)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean isTamed() {
        return true;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman entityhuman) {
        if (!((World)this.level()).isClientSide) {
            entityhuman.openHorseInventory(this, this.inventory);
        }
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new a(this);
    }

    private class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (this.operation == ControllerMove.Operation.MOVE_TO && !Camel.this.isLeashed() && Camel.this.isCamelSitting() && !Camel.this.isInPoseTransition() && Camel.this.canCamelChangePose()) {
                Camel.this.standUp();
            }
            super.tick();
        }
    }

    private class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (!Camel.this.hasControllingPassenger()) {
                super.tick();
            }
        }
    }

    private class a
    extends EntityAIBodyControl {
        public a(Camel camel2) {
            super(camel2);
        }

        @Override
        public void clientTick() {
            if (!Camel.this.refuseToMove()) {
                super.clientTick();
            }
        }
    }
}

