/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class ShootTongue
extends Behavior<Frog> {
    public static final int TIME_OUT_DURATION = 100;
    public static final int CATCH_ANIMATION_DURATION = 6;
    public static final int TONGUE_ANIMATION_DURATION = 10;
    private static final float EATING_DISTANCE = 1.75f;
    private static final float EATING_MOVEMENT_FACTOR = 0.75f;
    public static final int UNREACHABLE_TONGUE_TARGETS_COOLDOWN_DURATION = 100;
    public static final int MAX_UNREACHBLE_TONGUE_TARGETS_IN_MEMORY = 5;
    private int eatAnimationTimer;
    private int calculatePathCounter;
    private final SoundEffect tongueSound;
    private final SoundEffect eatSound;
    private Vec3D itemSpawnPos;
    private a state = a.DONE;

    public ShootTongue(SoundEffect soundeffect, SoundEffect soundeffect1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 100);
        this.tongueSound = soundeffect;
        this.eatSound = soundeffect1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer worldserver, Frog frog) {
        EntityLiving entityliving = frog.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        boolean flag = this.canPathfindToTarget(frog, entityliving);
        if (!flag) {
            frog.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            this.addUnreachableTargetToMemory(frog, entityliving);
        }
        return flag && frog.getPose() != EntityPose.CROAKING && Frog.canEat(entityliving);
    }

    @Override
    protected boolean canStillUse(WorldServer worldserver, Frog frog, long i2) {
        return frog.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.state != a.DONE && !frog.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void start(WorldServer worldserver, Frog frog, long i2) {
        EntityLiving entityliving = frog.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        BehaviorUtil.lookAtEntity(frog, entityliving);
        frog.setTongueTarget(entityliving);
        frog.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(entityliving.position(), 2.0f, 0));
        this.calculatePathCounter = 10;
        this.state = a.MOVE_TO_TARGET;
    }

    @Override
    protected void stop(WorldServer worldserver, Frog frog, long i2) {
        frog.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        frog.eraseTongueTarget();
        frog.setPose(EntityPose.STANDING);
    }

    private void eatEntity(WorldServer worldserver, Frog frog) {
        Entity entity;
        worldserver.playSound((EntityHuman)null, frog, this.eatSound, SoundCategory.NEUTRAL, 2.0f, 1.0f);
        Optional<Entity> optional = frog.getTongueTarget();
        if (optional.isPresent() && (entity = optional.get()).isAlive()) {
            frog.doHurtTarget(entity);
            if (!entity.isAlive()) {
                entity.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            }
        }
    }

    @Override
    protected void tick(WorldServer worldserver, Frog frog, long i2) {
        EntityLiving entityliving = frog.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        frog.setTongueTarget(entityliving);
        switch (this.state.ordinal()) {
            case 0: {
                if (entityliving.distanceTo(frog) < 1.75f) {
                    worldserver.playSound((EntityHuman)null, frog, this.tongueSound, SoundCategory.NEUTRAL, 2.0f, 1.0f);
                    frog.setPose(EntityPose.USING_TONGUE);
                    entityliving.setDeltaMovement(entityliving.position().vectorTo(frog.position()).normalize().scale(0.75));
                    this.itemSpawnPos = entityliving.position();
                    this.eatAnimationTimer = 0;
                    this.state = a.CATCH_ANIMATION;
                    break;
                }
                if (this.calculatePathCounter <= 0) {
                    frog.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(entityliving.position(), 2.0f, 0));
                    this.calculatePathCounter = 10;
                    break;
                }
                --this.calculatePathCounter;
                break;
            }
            case 1: {
                if (this.eatAnimationTimer++ < 6) break;
                this.state = a.EAT_ANIMATION;
                this.eatEntity(worldserver, frog);
                break;
            }
            case 2: {
                if (this.eatAnimationTimer >= 10) {
                    this.state = a.DONE;
                    break;
                }
                ++this.eatAnimationTimer;
            }
        }
    }

    private boolean canPathfindToTarget(Frog frog, EntityLiving entityliving) {
        PathEntity pathentity = frog.getNavigation().createPath(entityliving, 0);
        return pathentity != null && pathentity.getDistToTarget() < 1.75f;
    }

    private void addUnreachableTargetToMemory(Frog frog, EntityLiving entityliving) {
        boolean flag;
        List list = frog.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS).orElseGet(ArrayList::new);
        boolean bl = flag = !list.contains(entityliving.getUUID());
        if (list.size() == 5 && flag) {
            list.remove(0);
        }
        if (flag) {
            list.add(entityliving.getUUID());
        }
        frog.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS, list, 100L);
    }

    private static enum a {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION,
        DONE;

    }
}

