/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public class PathfinderGoalHorseTrap
extends PathfinderGoal {
    private final EntityHorseSkeleton horse;

    public PathfinderGoalHorseTrap(EntityHorseSkeleton entityhorseskeleton) {
        this.horse = entityhorseskeleton;
    }

    @Override
    public boolean canUse() {
        return this.horse.level().hasNearbyAlivePlayer(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0);
    }

    @Override
    public void tick() {
        WorldServer worldserver = (WorldServer)this.horse.level();
        DifficultyDamageScaler difficultydamagescaler = worldserver.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        EntityLightning entitylightning = EntityTypes.LIGHTNING_BOLT.create(worldserver);
        if (entitylightning != null) {
            entitylightning.moveTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entitylightning.setVisualOnly(true);
            worldserver.strikeLightning(entitylightning, LightningStrikeEvent.Cause.TRAP);
            EntitySkeleton entityskeleton = this.createSkeleton(difficultydamagescaler, this.horse);
            if (entityskeleton != null) {
                entityskeleton.startRiding(this.horse);
                worldserver.addFreshEntityWithPassengers(entityskeleton, CreatureSpawnEvent.SpawnReason.TRAP);
                for (int i2 = 0; i2 < 3; ++i2) {
                    EntitySkeleton entityskeleton1;
                    EntityHorseAbstract entityhorseabstract = this.createHorse(difficultydamagescaler);
                    if (entityhorseabstract == null || (entityskeleton1 = this.createSkeleton(difficultydamagescaler, entityhorseabstract)) == null) continue;
                    entityskeleton1.startRiding(entityhorseabstract);
                    entityhorseabstract.push(this.horse.getRandom().triangle(0.0, 1.1485), 0.0, this.horse.getRandom().triangle(0.0, 1.1485));
                    worldserver.addFreshEntityWithPassengers(entityhorseabstract, CreatureSpawnEvent.SpawnReason.JOCKEY);
                }
            }
        }
    }

    @Nullable
    private EntityHorseAbstract createHorse(DifficultyDamageScaler difficultydamagescaler) {
        EntityHorseSkeleton entityhorseskeleton = EntityTypes.SKELETON_HORSE.create((World)this.horse.level());
        if (entityhorseskeleton != null) {
            entityhorseskeleton.finalizeSpawn((WorldServer)this.horse.level(), difficultydamagescaler, EnumMobSpawn.TRIGGERED, null);
            entityhorseskeleton.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entityhorseskeleton.invulnerableTime = 60;
            entityhorseskeleton.setPersistenceRequired();
            entityhorseskeleton.setTamed(true);
            entityhorseskeleton.setAge(0);
        }
        return entityhorseskeleton;
    }

    @Nullable
    private EntitySkeleton createSkeleton(DifficultyDamageScaler difficultydamagescaler, EntityHorseAbstract entityhorseabstract) {
        EntitySkeleton entityskeleton = EntityTypes.SKELETON.create((World)entityhorseabstract.level());
        if (entityskeleton != null) {
            entityskeleton.finalizeSpawn((WorldServer)entityhorseabstract.level(), difficultydamagescaler, EnumMobSpawn.TRIGGERED, null);
            entityskeleton.setPos(entityhorseabstract.getX(), entityhorseabstract.getY(), entityhorseabstract.getZ());
            entityskeleton.invulnerableTime = 60;
            entityskeleton.setPersistenceRequired();
            if (entityskeleton.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
                entityskeleton.setItemSlot(EnumItemSlot.HEAD, new ItemStack(Items.IRON_HELMET));
            }
            this.enchant(entityskeleton, EnumItemSlot.MAINHAND, difficultydamagescaler);
            this.enchant(entityskeleton, EnumItemSlot.HEAD, difficultydamagescaler);
        }
        return entityskeleton;
    }

    private void enchant(EntitySkeleton entityskeleton, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = entityskeleton.getItemBySlot(enumitemslot);
        itemstack.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        EnchantmentManager.enchantItemFromProvider(itemstack, entityskeleton.level().registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, difficultydamagescaler, entityskeleton.getRandom());
        entityskeleton.setItemSlot(enumitemslot, itemstack);
    }
}

