/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final float DIGGING_BB_HEIGHT_OFFSET = 0.4f;
    private static final EntitySize DIGGING_DIMENSIONS = EntitySize.scalable(EntityTypes.SNIFFER.getWidth(), EntityTypes.SNIFFER.getHeight() - 0.4f).withEyeHeight(0.81f);
    private static final DataWatcherObject<State> DATA_STATE = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.SNIFFER_STATE);
    private static final DataWatcherObject<Integer> DATA_DROP_SEED_AT_TICK = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.INT);
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.MAX_HEALTH, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super(entitytypes, world);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_CAUTIOUS, -1.0f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_STATE, State.IDLING);
        datawatcher_a.define(DATA_DROP_SEED_AT_TICK, 0);
    }

    @Override
    public void onPathfindingStart() {
        super.onPathfindingStart();
        if (this.isOnFire() || this.isInWater()) {
            this.setPathfindingMalus(PathType.WATER, 0.0f);
        }
    }

    @Override
    public void onPathfindingDone() {
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.getState() == State.DIGGING ? DIGGING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(entitypose);
    }

    public boolean isSearching() {
        return this.getState() == State.SEARCHING;
    }

    public boolean isTempted() {
        return this.brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false);
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isPanicking() && !this.isInWater() && !this.isInLove() && this.onGround() && !this.isPassenger() && !this.isLeashed();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == State.DIGGING || this.getState() == State.SEARCHING;
    }

    private BlockPosition getHeadBlock() {
        Vec3D vec3d = this.getHeadPosition();
        return BlockPosition.containing(vec3d.x(), this.getY() + (double)0.2f, vec3d.z());
    }

    private Vec3D getHeadPosition() {
        return this.position().add(this.getForward().scale(2.25));
    }

    public State getState() {
        return this.entityData.get(DATA_STATE);
    }

    private Sniffer setState(State sniffer_state) {
        this.entityData.set(DATA_STATE, sniffer_state);
        return this;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_STATE.equals(datawatcherobject)) {
            State sniffer_state = this.getState();
            this.resetAnimations();
            switch (sniffer_state.ordinal()) {
                case 1: {
                    this.feelingHappyAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 2: {
                    this.scentingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 3: {
                    this.sniffingAnimationState.startIfStopped(this.tickCount);
                }
                default: {
                    break;
                }
                case 5: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 6: {
                    this.risingAnimationState.startIfStopped(this.tickCount);
                }
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    private void resetAnimations() {
        this.diggingAnimationState.stop();
        this.sniffingAnimationState.stop();
        this.risingAnimationState.stop();
        this.feelingHappyAnimationState.stop();
        this.scentingAnimationState.stop();
    }

    public Sniffer transitionTo(State sniffer_state) {
        switch (sniffer_state.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.playSound(SoundEffects.SNIFFER_HAPPY, 1.0f, 1.0f);
                this.setState(State.FEELING_HAPPY);
                break;
            }
            case 2: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case 3: {
                this.playSound(SoundEffects.SNIFFER_SNIFFING, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case 4: {
                this.setState(State.SEARCHING);
                break;
            }
            case 5: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 6: {
                this.playSound(SoundEffects.SNIFFER_DIGGING_STOP, 1.0f, 1.0f);
                this.setState(State.RISING);
            }
        }
        return this;
    }

    private Sniffer onScentingStart() {
        this.playSound(SoundEffects.SNIFFER_SCENTING, 1.0f, this.isBaby() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer onDiggingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, this.tickCount + 120);
        this.level().broadcastEntityEvent(this, (byte)63);
        return this;
    }

    public Sniffer onDiggingComplete(boolean flag) {
        if (flag) {
            this.storeExploredPosition(this.getOnPos());
        }
        return this;
    }

    public Optional<BlockPosition> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.getPos(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::containing).filter(blockposition -> this.level().getWorldBorder().isWithinBounds((BlockPosition)blockposition)).map(BlockPosition::below).filter(this::canDig).findFirst();
    }

    public boolean canDig() {
        return !this.isPanicking() && !this.isTempted() && !this.isBaby() && !this.isInWater() && this.onGround() && !this.isPassenger() && this.canDig(this.getHeadBlock().below());
    }

    private boolean canDig(BlockPosition blockposition) {
        return this.level().getBlockState(blockposition).is(TagsBlock.SNIFFER_DIGGABLE_BLOCK) && this.getExploredPositions().noneMatch(globalpos -> GlobalPos.of(this.level().dimension(), blockposition).equals(globalpos)) && Optional.ofNullable(this.getNavigation().createPath(blockposition, 1)).map(PathEntity::canReach).orElse(false) != false;
    }

    private void dropSeed() {
        if (!this.level().isClientSide() && this.entityData.get(DATA_DROP_SEED_AT_TICK) == this.tickCount) {
            WorldServer worldserver = (WorldServer)this.level();
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(LootTables.SNIFFER_DIGGING);
            LootParams lootparams = new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, this.getHeadPosition()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.GIFT);
            ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
            BlockPosition blockposition = this.getHeadBlock();
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(worldserver, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                entityitem.setDefaultPickUpDelay();
                worldserver.addFreshEntity(entityitem);
            }
            this.playSound(SoundEffects.SNIFFER_DROP_SEED, 1.0f, 1.0f);
        }
    }

    private Sniffer emitDiggingParticles(AnimationState animationstate) {
        boolean flag;
        boolean bl = flag = animationstate.getAccumulatedTime() > 1700L && animationstate.getAccumulatedTime() < 6000L;
        if (flag) {
            BlockPosition blockposition = this.getHeadBlock();
            IBlockData iblockdata = this.level().getBlockState(blockposition.below());
            if (iblockdata.getRenderShape() != EnumRenderType.INVISIBLE) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.atCenterOf(blockposition).add(0.0, -0.65f, 0.0);
                    this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, iblockdata), vec3d.x, vec3d.y, vec3d.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), iblockdata.getSoundType().getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.tickCount % 10 == 0) {
            this.level().gameEvent(GameEvent.ENTITY_ACTION, this.getHeadBlock(), GameEvent.a.of(this));
        }
        return this;
    }

    public Sniffer storeExploredPosition(BlockPosition blockposition) {
        List list = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.of(this.level().dimension(), blockposition));
        this.getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, list);
        return this;
    }

    public Stream<GlobalPos> getExploredPositions() {
        return this.getBrain().getMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS).stream().flatMap(Collection::stream);
    }

    @Override
    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.moveControl.getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void spawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal) {
        ItemStack itemstack = new ItemStack(Items.SNIFFER_EGG);
        EntityItem entityitem = new EntityItem(worldserver, this.position().x(), this.position().y(), this.position().z(), itemstack);
        entityitem.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, null);
        this.playSound(SoundEffects.SNIFFER_EGG_PLOP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        worldserver.addFreshEntity(entityitem);
    }

    @Override
    public void die(DamageSource damagesource) {
        this.transitionTo(State.IDLING);
        super.die(damagesource);
    }

    @Override
    public void tick() {
        switch (this.getState().ordinal()) {
            case 4: {
                this.playSearchingSound();
                break;
            }
            case 5: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
            }
        }
        super.tick();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        boolean flag = this.isFood(itemstack);
        EnumInteractionResult enuminteractionresult = super.mobInteract(entityhuman, enumhand);
        if (enuminteractionresult.consumesAction() && flag) {
            this.level().playSound((EntityHuman)null, this, this.getEatingSound(itemstack), SoundCategory.NEUTRAL, 1.0f, MathHelper.randomBetween(this.level().random, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    private void playSearchingSound() {
        if (this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.SNIFFER_SEARCHING, this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        this.playSound(SoundEffects.SNIFFER_STEP, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect getEatingSound(ItemStack itemstack) {
        return SoundEffects.SNIFFER_EAT;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.getState()) ? null : SoundEffects.SNIFFER_IDLE;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.SNIFFER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SNIFFER_DEATH;
    }

    @Override
    public int getMaxHeadYRot() {
        return 50;
    }

    @Override
    public void setBaby(boolean flag) {
        this.setAge(flag ? -48000 : 0);
    }

    @Override
    public EntityAgeable getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.SNIFFER.create(worldserver);
    }

    @Override
    public boolean canMate(EntityAnimal entityanimal) {
        if (!(entityanimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)entityanimal;
        Set<State> set = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
        return set.contains((Object)this.getState()) && set.contains((Object)sniffer.getState()) && super.canMate(entityanimal);
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(0.6f);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.SNIFFER_FOOD);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> dynamic) {
        return SnifferAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    public BehaviorController<Sniffer> getBrain() {
        return super.getBrain();
    }

    protected BehaviorController.b<Sniffer> brainProvider() {
        return BehaviorController.provider(SnifferAi.MEMORY_TYPES, SnifferAi.SENSOR_TYPES);
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("snifferBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        this.level().getProfiler().popPush("snifferActivityUpdate");
        SnifferAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public static enum State {
        IDLING(0),
        FEELING_HAPPY(1),
        SCENTING(2),
        SNIFFING(3),
        SEARCHING(4),
        DIGGING(5),
        RISING(6);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int i2) {
            this.id = i2;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, State.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

