/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> DATA_PHASE = DataWatcher.defineId(EntityEnderDragon.class, DataWatcherRegistry.INT);
    private static final PathfinderTargetCondition CRYSTAL_DESTROY_TARGETING = PathfinderTargetCondition.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    public final EntityComplexPart[] subEntities;
    public final EntityComplexPart head;
    private final EntityComplexPart neck;
    private final EntityComplexPart body;
    private final EntityComplexPart tail1;
    private final EntityComplexPart tail2;
    private final EntityComplexPart tail3;
    private final EntityComplexPart wing1;
    private final EntityComplexPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @Nullable
    public EntityEnderCrystal nearestCrystal;
    @Nullable
    private EnderDragonBattle dragonFight;
    private BlockPosition fightOrigin = BlockPosition.ZERO;
    private final DragonControllerManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final PathPoint[] nodes = new PathPoint[24];
    private final int[] nodeAdjacency = new int[24];
    private final Path openSet = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ENDER_DRAGON, world);
        this.head = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.neck = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.body = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EntityComplexPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new DragonControllerManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.DESTROY, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public void setDragonFight(EnderDragonBattle enderdragonbattle) {
        this.dragonFight = enderdragonbattle;
    }

    public void setFightOrigin(BlockPosition blockposition) {
        this.fightOrigin = blockposition;
    }

    public BlockPosition getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 200.0);
    }

    @Override
    public boolean isFlapping() {
        float f2 = MathHelper.cos(this.flapTime * ((float)Math.PI * 2));
        float f1 = MathHelper.cos(this.oFlapTime * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_PHASE, DragonControllerPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int i2, float f2) {
        if (this.isDeadOrDying()) {
            f2 = 0.0f;
        }
        f2 = 1.0f - f2;
        int j2 = this.posPointer - i2 & 0x3F;
        int k2 = this.posPointer - i2 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[j2][0];
        double d1 = MathHelper.wrapDegrees(this.positions[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)f2;
        d0 = this.positions[j2][1];
        d1 = this.positions[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)f2;
        adouble[2] = MathHelper.lerp((double)f2, this.positions[j2][2], this.positions[k2][2]);
        return adouble;
    }

    @Override
    public void aiStep() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (world = this.level()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).getDragonFight()) != null && this.getUUID().equals(enderdragonbattle.getDragonUUID())) {
            this.dragonFight = enderdragonbattle;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float f1 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION, this.getX() + (double)f1, this.getY() + 2.0 + (double)f2, this.getZ() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3D vec3d = this.getDeltaMovement();
            float f3 = 0.2f / ((float)vec3d.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f3 * 0.5f) : (this.flapTime += (f3 *= (float)Math.pow(2.0, vec3d.y))));
            this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                if (this.posPointer < 0) {
                    for (int i2 = 0; i2 < this.positions.length; ++i2) {
                        this.positions[i2][0] = this.getYRot();
                        this.positions[i2][1] = this.getY();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.getYRot();
                this.positions[this.posPointer][1] = this.getY();
                if (this.level().isClientSide) {
                    if (this.lerpSteps > 0) {
                        this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                        --this.lerpSteps;
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.phaseManager.getCurrentPhase();
                    idragoncontroller.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != idragoncontroller) {
                        idragoncontroller = this.phaseManager.getCurrentPhase();
                        idragoncontroller.doServerTick();
                    }
                    if ((vec3d1 = idragoncontroller.getFlyTargetLocation()) != null && idragoncontroller.getPhase() != DragonControllerPhase.HOVERING) {
                        double d0 = vec3d1.x - this.getX();
                        double d1 = vec3d1.y - this.getY();
                        double d2 = vec3d1.z - this.getZ();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.getFlySpeed();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.clamp(d1 / d4, (double)(-f6), (double)f6);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d1 * 0.01, 0.0));
                        this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
                        Vec3D vec3d2 = vec3d1.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3D vec3d3 = new Vec3D(MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                        float f32 = Math.max(((float)vec3d3.dot(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.clamp(MathHelper.wrapDegrees(180.0f - (float)MathHelper.atan2(d0, d2) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f4 * idragoncontroller.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        f4 = (float)(2.0 / (d3 + 1.0));
                        f5 = 0.06f;
                        this.moveRelative(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(EnumMoveType.SELF, this.getDeltaMovement().scale(0.8f));
                        } else {
                            this.move(EnumMoveType.SELF, this.getDeltaMovement());
                        }
                        Vec3D vec3d4 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec3d4.dot(vec3d3) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, 0.91f, d5));
                    }
                }
                this.yBodyRot = this.getYRot();
                Vec3D[] avec3d = new Vec3D[this.subEntities.length];
                for (int j2 = 0; j2 < this.subEntities.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.subEntities[j2].getX(), this.subEntities[j2].getY(), this.subEntities[j2].getZ());
                }
                float f7 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.cos(f7);
                float f9 = MathHelper.sin(f7);
                float f10 = this.getYRot() * ((float)Math.PI / 180);
                float f11 = MathHelper.sin(f10);
                float f12 = MathHelper.cos(f10);
                this.tickPart(this.body, f11 * 0.5f, 0.0, -f12 * 0.5f);
                this.tickPart(this.wing1, f12 * 4.5f, 2.0, f11 * 4.5f);
                this.tickPart(this.wing2, f12 * -4.5f, 2.0, f11 * -4.5f);
                World world1 = this.level();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    if (this.hurtTime == 0) {
                        this.knockBack(worldserver1, worldserver1.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.knockBack(worldserver1, worldserver1.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver1.getEntities(this, this.head.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver1.getEntities(this, this.neck.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                }
                float f13 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f14 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f15 = this.getHeadYOffset();
                this.tickPart(this.head, f13 * 6.5f * f8, f15 + f9 * 6.5f, -f14 * 6.5f * f8);
                this.tickPart(this.neck, f13 * 5.5f * f8, f15 + f9 * 5.5f, -f14 * 5.5f * f8);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.tail1;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.tail2;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k2 * 2, 1.0f);
                    float f16 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f33 = MathHelper.sin(f16);
                    f4 = MathHelper.cos(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.tickPart(entitycomplexpart, -(f11 * 1.5f + f33 * f17) * f8, adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (f12 * 1.5f + f4 * f17) * f8);
                }
                if (!this.level().isClientSide) {
                    this.inWall = this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                for (k2 = 0; k2 < this.subEntities.length; ++k2) {
                    this.subEntities[k2].xo = avec3d[k2].x;
                    this.subEntities[k2].yo = avec3d[k2].y;
                    this.subEntities[k2].zo = avec3d[k2].z;
                    this.subEntities[k2].xOld = avec3d[k2].x;
                    this.subEntities[k2].yOld = avec3d[k2].y;
                    this.subEntities[k2].zOld = avec3d[k2].z;
                }
            }
        }
    }

    private void tickPart(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.setPos(this.getX() + d0, this.getY() + d1, this.getZ() + d2);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setHealth((float)((double)this.getHealth() + event.getAmount()));
                }
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EntityEnderCrystal> list = this.level().getEntitiesOfClass(EntityEnderCrystal.class, this.getBoundingBox().inflate(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.distanceToSqr(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.nearestCrystal = entityendercrystal;
        }
    }

    private void knockBack(WorldServer worldserver, List<Entity> list) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || entityliving.getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurt(damagesource, 5.0f);
            EnchantmentManager.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    private void hurt(List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurt(damagesource, 10.0f);
            World world = this.level();
            if (!(world instanceof WorldServer)) continue;
            WorldServer worldserver = (WorldServer)world;
            EnchantmentManager.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    private float rotWrap(double d0) {
        return (float)MathHelper.wrapDegrees(d0);
    }

    private boolean checkWalls(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.floor(axisalignedbb.minY);
        int k2 = MathHelper.floor(axisalignedbb.minZ);
        int l2 = MathHelper.floor(axisalignedbb.maxX);
        int i1 = MathHelper.floor(axisalignedbb.maxY);
        int j1 = MathHelper.floor(axisalignedbb.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.level().getBlockState(blockposition);
                    if (iblockdata.isAir() || iblockdata.is(TagsBlock.DRAGON_TRANSPARENT)) continue;
                    if (this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !iblockdata.is(TagsBlock.DRAGON_IMMUNE)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.level(), blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.getBlockInteraction());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.level().removeBlock(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().getBlock();
                if (nmsBlock.dropFromExplosion(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().hasBlockEntity() ? this.level().getBlockEntity(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(blockposition)).withParameter(LootContextParameters.TOOL, ItemStack.EMPTY).withParameter(LootContextParameters.EXPLOSION_RADIUS, Float.valueOf(1.0f / event.getYield())).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, tileentity);
                    craftBlock.getNMS().getDrops(loottableinfo_builder).forEach(itemstack -> Block.popResource(this.level(), blockposition, itemstack));
                    craftBlock.getNMS().spawnAfterBreak((WorldServer)this.level(), blockposition, ItemStack.EMPTY, false);
                }
                nmsBlock.wasExploded(this.level(), blockposition, this.explosionSource);
                this.level().removeBlock(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.random.nextInt(l2 - i2 + 1), j2 + this.random.nextInt(i1 - j2 + 1), k2 + this.random.nextInt(j1 - k2 + 1));
            this.level().levelEvent(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean hurt(EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.phaseManager.getCurrentPhase().getPhase() == DragonControllerPhase.DYING) {
            return false;
        }
        f2 = this.phaseManager.getCurrentPhase().onHurt(damagesource, f2);
        if (entitycomplexpart != this.head) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.getEntity() instanceof EntityHuman || damagesource.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float f1 = this.getHealth();
            this.reallyHurt(damagesource, f2);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(DragonControllerPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f1 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(DragonControllerPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        return !this.level().isClientSide ? this.hurt(this.body, damagesource, f2) : false;
    }

    protected boolean reallyHurt(DamageSource damagesource, float f2) {
        return super.hurt(damagesource, f2);
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    public int getExpReward(Entity entity) {
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int short0 = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION_EMITTER, this.getX() + (double)f2, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.level() instanceof WorldServer) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0) {
                EntityExperienceOrb.award((WorldServer)this.level(), this.position(), MathHelper.floor((float)short0 * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                int viewDistance = ((WorldServer)this.level()).getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : this.level().getServer().getPlayerList().players) {
                    double deltaX = this.getX() - player.getX();
                    double deltaZ = this.getZ() - player.getZ();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.level().spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.level().spigotConfig.dragonDeathSoundRadius * this.level().spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                        player.connection.send(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.connection.send(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.getX(), (int)this.getY(), (int)this.getZ()), 0, true));
                }
            }
        }
        this.move(EnumMoveType.SELF, new Vec3D(0.0, 0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.level() instanceof WorldServer) {
            EntityExperienceOrb.award((WorldServer)this.level(), this.position(), MathHelper.floor((float)short0 * 0.2f));
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.floor(60.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.floor(60.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.floor(40.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.floor(40.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.floor(20.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.floor(20.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.level().getSeaLevel() + 10, this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPosition(k2, 0, l2)).getY() + j2);
                this.nodes[i2] = new PathPoint(k2, j1, l2);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.floor(d0), MathHelper.floor(d1), MathHelper.floor(d2));
        int b0 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.nodes[j2] == null || !((f1 = this.nodes[j2].distanceToSqr(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity findPath(int i2, int j2, @Nullable PathPoint pathpoint) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.nodes[k2];
            pathpoint1.closed = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.h = 0.0f;
            pathpoint1.cameFrom = null;
            pathpoint1.heapIdx = -1;
        }
        PathPoint pathpoint2 = this.nodes[i2];
        pathpoint1 = this.nodes[j2];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.h = pathpoint2.distanceTo(pathpoint1);
        this.openSet.clear();
        this.openSet.insert(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            b0 = 12;
        }
        while (!this.openSet.isEmpty()) {
            int i1;
            PathPoint pathpoint4 = this.openSet.pop();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathpoint != null) {
                    pathpoint.cameFrom = pathpoint1;
                    pathpoint1 = pathpoint;
                }
                return this.reconstructPath(pathpoint2, pathpoint1);
            }
            if (pathpoint4.distanceTo(pathpoint1) < pathpoint3.distanceTo(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.closed = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.nodes[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.nodes[i1];
                if (pathpoint5.closed) continue;
                float f2 = pathpoint4.g + pathpoint4.distanceTo(pathpoint5);
                if (pathpoint5.inOpenSet() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.cameFrom = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.h = pathpoint5.distanceTo(pathpoint1);
                if (pathpoint5.inOpenSet()) {
                    this.openSet.changeCost(pathpoint5, pathpoint5.g + pathpoint5.h);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.h;
                this.openSet.insert(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.cameFrom = pathpoint3;
            pathpoint3 = pathpoint;
        }
        return this.reconstructPath(pathpoint2, pathpoint3);
    }

    private PathEntity reconstructPath(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.cameFrom != null) {
            pathpoint2 = pathpoint2.cameFrom;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.x, pathpoint1.y, pathpoint1.z), true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        nbttagcompound.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
        nbttagcompound.putInt("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        if (nbttagcompound.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(DragonControllerPhase.getById(nbttagcompound.getInt(DRAGON_PHASE_KEY)));
        }
        if (nbttagcompound.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = nbttagcompound.getInt(DRAGON_DEATH_TIME_KEY);
        }
        if (nbttagcompound.contains("Bukkit.expToDrop")) {
            this.expToDrop = nbttagcompound.getInt("Bukkit.expToDrop");
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EntityComplexPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int i2, double[] adouble, double[] adouble1) {
        double d0;
        IDragonController idragoncontroller = this.phaseManager.getCurrentPhase();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.getPhase();
        if (dragoncontrollerphase != DragonControllerPhase.LANDING && dragoncontrollerphase != DragonControllerPhase.TAKEOFF) {
            d0 = idragoncontroller.isSitting() ? (double)i2 : (i2 == 6 ? 0.0 : adouble1[1] - adouble[1]);
        } else {
            BlockPosition blockposition = this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.fightOrigin));
            double d1 = Math.max(Math.sqrt(blockposition.distToCenterSqr(this.position())) / 4.0, 1.0);
            d0 = (double)i2 / d1;
        }
        return (float)d0;
    }

    public Vec3D getHeadLookVector(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.phaseManager.getCurrentPhase();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.getPhase();
        if (dragoncontrollerphase != DragonControllerPhase.LANDING && dragoncontrollerphase != DragonControllerPhase.TAKEOFF) {
            if (idragoncontroller.isSitting()) {
                float f22 = this.getXRot();
                float f1 = 1.5f;
                this.setXRot(-45.0f);
                vec3d = this.getViewVector(f2);
                this.setXRot(f22);
            } else {
                vec3d = this.getViewVector(f2);
            }
        } else {
            BlockPosition blockposition = this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.fightOrigin));
            float f1 = Math.max((float)Math.sqrt(blockposition.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.getXRot();
            float f5 = 1.5f;
            this.setXRot(-f3 * 1.5f * 5.0f);
            vec3d = this.getViewVector(f2);
            this.setXRot(f4);
        }
        return vec3d;
    }

    public void onCrystalDestroyed(EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman = damagesource.getEntity() instanceof EntityHuman ? (EntityHuman)damagesource.getEntity() : this.level().getNearestPlayer(CRYSTAL_DESTROY_TARGETING, blockposition.getX(), blockposition.getY(), blockposition.getZ());
        if (entityendercrystal == this.nearestCrystal) {
            this.hurt(this.head, this.damageSources().explosion(entityendercrystal, entityhuman), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_PHASE.equals(datawatcherobject) && this.level().isClientSide) {
            this.phaseManager.setPhase(DragonControllerPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    public DragonControllerManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EnderDragonBattle getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean canRide(Entity entity) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.getSubEntities();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].setId(i2 + packetplayoutspawnentity.getId());
        }
    }

    @Override
    public boolean canAttack(EntityLiving entityliving) {
        return entityliving.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float f2) {
        return 1.0f;
    }
}

