/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEnderDragon;
import org.bukkit.entity.EnderDragon;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.slf4j.Logger;

public class DragonControllerManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntityEnderDragon dragon;
    private final IDragonController[] phases = new IDragonController[DragonControllerPhase.getCount()];
    @Nullable
    private IDragonController currentPhase;

    public DragonControllerManager(EntityEnderDragon entityenderdragon) {
        this.dragon = entityenderdragon;
        this.setPhase(DragonControllerPhase.HOVERING);
    }

    public void setPhase(DragonControllerPhase<?> dragoncontrollerphase) {
        if (this.currentPhase == null || dragoncontrollerphase != this.currentPhase.getPhase()) {
            if (this.currentPhase != null) {
                this.currentPhase.end();
            }
            EnderDragonChangePhaseEvent event = new EnderDragonChangePhaseEvent((EnderDragon)((CraftEnderDragon)this.dragon.getBukkitEntity()), this.currentPhase == null ? null : CraftEnderDragon.getBukkitPhase(this.currentPhase.getPhase()), CraftEnderDragon.getBukkitPhase(dragoncontrollerphase));
            this.dragon.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            dragoncontrollerphase = CraftEnderDragon.getMinecraftPhase(event.getNewPhase());
            this.currentPhase = this.getPhase(dragoncontrollerphase);
            if (!this.dragon.level().isClientSide) {
                this.dragon.getEntityData().set(EntityEnderDragon.DATA_PHASE, dragoncontrollerphase.getId());
            }
            LOGGER.debug("Dragon is now in phase {} on the {}", (Object)dragoncontrollerphase, (Object)(this.dragon.level().isClientSide ? "client" : "server"));
            this.currentPhase.begin();
        }
    }

    public IDragonController getCurrentPhase() {
        return this.currentPhase;
    }

    public <T extends IDragonController> T getPhase(DragonControllerPhase<T> dragoncontrollerphase) {
        int i2 = dragoncontrollerphase.getId();
        if (this.phases[i2] == null) {
            this.phases[i2] = dragoncontrollerphase.createInstance(this.dragon);
        }
        return (T)this.phases[i2];
    }
}

