/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> DATA_TARGET_A = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_B = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_C = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final List<DataWatcherObject<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final DataWatcherObject<Integer> DATA_ID_INV = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    public final BossBattleServer bossEvent = (BossBattleServer)new BossBattleServer(this.getDisplayName(), BossBattle.BarColor.PURPLE, BossBattle.BarStyle.PROGRESS).setDarkenScreen(true);
    private static final Predicate<EntityLiving> LIVING_ENTITY_SELECTOR = entityliving -> !entityliving.getType().is(TagsEntity.WITHER_FRIENDS) && entityliving.attackable();
    private static final PathfinderTargetCondition TARGETING_CONDITIONS = PathfinderTargetCondition.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);

    public EntityWither(EntityTypes<? extends EntityWither> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.moveControl = new ControllerMoveFlying(this, 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Override
    protected NavigationAbstract createNavigation(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.setCanOpenDoors(false);
        navigationflying.setCanFloat(true);
        navigationflying.setCanPassDoors(true);
        return navigationflying;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new a());
        this.goalSelector.addGoal(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomFly(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_TARGET_A, 0);
        datawatcher_a.define(DATA_TARGET_B, 0);
        datawatcher_a.define(DATA_TARGET_C, 0);
        datawatcher_a.define(DATA_ID_INV, 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt("Invul", this.getInvulnerableTicks());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setInvulnerableTicks(nbttagcompound.getInt("Invul"));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomName(@Nullable IChatBaseComponent ichatbasecomponent) {
        super.setCustomName(ichatbasecomponent);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITHER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.WITHER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        int i2;
        Entity entity;
        Vec3D vec3d = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide && this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d0 = vec3d.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.x, d0, vec3d.z);
            Vec3D vec3d1 = new Vec3D(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec3d1.horizontalDistanceSqr() > 9.0) {
                Vec3D vec3d2 = vec3d1.normalize();
                vec3d = vec3d.add(vec3d2.x * 0.3 - vec3d.x * 0.6, 0.0, vec3d2.z * 0.3 - vec3d.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3d);
        if (vec3d.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)MathHelper.atan2(vec3d.z, vec3d.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (i2 = 0; i2 < 2; ++i2) {
            this.yRotOHeads[i2] = this.yRotHeads[i2];
            this.xRotOHeads[i2] = this.xRotHeads[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j2 = this.getAlternativeTarget(i2 + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.level().getEntity(j2);
            }
            if (entity1 != null) {
                double d1 = this.getHeadX(i2 + 1);
                double d2 = this.getHeadY(i2 + 1);
                double d3 = this.getHeadZ(i2 + 1);
                double d4 = entity1.getX() - d1;
                double d5 = entity1.getEyeY() - d2;
                double d6 = entity1.getZ() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.atan2(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.atan2(d5, d7) * 57.2957763671875));
                this.xRotHeads[i2] = this.rotlerp(this.xRotHeads[i2], f1, 40.0f);
                this.yRotHeads[i2] = this.rotlerp(this.yRotHeads[i2], f2, 10.0f);
                continue;
            }
            this.yRotHeads[i2] = this.rotlerp(this.yRotHeads[i2], this.yBodyRot, 10.0f);
        }
        boolean flag = this.isPowered();
        for (int j3 = 0; j3 < 3; ++j3) {
            double d8 = this.getHeadX(j3);
            double d9 = this.getHeadY(j3);
            double d10 = this.getHeadZ(j3);
            float f2 = 0.3f * this.getScale();
            this.level().addParticle(Particles.SMOKE, d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, 0.7f, 0.7f, 0.5f), d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float f3 = 3.3f * this.getScale();
            for (int k2 = 0; k2 < 3; ++k2) {
                this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, 0.7f, 0.7f, 0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * f3), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        if (this.getInvulnerableTicks() > 0) {
            int i2 = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.level().explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), event.getRadius(), event.getFire(), World.a.MOB);
                }
                if (!this.isSilent()) {
                    int viewDistance = ((WorldServer)this.level()).getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : MinecraftServer.getServer().getPlayerList().players) {
                        double deltaX = this.getX() - player.getX();
                        double deltaZ = this.getZ() - player.getZ();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (this.level().spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(this.level().spigotConfig.witherSpawnSoundRadius * this.level().spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                            player.connection.send(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.connection.send(new PacketPlayOutWorldEvent(1023, this.blockPosition(), 0, true));
                    }
                }
            }
            this.setInvulnerableTicks(i2);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j2;
            super.customServerAiStep();
            for (int i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                if (this.tickCount < this.nextHeadUpdate[i3 - 1]) continue;
                this.nextHeadUpdate[i3 - 1] = this.tickCount + 10 + this.random.nextInt(10);
                if (this.level().getDifficulty() == EnumDifficulty.NORMAL || this.level().getDifficulty() == EnumDifficulty.HARD) {
                    int k2 = i3 - 1;
                    int l2 = this.idleHeadUpdates[i3 - 1];
                    this.idleHeadUpdates[k2] = this.idleHeadUpdates[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                        double d1 = MathHelper.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                        double d2 = MathHelper.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                        this.performRangedAttack(i3 + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.getAlternativeTarget(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)this.level().getEntity(j2);
                    if (entityliving != null && this.canAttack(entityliving) && this.distanceToSqr(entityliving) <= 900.0 && this.hasLineOfSight(entityliving)) {
                        this.performRangedAttack(i3 + 1, entityliving);
                        this.nextHeadUpdate[i3 - 1] = this.tickCount + 40 + this.random.nextInt(20);
                        this.idleHeadUpdates[i3 - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(i3, 0);
                    continue;
                }
                List<EntityLiving> list = this.level().getNearbyEntities(EntityLiving.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.random.nextInt(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.setAlternativeTarget(i3, entityliving1.getId());
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    boolean flag = false;
                    j2 = MathHelper.floor(this.getBbWidth() / 2.0f + 1.0f);
                    int i1 = MathHelper.floor(this.getBbHeight());
                    for (BlockPosition blockposition : BlockPosition.betweenClosed(this.getBlockX() - j2, this.getBlockY(), this.getBlockZ() - j2, this.getBlockX() + j2, this.getBlockY() + i1, this.getBlockZ() + j2)) {
                        IBlockData iblockdata = this.level().getBlockState(blockposition);
                        if (!EntityWither.canDestroy(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.AIR.defaultBlockState())) continue;
                        flag = this.level().destroyBlock(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        this.level().levelEvent(null, 1022, this.blockPosition(), 0);
                    }
                }
            }
            if (this.tickCount % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroy(IBlockData iblockdata) {
        return !iblockdata.isAir() && !iblockdata.is(TagsBlock.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(IBlockData iblockdata, Vec3D vec3d) {
    }

    @Override
    public void startSeenByPlayer(EntityPlayer entityplayer) {
        super.startSeenByPlayer(entityplayer);
        this.bossEvent.addPlayer(entityplayer);
    }

    @Override
    public void stopSeenByPlayer(EntityPlayer entityplayer) {
        super.stopSeenByPlayer(entityplayer);
        this.bossEvent.removePlayer(entityplayer);
    }

    private double getHeadX(int i2) {
        if (i2 <= 0) {
            return this.getX();
        }
        float f2 = (this.yBodyRot + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.cos(f2);
        return this.getX() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int i2) {
        float f2 = i2 <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f2 * this.getScale());
    }

    private double getHeadZ(int i2) {
        if (i2 <= 0) {
            return this.getZ();
        }
        float f2 = (this.yBodyRot + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.sin(f2);
        return this.getZ() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float f2, float f1, float f22) {
        float f3 = MathHelper.wrapDegrees(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    private void performRangedAttack(int i2, EntityLiving entityliving) {
        this.performRangedAttack(i2, entityliving.getX(), entityliving.getY() + (double)entityliving.getEyeHeight() * 0.5, entityliving.getZ(), i2 == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int i2, double d0, double d1, double d2, boolean flag) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double d3 = this.getHeadX(i2);
        double d4 = this.getHeadY(i2);
        double d5 = this.getHeadZ(i2);
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        Vec3D vec3d = new Vec3D(d6, d7, d8);
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.level(), this, vec3d.normalize());
        entitywitherskull.setOwner(this);
        if (flag) {
            entitywitherskull.setDangerous(true);
        }
        entitywitherskull.setPosRaw(d3, d4, d5);
        this.level().addFreshEntity(entitywitherskull);
    }

    @Override
    public void performRangedAttack(EntityLiving entityliving, float f2) {
        this.performRangedAttack(0, entityliving);
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        if (!damagesource.is(DamageTypeTags.WITHER_IMMUNE_TO) && !(damagesource.getEntity() instanceof EntityWither)) {
            Entity entity;
            if (this.getInvulnerableTicks() > 0 && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return false;
            }
            if (this.isPowered() && ((entity = damagesource.getDirectEntity()) instanceof EntityArrow || entity instanceof WindCharge)) {
                return false;
            }
            entity = damagesource.getEntity();
            if (entity != null && entity.getType().is(TagsEntity.WITHER_FRIENDS)) {
                return false;
            }
            if (this.destroyBlocksTick <= 0) {
                this.destroyBlocksTick = 20;
            }
            int i2 = 0;
            while (i2 < this.idleHeadUpdates.length) {
                int n2 = i2++;
                this.idleHeadUpdates[n2] = this.idleHeadUpdates[n2] + 3;
            }
            return super.hurt(damagesource, f2);
        }
        return false;
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.dropCustomDeathLoot(worldserver, damagesource, flag);
        EntityItem entityitem = this.spawnAtLocation(Items.NETHER_STAR);
        if (entityitem != null) {
            entityitem.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 300.0).add(GenericAttributes.MOVEMENT_SPEED, 0.6f).add(GenericAttributes.FLYING_SPEED, 0.6f).add(GenericAttributes.FOLLOW_RANGE, 40.0).add(GenericAttributes.ARMOR, 4.0);
    }

    public float getHeadYRot(int i2) {
        return this.yRotHeads[i2];
    }

    public float getHeadXRot(int i2) {
        return this.xRotHeads[i2];
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int i2) {
        this.entityData.set(DATA_ID_INV, i2);
    }

    public int getAlternativeTarget(int i2) {
        return this.entityData.get(DATA_TARGETS.get(i2));
    }

    public void setAlternativeTarget(int i2, int j2) {
        this.entityData.set(DATA_TARGETS.get(i2), j2);
    }

    @Override
    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    protected boolean canRide(Entity entity) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public boolean canBeAffected(MobEffect mobeffect) {
        return mobeffect.is(MobEffects.WITHER) ? false : super.canBeAffected(mobeffect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityWither.this.getInvulnerableTicks() > 0;
        }
    }
}

