/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    private static final Vector3f DEFAULT_HEAD_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_BODY_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_LEFT_ARM_POSE = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f DEFAULT_RIGHT_ARM_POSE = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f DEFAULT_LEFT_LEG_POSE = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f DEFAULT_RIGHT_LEG_POSE = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize MARKER_DIMENSIONS = EntitySize.fixed(0.0f, 0.0f);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final DataWatcherObject<Byte> DATA_CLIENT_FLAGS = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Vector3f> DATA_HEAD_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_BODY_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).getMinecartType() == EntityMinecartAbstract.EnumMinecartType.RIDEABLE;
    private final NonNullList<net.minecraft.world.item.ItemStack> handItems = NonNullList.withSize(2, net.minecraft.world.item.ItemStack.EMPTY);
    private final NonNullList<net.minecraft.world.item.ItemStack> armorItems = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
    private boolean invisible;
    public long lastHit;
    public int disabledSlots;
    public Vector3f headPose = DEFAULT_HEAD_POSE;
    public Vector3f bodyPose = DEFAULT_BODY_POSE;
    public Vector3f leftArmPose = DEFAULT_LEFT_ARM_POSE;
    public Vector3f rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    public Vector3f leftLegPose = DEFAULT_LEFT_LEG_POSE;
    public Vector3f rightLegPose = DEFAULT_RIGHT_LEG_POSE;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
    }

    public EntityArmorStand(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.ARMOR_STAND, world);
        this.setPos(d0, d1, d2);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityArmorStand.createLivingAttributes().add(GenericAttributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.getYRot();
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_CLIENT_FLAGS, (byte)0);
        datawatcher_a.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        datawatcher_a.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        datawatcher_a.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        datawatcher_a.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        datawatcher_a.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        datawatcher_a.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    @Override
    public net.minecraft.world.item.ItemStack getItemBySlot(EnumItemSlot enumitemslot) {
        switch (enumitemslot.getType()) {
            case HAND: {
                return this.handItems.get(enumitemslot.getIndex());
            }
            case HUMANOID_ARMOR: {
                return this.armorItems.get(enumitemslot.getIndex());
            }
        }
        return net.minecraft.world.item.ItemStack.EMPTY;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.BODY;
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.verifyEquippedItem(itemstack);
        switch (enumitemslot.getType()) {
            case HAND: {
                this.onEquipItem(enumitemslot, this.handItems.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(enumitemslot, this.armorItems.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
            }
        }
    }

    @Override
    public boolean canTakeItem(net.minecraft.world.item.ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        return this.getItemBySlot(enumitemslot).isEmpty() && !this.isDisabled(enumitemslot);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.armorItems) {
            nbttaglist.add(itemstack.saveOptional(this.registryAccess()));
        }
        nbttagcompound.put("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.handItems) {
            nbttaglist1.add(itemstack1.saveOptional(this.registryAccess()));
        }
        nbttagcompound.put("HandItems", nbttaglist1);
        nbttagcompound.putBoolean("Invisible", this.isInvisible());
        nbttagcompound.putBoolean("Small", this.isSmall());
        nbttagcompound.putBoolean("ShowArms", this.isShowArms());
        nbttagcompound.putInt("DisabledSlots", this.disabledSlots);
        nbttagcompound.putBoolean("NoBasePlate", this.isNoBasePlate());
        if (this.isMarker()) {
            nbttagcompound.putBoolean("Marker", this.isMarker());
        }
        nbttagcompound.put("Pose", this.writePose());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        super.readAdditionalSaveData(nbttagcompound);
        if (nbttagcompound.contains("ArmorItems", 9)) {
            nbttaglist = nbttagcompound.getList("ArmorItems", 10);
            for (i2 = 0; i2 < this.armorItems.size(); ++i2) {
                nbttagcompound1 = nbttaglist.getCompound(i2);
                this.armorItems.set(i2, net.minecraft.world.item.ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        if (nbttagcompound.contains("HandItems", 9)) {
            nbttaglist = nbttagcompound.getList("HandItems", 10);
            for (i2 = 0; i2 < this.handItems.size(); ++i2) {
                nbttagcompound1 = nbttaglist.getCompound(i2);
                this.handItems.set(i2, net.minecraft.world.item.ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        this.setInvisible(nbttagcompound.getBoolean("Invisible"));
        this.setSmall(nbttagcompound.getBoolean("Small"));
        this.setShowArms(nbttagcompound.getBoolean("ShowArms"));
        this.disabledSlots = nbttagcompound.getInt("DisabledSlots");
        this.setNoBasePlate(nbttagcompound.getBoolean("NoBasePlate"));
        this.setMarker(nbttagcompound.getBoolean("Marker"));
        this.noPhysics = !this.hasPhysics();
        NBTTagCompound nbttagcompound2 = nbttagcompound.getCompound("Pose");
        this.readPose(nbttagcompound2);
    }

    private void readPose(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.getList("Head", 5);
        this.setHeadPose(nbttaglist.isEmpty() ? DEFAULT_HEAD_POSE : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbttagcompound.getList("Body", 5);
        this.setBodyPose(nbttaglist1.isEmpty() ? DEFAULT_BODY_POSE : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbttagcompound.getList("LeftArm", 5);
        this.setLeftArmPose(nbttaglist2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbttagcompound.getList("RightArm", 5);
        this.setRightArmPose(nbttaglist3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbttagcompound.getList("LeftLeg", 5);
        this.setLeftLegPose(nbttaglist4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbttagcompound.getList("RightLeg", 5);
        this.setRightLegPose(nbttaglist5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound writePose() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!DEFAULT_HEAD_POSE.equals(this.headPose)) {
            nbttagcompound.put("Head", this.headPose.save());
        }
        if (!DEFAULT_BODY_POSE.equals(this.bodyPose)) {
            nbttagcompound.put("Body", this.bodyPose.save());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals(this.leftArmPose)) {
            nbttagcompound.put("LeftArm", this.leftArmPose.save());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals(this.rightArmPose)) {
            nbttagcompound.put("RightArm", this.rightArmPose.save());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals(this.leftLegPose)) {
            nbttagcompound.put("LeftLeg", this.leftLegPose.save());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals(this.rightLegPose)) {
            nbttagcompound.put("RightLeg", this.rightLegPose.save());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity entity) {
    }

    @Override
    protected void pushEntities() {
        List<Entity> list = this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push(this);
        }
    }

    @Override
    public EnumInteractionResult interactAt(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        net.minecraft.world.item.ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (!this.isMarker() && !itemstack.is(Items.NAME_TAG)) {
            if (entityhuman.isSpectator()) {
                return EnumInteractionResult.SUCCESS;
            }
            if (entityhuman.level().isClientSide) {
                return EnumInteractionResult.CONSUME;
            }
            EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
            if (itemstack.isEmpty()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.getClickedSlot(vec3d);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.isDisabled(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.hasItemInSlot(enumitemslot2) && this.swapItem(entityhuman, enumitemslot2, itemstack, enumhand)) {
                    return EnumInteractionResult.SUCCESS;
                }
            } else {
                if (this.isDisabled(enumitemslot)) {
                    return EnumInteractionResult.FAIL;
                }
                if (enumitemslot.getType() == EnumItemSlot.Function.HAND && !this.isShowArms()) {
                    return EnumInteractionResult.FAIL;
                }
                if (this.swapItem(entityhuman, enumitemslot, itemstack, enumhand)) {
                    return EnumInteractionResult.SUCCESS;
                }
            }
            return EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot getClickedSlot(Vec3D vec3d) {
        EnumItemSlot enumitemslot = EnumItemSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = vec3d.y / (double)(this.getScale() * this.getAgeScale());
        EnumItemSlot enumitemslot1 = EnumItemSlot.FEET;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.hasItemInSlot(enumitemslot1)) {
                return EnumItemSlot.FEET;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.hasItemInSlot(EnumItemSlot.CHEST)) {
                return EnumItemSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.hasItemInSlot(EnumItemSlot.LEGS)) {
                return EnumItemSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EnumItemSlot.HEAD)) {
            return EnumItemSlot.HEAD;
        }
        if (this.hasItemInSlot(EnumItemSlot.MAINHAND)) return enumitemslot;
        if (!this.hasItemInSlot(EnumItemSlot.OFFHAND)) return enumitemslot;
        return EnumItemSlot.OFFHAND;
    }

    private boolean isDisabled(EnumItemSlot enumitemslot) {
        return (this.disabledSlots & 1 << enumitemslot.getFilterFlag()) != 0 || enumitemslot.getType() == EnumItemSlot.Function.HAND && !this.isShowArms();
    }

    private boolean swapItem(EntityHuman entityhuman, EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, EnumHand enumhand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
        if (!itemstack1.isEmpty() && (this.disabledSlots & 1 << enumitemslot.getFilterFlag() + 8) != 0) {
            return false;
        }
        if (itemstack1.isEmpty() && (this.disabledSlots & 1 << enumitemslot.getFilterFlag() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(itemstack);
        Player player = (Player)entityhuman.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot = CraftEquipmentSlot.getSlot(enumitemslot);
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot, hand);
        this.level().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (entityhuman.hasInfiniteMaterials() && itemstack1.isEmpty() && !itemstack.isEmpty()) {
            this.setItemSlot(enumitemslot, itemstack.copyWithCount(1));
            return true;
        }
        if (!itemstack.isEmpty() && itemstack.getCount() > 1) {
            if (!itemstack1.isEmpty()) {
                return false;
            }
            this.setItemSlot(enumitemslot, itemstack.split(1));
            return true;
        }
        this.setItemSlot(enumitemslot, itemstack);
        entityhuman.setItemInHand(enumhand, itemstack1);
        return true;
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isRemoved()) {
            return false;
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
                    return false;
                }
                this.kill(damagesource);
                return false;
            }
            if (!this.isInvulnerableTo(damagesource) && !this.isMarker()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, true, this.invisible)) {
                    return false;
                }
                if (damagesource.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(worldserver, damagesource);
                    this.kill(damagesource);
                    return false;
                }
                if (damagesource.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                    if (this.isOnFire()) {
                        this.causeDamage(worldserver, damagesource, 0.15f);
                    } else {
                        this.igniteForSeconds(5.0f);
                    }
                    return false;
                }
                if (damagesource.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                    this.causeDamage(worldserver, damagesource, 4.0f);
                    return false;
                }
                boolean flag = damagesource.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                boolean flag1 = damagesource.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                if (!flag && !flag1) {
                    return false;
                }
                Entity entity = damagesource.getEntity();
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (!entityhuman.getAbilities().mayBuild) {
                        return false;
                    }
                }
                if (damagesource.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill(damagesource);
                    return true;
                }
                long i2 = worldserver.getGameTime();
                if (i2 - this.lastHit > 5L && !flag1) {
                    worldserver.broadcastEntityEvent(this, (byte)32);
                    this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
                    this.lastHit = i2;
                } else {
                    this.brokenByPlayer(worldserver, damagesource);
                    this.showBreakingParticles();
                    this.discard(EntityRemoveEvent.Cause.DEATH);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof WorldServer) {
            ((WorldServer)this.level()).sendParticles(new ParticleParamBlock(Particles.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(WorldServer worldserver, DamageSource damagesource, float f2) {
        float f1 = this.getHealth();
        if ((f1 -= f2) <= 0.5f) {
            this.brokenByAnything(worldserver, damagesource);
            this.kill(damagesource);
        } else {
            this.setHealth(f1);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
        }
    }

    private void brokenByPlayer(WorldServer worldserver, DamageSource damagesource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
        itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
        this.brokenByAnything(worldserver, damagesource);
    }

    private void brokenByAnything(WorldServer worldserver, DamageSource damagesource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.playBrokenSound();
        for (i2 = 0; i2 < this.handItems.size(); ++i2) {
            itemstack = this.handItems.get(i2);
            if (itemstack.isEmpty()) continue;
            this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
            this.handItems.set(i2, net.minecraft.world.item.ItemStack.EMPTY);
        }
        for (i2 = 0; i2 < this.armorItems.size(); ++i2) {
            itemstack = this.armorItems.get(i2);
            if (itemstack.isEmpty()) continue;
            this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
            this.armorItems.set(i2, net.minecraft.world.item.ItemStack.EMPTY);
        }
        this.dropAllDeathLoot(worldserver, damagesource);
    }

    private void playBrokenSound() {
        this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected float tickHeadTurn(float f2, float f1) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    @Override
    public void travel(Vec3D vec3d) {
        if (this.hasPhysics()) {
            super.travel(vec3d);
        }
    }

    @Override
    public void setYBodyRot(float f2) {
        this.yBodyRotO = this.yRotO = f2;
        this.yHeadRotO = this.yHeadRot = f2;
    }

    @Override
    public void setYHeadRot(float f2) {
        this.yBodyRotO = this.yRotO = f2;
        this.yHeadRotO = this.yHeadRot = f2;
    }

    @Override
    public void tick() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        super.tick();
        Vector3f vector3f = this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals(vector3f)) {
            this.setHeadPose(vector3f);
        }
        if (!this.bodyPose.equals(vector3f1 = this.entityData.get(DATA_BODY_POSE))) {
            this.setBodyPose(vector3f1);
        }
        if (!this.leftArmPose.equals(vector3f2 = this.entityData.get(DATA_LEFT_ARM_POSE))) {
            this.setLeftArmPose(vector3f2);
        }
        if (!this.rightArmPose.equals(vector3f3 = this.entityData.get(DATA_RIGHT_ARM_POSE))) {
            this.setRightArmPose(vector3f3);
        }
        if (!this.leftLegPose.equals(vector3f4 = this.entityData.get(DATA_LEFT_LEG_POSE))) {
            this.setLeftLegPose(vector3f4);
        }
        if (!this.rightLegPose.equals(vector3f5 = this.entityData.get(DATA_RIGHT_LEG_POSE))) {
            this.setRightLegPose(vector3f5);
        }
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean flag) {
        this.invisible = flag;
        super.setInvisible(flag);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public boolean shouldDropExperience() {
        return true;
    }

    @Override
    public void kill() {
        this.kill(null);
    }

    public void kill(DamageSource damageSource) {
        CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.damageSources().genericKill() : damageSource, this.drops);
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return this.isInvisible();
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return this.isMarker() ? EnumPistonReaction.IGNORE : super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setSmall(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, flag));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, flag));
    }

    public boolean isShowArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, flag));
    }

    public boolean isNoBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    public void setMarker(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, flag));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte b0, int i2, boolean flag) {
        b0 = flag ? (byte)(b0 | i2) : (byte)(b0 & ~i2);
        return b0;
    }

    public void setHeadPose(Vector3f vector3f) {
        this.headPose = vector3f;
        this.entityData.set(DATA_HEAD_POSE, vector3f);
    }

    public void setBodyPose(Vector3f vector3f) {
        this.bodyPose = vector3f;
        this.entityData.set(DATA_BODY_POSE, vector3f);
    }

    public void setLeftArmPose(Vector3f vector3f) {
        this.leftArmPose = vector3f;
        this.entityData.set(DATA_LEFT_ARM_POSE, vector3f);
    }

    public void setRightArmPose(Vector3f vector3f) {
        this.rightArmPose = vector3f;
        this.entityData.set(DATA_RIGHT_ARM_POSE, vector3f);
    }

    public void setLeftLegPose(Vector3f vector3f) {
        this.leftLegPose = vector3f;
        this.entityData.set(DATA_LEFT_LEG_POSE, vector3f);
    }

    public void setRightLegPose(Vector3f vector3f) {
        this.rightLegPose = vector3f;
        this.entityData.set(DATA_RIGHT_LEG_POSE, vector3f);
    }

    public Vector3f getHeadPose() {
        return this.headPose;
    }

    public Vector3f getBodyPose() {
        return this.bodyPose;
    }

    public Vector3f getLeftArmPose() {
        return this.leftArmPose;
    }

    public Vector3f getRightArmPose() {
        return this.rightArmPose;
    }

    public Vector3f getLeftLegPose() {
        return this.leftLegPose;
    }

    public Vector3f getRightLegPose() {
        return this.rightLegPose;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        return entity instanceof EntityHuman && !this.level().mayInteract((EntityHuman)entity, this.blockPosition());
    }

    @Override
    public EnumMainHand getMainArm() {
        return EnumMainHand.RIGHT;
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.ARMOR_STAND_FALL, SoundEffects.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(WorldServer worldserver, EntityLightning entitylightning) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_CLIENT_FLAGS.equals(datawatcherobject)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntitySize getDimensionsMarker(boolean flag) {
        return flag ? MARKER_DIMENSIONS : (this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions());
    }

    @Override
    public Vec3D getLightProbePosition(float f2) {
        if (this.isMarker()) {
            AxisAlignedBB axisalignedbb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPosition blockposition = this.blockPosition();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.betweenClosed(BlockPosition.containing(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ), BlockPosition.containing(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ))) {
                int j2 = Math.max(this.level().getBrightness(EnumSkyBlock.BLOCK, blockposition1), this.level().getBrightness(EnumSkyBlock.SKY, blockposition1));
                if (j2 == 15) {
                    return Vec3D.atCenterOf(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.immutable();
            }
            return Vec3D.atCenterOf(blockposition);
        }
        return super.getLightProbePosition(f2);
    }

    @Override
    public net.minecraft.world.item.ItemStack getPickResult() {
        return new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }
}

