/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLeash;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLeash
extends BlockAttachedEntity {
    public static final double OFFSET_Y = 0.375;

    public EntityLeash(EntityTypes<? extends EntityLeash> entitytypes, World world) {
        super((EntityTypes<? extends BlockAttachedEntity>)entitytypes, world);
    }

    public EntityLeash(World world, BlockPosition blockposition) {
        super(EntityTypes.LEASH_KNOT, world, blockposition);
        this.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
    }

    @Override
    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double d0 = (double)this.getType().getWidth() / 2.0;
        double d1 = this.getType().getHeight();
        this.setBoundingBox(new AxisAlignedBB(this.getX() - d0, this.getY(), this.getZ() - d0, this.getX() + d0, this.getY() + d1, this.getZ() + d0));
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        return d0 < 1024.0;
    }

    @Override
    public void dropItem(@Nullable Entity entity) {
        this.playSound(SoundEffects.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
    }

    @Override
    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        if (this.level().isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        boolean flag = false;
        List<Leashable> list = ItemLeash.leashableInArea(this.level(), this.getPos(), leashable -> {
            Entity entity = leashable.getLeashHolder();
            return entity == entityhuman || entity == this;
        });
        for (Leashable leashable2 : list) {
            Entity leashed;
            if (leashable2.getLeashHolder() != entityhuman) continue;
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), this, entityhuman, enumhand).isCancelled()) {
                ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutAttachEntity(leashed, leashable2.getLeashHolder()));
                flag = true;
                continue;
            }
            leashable2.setLeashedTo(this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Leashable leashable1 : list) {
                Entity leashed;
                if (!leashable1.isLeashed() || leashable1.getLeashHolder() != this) continue;
                if (leashable1 instanceof Entity && CraftEventFactory.callPlayerUnleashEntityEvent(leashed = (Entity)((Object)leashable1), entityhuman, enumhand).isCancelled()) {
                    die = false;
                    continue;
                }
                leashable1.dropLeash(true, !entityhuman.getAbilities().instabuild);
                flag1 = true;
            }
            if (die) {
                this.discard(EntityRemoveEvent.Cause.DROP);
            }
        }
        if (flag || flag1) {
            this.gameEvent(GameEvent.BLOCK_ATTACH, entityhuman);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public boolean survives() {
        return this.level().getBlockState(this.pos).is(TagsBlock.FENCES);
    }

    public static EntityLeash getOrCreateKnot(World world, BlockPosition blockposition) {
        EntityLeash entityleash;
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        List<EntityLeash> list = world.getEntitiesOfClass(EntityLeash.class, new AxisAlignedBB((double)i2 - 1.0, (double)j2 - 1.0, (double)k2 - 1.0, (double)i2 + 1.0, (double)j2 + 1.0, (double)k2 + 1.0));
        Iterator<EntityLeash> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            EntityLeash entityleash1 = new EntityLeash(world, blockposition);
            world.addFreshEntity(entityleash1);
            return entityleash1;
        } while (!(entityleash = iterator.next()).getPos().equals(blockposition));
        return entityleash;
    }

    public void playPlacementSound() {
        this.playSound(SoundEffects.LEASH_KNOT_PLACE, 1.0f, 1.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, 0, this.getPos());
    }

    @Override
    public Vec3D getRopeHoldPosition(float f2) {
        return this.getPosition(f2).add(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.LEAD);
    }
}

