/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging
implements VariantHolder<Holder<PaintingVariant>> {
    private static final DataWatcherObject<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = DataWatcher.defineId(EntityPainting.class, DataWatcherRegistry.PAINTING_VARIANT);
    public static final MapCodec<Holder<PaintingVariant>> VARIANT_MAP_CODEC = PaintingVariant.CODEC.fieldOf("variant");
    public static final Codec<Holder<PaintingVariant>> VARIANT_CODEC = VARIANT_MAP_CODEC.codec();
    public static final float DEPTH = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> entitytypes, World world) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_PAINTING_VARIANT_ID, (Holder)this.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getAny().orElseThrow());
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_PAINTING_VARIANT_ID.equals(datawatcherobject)) {
            this.recalculateBoundingBox();
        }
    }

    @Override
    public void setVariant(Holder<PaintingVariant> holder) {
        this.entityData.set(DATA_PAINTING_VARIANT_ID, holder);
    }

    @Override
    public Holder<PaintingVariant> getVariant() {
        return this.entityData.get(DATA_PAINTING_VARIANT_ID);
    }

    public static Optional<EntityPainting> create(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        EntityPainting entitypainting = new EntityPainting(world, blockposition);
        ArrayList<Holder> list = new ArrayList<Holder>();
        Iterable<Holder<PaintingVariant>> iterable = world.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE);
        Objects.requireNonNull(list);
        iterable.forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.setDirection(enumdirection);
        list.removeIf(holder -> {
            entitypainting.setVariant((Holder<PaintingVariant>)holder);
            return !entitypainting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::variantArea).max().orElse(0);
        list.removeIf(holder -> EntityPainting.variantArea(holder) < i2);
        Optional optional = SystemUtils.getRandomSafe(list, entitypainting.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.setVariant((Holder)optional.get());
        entitypainting.setDirection(enumdirection);
        return Optional.of(entitypainting);
    }

    private static int variantArea(Holder<PaintingVariant> holder) {
        return holder.value().area();
    }

    private EntityPainting(World world, BlockPosition blockposition) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.PAINTING, world, blockposition);
    }

    public EntityPainting(World world, BlockPosition blockposition, EnumDirection enumdirection, Holder<PaintingVariant> holder) {
        this(world, blockposition);
        this.setVariant(holder);
        this.setDirection(enumdirection);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        VARIANT_CODEC.encodeStart(this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE), this.getVariant()).ifSuccess(nbtbase -> nbttagcompound.merge((NBTTagCompound)nbtbase));
        nbttagcompound.putByte("facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(nbttagcompound);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        VARIANT_CODEC.parse(this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)nbttagcompound).ifSuccess(this::setVariant);
        this.direction = EnumDirection.from2DDataValue(nbttagcompound.getByte("facing"));
        super.readAdditionalSaveData(nbttagcompound);
        this.setDirection(this.direction);
    }

    @Override
    protected AxisAlignedBB calculateBoundingBox(BlockPosition blockposition, EnumDirection enumdirection) {
        PaintingVariant paintingvariant = (PaintingVariant)this.getVariant().value();
        return EntityPainting.calculateBoundingBoxStatic(blockposition, enumdirection, paintingvariant.width(), paintingvariant.height());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection, int width, int height) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.atCenterOf(blockposition).relative(enumdirection, -0.46875);
        double d0 = EntityPainting.offsetForPaintingSize(width);
        double d1 = EntityPainting.offsetForPaintingSize(height);
        EnumDirection enumdirection1 = enumdirection.getCounterClockWise();
        Vec3D vec3d1 = vec3d.relative(enumdirection1, d0).relative(EnumDirection.UP, d1);
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.getAxis();
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.X ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = enumdirection_enumaxis == EnumDirection.EnumAxis.Z ? 0.0625 : (double)width;
        return AxisAlignedBB.ofSize(vec3d1, d2, d3, d4);
    }

    private static double offsetForPaintingSize(int i2) {
        return i2 % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void dropItem(@Nullable Entity entity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            EntityHuman entityhuman;
            this.playSound(SoundEffects.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(Items.PAINTING);
        }
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEffects.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void moveTo(double d0, double d1, double d2, float f2, float f1) {
        this.setPos(d0, d1, d2);
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.setPos(d0, d1, d2);
    }

    @Override
    public Vec3D trackingPosition() {
        return Vec3D.atLowerCornerOf(this.pos);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.setDirection(EnumDirection.from3DDataValue(packetplayoutspawnentity.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

