/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private IBlockData blockState = Blocks.SAND.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    public boolean cancelDrop;
    public boolean hurtEntities;
    public int fallDamageMax = 40;
    public float fallDamagePerDistance;
    @Nullable
    public NBTTagCompound blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final DataWatcherObject<BlockPosition> DATA_START_POS = DataWatcher.defineId(EntityFallingBlock.class, DataWatcherRegistry.BLOCK_POS);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> entitytypes, World world) {
        super(entitytypes, world);
    }

    private EntityFallingBlock(World world, double d0, double d1, double d2, IBlockData iblockdata) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.FALLING_BLOCK, world);
        this.blockState = iblockdata;
        this.blocksBuilding = true;
        this.setPos(d0, d1, d2);
        this.setDeltaMovement(Vec3D.ZERO);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
        this.setStartPos(this.blockPosition());
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return EntityFallingBlock.fall(world, blockposition, iblockdata, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, iblockdata.hasProperty(BlockProperties.WATERLOGGED) ? (IBlockData)iblockdata.setValue(BlockProperties.WATERLOGGED, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.getFluidState().createLegacyBlock())) {
            return entityfallingblock;
        }
        world.setBlock(blockposition, iblockdata.getFluidState().createLegacyBlock(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    public void setStartPos(BlockPosition blockposition) {
        this.entityData.set(DATA_START_POS, blockposition);
    }

    public BlockPosition getStartPos() {
        return this.entityData.get(DATA_START_POS);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_START_POS, BlockPosition.ZERO);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.blockState.isAir()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            this.applyGravity();
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.handlePortal();
            if (!this.level().isClientSide && (this.isAlive() || this.forceTickAfterTeleportToDuplicate)) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.blockPosition();
                boolean flag = this.blockState.getBlock() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.level().getFluidState(blockposition).is(TagsFluid.WATER);
                double d0 = this.getDeltaMovement().lengthSqr();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.level().clip(new RayTrace(new Vec3D(this.xo, this.yo, this.zo), this.position(), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.SOURCE_ONLY, this))).getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.level().getFluidState(movingobjectpositionblock.getBlockPos()).is(TagsFluid.WATER)) {
                    blockposition = movingobjectpositionblock.getBlockPos();
                    flag1 = true;
                }
                if (!this.onGround() && !flag1) {
                    if (!(this.level().isClientSide || (this.time <= 100 || blockposition.getY() > this.level().getMinBuildHeight() && blockposition.getY() <= this.level().getMaxBuildHeight()) && this.time <= 600)) {
                        if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            this.spawnAtLocation(block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    IBlockData iblockdata = this.level().getBlockState(blockposition);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!iblockdata.is(Blocks.MOVING_PISTON)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = iblockdata.canBeReplaced(new BlockActionContextDirectional(this.level(), blockposition, EnumDirection.DOWN, ItemStack.EMPTY, EnumDirection.UP));
                            boolean flag3 = BlockFalling.isFree(this.level().getBlockState(blockposition.below())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.canSurvive(this.level(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.hasProperty(BlockProperties.WATERLOGGED) && this.level().getFluidState(blockposition).getType() == FluidTypes.WATER) {
                                    this.blockState = (IBlockData)this.blockState.setValue(BlockProperties.WATERLOGGED, true);
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.blockState)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (this.level().setBlock(blockposition, this.blockState, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.level()).getChunkSource().chunkMap.broadcast(this, new PacketPlayOutBlockChange(blockposition, this.level().getBlockState(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).onLand(this.level(), blockposition, this.blockState, iblockdata, this);
                                    }
                                    if (this.blockData != null && this.blockState.hasBlockEntity() && (tileentity = this.level().getBlockEntity(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.saveWithoutMetadata(this.level().registryAccess());
                                        for (String s2 : this.blockData.getAllKeys()) {
                                            nbttagcompound.put(s2, this.blockData.get(s2).copy());
                                        }
                                        try {
                                            tileentity.loadWithComponents(nbttagcompound, this.level().registryAccess());
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.setChanged();
                                    }
                                } else if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    this.callOnBrokenAfterFall(block, blockposition);
                                    this.spawnAtLocation(block);
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.callOnBrokenAfterFall(block, blockposition);
                                    this.spawnAtLocation(block);
                                }
                            }
                        } else {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.callOnBrokenAfterFall(block, blockposition);
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPosition blockposition) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).onBrokenAfterFall(this.level(), blockposition, this);
        }
    }

    @Override
    public boolean causeFallDamage(float f2, float f1, DamageSource damagesource) {
        DamageSource damagesource1;
        if (!this.hurtEntities) {
            return false;
        }
        int i2 = MathHelper.ceil(f2 - 1.0f);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.NO_CREATIVE_OR_SPECTATOR.and(IEntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.getFallDamageSource(this);
        } else {
            damagesource1 = this.damageSources().fallingBlock(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f22 = Math.min(MathHelper.floor((float)i2 * this.fallDamagePerDistance), this.fallDamageMax);
        this.level().getEntities(this, this.getBoundingBox(), predicate).forEach(entity -> entity.hurt(damagesource2, f22));
        boolean flag = this.blockState.is(TagsBlock.ANVIL);
        if (flag && f22 > 0.0f && this.random.nextFloat() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.damage(this.blockState);
            if (iblockdata == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.put("BlockState", GameProfileSerializer.writeBlockState(this.blockState));
        nbttagcompound.putInt("Time", this.time);
        nbttagcompound.putBoolean("DropItem", this.dropItem);
        nbttagcompound.putBoolean("HurtEntities", this.hurtEntities);
        nbttagcompound.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        nbttagcompound.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            nbttagcompound.put("TileEntityData", this.blockData);
        }
        nbttagcompound.putBoolean("CancelDrop", this.cancelDrop);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.blockState = GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), nbttagcompound.getCompound("BlockState"));
        this.time = nbttagcompound.getInt("Time");
        if (nbttagcompound.contains("HurtEntities", 99)) {
            this.hurtEntities = nbttagcompound.getBoolean("HurtEntities");
            this.fallDamagePerDistance = nbttagcompound.getFloat("FallHurtAmount");
            this.fallDamageMax = nbttagcompound.getInt("FallHurtMax");
        } else if (this.blockState.is(TagsBlock.ANVIL)) {
            this.hurtEntities = true;
        }
        if (nbttagcompound.contains("DropItem", 99)) {
            this.dropItem = nbttagcompound.getBoolean("DropItem");
        }
        if (nbttagcompound.contains("TileEntityData", 10)) {
            this.blockData = nbttagcompound.getCompound("TileEntityData").copy();
        }
        this.cancelDrop = nbttagcompound.getBoolean("CancelDrop");
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public void setHurtsEntities(float f2, int i2) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = f2;
        this.fallDamageMax = i2;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    @Override
    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails crashreportsystemdetails) {
        super.fillCrashReportCategory(crashreportsystemdetails);
        crashreportsystemdetails.setDetail("Immitating BlockState", this.blockState.toString());
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Override
    protected IChatBaseComponent getTypeName() {
        return IChatBaseComponent.translatable("entity.minecraft.falling_block_type", this.blockState.getBlock().getName());
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, Block.getId(this.getBlockState()));
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.blockState = Block.stateById(packetplayoutspawnentity.getData());
        this.blocksBuilding = true;
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionTransition dimensiontransition) {
        ResourceKey<World> resourcekey = dimensiontransition.newLevel().dimension();
        ResourceKey<World> resourcekey1 = this.level().dimension();
        boolean flag = (resourcekey1 == World.END || resourcekey == World.END) && resourcekey1 != resourcekey;
        Entity entity = super.changeDimension(dimensiontransition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }
}

