/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> DATA_ITEM = DataWatcher.defineId(EntityItem.class, DataWatcherRegistry.ITEM_STACK);
    private static final float FLOAT_HEIGHT = 0.1f;
    public static final float EYE_HEIGHT = 0.2125f;
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    public int age;
    public int pickupDelay;
    private int health = 5;
    @Nullable
    public UUID thrower;
    @Nullable
    private Entity cachedThrower;
    @Nullable
    public UUID target;
    public final float bobOffs;
    private int lastTick = MinecraftServer.currentTick - 1;

    public EntityItem(EntityTypes<? extends EntityItem> entitytypes, World world) {
        super(entitytypes, world);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack, world.random.nextDouble() * 0.2 - 0.1, 0.2, world.random.nextDouble() * 0.2 - 0.1);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack, double d3, double d4, double d5) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ITEM, world);
        this.setPos(d0, d1, d2);
        this.setDeltaMovement(d3, d4, d5);
        this.setItem(itemstack);
    }

    private EntityItem(EntityItem entityitem) {
        super(entityitem.getType(), entityitem.level());
        this.setItem(entityitem.getItem().copy());
        this.copyPosition(entityitem);
        this.age = entityitem.age;
        this.bobOffs = entityitem.bobOffs;
    }

    @Override
    public boolean dampensVibrations() {
        return this.getItem().is(TagsItem.DAMPENS_VIBRATIONS);
    }

    @Override
    @Nullable
    public Entity getOwner() {
        World world;
        if (this.cachedThrower != null && !this.cachedThrower.isRemoved()) {
            return this.cachedThrower;
        }
        if (this.thrower != null && (world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.cachedThrower = worldserver.getEntity(this.thrower);
            return this.cachedThrower;
        }
        return null;
    }

    @Override
    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            this.cachedThrower = entityitem.cachedThrower;
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.getItem().isEmpty()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.tick();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.pickupDelay != Short.MAX_VALUE) {
                this.pickupDelay -= elapsedTicks;
            }
            if (this.age != Short.MIN_VALUE) {
                this.age += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            Vec3D vec3d = this.getDeltaMovement();
            if (this.isInWater() && this.getFluidHeight(TagsFluid.WATER) > (double)0.1f) {
                this.setUnderwaterMovement();
            } else if (this.isInLava() && this.getFluidHeight(TagsFluid.LAVA) > (double)0.1f) {
                this.setUnderLavaMovement();
            } else {
                this.applyGravity();
            }
            if (this.level().isClientSide) {
                this.noPhysics = false;
            } else {
                boolean bl = this.noPhysics = !this.level().noCollision(this, this.getBoundingBox().deflate(1.0E-7));
                if (this.noPhysics) {
                    this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                }
            }
            if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                float f2 = 0.98f;
                if (this.onGround()) {
                    f2 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
                }
                this.setDeltaMovement(this.getDeltaMovement().multiply(f2, 0.98, f2));
                if (this.onGround()) {
                    Vec3D vec3d1 = this.getDeltaMovement();
                    if (vec3d1.y < 0.0) {
                        this.setDeltaMovement(vec3d1.multiply(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.floor(this.xo) != MathHelper.floor(this.getX()) || MathHelper.floor(this.yo) != MathHelper.floor(this.getY()) || MathHelper.floor(this.zo) != MathHelper.floor(this.getZ());
            int n2 = i2 = flag ? 2 : 40;
            if (this.tickCount % i2 == 0 && !this.level().isClientSide && this.isMergable()) {
                this.mergeWithNeighbours();
            }
            this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
            if (!this.level().isClientSide && (d0 = this.getDeltaMovement().subtract(vec3d).lengthSqr()) > 0.01) {
                this.hasImpulse = true;
            }
            if (!this.level().isClientSide && this.age >= this.level().spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.age = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.pickupDelay != Short.MAX_VALUE) {
            this.pickupDelay -= elapsedTicks;
        }
        if (this.age != Short.MIN_VALUE) {
            this.age += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.level().isClientSide && this.age >= this.level().spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.age = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setUnderwaterMovement() {
        Vec3D vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.99f, vec3d.y + (double)(vec3d.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.z * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3D vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.95f, vec3d.y + (double)(vec3d.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.z * (double)0.95f);
    }

    private void mergeWithNeighbours() {
        if (this.isMergable()) {
            double radius = this.level().spigotConfig.itemMerge;
            List<EntityItem> list = this.level().getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(radius, radius - 0.5, radius), entityitem -> entityitem != this && entityitem.isMergable());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.isMergable()) continue;
                this.tryToMerge(entityitem2);
                if (!this.isRemoved()) continue;
                break;
            }
        }
    }

    private boolean isMergable() {
        ItemStack itemstack = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < 6000 && itemstack.getCount() < itemstack.getMaxStackSize();
    }

    private void tryToMerge(EntityItem entityitem) {
        ItemStack itemstack = this.getItem();
        ItemStack itemstack1 = entityitem.getItem();
        if (Objects.equals(this.target, entityitem.target) && EntityItem.areMergable(itemstack, itemstack1)) {
            EntityItem.merge(this, itemstack, entityitem, itemstack1);
        }
    }

    public static boolean areMergable(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack1.getCount() + itemstack.getCount() > itemstack1.getMaxStackSize() ? false : ItemStack.isSameItemSameComponents(itemstack, itemstack1);
    }

    public static ItemStack merge(ItemStack itemstack, ItemStack itemstack1, int i2) {
        int j2 = Math.min(Math.min(itemstack.getMaxStackSize(), i2) - itemstack.getCount(), itemstack1.getCount());
        ItemStack itemstack2 = itemstack.copyWithCount(itemstack.getCount() + j2);
        itemstack1.shrink(j2);
        return itemstack2;
    }

    private static void merge(EntityItem entityitem, ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2 = EntityItem.merge(itemstack, itemstack1, 64);
        entityitem.setItem(itemstack2);
    }

    private static void merge(EntityItem entityitem, ItemStack itemstack, EntityItem entityitem1, ItemStack itemstack1) {
        if (!CraftEventFactory.callItemMergeEvent(entityitem1, entityitem)) {
            return;
        }
        EntityItem.merge(entityitem, itemstack, itemstack1);
        entityitem.pickupDelay = Math.max(entityitem.pickupDelay, entityitem1.pickupDelay);
        entityitem.age = Math.min(entityitem.age, entityitem1.age);
        if (itemstack1.isEmpty()) {
            entityitem1.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean fireImmune() {
        return this.getItem().has(DataComponents.FIRE_RESISTANT) || super.fireImmune();
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        if (!this.getItem().isEmpty() && this.getItem().is(Items.NETHER_STAR) && damagesource.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        if (!this.getItem().canBeHurtBy(damagesource)) {
            return false;
        }
        if (this.level().isClientSide) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - f2);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putShort("Health", (short)this.health);
        nbttagcompound.putShort("Age", (short)this.age);
        nbttagcompound.putShort("PickupDelay", (short)this.pickupDelay);
        if (this.thrower != null) {
            nbttagcompound.putUUID("Thrower", this.thrower);
        }
        if (this.target != null) {
            nbttagcompound.putUUID("Owner", this.target);
        }
        if (!this.getItem().isEmpty()) {
            nbttagcompound.put("Item", this.getItem().save(this.registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health");
        this.age = nbttagcompound.getShort("Age");
        if (nbttagcompound.contains("PickupDelay")) {
            this.pickupDelay = nbttagcompound.getShort("PickupDelay");
        }
        if (nbttagcompound.hasUUID("Owner")) {
            this.target = nbttagcompound.getUUID("Owner");
        }
        if (nbttagcompound.hasUUID("Thrower")) {
            this.thrower = nbttagcompound.getUUID("Thrower");
            this.cachedThrower = null;
        }
        if (nbttagcompound.contains("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Item");
            this.setItem(ItemStack.parse(this.registryAccess(), nbttagcompound1).orElse(ItemStack.EMPTY));
        } else {
            this.setItem(ItemStack.EMPTY);
        }
        if (this.getItem().isEmpty()) {
            this.discard(null);
        }
    }

    @Override
    public void playerTouch(EntityHuman entityhuman) {
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            int i2 = itemstack.getCount();
            int canHold = entityhuman.getInventory().canHold(itemstack);
            int remaining = i2 - canHold;
            if (this.pickupDelay <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.setCount(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.setCount(i2);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)entityhuman.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.setCount(i2);
                    return;
                }
                ItemStack current = this.getItem();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.setCount(canHold + remaining);
                }
                this.pickupDelay = 0;
            } else if (this.pickupDelay == 0) {
                this.pickupDelay = -1;
            }
            if (this.pickupDelay == 0 && (this.target == null || this.target.equals(entityhuman.getUUID())) && entityhuman.getInventory().add(itemstack)) {
                entityhuman.take(this, i2);
                if (itemstack.isEmpty()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.setCount(i2);
                }
                entityhuman.awardStat(StatisticList.ITEM_PICKED_UP.get(item), i2);
                entityhuman.onItemPickup(this);
            }
        }
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.translatable(this.getItem().getDescriptionId());
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionTransition dimensiontransition) {
        Entity entity = super.changeDimension(dimensiontransition);
        if (!this.level().isClientSide && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.mergeWithNeighbours();
        }
        return entity;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack itemstack) {
        this.getEntityData().set(DATA_ITEM, itemstack);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (DATA_ITEM.equals(datawatcherobject)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    public void setTarget(@Nullable UUID uuid) {
        this.target = uuid;
    }

    public void setThrower(Entity entity) {
        this.thrower = entity.getUUID();
        this.cachedThrower = entity;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int i2) {
        this.pickupDelay = i2;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = this.level().spigotConfig.itemDespawnRate - 1;
    }

    public float getSpin(float f2) {
        return ((float)this.getAge() + f2) / 20.0f + this.bobOffs;
    }

    public EntityItem copy() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return 180.0f - this.getSpin(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess getSlot(int i2) {
        return i2 == 0 ? SlotAccess.of(this::getItem, this::setItem) : super.getSlot(i2);
    }
}

