/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep wololoTarget;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> entitytypes, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)entitytypes, world);
        this.xpReward = 10;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new b());
        this.goalSelector.addGoal(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, new c());
        this.goalSelector.addGoal(5, new a());
        this.goalSelector.addGoal(6, new d());
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.5).add(GenericAttributes.FOLLOW_RANGE, 12.0).add(GenericAttributes.MAX_HEALTH, 24.0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.EVOKER_CELEBRATE;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    @Override
    public boolean isAlliedTo(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof EntityVex) {
            EntityVex entityvex = (EntityVex)entity;
            return this.isAlliedTo(entityvex.getOwner());
        }
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.EVOKER_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.EVOKER_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.EVOKER_HURT;
    }

    void setWololoTarget(@Nullable EntitySheep entitysheep) {
        this.wololoTarget = entitysheep;
    }

    @Nullable
    EntitySheep getWololoTarget() {
        return this.wololoTarget;
    }

    @Override
    protected SoundEffect getCastingSoundEvent() {
        return SoundEffects.EVOKER_CAST_SPELL;
    }

    @Override
    public void applyRaidBuffs(WorldServer worldserver, int i2, boolean flag) {
    }

    private class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void tick() {
            if (EntityEvoker.this.getTarget() != null) {
                EntityEvoker.this.getLookControl().setLookAt(EntityEvoker.this.getTarget(), EntityEvoker.this.getMaxHeadYRot(), EntityEvoker.this.getMaxHeadXRot());
            } else if (EntityEvoker.this.getWololoTarget() != null) {
                EntityEvoker.this.getLookControl().setLookAt(EntityEvoker.this.getWololoTarget(), EntityEvoker.this.getMaxHeadYRot(), EntityEvoker.this.getMaxHeadXRot());
            }
        }
    }

    private class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition vexCountTargeting;

        c() {
            super(EntityEvoker.this);
            this.vexCountTargeting = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i2 = EntityEvoker.this.level().getNearbyEntities(EntityVex.class, this.vexCountTargeting, EntityEvoker.this, EntityEvoker.this.getBoundingBox().inflate(16.0)).size();
            return EntityEvoker.this.random.nextInt(8) + 1 > i2;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            WorldServer worldserver = (WorldServer)EntityEvoker.this.level();
            ScoreboardTeam scoreboardteam = EntityEvoker.this.getTeam();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition = EntityEvoker.this.blockPosition().offset(-2 + EntityEvoker.this.random.nextInt(5), 1, -2 + EntityEvoker.this.random.nextInt(5));
                EntityVex entityvex = EntityTypes.VEX.create(EntityEvoker.this.level());
                if (entityvex == null) continue;
                entityvex.moveTo(blockposition, 0.0f, 0.0f);
                entityvex.finalizeSpawn(worldserver, EntityEvoker.this.level().getCurrentDifficultyAt(blockposition), EnumMobSpawn.MOB_SUMMONED, null);
                entityvex.setOwner(EntityEvoker.this);
                entityvex.setBoundOrigin(blockposition);
                entityvex.setLimitedLife(20 * (30 + EntityEvoker.this.random.nextInt(90)));
                if (scoreboardteam != null) {
                    worldserver.getScoreboard().addPlayerToTeam(entityvex.getScoreboardName(), scoreboardteam);
                }
                worldserver.addFreshEntityWithPassengers(entityvex, CreatureSpawnEvent.SpawnReason.SPELL);
                worldserver.gameEvent(GameEvent.ENTITY_PLACE, blockposition, GameEvent.a.of(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.SUMMON_VEX;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void performSpellCasting() {
            EntityLiving entityliving = EntityEvoker.this.getTarget();
            double d0 = Math.min(entityliving.getY(), EntityEvoker.this.getY());
            double d1 = Math.max(entityliving.getY(), EntityEvoker.this.getY()) + 1.0;
            float f2 = (float)MathHelper.atan2(entityliving.getZ() - EntityEvoker.this.getZ(), entityliving.getX() - EntityEvoker.this.getX());
            if (EntityEvoker.this.distanceToSqr(entityliving) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(f1) * 1.5, EntityEvoker.this.getZ() + (double)MathHelper.sin(f1) * 1.5, d0, d1, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(f1) * 2.5, EntityEvoker.this.getZ() + (double)MathHelper.sin(f1) * 2.5, d0, d1, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d2 = 1.25 * (double)(i3 + 1);
                    int j2 = 1 * i3;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(f2) * d2, EntityEvoker.this.getZ() + (double)MathHelper.sin(f2) * d2, d0, d1, f2, j2);
                }
            }
        }

        private void createSpellEntity(double d0, double d1, double d2, double d3, float f2, int i2) {
            BlockPosition blockposition = BlockPosition.containing(d0, d3, d1);
            boolean flag = false;
            double d4 = 0.0;
            do {
                IBlockData iblockdata1;
                VoxelShape voxelshape;
                BlockPosition blockposition1 = blockposition.below();
                IBlockData iblockdata = EntityEvoker.this.level().getBlockState(blockposition1);
                if (!iblockdata.isFaceSturdy(EntityEvoker.this.level(), blockposition1, EnumDirection.UP)) continue;
                if (!EntityEvoker.this.level().isEmptyBlock(blockposition) && !(voxelshape = (iblockdata1 = EntityEvoker.this.level().getBlockState(blockposition)).getCollisionShape(EntityEvoker.this.level(), blockposition)).isEmpty()) {
                    d4 = voxelshape.max(EnumDirection.EnumAxis.Y);
                }
                flag = true;
                break;
            } while ((blockposition = blockposition.below()).getY() >= MathHelper.floor(d2) - 1);
            if (flag) {
                EntityEvoker.this.level().addFreshEntity(new EntityEvokerFangs(EntityEvoker.this.level(), d0, (double)blockposition.getY() + d4, d1, f2, i2, EntityEvoker.this));
                EntityEvoker.this.level().gameEvent(GameEvent.ENTITY_PLACE, new Vec3D(d0, (double)blockposition.getY() + d4, d1), GameEvent.a.of(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_ATTACK;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.FANGS;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition wololoTargeting;

        public d() {
            super(EntityEvoker.this);
            this.wololoTargeting = PathfinderTargetCondition.forNonCombat().range(16.0).selector(entityliving -> ((EntitySheep)entityliving).getColor() == EnumColor.BLUE);
        }

        @Override
        public boolean canUse() {
            if (EntityEvoker.this.getTarget() != null) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EntityEvoker.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.level().getNearbyEntities(EntitySheep.class, this.wololoTargeting, EntityEvoker.this, EntityEvoker.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.setWololoTarget(list.get(EntityEvoker.this.random.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return EntityEvoker.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        @Override
        public void stop() {
            super.stop();
            EntityEvoker.this.setWololoTarget(null);
        }

        @Override
        protected void performSpellCasting() {
            EntitySheep entitysheep = EntityEvoker.this.getWololoTarget();
            if (entitysheep != null && entitysheep.isAlive()) {
                entitysheep.setColor(EnumColor.RED);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_WOLOLO;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.WOLOLO;
        }
    }
}

