/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class EntityIllagerWizard
extends EntityIllagerAbstract {
    private static final DataWatcherObject<Byte> DATA_SPELL_CASTING_ID = DataWatcher.defineId(EntityIllagerWizard.class, DataWatcherRegistry.BYTE);
    protected int spellCastingTickCount;
    private Spell currentSpell = Spell.NONE;

    protected EntityIllagerWizard(EntityTypes<? extends EntityIllagerWizard> entitytypes, World world) {
        super((EntityTypes<? extends EntityIllagerAbstract>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_SPELL_CASTING_ID, (byte)0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.spellCastingTickCount = nbttagcompound.getInt("SpellTicks");
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt("SpellTicks", this.spellCastingTickCount);
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        return this.isCastingSpell() ? EntityIllagerAbstract.a.SPELLCASTING : (this.isCelebrating() ? EntityIllagerAbstract.a.CELEBRATING : EntityIllagerAbstract.a.CROSSED);
    }

    public boolean isCastingSpell() {
        return this.level().isClientSide ? this.entityData.get(DATA_SPELL_CASTING_ID) > 0 : this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(Spell entityillagerwizard_spell) {
        this.currentSpell = entityillagerwizard_spell;
        this.entityData.set(DATA_SPELL_CASTING_ID, (byte)entityillagerwizard_spell.id);
    }

    public Spell getCurrentSpell() {
        return !this.level().isClientSide ? this.currentSpell : Spell.byId(this.entityData.get(DATA_SPELL_CASTING_ID).byteValue());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isCastingSpell()) {
            Spell entityillagerwizard_spell = this.getCurrentSpell();
            float f2 = (float)entityillagerwizard_spell.spellColor[0];
            float f1 = (float)entityillagerwizard_spell.spellColor[1];
            float f22 = (float)entityillagerwizard_spell.spellColor[2];
            float f3 = this.yBodyRot * ((float)Math.PI / 180) + MathHelper.cos((float)this.tickCount * 0.6662f) * 0.25f;
            float f4 = MathHelper.cos(f3);
            float f5 = MathHelper.sin(f3);
            double d0 = 0.6 * (double)this.getScale();
            double d1 = 1.8 * (double)this.getScale();
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, f2, f1, f22), this.getX() + (double)f4 * d0, this.getY() + d1, this.getZ() + (double)f5 * d0, 0.0, 0.0, 0.0);
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, f2, f1, f22), this.getX() - (double)f4 * d0, this.getY() + d1, this.getZ() - (double)f5 * d0, 0.0, 0.0, 0.0);
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract SoundEffect getCastingSoundEvent();

    public static enum Spell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private static final IntFunction<Spell> BY_ID;
        final int id;
        final double[] spellColor;

        private Spell(int i2, double d0, double d1, double d2) {
            this.id = i2;
            this.spellColor = new double[]{d0, d1, d2};
        }

        public static Spell byId(int i2) {
            return BY_ID.apply(i2);
        }

        static {
            BY_ID = ByIdMap.continuous(entityillagerwizard_spell -> entityillagerwizard_spell.id, Spell.values(), ByIdMap.a.ZERO);
        }
    }

    protected class b
    extends PathfinderGoal {
        public b() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityIllagerWizard.this.getSpellCastingTime() > 0;
        }

        @Override
        public void start() {
            super.start();
            EntityIllagerWizard.this.navigation.stop();
        }

        @Override
        public void stop() {
            super.stop();
            EntityIllagerWizard.this.setIsCastingSpell(Spell.NONE);
        }

        @Override
        public void tick() {
            if (EntityIllagerWizard.this.getTarget() != null) {
                EntityIllagerWizard.this.getLookControl().setLookAt(EntityIllagerWizard.this.getTarget(), EntityIllagerWizard.this.getMaxHeadYRot(), EntityIllagerWizard.this.getMaxHeadXRot());
            }
        }
    }

    protected abstract class PathfinderGoalCastSpell
    extends PathfinderGoal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected PathfinderGoalCastSpell() {
        }

        @Override
        public boolean canUse() {
            EntityLiving entityliving = EntityIllagerWizard.this.getTarget();
            return entityliving != null && entityliving.isAlive() ? (EntityIllagerWizard.this.isCastingSpell() ? false : EntityIllagerWizard.this.tickCount >= this.nextAttackTickCount) : false;
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving entityliving = EntityIllagerWizard.this.getTarget();
            return entityliving != null && entityliving.isAlive() && this.attackWarmupDelay > 0;
        }

        @Override
        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            EntityIllagerWizard.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = EntityIllagerWizard.this.tickCount + this.getCastingInterval();
            SoundEffect soundeffect = this.getSpellPrepareSound();
            if (soundeffect != null) {
                EntityIllagerWizard.this.playSound(soundeffect, 1.0f, 1.0f);
            }
            EntityIllagerWizard.this.setIsCastingSpell(this.getSpell());
        }

        @Override
        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                if (!CraftEventFactory.handleEntitySpellCastEvent(EntityIllagerWizard.this, this.getSpell())) {
                    return;
                }
                this.performSpellCasting();
                EntityIllagerWizard.this.playSound(EntityIllagerWizard.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEffect getSpellPrepareSound();

        protected abstract Spell getSpell();
    }
}

