/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final MinecraftKey SUFFOCATING_MODIFIER_ID = MinecraftKey.withDefaultNamespace("suffocating");
    private static final AttributeModifier SUFFOCATING_MODIFIER = new AttributeModifier(SUFFOCATING_MODIFIER_ID, -0.34f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float SUFFOCATE_STEERING_MODIFIER = 0.35f;
    private static final float STEERING_MODIFIER = 0.55f;
    private static final DataWatcherObject<Integer> DATA_BOOST_TIME = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_SUFFOCATING = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_SADDLE_ID = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.BOOLEAN);
    public final SaddleStorage steering;
    @Nullable
    private PathfinderGoalTempt temptGoal;

    public EntityStrider(EntityTypes<? extends EntityStrider> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.steering = new SaddleStorage(this.entityData, DATA_BOOST_TIME, DATA_SADDLE_ID);
        this.blocksBuilding = true;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean checkStriderSpawnRules(EntityTypes<EntityStrider> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        do {
            blockposition_mutableblockposition.move(EnumDirection.UP);
        } while (generatoraccess.getFluidState(blockposition_mutableblockposition).is(TagsFluid.LAVA));
        return generatoraccess.getBlockState(blockposition_mutableblockposition).isAir();
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_BOOST_TIME.equals(datawatcherobject) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_BOOST_TIME, 0);
        datawatcher_a.define(DATA_SUFFOCATING, false);
        datawatcher_a.define(DATA_SADDLE_ID, false);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        this.steering.addAdditionalSaveData(nbttagcompound);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.steering.readAdditionalSaveData(nbttagcompound);
    }

    @Override
    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void equipSaddle(ItemStack itemstack, @Nullable SoundCategory soundcategory) {
        this.steering.setSaddle(true);
        if (soundcategory != null) {
            this.level().playSound((EntityHuman)null, this, SoundEffects.STRIDER_SADDLE, soundcategory, 0.5f, 1.0f);
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.65));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.temptGoal = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.is(TagsItem.STRIDER_TEMPT_ITEMS), false);
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(4, new a(this, 1.0));
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void setSuffocating(boolean flag) {
        this.entityData.set(DATA_SUFFOCATING, flag);
        AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (attributemodifiable != null) {
            if (flag) {
                attributemodifiable.addOrUpdateTransientModifier(SUFFOCATING_MODIFIER);
            } else {
                attributemodifiable.removeModifier(SUFFOCATING_MODIFIER_ID);
            }
        }
    }

    public boolean isSuffocating() {
        return this.entityData.get(DATA_SUFFOCATING);
    }

    @Override
    public boolean canStandOnFluid(Fluid fluid) {
        return fluid.is(TagsFluid.LAVA);
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity entity, EntitySize entitysize, float f2) {
        float f1 = Math.min(0.25f, this.walkAnimation.speed());
        float f22 = this.walkAnimation.position();
        float f3 = 0.12f * MathHelper.cos(f22 * 1.5f) * 2.0f * f1;
        return super.getPassengerAttachmentPoint(entity, entitysize, f2).add(0.0, f3 * f2, 0.0);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader iworldreader) {
        return iworldreader.isUnobstructed(this);
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).isHolding(Items.WARPED_FUNGUS_ON_A_STICK)) {
            return entityhuman;
        }
        return super.getControllingPassenger();
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving entityliving) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot()), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() - 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() + 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() - 45.0f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.getBoundingBox().maxY;
        double d1 = this.getBoundingBox().minY - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.set(this.getX() + vec3d.x, d0, this.getZ() + vec3d.z);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.immutable());
                blockposition_mutableblockposition.move(EnumDirection.DOWN);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.level().getFluidState(blockposition).is(TagsFluid.LAVA) || !DismountUtil.isBlockFloorValid(d3 = this.level().getBlockFloorHeight(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.upFromBottomCenterOf(blockposition, d3);
            for (EntityPose entitypose : entityliving.getDismountPoses()) {
                AxisAlignedBB axisalignedbb = entityliving.getLocalBoundsForPose(entitypose);
                if (!DismountUtil.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d1))) continue;
                entityliving.setPose(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Override
    protected void tickRidden(EntityHuman entityhuman, Vec3D vec3d) {
        this.setRot(entityhuman.getYRot(), entityhuman.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
        super.tickRidden(entityhuman, vec3d);
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(EntityHuman entityhuman) {
        return (float)(this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)(this.isSuffocating() ? 0.35f : 0.55f) * (double)this.steering.boostFactor());
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        this.playSound(this.isInLava() ? SoundEffects.STRIDER_STEP_LAVA : SoundEffects.STRIDER_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        this.checkInsideBlocks();
        if (this.isInLava()) {
            this.resetFallDistance();
        } else {
            super.checkFallDamage(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void tick() {
        if (this.isBeingTempted() && this.random.nextInt(140) == 0) {
            this.makeSound(SoundEffects.STRIDER_HAPPY);
        } else if (this.isPanicking() && this.random.nextInt(60) == 0) {
            this.makeSound(SoundEffects.STRIDER_RETREAT);
        }
        if (!this.isNoAi()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.level().getBlockState(this.blockPosition());
            IBlockData iblockdata1 = this.getBlockStateOnLegacy();
            boolean flag = iblockdata.is(TagsBlock.STRIDER_WARM_BLOCKS) || iblockdata1.is(TagsBlock.STRIDER_WARM_BLOCKS) || this.getFluidHeight(TagsFluid.LAVA) > 0.0;
            Entity entity = this.getVehicle();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).isSuffocating();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.isSuffocating() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.setSuffocating(suffocating);
            }
        }
        super.tick();
        this.floatStrider();
        this.checkInsideBlocks();
    }

    private boolean isBeingTempted() {
        return this.temptGoal != null && this.temptGoal.isRunning();
    }

    @Override
    protected boolean shouldPassengersInheritMalus() {
        return true;
    }

    private void floatStrider() {
        if (this.isInLava()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.of(this);
            if (voxelshapecollision.isAbove(BlockFluids.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(TagsFluid.LAVA)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.175f).add(GenericAttributes.FOLLOW_RANGE, 16.0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return !this.isPanicking() && !this.isBeingTempted() ? SoundEffects.STRIDER_AMBIENT : null;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.STRIDER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.STRIDER_DEATH;
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return !this.isVehicle() && !this.isEyeInFluid(TagsFluid.LAVA);
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected NavigationAbstract createNavigation(World world) {
        return new b(this, world);
    }

    @Override
    public float getWalkTargetValue(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.getBlockState(blockposition).getFluidState().is(TagsFluid.LAVA) ? 10.0f : (this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Override
    @Nullable
    public EntityStrider getBreedOffspring(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.STRIDER.create(worldserver);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(TagsItem.STRIDER_FOOD);
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation(Items.SADDLE);
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.isFood(entityhuman.getItemInHand(enumhand));
        if (!flag && this.isSaddled() && !this.isVehicle() && !entityhuman.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                entityhuman.startRiding(this);
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        EnumInteractionResult enuminteractionresult = super.mobInteract(entityhuman, enumhand);
        if (!enuminteractionresult.consumesAction()) {
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            return itemstack.is(Items.SADDLE) ? itemstack.interactLivingEntity(entityhuman, this, enumhand) : EnumInteractionResult.PASS;
        }
        if (flag && !this.isSilent()) {
            this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.STRIDER_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        if (this.isBaby()) {
            return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
        }
        RandomSource randomsource = worldaccess.getRandom();
        if (randomsource.nextInt(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.ZOMBIFIED_PIGLIN.create(worldaccess.getLevel());
            if (entityinsentient != null) {
                groupdataentity = this.spawnJockey(worldaccess, difficultydamagescaler, entityinsentient, new EntityZombie.GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(randomsource), false));
                entityinsentient.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.WARPED_FUNGUS_ON_A_STICK));
                this.equipSaddle(new ItemStack(Items.SADDLE), null);
            }
        } else if (randomsource.nextInt(10) == 0) {
            EntityAgeable entityageable = EntityTypes.STRIDER.create(worldaccess.getLevel());
            if (entityageable != null) {
                entityageable.setAge(-24000);
                groupdataentity = this.spawnJockey(worldaccess, difficultydamagescaler, entityageable, null);
            }
        } else {
            groupdataentity = new EntityAgeable.a(0.5f);
        }
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    private GroupDataEntity spawnJockey(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntityInsentient entityinsentient, @Nullable GroupDataEntity groupdataentity) {
        entityinsentient.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        entityinsentient.finalizeSpawn(worldaccess, difficultydamagescaler, EnumMobSpawn.JOCKEY, groupdataentity);
        entityinsentient.startRiding(this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider strider;

        a(EntityStrider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.strider = entitystrider;
        }

        @Override
        public BlockPosition getMoveToTarget() {
            return this.blockPos;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.strider.isInLava() && this.isValidTarget(this.strider.level(), this.blockPos);
        }

        @Override
        public boolean canUse() {
            return !this.strider.isInLava() && super.canUse();
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader iworldreader, BlockPosition blockposition) {
            return iworldreader.getBlockState(blockposition).is(Blocks.LAVA) && iworldreader.getBlockState(blockposition.above()).isPathfindable(PathMode.LAND);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entitystrider, World world) {
            super(entitystrider, world);
        }

        @Override
        protected Pathfinder createPathFinder(int i2) {
            this.nodeEvaluator = new PathfinderNormal();
            this.nodeEvaluator.setCanPassDoors(true);
            return new Pathfinder(this.nodeEvaluator, i2);
        }

        @Override
        protected boolean hasValidPathType(PathType pathtype) {
            return pathtype != PathType.LAVA && pathtype != PathType.DAMAGE_FIRE && pathtype != PathType.DANGER_FIRE ? super.hasValidPathType(pathtype) : true;
        }

        @Override
        public boolean isStableDestination(BlockPosition blockposition) {
            return this.level.getBlockState(blockposition).is(Blocks.LAVA) || super.isStableDestination(blockposition);
        }
    }
}

