/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityZoglin
extends EntityMonster
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityZoglin.class, DataWatcherRegistry.BOOLEAN);
    private static final int MAX_HEALTH = 40;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final float BABY_ATTACK_DAMAGE = 0.5f;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int ATTACK_DURATION = 200;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private int attackAnimationRemainingTicks;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityZoglin>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN);

    public EntityZoglin(EntityTypes<? extends EntityZoglin> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.xpReward = 5;
    }

    protected BehaviorController.b<EntityZoglin> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        BehaviorController<EntityZoglin> var1 = this.brainProvider().makeBrain(var0);
        EntityZoglin.initCoreActivity(var1);
        EntityZoglin.initIdleActivity(var1);
        EntityZoglin.initFightActivity(var1);
        var1.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var1.setDefaultActivity(Activity.IDLE);
        var1.useDefaultActivity();
        return var1;
    }

    private static void initCoreActivity(BehaviorController<EntityZoglin> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    private static void initIdleActivity(BehaviorController<EntityZoglin> var0) {
        var0.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorAttackTargetSet.create(EntityZoglin::findNearestValidAttackTarget), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.4f), (Object)2), (Object)Pair.of(BehaviorLookWalk.create(0.4f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))));
    }

    private static void initFightActivity(BehaviorController<EntityZoglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorWalkAwayOutOfRange.create(1.0f), BehaviorBuilder.triggerIf(EntityZoglin::isAdult, BehaviorAttack.create(40)), BehaviorBuilder.triggerIf(EntityZoglin::isBaby, BehaviorAttack.create(15)), BehaviorAttackTargetForget.create()), MemoryModuleType.ATTACK_TARGET);
    }

    private Optional<? extends EntityLiving> findNearestValidAttackTarget() {
        return this.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty()).findClosest(this::isTargetable);
    }

    private boolean isTargetable(EntityLiving var0) {
        EntityTypes<?> var1 = var0.getType();
        return var1 != EntityTypes.ZOGLIN && var1 != EntityTypes.CREEPER && Sensor.isEntityAttackable(this, var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BABY_ID, false);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 40.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.KNOCKBACK_RESISTANCE, 0.6f).add(GenericAttributes.ATTACK_KNOCKBACK, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 6.0);
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        if (!(var0 instanceof EntityLiving)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.level().broadcastEntityEvent(this, (byte)4);
        this.makeSound(SoundEffects.ZOGLIN_ATTACK);
        return IOglin.hurtAndThrowTarget(this, (EntityLiving)var0);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected void blockedByShield(EntityLiving var0) {
        if (!this.isBaby()) {
            IOglin.throwTarget(this, var0);
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2 = super.hurt(var0, var1);
        if (this.level().isClientSide) {
            return false;
        }
        if (!var2 || !(var0.getEntity() instanceof EntityLiving)) {
            return var2;
        }
        EntityLiving var3 = (EntityLiving)var0.getEntity();
        if (this.canAttack(var3) && !BehaviorUtil.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(this, var3, 4.0)) {
            this.setAttackTarget(var3);
        }
        return var2;
    }

    private void setAttackTarget(EntityLiving var0) {
        this.brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        this.brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, var0, 200L);
    }

    public BehaviorController<EntityZoglin> getBrain() {
        return super.getBrain();
    }

    protected void updateActivity() {
        Activity var0 = this.brain.getActiveNonCoreActivity().orElse(null);
        this.brain.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        Activity var1 = this.brain.getActiveNonCoreActivity().orElse(null);
        if (var1 == Activity.FIGHT && var0 != Activity.FIGHT) {
            this.playAngrySound();
        }
        this.setAggressive(this.brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("zoglinBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        this.level().getProfiler().pop();
        this.updateActivity();
    }

    @Override
    public void setBaby(boolean var0) {
        this.getEntityData().set(DATA_BABY_ID, var0);
        if (!this.level().isClientSide && var0) {
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(0.5);
        }
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    @Override
    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.makeSound(SoundEffects.ZOGLIN_ATTACK);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.level().isClientSide) {
            return null;
        }
        if (this.brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return SoundEffects.ZOGLIN_ANGRY;
        }
        return SoundEffects.ZOGLIN_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOGLIN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOGLIN_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.ZOGLIN_STEP, 0.15f, 1.0f);
    }

    protected void playAngrySound() {
        this.makeSound(SoundEffects.ZOGLIN_ANGRY);
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.isBaby()) {
            var0.putBoolean("IsBaby", true);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.getBoolean("IsBaby")) {
            this.setBaby(true);
        }
    }
}

