/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey SPEED_MODIFIER_BABY_ID = MinecraftKey.withDefaultNamespace("baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final MinecraftKey REINFORCEMENT_CALLER_CHARGE_ID = MinecraftKey.withDefaultNamespace("reinforcement_caller_charge");
    private static final AttributeModifier ZOMBIE_REINFORCEMENT_CALLEE_CHARGE = new AttributeModifier(MinecraftKey.withDefaultNamespace("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.ADD_VALUE);
    private static final MinecraftKey LEADER_ZOMBIE_BONUS_ID = MinecraftKey.withDefaultNamespace("leader_zombie_bonus");
    private static final MinecraftKey ZOMBIE_RANDOM_SPAWN_BONUS_ID = MinecraftKey.withDefaultNamespace("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_SPECIAL_TYPE_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.INT);
    public static final DataWatcherObject<Boolean> DATA_DROWNED_CONVERSION_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ZOMBIE.getDimensions().scale(0.5f).withEyeHeight(0.93f);
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private static final Predicate<EnumDifficulty> DOOR_BREAKING_PREDICATE = enumdifficulty -> enumdifficulty == EnumDifficulty.HARD;
    private final PathfinderGoalBreakDoor breakDoorGoal;
    private boolean canBreakDoors;
    private int inWaterTime;
    public int conversionTime;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.breakDoorGoal = new PathfinderGoalBreakDoor(this, DOOR_BREAKING_PREDICATE);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.ZOMBIE, world);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(4, new a((EntityCreature)this, 1.0, 3));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.goalSelector.addGoal(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(EntityPigZombie.class));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.level().spigotConfig.zombieAggressiveTowardsVillager) {
            this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.FOLLOW_RANGE, 35.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f).add(GenericAttributes.ATTACK_DAMAGE, 3.0).add(GenericAttributes.ARMOR, 2.0).add(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_BABY_ID, false);
        datawatcher_a.define(DATA_SPECIAL_TYPE_ID, 0);
        datawatcher_a.define(DATA_DROWNED_CONVERSION_ID, false);
    }

    public boolean isUnderWaterConverting() {
        return this.getEntityData().get(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean flag) {
        if (this.supportsBreakDoorGoal() && PathfinderGoalUtil.hasGroundPathNavigation(this)) {
            if (this.canBreakDoors != flag) {
                this.canBreakDoors = flag;
                ((Navigation)this.getNavigation()).setCanOpenDoors(flag);
                if (flag) {
                    this.goalSelector.addGoal(1, this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal(this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal(this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    @Override
    protected int getBaseExperienceReward() {
        if (this.isBaby()) {
            this.xpReward = (int)((double)this.xpReward * 2.5);
        }
        return super.getBaseExperienceReward();
    }

    @Override
    public void setBaby(boolean flag) {
        this.getEntityData().set(DATA_BABY_ID, flag);
        if (this.level() != null && !this.level().isClientSide) {
            AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            attributemodifiable.removeModifier(SPEED_MODIFIER_BABY_ID);
            if (flag) {
                attributemodifiable.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_BABY_ID.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi()) {
            if (this.isUnderWaterConverting()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.conversionTime -= elapsedTicks;
                if (this.conversionTime < 0) {
                    this.doUnderWaterConversion();
                }
            } else if (this.convertsInWater()) {
                if (this.isEyeInFluid(TagsFluid.WATER)) {
                    ++this.inWaterTime;
                    if (this.inWaterTime >= 600) {
                        this.startUnderWaterConversion(300);
                    }
                } else {
                    this.inWaterTime = -1;
                }
            }
        }
        super.tick();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void aiStep() {
        if (this.isAlive()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.isSunBurnTick();
            if (flag) {
                ItemStack itemstack = this.getItemBySlot(EnumItemSlot.HEAD);
                if (!itemstack.isEmpty()) {
                    if (itemstack.isDamageableItem()) {
                        Item item = itemstack.getItem();
                        itemstack.setDamageValue(itemstack.getDamageValue() + this.random.nextInt(2));
                        if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                            this.onEquippedItemBroken(item, EnumItemSlot.HEAD);
                            this.setItemSlot(EnumItemSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.igniteForSeconds(8.0f);
                }
            }
        }
        super.aiStep();
    }

    public void startUnderWaterConversion(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.conversionTime = i2;
        this.getEntityData().set(DATA_DROWNED_CONVERSION_ID, true);
    }

    protected void doUnderWaterConversion() {
        this.convertToZombieType(EntityTypes.DROWNED);
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1040, this.blockPosition(), 0);
        }
    }

    protected void convertToZombieType(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie entityzombie = this.convertTo(entitytypes, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.handleAttributes(entityzombie.level().getCurrentDifficultyAt(entityzombie.blockPosition()).getSpecialMultiplier());
            entityzombie.setCanBreakDoors(entityzombie.supportsBreakDoorGoal() && this.canBreakDoors());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (!super.hurt(damagesource, f2)) {
            return false;
        }
        if (!(this.level() instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.level();
        EntityLiving entityliving = this.getTarget();
        if (entityliving == null && damagesource.getEntity() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.getEntity();
        }
        if (entityliving != null && this.level().getDifficulty() == EnumDifficulty.HARD && (double)this.random.nextFloat() < this.getAttributeValue(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE) && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            int i2 = MathHelper.floor(this.getX());
            int j2 = MathHelper.floor(this.getY());
            int k2 = MathHelper.floor(this.getZ());
            EntityZombie entityzombie = new EntityZombie(this.level());
            for (int l2 = 0; l2 < 50; ++l2) {
                int i1 = i2 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                int j1 = j2 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                int k1 = k2 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.getType();
                if (!EntityPositionTypes.isSpawnPositionOk(entitytypes, this.level(), blockposition) || !EntityPositionTypes.checkSpawnRules(entitytypes, worldserver, EnumMobSpawn.REINFORCEMENT, blockposition, this.level().random)) continue;
                entityzombie.setPos(i1, j1, k1);
                if (this.level().hasNearbyAlivePlayer(i1, j1, k1, 7.0) || !this.level().isUnobstructed(entityzombie) || !this.level().noCollision(entityzombie) || this.level().containsAnyLiquid(entityzombie.getBoundingBox())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.finalizeSpawn(worldserver, this.level().getCurrentDifficultyAt(entityzombie.blockPosition()), EnumMobSpawn.REINFORCEMENT, null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE);
                AttributeModifier attributemodifier = attributemodifiable.getModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                double d0 = attributemodifier != null ? attributemodifier.amount() : 0.0;
                attributemodifiable.removeModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                attributemodifiable.addPermanentModifier(new AttributeModifier(REINFORCEMENT_CALLER_CHARGE_ID, d0 - 0.05, AttributeModifier.Operation.ADD_VALUE));
                entityzombie.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(ZOMBIE_REINFORCEMENT_CALLEE_CHARGE);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag) {
            float f2 = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.ZOMBIE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_DEATH;
    }

    protected SoundEffect getStepSound() {
        return SoundEffects.ZOMBIE_STEP;
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.populateDefaultEquipmentSlots(randomsource, difficultydamagescaler);
        float f2 = randomsource.nextFloat();
        float f3 = this.level().getDifficulty() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.nextInt(3);
            if (i2 == 0) {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
            } else {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SHOVEL));
            }
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putBoolean("IsBaby", this.isBaby());
        nbttagcompound.putBoolean("CanBreakDoors", this.canBreakDoors());
        nbttagcompound.putInt("InWaterTime", this.isInWater() ? this.inWaterTime : -1);
        nbttagcompound.putInt("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setBaby(nbttagcompound.getBoolean("IsBaby"));
        this.setCanBreakDoors(nbttagcompound.getBoolean("CanBreakDoors"));
        this.inWaterTime = nbttagcompound.getInt("InWaterTime");
        if (nbttagcompound.contains("DrownedConversionTime", 99) && nbttagcompound.getInt("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(nbttagcompound.getInt("DrownedConversionTime"));
        }
    }

    @Override
    public boolean killedEntity(WorldServer worldserver, EntityLiving entityliving) {
        boolean flag = super.killedEntity(worldserver, entityliving);
        if ((worldserver.getDifficulty() == EnumDifficulty.NORMAL || worldserver.getDifficulty() == EnumDifficulty.HARD) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.getDifficulty() != EnumDifficulty.HARD && this.random.nextBoolean()) {
                return flag;
            }
            flag = EntityZombie.zombifyVillager(worldserver, entityvillager, this.blockPosition(), this.isSilent(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.ZOMBIE_VILLAGER, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entityzombievillager.blockPosition()), EnumMobSpawn.CONVERSION, new GroupDataZombie(false, true));
            entityzombievillager.setVillagerData(entityvillager.getVillagerData());
            entityzombievillager.setGossips(entityvillager.getGossips().store(DynamicOpsNBT.INSTANCE));
            entityzombievillager.setTradeOffers(entityvillager.getOffers().copy());
            entityzombievillager.setVillagerXp(entityvillager.getVillagerXp());
            if (!silent) {
                worldserver.levelEvent(null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(entitypose);
    }

    @Override
    public boolean canHoldItem(ItemStack itemstack) {
        return itemstack.is(Items.EGG) && this.isBaby() && this.isPassenger() ? false : super.canHoldItem(itemstack);
    }

    @Override
    public boolean wantsToPickUp(ItemStack itemstack) {
        return itemstack.is(Items.GLOW_INK_SAC) ? false : super.wantsToPickUp(itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        GroupDataEntity object = super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
        float f2 = difficultydamagescaler.getSpecialMultiplier();
        this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.isBaby) {
                this.setBaby(true);
                if (entityzombie_groupdatazombie.canSpawnJockey) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.nextFloat() < 0.05) {
                        List<Entity> list = worldaccess.getEntitiesOfClass(EntityChicken.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), IEntitySelector.ENTITY_NOT_BEING_RIDDEN);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.setChickenJockey(true);
                            this.startRiding(entitychicken);
                        }
                    } else if ((double)randomsource.nextFloat() < 0.05 && (entitychicken1 = EntityTypes.CHICKEN.create(this.level())) != null) {
                        entitychicken1.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                        entitychicken1.finalizeSpawn(worldaccess, difficultydamagescaler, EnumMobSpawn.JOCKEY, null);
                        entitychicken1.setChickenJockey(true);
                        this.startRiding(entitychicken1);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.setCanBreakDoors(this.supportsBreakDoorGoal() && randomsource.nextFloat() < f2 * 0.1f);
            this.populateDefaultEquipmentSlots(randomsource, difficultydamagescaler);
            this.populateDefaultEquipmentEnchantments(worldaccess, randomsource, difficultydamagescaler);
        }
        if (this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.nextFloat() < 0.25f) {
                this.setItemSlot(EnumItemSlot.HEAD, new ItemStack(randomsource.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN));
                this.armorDropChances[EnumItemSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        this.handleAttributes(f2);
        return object;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource randomsource) {
        return randomsource.nextFloat() < 0.05f;
    }

    protected void handleAttributes(float f2) {
        this.randomizeReinforcementsChance();
        this.getAttribute(GenericAttributes.KNOCKBACK_RESISTANCE).addOrReplacePermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, this.random.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADD_VALUE));
        double d0 = this.random.nextDouble() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.getAttribute(GenericAttributes.FOLLOW_RANGE).addOrReplacePermanentModifier(new AttributeModifier(ZOMBIE_RANDOM_SPAWN_BONUS_ID, d0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (this.random.nextFloat() < f2 * 0.05f) {
            this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADD_VALUE));
            this.getAttribute(GenericAttributes.MAX_HEALTH).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            this.setCanBreakDoors(this.supportsBreakDoorGoal());
        }
    }

    protected void randomizeReinforcementsChance() {
        this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).setBaseValue(this.random.nextDouble() * (double)0.1f);
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.dropCustomDeathLoot(worldserver, damagesource, flag);
        Entity entity = damagesource.getEntity();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).canDropMobsSkull() && !(itemstack = this.getSkull()).isEmpty()) {
            entitycreeper.increaseDroppedSkulls();
            this.spawnAtLocation(itemstack);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack(Items.ZOMBIE_HEAD);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.TURTLE_EGG, entitycreature, d0, i2);
        }

        @Override
        public void playDestroyProgressSound(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.playSound(null, blockposition, SoundEffects.ZOMBIE_DESTROY_EGG, SoundCategory.HOSTILE, 0.5f, 0.9f + EntityZombie.this.random.nextFloat() * 0.2f);
        }

        @Override
        public void playBreakSound(World world, BlockPosition blockposition) {
            world.playSound((EntityHuman)null, blockposition, SoundEffects.TURTLE_EGG_BREAK, SoundCategory.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        }

        @Override
        public double acceptedDistance() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.isBaby = flag;
            this.canSpawnJockey = flag1;
        }
    }
}

