/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public interface InventoryCarrier {
    public static final String TAG_INVENTORY = "Inventory";

    public InventorySubcontainer getInventory();

    public static void pickUpItem(EntityInsentient entityinsentient, InventoryCarrier inventorycarrier, EntityItem entityitem) {
        ItemStack itemstack = entityitem.getItem();
        if (entityinsentient.wantsToPickUp(itemstack)) {
            InventorySubcontainer inventorysubcontainer = inventorycarrier.getInventory();
            boolean flag = inventorysubcontainer.canAddItem(itemstack);
            if (!flag) {
                return;
            }
            ItemStack remaining = new InventorySubcontainer(inventorysubcontainer).addItem(itemstack);
            if (CraftEventFactory.callEntityPickupItemEvent(entityinsentient, entityitem, remaining.getCount(), false).isCancelled()) {
                return;
            }
            entityinsentient.onItemPickup(entityitem);
            int i2 = itemstack.getCount();
            ItemStack itemstack1 = inventorysubcontainer.addItem(itemstack);
            entityinsentient.take(entityitem, i2 - itemstack1.getCount());
            if (itemstack1.isEmpty()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                itemstack.setCount(itemstack1.getCount());
            }
        }
    }

    default public void readInventoryFromTag(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        if (nbttagcompound.contains(TAG_INVENTORY, 9)) {
            this.getInventory().fromTag(nbttagcompound.getList(TAG_INVENTORY, 10), holderlookup_a);
        }
    }

    default public void writeInventoryToTag(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        nbttagcompound.put(TAG_INVENTORY, this.getInventory().createTag(holderlookup_a));
    }
}

