/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.IWorldDataServer;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobSpawnerTrader
implements MobSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final IWorldDataServer serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public MobSpawnerTrader(IWorldDataServer iworlddataserver) {
        this.serverLevelData = iworlddataserver;
        this.tickDelay = 1200;
        this.spawnDelay = iworlddataserver.getWanderingTraderSpawnDelay();
        this.spawnChance = iworlddataserver.getWanderingTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            iworlddataserver.setWanderingTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            iworlddataserver.setWanderingTraderSpawnChance(this.spawnChance);
        }
    }

    @Override
    public int tick(WorldServer worldserver, boolean flag, boolean flag1) {
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.serverLevelData.setWanderingTraderSpawnDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        int i2 = this.spawnChance;
        this.spawnChance = MathHelper.clamp(this.spawnChance + 25, 25, 75);
        this.serverLevelData.setWanderingTraderSpawnChance(this.spawnChance);
        if (this.random.nextInt(100) > i2) {
            return 0;
        }
        if (this.spawn(worldserver)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawn(WorldServer worldserver) {
        EntityPlayer entityplayer = worldserver.getRandomPlayer();
        if (entityplayer == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPosition blockposition = entityplayer.blockPosition();
        boolean flag = true;
        VillagePlace villageplace = worldserver.getPoiManager();
        Optional<BlockPosition> optional = villageplace.find(holder -> holder.is(PoiTypes.MEETING), blockposition1 -> true, blockposition, 48, VillagePlace.Occupancy.ANY);
        BlockPosition blockposition12 = optional.orElse(blockposition);
        BlockPosition blockposition2 = this.findSpawnPositionNear(worldserver, blockposition12, 48);
        if (blockposition2 != null && this.hasEnoughSpace(worldserver, blockposition2)) {
            if (worldserver.getBiome(blockposition2).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            EntityVillagerTrader entityvillagertrader = EntityTypes.WANDERING_TRADER.spawn(worldserver, blockposition2, EnumMobSpawn.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL);
            if (entityvillagertrader != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.tryToSpawnLlamaFor(worldserver, entityvillagertrader, 4);
                }
                this.serverLevelData.setWanderingTraderId(entityvillagertrader.getUUID());
                entityvillagertrader.setWanderTarget(blockposition12);
                entityvillagertrader.restrictTo(blockposition12, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(WorldServer worldserver, EntityVillagerTrader entityvillagertrader, int i2) {
        EntityLlamaTrader entityllamatrader;
        BlockPosition blockposition = this.findSpawnPositionNear(worldserver, entityvillagertrader.blockPosition(), i2);
        if (blockposition != null && (entityllamatrader = EntityTypes.TRADER_LLAMA.spawn(worldserver, blockposition, EnumMobSpawn.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL)) != null) {
            entityllamatrader.setLeashedTo(entityvillagertrader, true);
        }
    }

    @Nullable
    private BlockPosition findSpawnPositionNear(IWorldReader iworldreader, BlockPosition blockposition, int i2) {
        BlockPosition blockposition1 = null;
        SpawnPlacementType spawnplacementtype = EntityPositionTypes.getPlacementType(EntityTypes.WANDERING_TRADER);
        for (int j2 = 0; j2 < 10; ++j2) {
            int l2;
            int i1;
            int k2 = blockposition.getX() + this.random.nextInt(i2 * 2) - i2;
            BlockPosition blockposition2 = new BlockPosition(k2, i1 = iworldreader.getHeight(HeightMap.Type.WORLD_SURFACE, k2, l2 = blockposition.getZ() + this.random.nextInt(i2 * 2) - i2), l2);
            if (!spawnplacementtype.isSpawnPositionOk(iworldreader, blockposition2, EntityTypes.WANDERING_TRADER)) continue;
            blockposition1 = blockposition2;
            break;
        }
        return blockposition1;
    }

    private boolean hasEnoughSpace(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1;
        Iterator<BlockPosition> iterator = BlockPosition.betweenClosed(blockposition, blockposition.offset(1, 2, 1)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (iblockaccess.getBlockState(blockposition1 = iterator.next()).getCollisionShape(iblockaccess, blockposition1).isEmpty());
        return false;
    }
}

