/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EnumMainHand DEFAULT_MAIN_HAND = EnumMainHand.RIGHT;
    public static final int DEFAULT_MODEL_CUSTOMIZATION = 0;
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    public static final float CROUCH_BB_HEIGHT = 1.5f;
    public static final float SWIMMING_BB_WIDTH = 0.6f;
    public static final float SWIMMING_BB_HEIGHT = 0.6f;
    public static final float DEFAULT_EYE_HEIGHT = 1.62f;
    private static final int CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 40;
    public static final Vec3D DEFAULT_VEHICLE_ATTACHMENT = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize STANDING_DIMENSIONS = EntitySize.scalable(0.6f, 1.8f).withEyeHeight(1.62f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT));
    private static final Map<EntityPose, EntitySize> POSES = ImmutableMap.builder().put((Object)EntityPose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)EntityPose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)EntityPose.FALL_FLYING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SWIMMING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SPIN_ATTACK, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.CROUCHING, (Object)EntitySize.scalable(0.6f, 1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT))).put((Object)EntityPose.DYING, (Object)EntitySize.fixed(0.2f, 0.2f).withEyeHeight(1.62f)).build();
    private static final DataWatcherObject<Float> DATA_PLAYER_ABSORPTION_ID = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_SCORE_ID = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Byte> DATA_PLAYER_MODE_CUSTOMISATION = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<Byte> DATA_PLAYER_MAIN_HAND = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<NBTTagCompound> DATA_SHOULDER_LEFT = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.COMPOUND_TAG);
    protected static final DataWatcherObject<NBTTagCompound> DATA_SHOULDER_RIGHT = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.COMPOUND_TAG);
    private long timeEntitySatOnShoulder;
    final PlayerInventory inventory = new PlayerInventory(this);
    protected InventoryEnderChest enderChestInventory = new InventoryEnderChest(this);
    public final ContainerPlayer inventoryMenu;
    public Container containerMenu;
    protected FoodMetaData foodData = new FoodMetaData(this);
    protected int jumpTriggerTime;
    public float oBob;
    public float bob;
    public int takeXpDelay;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public int sleepCounter;
    protected boolean wasUnderwater;
    private final PlayerAbilities abilities = new PlayerAbilities();
    public int experienceLevel;
    public int totalExperience;
    public float experienceProgress;
    public int enchantmentSeed;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    private final GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private net.minecraft.world.item.ItemStack lastItemInMainHand = net.minecraft.world.item.ItemStack.EMPTY;
    private final ItemCooldown cooldowns = this.createItemCooldowns();
    private Optional<GlobalPos> lastDeathLocation = Optional.empty();
    @Nullable
    public EntityFishingHook fishing;
    protected float hurtDir;
    @Nullable
    public Vec3D currentImpulseImpactPos;
    @Nullable
    public Entity currentExplosionCause;
    private boolean ignoreFallDamageFromCurrentImpulse;
    private int currentImpulseContextResetGraceTime;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition blockposition, float f2, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.PLAYER, world);
        this.setUUID(gameprofile.getId());
        this.gameProfile = gameprofile;
        this.inventoryMenu = new ContainerPlayer(this.inventory, !world.isClientSide, this);
        this.containerMenu = this.inventoryMenu;
        this.moveTo((double)blockposition.getX() + 0.5, blockposition.getY() + 1, (double)blockposition.getZ() + 0.5, f2, 0.0f);
        this.rotOffs = 180.0f;
    }

    public boolean blockActionRestricted(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.isBlockPlacingRestricted()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.getMainHandItem();
        return itemstack.isEmpty() || !itemstack.canBreakBlockInAdventureMode(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityLiving.createLivingAttributes().add(GenericAttributes.ATTACK_DAMAGE, 1.0).add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.ATTACK_SPEED).add(GenericAttributes.LUCK).add(GenericAttributes.BLOCK_INTERACTION_RANGE, 4.5).add(GenericAttributes.ENTITY_INTERACTION_RANGE, 3.0).add(GenericAttributes.BLOCK_BREAK_SPEED).add(GenericAttributes.SUBMERGED_MINING_SPEED).add(GenericAttributes.SNEAKING_SPEED).add(GenericAttributes.MINING_EFFICIENCY).add(GenericAttributes.SWEEPING_DAMAGE_RATIO);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        datawatcher_a.define(DATA_SCORE_ID, 0);
        datawatcher_a.define(DATA_PLAYER_MODE_CUSTOMISATION, (byte)0);
        datawatcher_a.define(DATA_PLAYER_MAIN_HAND, (byte)DEFAULT_MAIN_HAND.getId());
        datawatcher_a.define(DATA_SHOULDER_LEFT, new NBTTagCompound());
        datawatcher_a.define(DATA_SHOULDER_RIGHT, new NBTTagCompound());
    }

    @Override
    public void tick() {
        this.noPhysics = this.isSpectator();
        if (this.isSpectator()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide && this.level().isDay()) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        if (!this.level().isClientSide && this.containerMenu != null && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        this.moveCloak();
        if (!this.level().isClientSide) {
            this.foodData.tick(this);
            this.awardStat(StatisticList.PLAY_TIME);
            this.awardStat(StatisticList.TOTAL_WORLD_TIME);
            if (this.isAlive()) {
                this.awardStat(StatisticList.TIME_SINCE_DEATH);
            }
            if (this.isDiscrete()) {
                this.awardStat(StatisticList.CROUCH_TIME);
            }
            if (!this.isSleeping()) {
                this.awardStat(StatisticList.TIME_SINCE_REST);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.getX() || d1 != this.getZ()) {
            this.setPos(d0, this.getY(), d1);
        }
        ++this.attackStrengthTicker;
        net.minecraft.world.item.ItemStack itemstack = this.getMainHandItem();
        if (!net.minecraft.world.item.ItemStack.matches(this.lastItemInMainHand, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.isSameItem(this.lastItemInMainHand, itemstack)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = itemstack.copy();
        }
        this.turtleHelmetTick();
        this.cooldowns.tick();
        this.updatePlayerPose();
        if (this.currentImpulseContextResetGraceTime > 0) {
            --this.currentImpulseContextResetGraceTime;
        }
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        return this.isBlocking() ? 15.0f : super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(TagsFluid.WATER);
        return this.wasUnderwater;
    }

    private void turtleHelmetTick() {
        net.minecraft.world.item.ItemStack itemstack = this.getItemBySlot(EnumItemSlot.HEAD);
        if (itemstack.is(Items.TURTLE_HELMET) && !this.isEyeInFluid(TagsFluid.WATER)) {
            this.addEffect(new MobEffect(MobEffects.WATER_BREATHING, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown createItemCooldowns() {
        return new ItemCooldown();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.getX() - this.xCloak;
        double d1 = this.getY() - this.yCloak;
        double d2 = this.getZ() - this.zCloak;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 > 10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 > 10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if (d0 < -10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 < -10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 < -10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    protected void updatePlayerPose() {
        if (this.canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose.SWIMMING)) {
            EntityPose entitypose = this.isFallFlying() ? EntityPose.FALL_FLYING : (this.isSleeping() ? EntityPose.SLEEPING : (this.isSwimming() ? EntityPose.SWIMMING : (this.isAutoSpinAttack() ? EntityPose.SPIN_ATTACK : (this.isShiftKeyDown() && !this.abilities.flying ? EntityPose.CROUCHING : EntityPose.STANDING))));
            EntityPose entitypose1 = !(this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(entitypose)) ? (this.canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose.CROUCHING) ? EntityPose.CROUCHING : EntityPose.SWIMMING) : entitypose;
            this.setPose(entitypose1);
        }
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose entitypose) {
        return this.level().noCollision(this, this.getDimensions(entitypose).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.PLAYER_SWIM;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.PLAYER_SPLASH;
    }

    @Override
    protected SoundEffect getSwimHighSpeedSplashSound() {
        return SoundEffects.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEffect soundeffect, float f2, float f1) {
        this.level().playSound(this, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), f2, f1);
    }

    public void playNotifySound(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.PLAYERS;
    }

    @Override
    public int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 9) {
            this.completeUsingItem();
        } else if (b0 == 23) {
            this.reducedDebugInfo = false;
        } else if (b0 == 22) {
            this.reducedDebugInfo = true;
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            if (!this.isPassenger()) {
                this.setShiftKeyDown(false);
                return;
            }
        }
        super.rideTick();
        this.oBob = this.bob;
        this.bob = 0.0f;
    }

    @Override
    protected void serverAiStep() {
        super.serverAiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
    }

    @Override
    public void aiStep() {
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.getHealth() < this.getMaxHealth() && this.tickCount % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.foodData.getSaturationLevel() < 20.0f && this.tickCount % 20 == 0) {
                this.foodData.setSaturation(this.foodData.getSaturationLevel() + 1.0f);
            }
            if (this.foodData.needsFood() && this.tickCount % 10 == 0) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
        this.inventory.tick();
        this.oBob = this.bob;
        super.aiStep();
        this.setSpeed((float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
        float f2 = this.onGround() && !this.isDeadOrDying() && !this.isSwimming() ? Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance()) : 0.0f;
        this.bob += (f2 - this.bob) * 0.4f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AxisAlignedBB axisalignedbb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List<Entity> list = this.level().getEntities(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.getType() == EntityTypes.EXPERIENCE_ORB) {
                    list1.add(entity);
                    continue;
                }
                if (entity.isRemoved()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)SystemUtils.getRandom(list1, this.random));
            }
        }
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (!this.level().isClientSide && (this.fallDistance > 0.5f || this.isInWater()) || this.abilities.flying || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    private void playShoulderEntityAmbientSound(@Nullable NBTTagCompound nbttagcompound) {
        if (!(nbttagcompound == null || nbttagcompound.contains("Silent") && nbttagcompound.getBoolean("Silent") || this.level().random.nextInt(200) != 0)) {
            String s2 = nbttagcompound.getString("id");
            EntityTypes.byString(s2).filter(entitytypes -> entitytypes == EntityTypes.PARROT).ifPresent(entitytypes -> {
                if (!EntityParrot.imitateNearbyMobs(this.level(), this)) {
                    this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), EntityParrot.getAmbient(this.level(), this.level().random), this.getSoundSource(), 1.0f, EntityParrot.getPitch(this.level().random));
                }
            });
        }
    }

    private void touch(Entity entity) {
        entity.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int i2) {
        this.entityData.set(DATA_SCORE_ID, i2);
    }

    public void increaseScore(int i2) {
        int j2 = this.getScore();
        this.entityData.set(DATA_SCORE_ID, j2 + i2);
    }

    public void startAutoSpinAttack(int i2, float f2, net.minecraft.world.item.ItemStack itemstack) {
        this.autoSpinAttackTicks = i2;
        this.autoSpinAttackDmg = f2;
        this.autoSpinAttackItemStack = itemstack;
        if (!this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack getWeaponItem() {
        return this.isAutoSpinAttack() && this.autoSpinAttackItemStack != null ? this.autoSpinAttackItemStack : super.getWeaponItem();
    }

    @Override
    public void die(DamageSource damagesource) {
        World world;
        super.die(damagesource);
        this.reapplyPosition();
        if (!this.isSpectator() && (world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.dropAllDeathLoot(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.setDeltaMovement(-MathHelper.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(StatisticList.DEATHS);
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_DEATH));
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int i2 = 0; i2 < this.inventory.getContainerSize(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.inventory.getItem(i2);
            if (itemstack.isEmpty() || !EnchantmentManager.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(i2);
        }
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return damagesource.type().effects().sound();
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PLAYER_DEATH;
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        return this.drop(itemstack, false, flag);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            this.swing(EnumHand.MAIN_HAND);
        }
        double d0 = this.getEyeY() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.level(), this.getX(), d0, this.getZ(), itemstack);
        entityitem.setPickUpDelay(40);
        if (flag1) {
            entityitem.setThrower(this);
        }
        if (flag) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            entityitem.setDeltaMovement(-MathHelper.sin(f1) * f2, 0.2f, MathHelper.cos(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.sin(this.getXRot() * ((float)Math.PI / 180));
            float f2 = MathHelper.cos(this.getXRot() * ((float)Math.PI / 180));
            float f32 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180));
            float f4 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180));
            float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.random.nextFloat();
            entityitem.setDeltaMovement((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        return entityitem;
    }

    public float getDestroySpeed(IBlockData iblockdata) {
        float f2 = this.inventory.getDestroySpeed(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.getAttributeValue(GenericAttributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            f2 *= (switch (this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        f2 *= (float)this.getAttributeValue(GenericAttributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(TagsFluid.WATER)) {
            f2 *= (float)this.getAttribute(GenericAttributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean hasCorrectToolForDrops(IBlockData iblockdata) {
        return !iblockdata.requiresCorrectToolForDrops() || this.inventory.getSelected().isCorrectToolForDrops(iblockdata);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setUUID(this.gameProfile.getId());
        NBTTagList nbttaglist = nbttagcompound.getList("Inventory", 10);
        this.inventory.load(nbttaglist);
        this.inventory.selected = nbttagcompound.getInt("SelectedItemSlot");
        this.sleepCounter = nbttagcompound.getShort("SleepTimer");
        this.experienceProgress = nbttagcompound.getFloat("XpP");
        this.experienceLevel = nbttagcompound.getInt("XpLevel");
        this.totalExperience = nbttagcompound.getInt("XpTotal");
        this.enchantmentSeed = nbttagcompound.getInt("XpSeed");
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(nbttagcompound.getInt("Score"));
        this.foodData.readAdditionalSaveData(nbttagcompound);
        this.abilities.loadSaveData(nbttagcompound);
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        if (nbttagcompound.contains("EnderItems", 9)) {
            this.enderChestInventory.fromTag(nbttagcompound.getList("EnderItems", 10), this.registryAccess());
        }
        if (nbttagcompound.contains("ShoulderEntityLeft", 10)) {
            this.setShoulderEntityLeft(nbttagcompound.getCompound("ShoulderEntityLeft"));
        }
        if (nbttagcompound.contains("ShoulderEntityRight", 10)) {
            this.setShoulderEntityRight(nbttagcompound.getCompound("ShoulderEntityRight"));
        }
        if (nbttagcompound.contains("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("LastDeathLocation"));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            this.setLastDeathLocation(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
        if (nbttagcompound.contains("current_explosion_impact_pos", 9)) {
            DataResult dataresult1 = Vec3D.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("current_explosion_impact_pos"));
            Logger logger1 = LOGGER;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).ifPresent(vec3d -> {
                this.currentImpulseImpactPos = vec3d;
            });
        }
        this.ignoreFallDamageFromCurrentImpulse = nbttagcompound.getBoolean("ignore_fall_damage_from_current_explosion");
        this.currentImpulseContextResetGraceTime = nbttagcompound.getInt("current_impulse_context_reset_grace_time");
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        GameProfileSerializer.addCurrentDataVersion(nbttagcompound);
        nbttagcompound.put("Inventory", this.inventory.save(new NBTTagList()));
        nbttagcompound.putInt("SelectedItemSlot", this.inventory.selected);
        nbttagcompound.putShort("SleepTimer", (short)this.sleepCounter);
        nbttagcompound.putFloat("XpP", this.experienceProgress);
        nbttagcompound.putInt("XpLevel", this.experienceLevel);
        nbttagcompound.putInt("XpTotal", this.totalExperience);
        nbttagcompound.putInt("XpSeed", this.enchantmentSeed);
        nbttagcompound.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(nbttagcompound);
        this.abilities.addSaveData(nbttagcompound);
        nbttagcompound.put("EnderItems", this.enderChestInventory.createTag(this.registryAccess()));
        if (!this.getShoulderEntityLeft().isEmpty()) {
            nbttagcompound.put("ShoulderEntityLeft", this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            nbttagcompound.put("ShoulderEntityRight", this.getShoulderEntityRight());
        }
        this.getLastDeathLocation().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, globalpos);
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbttagcompound.put("LastDeathLocation", (NBTBase)nbtbase));
        if (this.currentImpulseImpactPos != null) {
            nbttagcompound.put("current_explosion_impact_pos", (NBTBase)Vec3D.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.currentImpulseImpactPos).getOrThrow());
        }
        nbttagcompound.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
        nbttagcompound.putInt("current_impulse_context_reset_grace_time", this.currentImpulseContextResetGraceTime);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource damagesource) {
        return super.isInvulnerableTo(damagesource) ? true : (damagesource.is(DamageTypeTags.IS_DROWNING) ? !this.level().getGameRules().getBoolean(GameRules.RULE_DROWNING_DAMAGE) : (damagesource.is(DamageTypeTags.IS_FALL) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FALL_DAMAGE) : (damagesource.is(DamageTypeTags.IS_FIRE) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FIRE_DAMAGE) : (damagesource.is(DamageTypeTags.IS_FREEZING) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FREEZE_DAMAGE) : false))));
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        if (this.abilities.invulnerable && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        if (!this.level().isClientSide) {
            // empty if block
        }
        if (damagesource.scalesWithDifficulty()) {
            if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
                return false;
            }
            if (this.level().getDifficulty() == EnumDifficulty.EASY) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.hurt(damagesource, f2)) {
            this.removeEntitiesOnShoulder();
        }
        return damaged;
    }

    @Override
    protected void blockUsingShield(EntityLiving entityliving) {
        super.blockUsingShield(entityliving);
        if (entityliving.canDisableShield()) {
            this.disableShield();
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.level().getCraftServer().getOfflinePlayer(entityhuman.getScoreboardName());
            team = entityhuman.level().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.level().getCraftServer().getOfflinePlayer(this.getScoreboardName()));
    }

    @Override
    protected void hurtArmor(DamageSource damagesource, float f2) {
        this.doHurtEquipment(damagesource, f2, EnumItemSlot.FEET, EnumItemSlot.LEGS, EnumItemSlot.CHEST, EnumItemSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource damagesource, float f2) {
        this.doHurtEquipment(damagesource, f2, EnumItemSlot.HEAD);
    }

    @Override
    protected void hurtCurrentlyUsedShield(float f2) {
        if (this.useItem.is(Items.SHIELD)) {
            if (!this.level().isClientSide) {
                this.awardStat(StatisticList.ITEM_USED.get(this.useItem.getItem()));
            }
            if (f2 >= 3.0f) {
                int i2 = 1 + MathHelper.floor(f2);
                EnumHand enumhand = this.getUsedItemHand();
                this.useItem.hurtAndBreak(i2, this, EntityHuman.getSlotForHand(enumhand));
                if (this.useItem.isEmpty()) {
                    if (enumhand == EnumHand.MAIN_HAND) {
                        this.setItemSlot(EnumItemSlot.MAINHAND, net.minecraft.world.item.ItemStack.EMPTY);
                    } else {
                        this.setItemSlot(EnumItemSlot.OFFHAND, net.minecraft.world.item.ItemStack.EMPTY);
                    }
                    this.useItem = net.minecraft.world.item.ItemStack.EMPTY;
                    this.playSound(SoundEffects.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(damagesource, f2, event);
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(TileEntitySign tileentitysign, boolean flag) {
    }

    public void openMinecartCommandBlock(CommandBlockListenerAbstract commandblocklistenerabstract) {
    }

    public void openCommandBlock(TileEntityCommand tileentitycommand) {
    }

    public void openStructureBlock(TileEntityStructure tileentitystructure) {
    }

    public void openJigsawBlock(TileEntityJigsaw tileentityjigsaw) {
    }

    public void openHorseInventory(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public OptionalInt openMenu(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void sendMerchantOffers(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void openItemGui(net.minecraft.world.item.ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult interactOn(Entity entity, EnumHand enumhand) {
        if (this.isSpectator()) {
            if (entity instanceof ITileInventory) {
                this.openMenu((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.PASS;
        }
        net.minecraft.world.item.ItemStack itemstack = this.getItemInHand(enumhand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.copy();
        EnumInteractionResult enuminteractionresult = entity.interact(this, enumhand);
        if (enuminteractionresult.consumesAction()) {
            if (this.abilities.instabuild && itemstack == this.getItemInHand(enumhand) && itemstack.getCount() < itemstack1.getCount()) {
                itemstack.setCount(itemstack1.getCount());
            }
            return enuminteractionresult;
        }
        if (!itemstack.isEmpty() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.abilities.instabuild) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.interactLivingEntity(this, (EntityLiving)entity, enumhand)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, entity.position(), GameEvent.a.of(this));
                if (itemstack.isEmpty() && !this.abilities.instabuild) {
                    this.setItemInHand(enumhand, net.minecraft.world.item.ItemStack.EMPTY);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping();
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3D maybeBackOffFromEdge(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.maxUpStep();
        if (!this.abilities.flying && vec3d.y <= 0.0 && (enummovetype == EnumMoveType.SELF || enummovetype == EnumMoveType.PLAYER) && this.isStayingOnGroundSurface() && this.isAboveGround(f2)) {
            double d0;
            double d1 = vec3d.z;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.x; d0 != 0.0 && this.canFallAtLeast(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.canFallAtLeast(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.canFallAtLeast(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.y, d1);
        }
        return vec3d;
    }

    private boolean isAboveGround(float f2) {
        return this.onGround() || this.fallDistance < f2 && !this.canFallAtLeast(0.0, 0.0, f2 - this.fallDistance);
    }

    private boolean canFallAtLeast(double d0, double d1, float f2) {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        return this.level().noCollision(this, new AxisAlignedBB(axisalignedbb.minX + d0, axisalignedbb.minY - (double)f2 - (double)1.0E-5f, axisalignedbb.minZ + d1, axisalignedbb.maxX + d0, axisalignedbb.minY, axisalignedbb.maxZ + d1));
    }

    public void attack(Entity entity) {
        if (entity.isAttackable() && !entity.skipAttackInteraction(this)) {
            float f2 = this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
            net.minecraft.world.item.ItemStack itemstack = this.getWeaponItem();
            DamageSource damagesource = this.damageSources().playerAttack(this);
            float f1 = this.getEnchantedDamage(entity, f2, damagesource) - f2;
            float f22 = this.getAttackStrengthScale(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (entity.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.deflect(ProjectileDeflection.AIM_DEFLECT, this, this, true)) {
                    this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_NODAMAGE, this.getSoundSource());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack1;
                boolean flag2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.isSprinting() && flag) {
                    this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.getItem().getAttackDamageBonus(entity, f2, damagesource);
                boolean bl2 = flag2 = flag && this.fallDistance > 0.0f && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.hasEffect(MobEffects.BLINDNESS) && !this.isPassenger() && entity instanceof EntityLiving && !this.isSprinting();
                if (flag2) {
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                double d0 = this.walkDist - this.walkDistO;
                if (flag && !flag2 && !flag1 && this.onGround() && d0 < (double)this.getSpeed() && (itemstack1 = this.getItemInHand(EnumHand.MAIN_HAND)).getItem() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (entity instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    f4 = entityliving.getHealth();
                }
                Vec3D vec3d = entity.getDeltaMovement();
                boolean flag4 = entity.hurt(damagesource, f3);
                if (flag4) {
                    float f5 = this.getKnockback(entity, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)entity;
                            entityliving1.knockback(f5 * 0.5f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                        } else {
                            entity.push(-MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * f5 * 0.5f);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        this.setSprinting(false);
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.getAttributeValue(GenericAttributes.SWEEPING_DAMAGE_RATIO) * f2;
                        List<EntityLiving> list = this.level().getEntitiesOfClass(EntityLiving.class, entity.getBoundingBox().inflate(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving2 : list) {
                            if (entityliving2 == this || entityliving2 == entity || this.isAlliedTo(entityliving2) || entityliving2 instanceof EntityArmorStand && ((EntityArmorStand)entityliving2).isMarker() || !(this.distanceToSqr(entityliving2) < 9.0)) continue;
                            float f7 = this.getEnchantedDamage(entityliving2, f6, damagesource) * f22;
                            if (!entityliving2.hurt(this.damageSources().playerAttack(this).sweep(), f7)) continue;
                            entityliving2.knockback(0.4f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                            World world = this.level();
                            if (!(world instanceof WorldServer)) continue;
                            WorldServer worldserver = (WorldServer)world;
                            EnchantmentManager.doPostAttackEffects(worldserver, entityliving2, damagesource);
                        }
                        this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                        this.sweepAttack();
                    }
                    if (entity instanceof EntityPlayer && entity.hurtMarked) {
                        boolean cancelled = false;
                        Player player = (Player)entity.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)entity).connection.send(new PacketPlayOutEntityVelocity(entity));
                            entity.hurtMarked = false;
                            entity.setDeltaMovement(vec3d);
                        }
                    }
                    if (flag2) {
                        this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                        this.crit(entity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.magicCrit(entity);
                    }
                    this.setLastHurtMob(entity);
                    Entity object = entity;
                    if (entity instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)entity).parentMob;
                    }
                    boolean flag5 = false;
                    World world1 = this.level();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (object instanceof EntityLiving) {
                            EntityLiving entityliving2;
                            entityliving2 = (EntityLiving)object;
                            flag5 = itemstack.hurtEnemy(entityliving2, this);
                        }
                        EnchantmentManager.doPostAttackEffects(worldserver1, entity, damagesource);
                    }
                    if (!this.level().isClientSide && !itemstack.isEmpty() && object instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.postHurtEnemy((EntityLiving)object, this);
                        }
                        if (itemstack.isEmpty()) {
                            if (itemstack == this.getMainHandItem()) {
                                this.setItemInHand(EnumHand.MAIN_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                            } else {
                                this.setItemInHand(EnumHand.OFF_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                            }
                        }
                    }
                    if (entity instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)entity).getHealth();
                        this.awardStat(StatisticList.DAMAGE_DEALT, Math.round(f8 * 10.0f));
                        if (this.level() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.level()).sendParticles(Particles.DAMAGE_INDICATOR, entity.getX(), entity.getY(0.5), entity.getZ(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.level().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float getEnchantedDamage(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void doAutoAttackOnTouch(EntityLiving entityliving) {
        this.attack(entityliving);
    }

    public void disableShield() {
        this.getCooldowns().addCooldown(Items.SHIELD, 100);
        this.stopUsingItem();
        this.level().broadcastEntityEvent(this, (byte)30);
    }

    public void crit(Entity entity) {
    }

    public void magicCrit(Entity entity) {
    }

    public void sweepAttack() {
        double d0 = -MathHelper.sin(this.getYRot() * ((float)Math.PI / 180));
        double d1 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180));
        if (this.level() instanceof WorldServer) {
            ((WorldServer)this.level()).sendParticles(Particles.SWEEP_ATTACK, this.getX() + d0, this.getY(0.5), this.getZ() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void respawn() {
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.inventoryMenu.removed(this);
        if (this.containerMenu != null && this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    public boolean isLocalPlayer() {
        return false;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public PlayerAbilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.startSleeping(blockposition);
        this.sleepCounter = 0;
        return Either.right((Object)((Object)Unit.INSTANCE));
    }

    public void stopSleepInBed(boolean flag, boolean flag1) {
        super.stopSleeping();
        if (this.level() instanceof WorldServer && flag1) {
            ((WorldServer)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = flag ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void awardStat(MinecraftKey minecraftkey) {
        this.awardStat(StatisticList.CUSTOM.get(minecraftkey));
    }

    public void awardStat(MinecraftKey minecraftkey, int i2) {
        this.awardStat(StatisticList.CUSTOM.get(minecraftkey), i2);
    }

    public void awardStat(Statistic<?> statistic) {
        this.awardStat(statistic, 1);
    }

    public void awardStat(Statistic<?> statistic, int i2) {
    }

    public void resetStat(Statistic<?> statistic) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> recipeholder, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardRecipesByKey(List<MinecraftKey> list) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(StatisticList.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void travel(Vec3D vec3d) {
        double d0;
        if (this.isSwimming() && !this.isPassenger()) {
            double d1;
            d0 = this.getLookAngle().y;
            double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
            if (d0 <= 0.0 || this.jumping || !this.level().getBlockState(BlockPosition.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).getFluidState().isEmpty()) {
                Vec3D vec3d1 = this.getDeltaMovement();
                this.setDeltaMovement(vec3d1.add(0.0, (d0 - vec3d1.y) * d1, 0.0));
            }
        }
        if (this.abilities.flying && !this.isPassenger()) {
            d0 = this.getDeltaMovement().y;
            super.travel(vec3d);
            Vec3D vec3d2 = this.getDeltaMovement();
            this.setDeltaMovement(vec3d2.x, d0 * 0.6, vec3d2.z);
            this.resetFallDistance();
            if (this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.setSharedFlag(7, false);
            }
        } else {
            super.travel(vec3d);
        }
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPosition blockposition) {
        return !this.level().getBlockState(blockposition).isSuffocating(this.level(), blockposition);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(float f2, float f1, DamageSource damagesource) {
        boolean flag;
        if (this.abilities.mayfly) {
            return false;
        }
        if (f2 >= 2.0f) {
            this.awardStat(StatisticList.FALL_ONE_CM, (int)Math.round((double)f2 * 100.0));
        }
        if (this.ignoreFallDamageFromCurrentImpulse && this.currentImpulseImpactPos != null) {
            double d0 = this.currentImpulseImpactPos.y;
            this.tryResetCurrentImpulseContext();
            if (d0 < this.getY()) {
                return false;
            }
            float f22 = Math.min(f2, (float)(d0 - this.getY()));
            flag = super.causeFallDamage(f22, f1, damagesource);
        } else {
            flag = super.causeFallDamage(f2, f1, damagesource);
        }
        if (flag) {
            this.resetCurrentImpulseContext();
        }
        return flag;
    }

    public boolean tryToStartFallFlying() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.onGround() && !this.isFallFlying() && !this.isInWater() && !this.hasEffect(MobEffects.LEVITATION) && (itemstack = this.getItemBySlot(EnumItemSlot.CHEST)).is(Items.ELYTRA) && ItemElytra.isFlyEnabled(itemstack)) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.setSharedFlag(7, true);
        } else {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    public void stopFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(iblockdata);
        } else {
            BlockPosition blockposition1 = this.getPrimaryStepSoundBlockPos(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.level().getBlockState(blockposition1);
                if (iblockdata1.is(TagsBlock.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds(iblockdata1, iblockdata);
                } else {
                    super.playStepSound(blockposition1, iblockdata1);
                }
            } else {
                super.playStepSound(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.PLAYER_SMALL_FALL, SoundEffects.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(WorldServer worldserver, EntityLiving entityliving) {
        this.awardStat(StatisticList.ENTITY_KILLED.get(entityliving.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(iblockdata, vec3d);
        }
        this.tryResetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int i2) {
        this.increaseScore(i2);
        this.experienceProgress += (float)i2 / (float)this.getXpNeededForNextLevel();
        this.totalExperience = MathHelper.clamp(this.totalExperience + i2, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float f2 = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f2 / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(net.minecraft.world.item.ItemStack itemstack, int i2) {
        this.experienceLevel -= i2;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int i2) {
        this.experienceLevel += i2;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (i2 > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float f2 = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_LEVELUP, this.getSoundSource(), f2 * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        return this.experienceLevel >= 30 ? 112 + (this.experienceLevel - 30) * 9 : (this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2);
    }

    public void causeFoodExhaustion(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.abilities.invulnerable || this.level().isClientSide || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.foodData.addExhaustion(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodMetaData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean flag) {
        return this.abilities.invulnerable || flag || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPosition blockposition, EnumDirection enumdirection, net.minecraft.world.item.ItemStack itemstack) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.relative(enumdirection.getOpposite());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.level(), blockposition1, false);
        return itemstack.canPlaceOnBlockInAdventureMode(shapedetectorblock);
    }

    @Override
    protected int getBaseExperienceReward() {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !this.isSpectator()) {
            int i2 = this.experienceLevel * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return !this.abilities.flying && (!this.onGround() || !this.isDiscrete()) ? Entity.MovementEmission.ALL : Entity.MovementEmission.NONE;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public IChatBaseComponent getName() {
        return IChatBaseComponent.literal(this.gameProfile.getName());
    }

    public InventoryEnderChest getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    public net.minecraft.world.item.ItemStack getItemBySlot(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.MAINHAND ? this.inventory.getSelected() : (enumitemslot == EnumItemSlot.OFFHAND ? this.inventory.offhand.get(0) : (enumitemslot.getType() == EnumItemSlot.Function.HUMANOID_ARMOR ? this.inventory.armor.get(enumitemslot.getIndex()) : net.minecraft.world.item.ItemStack.EMPTY));
    }

    @Override
    protected boolean doesEmitEquipEvent(EnumItemSlot enumitemslot) {
        return enumitemslot.getType() == EnumItemSlot.Function.HUMANOID_ARMOR;
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.verifyEquippedItem(itemstack);
        if (enumitemslot == EnumItemSlot.MAINHAND) {
            this.onEquipItem(enumitemslot, this.inventory.items.set(this.inventory.selected, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.OFFHAND) {
            this.onEquipItem(enumitemslot, this.inventory.offhand.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.getType() == EnumItemSlot.Function.HUMANOID_ARMOR) {
            this.onEquipItem(enumitemslot, this.inventory.armor.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
        }
    }

    public boolean addItem(net.minecraft.world.item.ItemStack itemstack) {
        return this.inventory.add(itemstack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getHandSlots() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.getMainHandItem(), this.getOffhandItem()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getArmorSlots() {
        return this.inventory.armor;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.BODY;
    }

    public boolean setEntityOnShoulder(NBTTagCompound nbttagcompound) {
        if (!this.isPassenger() && this.onGround() && !this.isInWater() && !this.isInPowderSnow) {
            if (this.getShoulderEntityLeft().isEmpty()) {
                this.setShoulderEntityLeft(nbttagcompound);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            if (this.getShoulderEntityRight().isEmpty()) {
                this.setShoulderEntityRight(nbttagcompound);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            if (this.respawnEntityOnShoulder(this.getShoulderEntityLeft())) {
                this.setShoulderEntityLeft(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.getShoulderEntityRight())) {
                this.setShoulderEntityRight(new NBTTagCompound());
            }
        }
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        if (!this.level().isClientSide && !nbttagcompound.isEmpty()) {
            return EntityTypes.create(nbttagcompound, this.level()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).setOwnerUUID(this.uuid);
                }
                entity.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                return ((WorldServer)this.level()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
            }).orElse(true);
        }
        return true;
    }

    @Override
    public abstract boolean isSpectator();

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public abstract boolean isCreative();

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    public Scoreboard getScoreboard() {
        return this.level().getScoreboard();
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.formatNameForTeam(this.getTeam(), this.getName());
        return this.decorateDisplayNameComponent(ichatmutablecomponent);
    }

    private IChatMutableComponent decorateDisplayNameComponent(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.getGameProfile().getName();
        return ichatmutablecomponent.withStyle(chatmodifier -> chatmodifier.withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/tell " + s2 + " ")).withHoverEvent(this.createHoverEvent()).withInsertion(s2));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().getName();
    }

    @Override
    protected void internalSetAbsorptionAmount(float f2) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(f2));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    public boolean isModelPartShown(PlayerModelPart playermodelpart) {
        return (this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & playermodelpart.getMask()) == playermodelpart.getMask();
    }

    @Override
    public SlotAccess getSlot(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return EntityHuman.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack itemstack) {
                    EntityHuman.this.containerMenu.setCarried(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return EntityHuman.this.inventoryMenu.getCraftSlots().getItem(j2);
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack itemstack) {
                    EntityHuman.this.inventoryMenu.getCraftSlots().setItem(j2, itemstack);
                    EntityHuman.this.inventoryMenu.slotsChanged(EntityHuman.this.inventory);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.inventory.items.size()) {
            return SlotAccess.forContainer(this.inventory, i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.enderChestInventory.getContainerSize() ? SlotAccess.forContainer(this.enderChestInventory, k2) : super.getSlot(i2);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean flag) {
        this.reducedDebugInfo = flag;
    }

    @Override
    public void setRemainingFireTicks(int i2) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(i2, 1) : i2);
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.entityData.get(DATA_PLAYER_MAIN_HAND) == 0 ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public void setMainArm(EnumMainHand enummainhand) {
        this.entityData.set(DATA_PLAYER_MAIN_HAND, (byte)(enummainhand != EnumMainHand.LEFT ? 1 : 0));
    }

    public NBTTagCompound getShoulderEntityLeft() {
        return this.entityData.get(DATA_SHOULDER_LEFT);
    }

    public void setShoulderEntityLeft(NBTTagCompound nbttagcompound) {
        this.entityData.set(DATA_SHOULDER_LEFT, nbttagcompound);
    }

    public NBTTagCompound getShoulderEntityRight() {
        return this.entityData.get(DATA_SHOULDER_RIGHT);
    }

    public void setShoulderEntityRight(NBTTagCompound nbttagcompound) {
        this.entityData.set(DATA_SHOULDER_RIGHT, nbttagcompound);
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(GenericAttributes.ATTACK_SPEED) * 20.0);
    }

    public float getAttackStrengthScale(float f2) {
        return MathHelper.clamp(((float)this.attackStrengthTicker + f2) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldown getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return !this.abilities.flying && !this.isFallFlying() ? super.getBlockSpeedFactor() : 1.0f;
    }

    public float getLuck() {
        return (float)this.getAttributeValue(GenericAttributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.getPermissionLevel() >= 2;
    }

    @Override
    public boolean canTakeItem(net.minecraft.world.item.ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        return this.getItemBySlot(enumitemslot).isEmpty();
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose entitypose) {
        return POSES.getOrDefault((Object)entitypose, STANDING_DIMENSIONS);
    }

    @Override
    public ImmutableList<EntityPose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)EntityPose.STANDING), (Object)((Object)EntityPose.CROUCHING), (Object)((Object)EntityPose.SWIMMING));
    }

    @Override
    public net.minecraft.world.item.ItemStack getProjectile(net.minecraft.world.item.ItemStack itemstack) {
        if (!(itemstack.getItem() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)itemstack.getItem()).getSupportedHeldProjectiles();
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.getHeldProjectile(this, predicate);
        if (!itemstack1.isEmpty()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.getItem()).getAllSupportedProjectiles();
        for (int i2 = 0; i2 < this.inventory.getContainerSize(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.inventory.getItem(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.abilities.instabuild ? new net.minecraft.world.item.ItemStack(Items.ARROW) : net.minecraft.world.item.ItemStack.EMPTY;
    }

    @Override
    public net.minecraft.world.item.ItemStack eat(World world, net.minecraft.world.item.ItemStack itemstack, FoodInfo foodinfo) {
        this.getFoodData().eat(itemstack, foodinfo);
        this.awardStat(StatisticList.ITEM_USED.get(itemstack.getItem()));
        world.playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_BURP, SoundCategory.PLAYERS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.CONSUME_ITEM.trigger((EntityPlayer)this, itemstack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = super.eat(world, itemstack, foodinfo);
        Optional<net.minecraft.world.item.ItemStack> optional = foodinfo.usingConvertsTo();
        if (optional.isPresent() && !this.hasInfiniteMaterials()) {
            if (itemstack1.isEmpty()) {
                return optional.get().copy();
            }
            if (!this.level().isClientSide()) {
                this.getInventory().add(optional.get().copy());
            }
        }
        return itemstack1;
    }

    @Override
    public Vec3D getRopeHoldPosition(float f2) {
        float f3;
        double d0 = 0.22 * (this.getMainArm() == EnumMainHand.RIGHT ? -1.0 : 1.0);
        float f1 = MathHelper.lerp(f2 * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float f22 = MathHelper.lerp(f2, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (!this.isFallFlying() && !this.isAutoSpinAttack()) {
            if (this.isVisuallySwimming()) {
                return this.getPosition(f2).add(new Vec3D(d0, 0.2, -0.15).xRot(-f1).yRot(-f22));
            }
            double d2 = this.getBoundingBox().getYsize() - 1.0;
            double d1 = this.isCrouching() ? -0.2 : 0.07;
            return this.getPosition(f2).add(new Vec3D(d0, d2, d1).yRot(-f22));
        }
        Vec3D vec3d = this.getViewVector(f2);
        Vec3D vec3d1 = this.getDeltaMovement();
        double d1 = vec3d1.horizontalDistanceSqr();
        double d3 = vec3d.horizontalDistanceSqr();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.x * vec3d.x + vec3d1.z * vec3d.z) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.x * vec3d.z - vec3d1.z * vec3d.x;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.getPosition(f2).add(new Vec3D(d0, -0.11, 0.85).zRot(-f3).xRot(-f1).yRot(-f22));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> optional) {
        this.lastDeathLocation = optional;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float f2) {
        super.animateHurt(f2);
        this.hurtDir = f2;
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        return this.abilities.flying && !this.isPassenger() ? (this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed()) : (this.isSprinting() ? 0.025999999f : 0.02f);
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(GenericAttributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(GenericAttributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean canInteractWithEntity(Entity entity, double d0) {
        return entity.isRemoved() ? false : this.canInteractWithEntity(entity.getBoundingBox(), d0);
    }

    public boolean canInteractWithEntity(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.entityInteractionRange() + d0;
        return axisalignedbb.distanceToSqr(this.getEyePosition()) < d1 * d1;
    }

    public boolean canInteractWithBlock(BlockPosition blockposition, double d0) {
        double d1 = this.blockInteractionRange() + d0;
        return new AxisAlignedBB(blockposition).distanceToSqr(this.getEyePosition()) < d1 * d1;
    }

    public void setIgnoreFallDamageFromCurrentImpulse(boolean flag) {
        this.ignoreFallDamageFromCurrentImpulse = flag;
        this.currentImpulseContextResetGraceTime = flag ? 40 : 0;
    }

    public boolean isIgnoringFallDamageFromCurrentImpulse() {
        return this.ignoreFallDamageFromCurrentImpulse;
    }

    public void tryResetCurrentImpulseContext() {
        if (this.currentImpulseContextResetGraceTime == 0) {
            this.resetCurrentImpulseContext();
        }
    }

    public void resetCurrentImpulseContext() {
        this.currentImpulseContextResetGraceTime = 0;
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public static enum EnumBedResult {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW(IChatBaseComponent.translatable("block.minecraft.bed.no_sleep")),
        TOO_FAR_AWAY(IChatBaseComponent.translatable("block.minecraft.bed.too_far_away")),
        OBSTRUCTED(IChatBaseComponent.translatable("block.minecraft.bed.obstructed")),
        OTHER_PROBLEM,
        NOT_SAFE(IChatBaseComponent.translatable("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent message;

        private EnumBedResult() {
            this.message = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.message = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent getMessage() {
            return this.message;
        }
    }
}

