/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    private static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final int[] ALL_ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOT_ONLY = new int[]{3};
    public final NonNullList<ItemStack> items;
    public final NonNullList<ItemStack> armor;
    public final NonNullList<ItemStack> offhand;
    private final List<NonNullList<ItemStack>> compartments;
    public int selected;
    public final EntityHuman player;
    private int timesChanged;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.items.size() + this.armor.size() + this.offhand.size());
        for (List list : this.compartments) {
            combined.addAll(list);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        return this.armor;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public PlayerInventory(EntityHuman entityhuman) {
        this.items = NonNullList.withSize(36, ItemStack.EMPTY);
        this.armor = NonNullList.withSize(4, ItemStack.EMPTY);
        this.offhand = NonNullList.withSize(1, ItemStack.EMPTY);
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand);
        this.player = entityhuman;
    }

    public ItemStack getSelected() {
        return PlayerInventory.isHotbarSlot(this.selected) ? this.items.get(this.selected) : ItemStack.EMPTY;
    }

    public static int getSelectionSize() {
        return 9;
    }

    private boolean hasRemainingSpaceForItem(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.isEmpty() && ItemStack.isSameItemSameComponents(itemstack, itemstack1) && itemstack.isStackable() && itemstack.getCount() < this.getMaxStackSize(itemstack);
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.getCount();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            ItemStack itemstack1 = this.getItem(i2);
            if (itemstack1.isEmpty()) {
                return itemstack.getCount();
            }
            if (this.hasRemainingSpaceForItem(itemstack1, itemstack)) {
                remains -= (itemstack1.getMaxStackSize() < this.getMaxStackSize() ? itemstack1.getMaxStackSize() : this.getMaxStackSize()) - itemstack1.getCount();
            }
            if (remains > 0) continue;
            return itemstack.getCount();
        }
        ItemStack offhandItemStack = this.getItem(this.items.size() + this.armor.size());
        if (this.hasRemainingSpaceForItem(offhandItemStack, itemstack)) {
            remains -= (offhandItemStack.getMaxStackSize() < this.getMaxStackSize() ? offhandItemStack.getMaxStackSize() : this.getMaxStackSize()) - offhandItemStack.getCount();
        }
        if (remains <= 0) {
            return itemstack.getCount();
        }
        return itemstack.getCount() - remains;
    }

    public int getFreeSlot() {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (!this.items.get(i2).isEmpty()) continue;
            return i2;
        }
        return -1;
    }

    public void setPickedItem(ItemStack itemstack) {
        int i2 = this.findSlotMatchingItem(itemstack);
        if (PlayerInventory.isHotbarSlot(i2)) {
            this.selected = i2;
        } else if (i2 == -1) {
            int j2;
            this.selected = this.getSuitableHotbarSlot();
            if (!this.items.get(this.selected).isEmpty() && (j2 = this.getFreeSlot()) != -1) {
                this.items.set(j2, this.items.get(this.selected));
            }
            this.items.set(this.selected, itemstack);
        } else {
            this.pickSlot(i2);
        }
    }

    public void pickSlot(int i2) {
        this.selected = this.getSuitableHotbarSlot();
        ItemStack itemstack = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(i2));
        this.items.set(i2, itemstack);
    }

    public static boolean isHotbarSlot(int i2) {
        return i2 >= 0 && i2 < 9;
    }

    public int findSlotMatchingItem(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (this.items.get(i2).isEmpty() || !ItemStack.isSameItemSameComponents(itemstack, this.items.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int findSlotMatchingUnusedItem(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            ItemStack itemstack1 = this.items.get(i2);
            if (itemstack1.isEmpty() || !ItemStack.isSameItemSameComponents(itemstack, itemstack1) || itemstack1.isDamaged() || itemstack1.isEnchanted() || itemstack1.has(DataComponents.CUSTOM_NAME)) continue;
            return i2;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int i2;
        int j2;
        for (j2 = 0; j2 < 9; ++j2) {
            i2 = (this.selected + j2) % 9;
            if (!this.items.get(i2).isEmpty()) continue;
            return i2;
        }
        for (j2 = 0; j2 < 9; ++j2) {
            i2 = (this.selected + j2) % 9;
            if (this.items.get(i2).isEnchanted()) continue;
            return i2;
        }
        return this.selected;
    }

    public void swapPaint(double d0) {
        int i2 = (int)Math.signum(d0);
        this.selected -= i2;
        while (this.selected < 0) {
            this.selected += 9;
        }
        while (this.selected >= 9) {
            this.selected -= 9;
        }
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> predicate, int i2, IInventory iinventory) {
        int j2 = 0;
        boolean flag = i2 == 0;
        j2 += ContainerUtil.clearOrCountMatchingItems(this, predicate, i2 - j2, flag);
        j2 += ContainerUtil.clearOrCountMatchingItems(iinventory, predicate, i2 - j2, flag);
        ItemStack itemstack = this.player.containerMenu.getCarried();
        j2 += ContainerUtil.clearOrCountMatchingItems(itemstack, predicate, i2 - j2, flag);
        if (itemstack.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return j2;
    }

    private int addResource(ItemStack itemstack) {
        int i2 = this.getSlotWithRemainingSpace(itemstack);
        if (i2 == -1) {
            i2 = this.getFreeSlot();
        }
        return i2 == -1 ? itemstack.getCount() : this.addResource(i2, itemstack);
    }

    private int addResource(int i2, ItemStack itemstack) {
        int k2;
        int l2;
        int j2 = itemstack.getCount();
        ItemStack itemstack1 = this.getItem(i2);
        if (itemstack1.isEmpty()) {
            itemstack1 = itemstack.copyWithCount(0);
            this.setItem(i2, itemstack1);
        }
        if ((l2 = Math.min(j2, k2 = this.getMaxStackSize(itemstack1) - itemstack1.getCount())) == 0) {
            return j2;
        }
        itemstack1.grow(l2);
        itemstack1.setPopTime(5);
        return j2 -= l2;
    }

    public int getSlotWithRemainingSpace(ItemStack itemstack) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), itemstack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), itemstack)) {
            return 40;
        }
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (!this.hasRemainingSpaceForItem(this.items.get(i2), itemstack)) continue;
            return i2;
        }
        return -1;
    }

    public void tick() {
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
                if (nonnulllist.get(i2).isEmpty()) continue;
                nonnulllist.get(i2).inventoryTick(this.player.level(), this.player, i2, this.selected == i2);
            }
        }
    }

    public boolean add(ItemStack itemstack) {
        return this.add(-1, itemstack);
    }

    public boolean add(int i2, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return false;
        }
        try {
            int j2;
            if (itemstack.isDamaged()) {
                if (i2 == -1) {
                    i2 = this.getFreeSlot();
                }
                if (i2 >= 0) {
                    this.items.set(i2, itemstack.copyAndClear());
                    this.items.get(i2).setPopTime(5);
                    return true;
                }
                if (this.player.hasInfiniteMaterials()) {
                    itemstack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                j2 = itemstack.getCount();
                if (i2 == -1) {
                    itemstack.setCount(this.addResource(itemstack));
                    continue;
                }
                itemstack.setCount(this.addResource(i2, itemstack));
            } while (!itemstack.isEmpty() && itemstack.getCount() < j2);
            if (itemstack.getCount() == j2 && this.player.hasInfiniteMaterials()) {
                itemstack.setCount(0);
                return true;
            }
            return itemstack.getCount() < j2;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Adding item to inventory");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Item being added");
            crashreportsystemdetails.setDetail("Item ID", Item.getId(itemstack.getItem()));
            crashreportsystemdetails.setDetail("Item data", itemstack.getDamageValue());
            crashreportsystemdetails.setDetail("Item name", () -> itemstack.getHoverName().getString());
            throw new ReportedException(crashreport);
        }
    }

    public void placeItemBackInInventory(ItemStack itemstack) {
        this.placeItemBackInInventory(itemstack, true);
    }

    public void placeItemBackInInventory(ItemStack itemstack, boolean flag) {
        while (!itemstack.isEmpty()) {
            int i2 = this.getSlotWithRemainingSpace(itemstack);
            if (i2 == -1) {
                i2 = this.getFreeSlot();
            }
            if (i2 != -1) {
                int j2 = itemstack.getMaxStackSize() - this.getItem(i2).getCount();
                if (!this.add(i2, itemstack.split(j2)) || !flag || !(this.player instanceof EntityPlayer)) continue;
                ((EntityPlayer)this.player).connection.send(new PacketPlayOutSetSlot(-2, 0, i2, this.getItem(i2)));
                continue;
            }
            this.player.drop(itemstack, false);
            break;
        }
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            if (i2 < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            i2 -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(i2)).isEmpty() ? ContainerUtil.removeItem(list, i2, j2) : ItemStack.EMPTY;
    }

    public void removeItem(ItemStack itemstack) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
                if (nonnulllist.get(i2) != itemstack) continue;
                nonnulllist.set(i2, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.compartments) {
            if (i2 < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            i2 -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(i2)).isEmpty()) {
            ItemStack itemstack = nonnulllist.get(i2);
            nonnulllist.set(i2, ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.compartments) {
            if (i2 < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            i2 -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(i2, itemstack);
        }
    }

    public float getDestroySpeed(IBlockData iblockdata) {
        return this.items.get(this.selected).getDestroySpeed(iblockdata);
    }

    public NBTTagList save(NBTTagList nbttaglist) {
        NBTTagCompound nbttagcompound;
        int i2;
        for (i2 = 0; i2 < this.items.size(); ++i2) {
            if (this.items.get(i2).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.putByte("Slot", (byte)i2);
            nbttaglist.add(this.items.get(i2).save(this.player.registryAccess(), nbttagcompound));
        }
        for (i2 = 0; i2 < this.armor.size(); ++i2) {
            if (this.armor.get(i2).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.putByte("Slot", (byte)(i2 + 100));
            nbttaglist.add(this.armor.get(i2).save(this.player.registryAccess(), nbttagcompound));
        }
        for (i2 = 0; i2 < this.offhand.size(); ++i2) {
            if (this.offhand.get(i2).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.putByte("Slot", (byte)(i2 + 150));
            nbttaglist.add(this.offhand.get(i2).save(this.player.registryAccess(), nbttagcompound));
        }
        return nbttaglist;
    }

    public void load(NBTTagList nbttaglist) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompound(i2);
            int j2 = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.parse(this.player.registryAccess(), nbttagcompound).orElse(ItemStack.EMPTY);
            if (j2 >= 0 && j2 < this.items.size()) {
                this.items.set(j2, itemstack);
                continue;
            }
            if (j2 >= 100 && j2 < this.armor.size() + 100) {
                this.armor.set(j2 - 100, itemstack);
                continue;
            }
            if (j2 < 150 || j2 >= this.offhand.size() + 150) continue;
            this.offhand.set(j2 - 150, itemstack);
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + this.armor.size() + this.offhand.size();
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            iterator = this.armor.iterator();
            do {
                if (iterator.hasNext()) continue;
                iterator = this.offhand.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
                return false;
            } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
            return false;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public ItemStack getItem(int i2) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            if (i2 < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            i2 -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(i2);
    }

    @Override
    public IChatBaseComponent getName() {
        return IChatBaseComponent.translatable("container.inventory");
    }

    public ItemStack getArmor(int i2) {
        return this.armor.get(i2);
    }

    public void dropAll() {
        for (List list : this.compartments) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ItemStack itemstack = (ItemStack)list.get(i2);
                if (itemstack.isEmpty()) continue;
                this.player.drop(itemstack, true, false);
                list.set(i2, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return entityhuman.canInteractWithEntity(this.player, 4.0);
    }

    public boolean contains(ItemStack itemstack) {
        for (List list : this.compartments) {
            for (ItemStack itemstack1 : list) {
                if (itemstack1.isEmpty() || !ItemStack.isSameItemSameComponents(itemstack1, itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> tagkey) {
        for (List list : this.compartments) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemstack.is(tagkey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> predicate) {
        for (List list : this.compartments) {
            for (ItemStack itemstack : list) {
                if (!predicate.test(itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceWith(PlayerInventory playerinventory) {
        for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
            this.setItem(i2, playerinventory.getItem(i2));
        }
        this.selected = playerinventory.selected;
    }

    @Override
    public void clearContent() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    public void fillStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.accountSimpleStack(itemstack);
        }
    }

    public ItemStack removeFromSelected(boolean flag) {
        ItemStack itemstack = this.getSelected();
        return itemstack.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selected, flag ? itemstack.getCount() : 1);
    }
}

