/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final DataWatcherObject<Byte> ID_FLAGS = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> PIERCE_LEVEL = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private IBlockData lastState;
    public boolean inGround;
    protected int inGroundTime;
    public PickupStatus pickup = PickupStatus.DISALLOWED;
    public int shakeTime;
    public int life;
    private double baseDamage = 2.0;
    private SoundEffect soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    public ItemStack pickupItemStack = this.getDefaultPickupItem();
    @Nullable
    public ItemStack firedFromWeapon = null;

    @Override
    public void inactiveTick() {
        if (this.inGround) {
            ++this.life;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, d0, d1, d2, world, itemstack, itemstack1, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable EntityLiving ownerEntity) {
        this(entitytypes, world);
        this.setOwner(ownerEntity);
        this.pickupItemStack = itemstack.copy();
        this.setCustomName(itemstack.get(DataComponents.CUSTOM_NAME));
        Unit unit = itemstack.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if (unit != null) {
            this.pickup = PickupStatus.CREATIVE_ONLY;
        }
        this.setPos(d0, d1, d2);
        if (itemstack1 != null && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack1.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = itemstack1.copy();
            int i2 = EnchantmentManager.getPiercingCount(worldserver, itemstack1, this.pickupItemStack);
            if (i2 > 0) {
                this.setPierceLevel((byte)i2);
            }
            EnchantmentManager.onProjectileSpawned(worldserver, itemstack1, this, item -> {
                this.firedFromWeapon = null;
            });
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, EntityLiving entityliving, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, entityliving.getX(), entityliving.getEyeY() - (double)0.1f, entityliving.getZ(), world, itemstack, itemstack1, entityliving);
    }

    public void setSoundEvent(SoundEffect soundeffect) {
        this.soundEvent = soundeffect;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * EntityArrow.getViewScale()) * d1;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(ID_FLAGS, (byte)0);
        datawatcher_a.define(PIERCE_LEVEL, (byte)0);
    }

    @Override
    public void shoot(double d0, double d1, double d2, float f2, float f1) {
        super.shoot(d0, d1, d2, f2, f1);
        this.life = 0;
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.setPos(d0, d1, d2);
        this.setRot(f2, f1);
    }

    @Override
    public void lerpMotion(double d0, double d1, double d2) {
        super.lerpMotion(d0, d1, d2);
        this.life = 0;
    }

    @Override
    public void tick() {
        Vec3D vec3d1;
        VoxelShape voxelshape;
        super.tick();
        boolean flag = this.isNoPhysics();
        Vec3D vec3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3d.horizontalDistance();
            this.setYRot((float)(MathHelper.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
            this.setXRot((float)(MathHelper.atan2(vec3d.y, d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPosition blockposition = this.blockPosition();
        IBlockData iblockdata = this.level().getBlockState(blockposition);
        if (!(iblockdata.isAir() || flag || (voxelshape = iblockdata.getCollisionShape(this.level(), blockposition)).isEmpty())) {
            vec3d1 = this.position();
            for (AxisAlignedBB axisalignedbb : voxelshape.toAabbs()) {
                if (!axisalignedbb.move(blockposition).contains(vec3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || iblockdata.is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
        if (this.inGround && !flag) {
            if (this.lastState != iblockdata && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3D vec3d2 = this.position();
            vec3d1 = vec3d2.add(vec3d);
            MovingObjectPosition object = this.level().clip(new RayTrace(vec3d2, vec3d1, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
            if (((MovingObjectPosition)object).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
                vec3d1 = ((MovingObjectPosition)object).getLocation();
            }
            while (!this.isRemoved()) {
                MovingObjectPositionEntity movingobjectpositionentity = this.findHitEntity(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((MovingObjectPosition)object).getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                    Entity entity = ((MovingObjectPositionEntity)object).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof EntityHuman && entity1 instanceof EntityHuman && !((EntityHuman)entity1).canHarmPlayer((EntityHuman)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object != null && !flag) {
                    ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(object);
                    this.hasImpulse = true;
                    if (projectiledeflection != ProjectileDeflection.NONE) break;
                }
                if (movingobjectpositionentity == null || this.getPierceLevel() <= 0) break;
                object = null;
            }
            vec3d = this.getDeltaMovement();
            double d1 = vec3d.x;
            double d2 = vec3d.y;
            double d3 = vec3d.z;
            if (this.isCritArrow()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.level().addParticle(Particles.CRIT, this.getX() + d1 * (double)i2 / 4.0, this.getY() + d2 * (double)i2 / 4.0, this.getZ() + d3 * (double)i2 / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.getX() + d1;
            double d5 = this.getY() + d2;
            double d6 = this.getZ() + d3;
            double d7 = vec3d.horizontalDistance();
            if (flag) {
                this.setYRot((float)(MathHelper.atan2(-d1, -d3) * 57.2957763671875));
            } else {
                this.setYRot((float)(MathHelper.atan2(d1, d3) * 57.2957763671875));
            }
            this.setXRot((float)(MathHelper.atan2(d2, d7) * 57.2957763671875));
            this.setXRot(EntityArrow.lerpRotation(this.xRotO, this.getXRot()));
            this.setYRot(EntityArrow.lerpRotation(this.yRotO, this.getYRot()));
            float f2 = 0.99f;
            if (this.isInWater()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    float f1 = 0.25f;
                    this.level().addParticle(Particles.BUBBLE, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f2 = this.getWaterInertia();
            }
            this.setDeltaMovement(vec3d.scale(f2));
            if (!flag) {
                this.applyGravity();
            }
            this.setPos(d4, d5, d6);
            this.checkInsideBlocks();
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AxisAlignedBB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3D vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    @Override
    public void move(EnumMoveType enummovetype, Vec3D vec3d) {
        super.move(enummovetype, vec3d);
        if (enummovetype != EnumMoveType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= (this instanceof EntityThrownTrident ? this.level().spigotConfig.tridentDespawnRate : this.level().spigotConfig.arrowDespawnRate)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        World world;
        super.onHitEntity(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.getEntity();
        float f2 = (float)this.getDeltaMovement().length();
        double d0 = this.baseDamage;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow(this, entity1 != null ? entity1 : this);
        if (this.getWeaponItem() != null && (world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            d0 = EnchantmentManager.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, (float)d0);
        }
        int i2 = MathHelper.ceil(MathHelper.clamp((double)f2 * d0, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long j2 = this.random.nextInt(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if (entity1 instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity1;
            entityliving.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityTypes.ENDERMAN;
        int k2 = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.hurt(damagesource, i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    entityliving1.setArrowCount(entityliving1.getArrowCount() + 1);
                }
                this.doKnockback(entityliving1, damagesource);
                World world1 = this.level();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    EnchantmentManager.doPostAttackEffectsWithItemSource(worldserver1, entityliving1, damagesource, this.getWeaponItem());
                }
                this.doPostHurtEffects(entityliving1);
                if (entityliving1 != entity1 && entityliving1 instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.isSilent()) {
                    ((EntityPlayer)entity1).connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(entityliving1);
                }
                if (!this.level().isClientSide && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger(entityplayer, this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.setRemainingFireTicks(k2);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == PickupStatus.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        }
    }

    protected void doKnockback(EntityLiving entityliving, DamageSource damagesource) {
        float f2;
        World world;
        if (this.firedFromWeapon != null && (world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.modifyKnockback(worldserver, this.firedFromWeapon, entityliving, damagesource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d0 = f2;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entityliving.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
            Vec3D vec3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3d.lengthSqr() > 0.0) {
                entityliving.push(vec3d.x, 0.1, vec3d.z);
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        this.lastState = this.level().getBlockState(movingobjectpositionblock.getBlockPos());
        super.onHitBlock(movingobjectpositionblock);
        Vec3D vec3d = movingobjectpositionblock.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3d);
        ItemStack itemstack = this.getWeaponItem();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(worldserver, movingobjectpositionblock, itemstack);
            }
        }
        Vec3D vec3d1 = vec3d.normalize().scale(0.05f);
        this.setPosRaw(this.getX() - vec3d1.x, this.getY() - vec3d1.y, this.getZ() - vec3d1.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEffects.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void hitBlockEnchantmentEffects(WorldServer worldserver, MovingObjectPositionBlock movingobjectpositionblock, ItemStack itemstack) {
        EntityLiving entityliving1;
        Vec3D vec3d = movingobjectpositionblock.getBlockPos().clampLocationWithin(movingobjectpositionblock.getLocation());
        Entity entity = this.getOwner();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.onHitBlock(worldserver, itemstack, entityliving, this, null, vec3d, worldserver.getBlockState(movingobjectpositionblock.getBlockPos()), item -> {
            this.firedFromWeapon = null;
        });
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.ARROW_HIT;
    }

    protected final SoundEffect getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(EntityLiving entityliving) {
    }

    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D vec3d, Vec3D vec3d1) {
        return ProjectileHelper.getEntityHitResult(this.level(), this, vec3d, vec3d1, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.getId()));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putShort("life", (short)this.life);
        if (this.lastState != null) {
            nbttagcompound.put("inBlockState", GameProfileSerializer.writeBlockState(this.lastState));
        }
        nbttagcompound.putByte("shake", (byte)this.shakeTime);
        nbttagcompound.putBoolean("inGround", this.inGround);
        nbttagcompound.putByte("pickup", (byte)this.pickup.ordinal());
        nbttagcompound.putDouble("damage", this.baseDamage);
        nbttagcompound.putBoolean("crit", this.isCritArrow());
        nbttagcompound.putByte("PierceLevel", this.getPierceLevel());
        nbttagcompound.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey(this.soundEvent).toString());
        nbttagcompound.put("item", this.pickupItemStack.save(this.registryAccess()));
        if (this.firedFromWeapon != null) {
            nbttagcompound.put("weapon", this.firedFromWeapon.save(this.registryAccess(), new NBTTagCompound()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.life = nbttagcompound.getShort("life");
        if (nbttagcompound.contains("inBlockState", 10)) {
            this.lastState = GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), nbttagcompound.getCompound("inBlockState"));
        }
        this.shakeTime = nbttagcompound.getByte("shake") & 0xFF;
        this.inGround = nbttagcompound.getBoolean("inGround");
        if (nbttagcompound.contains("damage", 99)) {
            this.baseDamage = nbttagcompound.getDouble("damage");
        }
        this.pickup = PickupStatus.byOrdinal(nbttagcompound.getByte("pickup"));
        this.setCritArrow(nbttagcompound.getBoolean("crit"));
        this.setPierceLevel(nbttagcompound.getByte("PierceLevel"));
        if (nbttagcompound.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(MinecraftKey.parse(nbttagcompound.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        if (nbttagcompound.contains("item", 10)) {
            this.setPickupItemStack(ItemStack.parse(this.registryAccess(), nbttagcompound.getCompound("item")).orElse(this.getDefaultPickupItem()));
        } else {
            this.setPickupItemStack(this.getDefaultPickupItem());
        }
        this.firedFromWeapon = nbttagcompound.contains("weapon", 10) ? (ItemStack)ItemStack.parse(this.registryAccess(), nbttagcompound.getCompound("weapon")).orElse(null) : null;
    }

    @Override
    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        PickupStatus entityarrow_pickupstatus = this.pickup;
        Entity entity2 = entity1;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
            case 0: {
                EntityHuman entityhuman = (EntityHuman)entity2;
                if (this.pickup != PickupStatus.DISALLOWED) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = PickupStatus.ALLOWED;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = PickupStatus.DISALLOWED;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.pickup;
                break;
            }
        }
        this.pickup = entityarrow_pickupstatus;
    }

    @Override
    public void playerTouch(EntityHuman entityhuman) {
        if (!this.level().isClientSide && (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0) {
            ItemStack itemstack = this.getPickupItem();
            if (this.pickup == PickupStatus.ALLOWED && !itemstack.isEmpty() && entityhuman.getInventory().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entityhuman.getBukkitEntity(), (Item)new CraftItem(this.level().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.getItem();
            }
            if (this.pickup == PickupStatus.ALLOWED && entityhuman.getInventory().add(itemstack) || this.pickup == PickupStatus.CREATIVE_ONLY && entityhuman.getAbilities().instabuild) {
                entityhuman.take(this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean tryPickup(EntityHuman entityhuman) {
        return switch (this.pickup.ordinal()) {
            case 0 -> false;
            case 1 -> entityhuman.getInventory().add(this.getPickupItem());
            case 2 -> entityhuman.hasInfiniteMaterials();
            default -> throw new MatchException(null, null);
        };
    }

    protected ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double d0) {
        this.baseDamage = d0;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean flag) {
        this.setFlag(1, flag);
    }

    public void setPierceLevel(byte b0) {
        this.entityData.set(PIERCE_LEVEL, b0);
    }

    private void setFlag(int i2, boolean flag) {
        byte b0 = this.entityData.get(ID_FLAGS);
        if (flag) {
            this.entityData.set(ID_FLAGS, (byte)(b0 | i2));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(b0 & ~i2));
        }
    }

    protected void setPickupItemStack(ItemStack itemstack) {
        this.pickupItemStack = !itemstack.isEmpty() ? itemstack : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte b0 = this.entityData.get(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        return this.firedFromWeapon != null && this.firedFromWeapon.is(Items.CROSSBOW);
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setBaseDamageFromMob(float f2) {
        this.setBaseDamage((double)(f2 * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean flag) {
        this.noPhysics = flag;
        this.setFlag(2, flag);
    }

    public boolean isNoPhysics() {
        return !this.level().isClientSide ? this.noPhysics : (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.inGround;
    }

    @Override
    public SlotAccess getSlot(int i2) {
        return i2 == 0 ? SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack) : super.getSlot(i2);
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus byOrdinal(int i2) {
            if (i2 < 0 || i2 > PickupStatus.values().length) {
                i2 = 0;
            }
            return PickupStatus.values()[i2];
        }
    }
}

