/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityDragonFireball
extends EntityFireball {
    public static final float SPLASH_RANGE = 4.0f;

    public EntityDragonFireball(EntityTypes<? extends EntityDragonFireball> entitytypes, World world) {
        super((EntityTypes<? extends EntityFireball>)entitytypes, world);
    }

    public EntityDragonFireball(World world, EntityLiving entityliving, Vec3D vec3d) {
        super(EntityTypes.DRAGON_FIREBALL, entityliving, vec3d, world);
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!(movingobjectposition.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY && this.ownedBy(((MovingObjectPositionEntity)movingobjectposition).getEntity()) || this.level().isClientSide)) {
            List<EntityLiving> list = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof EntityLiving) {
                entityareaeffectcloud.setOwner((EntityLiving)entity);
            }
            entityareaeffectcloud.setParticle(Particles.DRAGON_BREATH);
            entityareaeffectcloud.setRadius(3.0f);
            entityareaeffectcloud.setDuration(600);
            entityareaeffectcloud.setRadiusPerTick((7.0f - entityareaeffectcloud.getRadius()) / (float)entityareaeffectcloud.getDuration());
            entityareaeffectcloud.addEffect(new MobEffect(MobEffects.HARM, 1, 1));
            if (!list.isEmpty()) {
                for (EntityLiving entityliving : list) {
                    double d0 = this.distanceToSqr(entityliving);
                    if (!(d0 < 16.0)) continue;
                    entityareaeffectcloud.setPos(entityliving.getX(), entityliving.getY(), entityliving.getZ());
                    break;
                }
            }
            this.level().levelEvent(2006, this.blockPosition(), this.isSilent() ? -1 : 1);
            this.level().addFreshEntity(entityareaeffectcloud);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        return false;
    }

    @Override
    protected ParticleParam getTrailParticle() {
        return Particles.DRAGON_BREATH;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

