/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class EntityEgg
extends EntityProjectileThrowable {
    private static final EntitySize ZERO_SIZED_DIMENSIONS = EntitySize.fixed(0.0f, 0.0f);

    public EntityEgg(EntityTypes<? extends EntityEgg> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntityEgg(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.EGG, entityliving, world);
    }

    public EntityEgg(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.EGG, d0, d1, d2, world);
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 3) {
            double d0 = 0.08;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.level().addParticle(new ParticleParamItem(Particles.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        movingobjectpositionentity.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide) {
            boolean hatching = this.random.nextInt(8) == 0;
            int b0 = 1;
            if (this.random.nextInt(32) == 0) {
                b0 = 4;
            }
            EntityType hatchingType = EntityType.CHICKEN;
            Entity shooter = this.getOwner();
            if (!hatching) {
                b0 = 0;
            }
            if (shooter instanceof EntityPlayer) {
                PlayerEggThrowEvent event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)b0, hatchingType);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                b0 = event.getNumHatches();
                hatching = event.isHatching();
                hatchingType = event.getHatchingType();
                if (!hatching) {
                    b0 = 0;
                }
            }
            for (int i2 = 0; i2 < b0; ++i2) {
                Entity entitychicken = this.level().getWorld().makeEntity(new Location((org.bukkit.World)this.level().getWorld(), this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f), hatchingType.getEntityClass());
                if (entitychicken == null) continue;
                if (entitychicken.getBukkitEntity() instanceof Ageable) {
                    ((Ageable)entitychicken.getBukkitEntity()).setBaby();
                }
                entitychicken.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                if (!entitychicken.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                this.level().addFreshEntity(entitychicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EGG;
    }
}

