/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EntityEnderPearl
extends EntityProjectileThrowable {
    public EntityEnderPearl(EntityTypes<? extends EntityEnderPearl> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntityEnderPearl(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.ENDER_PEARL, entityliving, world);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        movingobjectpositionentity.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        for (int i2 = 0; i2 < 32; ++i2) {
            this.level().addParticle(Particles.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && EntityEnderPearl.isAllowedToTeleportOwner(entity, worldserver)) {
                    if (entity.isPassenger()) {
                        entity.unRide();
                    }
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer entityplayer = (EntityPlayer)entity;
                        if (entityplayer.connection.isAcceptingMessages()) {
                            EntityEndermite entityendermite;
                            Entity tp = entity.changeDimension(new DimensionTransition(worldserver, this.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING, PlayerTeleportEvent.TeleportCause.ENDER_PEARL));
                            if (tp == null) {
                                this.discard(EntityRemoveEvent.Cause.HIT);
                                return;
                            }
                            if (this.random.nextFloat() < 0.05f && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (entityendermite = EntityTypes.ENDERMITE.create(worldserver)) != null) {
                                entityendermite.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                worldserver.addFreshEntity(entityendermite, CreatureSpawnEvent.SpawnReason.ENDER_PEARL);
                            }
                            entity.resetFallDistance();
                            entityplayer.resetCurrentImpulseContext();
                            entity.hurt(this.damageSources().fall().customEntityDamager(this), 5.0f);
                            this.playSound(worldserver, this.position());
                        }
                    } else {
                        entity.changeDimension(new DimensionTransition(worldserver, this.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        entity.resetFallDistance();
                        this.playSound(worldserver, this.position());
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity entity, World world) {
        if (entity.level().dimension() == world.dimension()) {
            if (!(entity instanceof EntityLiving)) {
                return entity.isAlive();
            }
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving.isAlive() && !entityliving.isSleeping();
        }
        return entity.canUsePortal(true);
    }

    @Override
    public void tick() {
        Entity entity = this.getOwner();
        if (entity instanceof EntityPlayer && !entity.isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            super.tick();
        }
    }

    private void playSound(World world, Vec3D vec3d) {
        world.playSound((EntityHuman)null, vec3d.x, vec3d.y, vec3d.z, SoundEffects.PLAYER_TELEPORT, SoundCategory.PLAYERS);
    }

    @Override
    public boolean canChangeDimensions(World world, World world1) {
        Entity entity;
        if (world.getTypeKey() == WorldDimension.END && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            return super.canChangeDimensions(world, world1) && entityplayer.seenCredits;
        }
        return super.canChangeDimensions(world, world1);
    }

    @Override
    protected void onInsideBlock(IBlockData iblockdata) {
        Entity entity;
        super.onInsideBlock(iblockdata);
        if (iblockdata.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.onInsideBlock(iblockdata);
        }
    }
}

