/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK = DataWatcher.defineId(EntityEnderSignal.class, DataWatcherRegistry.ITEM_STACK);
    public double tx;
    public double ty;
    public double tz;
    public int life;
    public boolean surviveAfterDeath;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> entitytypes, World world) {
        super(entitytypes, world);
    }

    public EntityEnderSignal(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.EYE_OF_ENDER, world);
        this.setPos(d0, d1, d2);
    }

    public void setItem(ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, itemstack.copyWithCount(1));
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_ITEM_STACK, this.getDefaultItem());
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    public void signalTo(BlockPosition blockposition) {
        double d3;
        double d0 = blockposition.getX();
        int i2 = blockposition.getY();
        double d1 = blockposition.getZ();
        double d2 = d0 - this.getX();
        double d4 = Math.sqrt(d2 * d2 + (d3 = d1 - this.getZ()) * d3);
        if (d4 > 12.0) {
            this.tx = this.getX() + d2 / d4 * 12.0;
            this.tz = this.getZ() + d3 / d4 * 12.0;
            this.ty = this.getY() + 8.0;
        } else {
            this.tx = d0;
            this.ty = i2;
            this.tz = d1;
        }
        this.life = 0;
        this.surviveAfterDeath = this.random.nextInt(5) > 0;
    }

    @Override
    public void lerpMotion(double d0, double d1, double d2) {
        this.setDeltaMovement(d0, d1, d2);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.setYRot((float)(MathHelper.atan2(d0, d2) * 57.2957763671875));
            this.setXRot((float)(MathHelper.atan2(d1, d3) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    @Override
    public void tick() {
        super.tick();
        Vec3D vec3d = this.getDeltaMovement();
        double d0 = this.getX() + vec3d.x;
        double d1 = this.getY() + vec3d.y;
        double d2 = this.getZ() + vec3d.z;
        double d3 = vec3d.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(vec3d.y, d3) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(vec3d.x, vec3d.z) * 57.2957763671875)));
        if (!this.level().isClientSide) {
            double d4 = this.tx - d0;
            double d5 = this.tz - d2;
            float f2 = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)MathHelper.atan2(d5, d4);
            double d6 = MathHelper.lerp(0.0025, d3, (double)f2);
            double d7 = vec3d.y;
            if (f2 < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int i2 = this.getY() < this.ty ? 1 : -1;
            vec3d = new Vec3D(Math.cos(f1) * d6, d7 + ((double)i2 - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.setDeltaMovement(vec3d);
        }
        float f2 = 0.25f;
        if (this.isInWater()) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.level().addParticle(Particles.BUBBLE, d0 - vec3d.x * 0.25, d1 - vec3d.y * 0.25, d2 - vec3d.z * 0.25, vec3d.x, vec3d.y, vec3d.z);
            }
        } else {
            this.level().addParticle(Particles.PORTAL, d0 - vec3d.x * 0.25 + this.random.nextDouble() * 0.6 - 0.3, d1 - vec3d.y * 0.25 - 0.5, d2 - vec3d.z * 0.25 + this.random.nextDouble() * 0.6 - 0.3, vec3d.x, vec3d.y, vec3d.z);
        }
        if (!this.level().isClientSide) {
            this.setPos(d0, d1, d2);
            ++this.life;
            if (this.life > 80 && !this.level().isClientSide) {
                this.playSound(SoundEffects.ENDER_EYE_DEATH, 1.0f, 1.0f);
                this.discard(this.surviveAfterDeath ? EntityRemoveEvent.Cause.DROP : EntityRemoveEvent.Cause.DESPAWN);
                if (this.surviveAfterDeath) {
                    this.level().addFreshEntity(new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem()));
                } else {
                    this.level().levelEvent(2003, this.blockPosition(), 0);
                }
            }
        } else {
            this.setPosRaw(d0, d1, d2);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.put("Item", this.getItem().save(this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.contains("Item", 10)) {
            ItemStack itemstack = ItemStack.parse(this.registryAccess(), nbttagcompound.getCompound("Item")).orElse(this.getDefaultItem());
            if (!itemstack.isEmpty()) {
                this.setItem(itemstack);
            }
        } else {
            this.setItem(this.getDefaultItem());
        }
    }

    private ItemStack getDefaultItem() {
        return new ItemStack(Items.ENDER_EYE);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }
}

