/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean biting;
    private int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    public static final DataWatcherObject<Integer> DATA_HOOKED_ENTITY = DataWatcher.defineId(EntityFishingHook.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_BITING = DataWatcher.defineId(EntityFishingHook.class, DataWatcherRegistry.BOOLEAN);
    private int life;
    private int nibble;
    public int timeUntilLured;
    public int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    public Entity hookedIn;
    public HookState currentState = HookState.FLYING;
    private final int luck;
    private final int lureSpeed;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world, int i2, int j2) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.noCulling = true;
        this.luck = Math.max(0, i2);
        this.lureSpeed = Math.max(0, j2);
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world) {
        this(entitytypes, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman entityhuman, World world, int i2, int j2) {
        this(EntityTypes.FISHING_BOBBER, world, i2, j2);
        this.setOwner(entityhuman);
        float f2 = entityhuman.getXRot();
        float f1 = entityhuman.getYRot();
        float f22 = MathHelper.cos(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.sin(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.cos(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.sin(-f2 * ((float)Math.PI / 180));
        double d0 = entityhuman.getX() - (double)f3 * 0.3;
        double d1 = entityhuman.getEyeY();
        double d2 = entityhuman.getZ() - (double)f22 * 0.3;
        this.moveTo(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.clamp(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.length();
        vec3d = vec3d.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3d);
        this.setYRot((float)(MathHelper.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(vec3d.y, vec3d.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_HOOKED_ENTITY, 0);
        datawatcher_a.define(DATA_BITING, false);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_HOOKED_ENTITY.equals(datawatcherobject)) {
            int i2 = this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i2 > 0 ? this.level().getEntity(i2 - 1) : null;
        }
        if (DATA_BITING.equals(datawatcherobject)) {
            this.biting = this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * MathHelper.nextFloat(this.syncronizedRandom, 0.6f, 1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = 64.0;
        return d0 < 4096.0;
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
    }

    @Override
    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        super.tick();
        EntityHuman entityhuman = this.getPlayerOwner();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.level().isClientSide || !this.shouldStopFishing(entityhuman)) {
            boolean flag;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.life = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.blockPosition();
            Fluid fluid = this.level().getFluidState(blockposition);
            if (fluid.is(TagsFluid.WATER)) {
                f2 = fluid.getHeight(this.level(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.currentState == HookState.FLYING) {
                if (this.hookedIn != null) {
                    this.setDeltaMovement(Vec3D.ZERO);
                    this.currentState = HookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = HookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == HookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.isRemoved() && this.hookedIn.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = HookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == HookState.BOBBING) {
                    Vec3D vec3d = this.getDeltaMovement();
                    double d0 = this.getY() + vec3d.y - (double)blockposition.getY() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(vec3d.x * 0.9, vec3d.y - d0 * (double)this.random.nextFloat() * 0.2, vec3d.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockposition);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide) {
                            this.catchingFish(blockposition);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluid.is(TagsFluid.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.currentState == HookState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3D.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    private boolean shouldStopFishing(EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.getMainHandItem();
        ItemStack itemstack1 = entityhuman.getOffhandItem();
        boolean flag = itemstack.is(Items.FISHING_ROD);
        boolean flag1 = itemstack1.is(Items.FISHING_ROD);
        if (!entityhuman.isRemoved() && entityhuman.isAlive() && (flag || flag1) && this.distanceToSqr(entityhuman) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void checkCollision() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) || entity.isAlive() && entity instanceof EntityItem;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        if (!this.level().isClientSide) {
            this.setHookedEntity(movingobjectpositionentity.getEntity());
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(movingobjectpositionblock.distanceTo(this)));
    }

    public void setHookedEntity(@Nullable Entity entity) {
        this.hookedIn = entity;
        this.getEntityData().set(DATA_HOOKED_ENTITY, entity == null ? 0 : entity.getId() + 1);
    }

    private void catchingFish(BlockPosition blockposition) {
        WorldServer worldserver = (WorldServer)this.level();
        int i2 = 1;
        BlockPosition blockposition1 = blockposition.above();
        if (this.rainInfluenced && this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockposition1)) {
            --i2;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i2;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f2 = this.fishAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.sin(f2);
                float f22 = MathHelper.cos(f2);
                double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                IBlockData iblockdata = worldserver.getBlockState(BlockPosition.containing(d0, (d1 = (double)((float)MathHelper.floor(this.getY()) + 1.0f)) - 1.0, d2 = this.getZ() + (double)(f22 * (float)this.timeUntilHooked * 0.1f)));
                if (iblockdata.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        worldserver.sendParticles(Particles.BUBBLE, d0, d1 - (double)0.1f, d2, 1, f1, 0.1, f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.sendParticles(Particles.FISHING, d0, d1, d2, 0, f4, 0.01, -f3, 1.0);
                    worldserver.sendParticles(Particles.FISHING, d0, d1, d2, 0, -f4, 0.01, f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.playSound(SoundEffects.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getY() + 0.5;
                worldserver.sendParticles(Particles.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                worldserver.sendParticles(Particles.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                this.nibble = MathHelper.nextInt(this.random, 20, 40);
                this.getEntityData().set(DATA_BITING, true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i2;
            float f3 = 0.15f;
            if (this.timeUntilLured < 20) {
                f3 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f3 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f3 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f3) {
                double d2;
                double d1;
                float f1 = MathHelper.nextFloat(this.random, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.nextFloat(this.random, 25.0f, 60.0f);
                double d0 = this.getX() + (double)(MathHelper.sin(f1) * f2) * 0.1;
                IBlockData iblockdata = worldserver.getBlockState(BlockPosition.containing(d0, (d1 = (double)((float)MathHelper.floor(this.getY()) + 1.0f)) - 1.0, d2 = this.getZ() + (double)(MathHelper.cos(f1) * f2) * 0.1));
                if (iblockdata.is(Blocks.WATER)) {
                    worldserver.sendParticles(Particles.SPLASH, d0, d1, d2, 2 + this.random.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = MathHelper.nextFloat(this.random, this.minLureAngle, this.maxLureAngle);
                this.timeUntilHooked = MathHelper.nextInt(this.random, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.timeUntilLured = MathHelper.nextInt(this.random, this.minWaitTime, this.maxWaitTime);
            this.timeUntilLured -= this.applyLure ? this.lureSpeed : 0;
        }
    }

    private boolean calculateOpenWater(BlockPosition blockposition) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.INVALID;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.getOpenWaterTypeForArea(blockposition.offset(-2, i2, -2), blockposition.offset(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.INVALID) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.ABOVE_WATER) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition getOpenWaterTypeForArea(BlockPosition blockposition, BlockPosition blockposition1) {
        return BlockPosition.betweenClosedStream(blockposition, blockposition1).map(this::getOpenWaterTypeForBlock).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.INVALID).orElse(WaterPosition.INVALID);
    }

    private WaterPosition getOpenWaterTypeForBlock(BlockPosition blockposition) {
        IBlockData iblockdata = this.level().getBlockState(blockposition);
        if (!iblockdata.isAir() && !iblockdata.is(Blocks.LILY_PAD)) {
            Fluid fluid = iblockdata.getFluidState();
            return fluid.is(TagsFluid.WATER) && fluid.isSource() && iblockdata.getCollisionShape(this.level(), blockposition).isEmpty() ? WaterPosition.INSIDE_WATER : WaterPosition.INVALID;
        }
        return WaterPosition.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
    }

    public int retrieve(ItemStack itemstack) {
        EntityHuman entityhuman = this.getPlayerOwner();
        if (!this.level().isClientSide && entityhuman != null && !this.shouldStopFishing(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.hookedIn != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.hookedIn.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.pullEntity(this.hookedIn);
                CriterionTriggers.FISHING_ROD_HOOKED.trigger((EntityPlayer)entityhuman, itemstack, this, Collections.emptyList());
                this.level().broadcastEntityEvent(this, (byte)31);
                i2 = this.hookedIn instanceof EntityItem ? 3 : 5;
            } else if (this.nibble > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.TOOL, itemstack).withParameter(LootContextParameters.THIS_ENTITY, this).withLuck((float)this.luck + entityhuman.getLuck()).create(LootContextParameterSets.FISHING);
                LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(LootTables.FISHING);
                ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
                CriterionTriggers.FISHING_ROD_HOOKED.trigger((EntityPlayer)entityhuman, itemstack, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    EntityItem entityitem = new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), itemstack1);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)entityitem.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.random.nextInt(6) + 1);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.getX() - this.getX();
                    double d1 = entityhuman.getY() - this.getY();
                    double d2 = entityhuman.getZ() - this.getZ();
                    double d3 = 0.1;
                    entityitem.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity(entityitem);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.level().addFreshEntity(new EntityExperienceOrb(entityhuman.level(), entityhuman.getX(), entityhuman.getY() + 0.5, entityhuman.getZ() + 0.5, playerFishEvent2.getExpToDrop()));
                    }
                    if (!itemstack1.is(TagsItem.FISHES)) continue;
                    entityhuman.awardStat(StatisticList.FISH_CAUGHT, 1);
                }
                i2 = 1;
            }
            if (this.onGround()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 31 && this.level().isClientSide && this.hookedIn instanceof EntityHuman && ((EntityHuman)this.hookedIn).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(b0);
    }

    public void pullEntity(Entity entity) {
        Entity entity1 = this.getOwner();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.getX() - this.getX(), entity1.getY() - this.getY(), entity1.getZ() - this.getZ()).scale(0.1);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.updateOwnerInfo(null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable EntityFishingHook entityfishinghook) {
        EntityHuman entityhuman = this.getPlayerOwner();
        if (entityhuman != null) {
            entityhuman.fishing = entityfishinghook;
        }
    }

    @Nullable
    public EntityHuman getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof EntityHuman ? (EntityHuman)entity : null;
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.getOwner();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? this.getId() : entity.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        if (this.getPlayerOwner() == null) {
            int i2 = packetplayoutspawnentity.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity(i2), (Object)i2);
            this.kill();
        }
    }

    public static enum HookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    private static enum WaterPosition {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

