/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLlamaSpit
extends IProjectile {
    public EntityLlamaSpit(EntityTypes<? extends EntityLlamaSpit> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityLlamaSpit(World world, EntityLlama entityllama) {
        this((EntityTypes<? extends EntityLlamaSpit>)EntityTypes.LLAMA_SPIT, world);
        this.setOwner(entityllama);
        this.setPos(entityllama.getX() - (double)(entityllama.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.sin(entityllama.yBodyRot * ((float)Math.PI / 180)), entityllama.getEyeY() - (double)0.1f, entityllama.getZ() + (double)(entityllama.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.cos(entityllama.yBodyRot * ((float)Math.PI / 180)));
    }

    @Override
    protected double getDefaultGravity() {
        return 0.06;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3D vec3d = this.getDeltaMovement();
        MovingObjectPosition movingobjectposition = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
        double d0 = this.getX() + vec3d.x;
        double d1 = this.getY() + vec3d.y;
        double d2 = this.getZ() + vec3d.z;
        this.updateRotation();
        float f2 = 0.99f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBase.BlockData::isAir)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.isInWaterOrBubble()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.setDeltaMovement(vec3d.scale(0.99f));
            this.applyGravity();
            this.setPos(d0, d1, d2);
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            World world;
            DamageSource damagesource;
            EntityLiving entityliving = (EntityLiving)entity;
            entity = movingobjectpositionentity.getEntity();
            if (entity.hurt(damagesource = this.damageSources().spit(this, entityliving), 1.0f) && (world = this.level()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.doPostAttackEffects(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        double d0 = packetplayoutspawnentity.getXa();
        double d1 = packetplayoutspawnentity.getYa();
        double d2 = packetplayoutspawnentity.getZa();
        for (int i2 = 0; i2 < 7; ++i2) {
            double d3 = 0.4 + 0.1 * (double)i2;
            this.level().addParticle(Particles.SPIT, this.getX(), this.getY(), this.getZ(), d0 * d3, d1, d2 * d3);
        }
        this.setDeltaMovement(d0, d1, d2);
    }
}

