/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<EntityLiving> WATER_SENSITIVE_OR_ON_FIRE = entityliving -> entityliving.isSensitiveToWater() || entityliving.isOnFire();

    public EntityPotion(EntityTypes<? extends EntityPotion> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntityPotion(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, entityliving, world);
    }

    public EntityPotion(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, d0, d1, d2, world);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            EnumDirection enumdirection = movingobjectpositionblock.getDirection();
            BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.dowseFire(blockposition1);
                this.dowseFire(blockposition1.relative(enumdirection.getOpposite()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                    this.dowseFire(blockposition1.relative(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.applyWater();
            } else if (this.isLingering()) {
                this.makeAreaOfEffectCloud(potioncontents, movingobjectposition);
            } else {
                this.applySplash(potioncontents.getAllEffects(), movingobjectposition.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY ? ((MovingObjectPositionEntity)movingobjectposition).getEntity() : null, movingobjectposition);
            }
            int i2 = potioncontents.potion().isPresent() && potioncontents.potion().get().value().hasInstantEffects() ? 2007 : 2002;
            this.level().levelEvent(i2, this.blockPosition(), potioncontents.getColor());
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private void applyWater() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.level().getEntitiesOfClass(EntityLiving.class, axisalignedbb, WATER_SENSITIVE_OR_ON_FIRE);
        for (EntityLiving entityliving : list) {
            double d0 = this.distanceToSqr(entityliving);
            if (!(d0 < 16.0)) continue;
            if (entityliving.isSensitiveToWater()) {
                entityliving.hurt(this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!entityliving.isOnFire() || !entityliving.isAlive()) continue;
            entityliving.extinguishFire();
        }
        List<Axolotl> list1 = this.level().getEntitiesOfClass(Axolotl.class, axisalignedbb);
        for (Axolotl axolotl : list1) {
            axolotl.rehydrate();
        }
    }

    private void applySplash(Iterable<MobEffect> iterable, @Nullable Entity entity, MovingObjectPosition position) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.level().getEntitiesOfClass(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity1 = this.getEffectSource();
            for (EntityLiving entityliving : list) {
                double d0;
                if (!entityliving.isAffectedByPotions() || !((d0 = this.distanceToSqr(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, position, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.getEffectSource();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : iterable) {
                    MobEffectList mobeffectlist;
                    Holder<MobEffectList> holder = mobeffect.getEffect();
                    if (!this.level().pvpMode && this.getOwner() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.getOwner() && ((mobeffectlist = holder.value()) == MobEffects.MOVEMENT_SLOWDOWN || mobeffectlist == MobEffects.DIG_SLOWDOWN || mobeffectlist == MobEffects.HARM || mobeffectlist == MobEffects.BLINDNESS || mobeffectlist == MobEffects.HUNGER || mobeffectlist == MobEffects.WEAKNESS || mobeffectlist == MobEffects.POISON)) continue;
                    if (holder.value().isInstantenous()) {
                        holder.value().applyInstantenousEffect(this, this.getOwner(), entityliving, mobeffect.getAmplifier(), d1);
                        continue;
                    }
                    int i2 = mobeffect.mapDuration(j2 -> (int)(d1 * (double)j2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(holder, i2, mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible());
                    if (mobeffect1.endsWithin(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents potioncontents, MovingObjectPosition position) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityareaeffectcloud.setOwner(entityliving);
        }
        entityareaeffectcloud.setRadius(3.0f);
        entityareaeffectcloud.setRadiusOnUse(-0.5f);
        entityareaeffectcloud.setWaitTime(10);
        entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
        entityareaeffectcloud.setPotionContents(potioncontents);
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, position, entityareaeffectcloud);
        if (!event.isCancelled() && !entityareaeffectcloud.isRemoved()) {
            this.level().addFreshEntity(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.discard(null);
        }
    }

    public boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPosition blockposition) {
        IBlockData iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.is(TagsBlock.FIRE)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.AIR.defaultBlockState())) {
                this.level().destroyBlock(blockposition, false, this);
            }
        } else if (AbstractCandleBlock.isLit(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.setValue(AbstractCandleBlock.LIT, false))) {
                AbstractCandleBlock.extinguish(null, iblockdata, this.level(), blockposition);
            }
        } else if (BlockCampfire.isLitCampfire(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.setValue(BlockCampfire.LIT, false))) {
            this.level().levelEvent(null, 1009, blockposition, 0);
            BlockCampfire.dowse(this.getOwner(), this.level(), blockposition, iblockdata);
            this.level().setBlockAndUpdate(blockposition, (IBlockData)iblockdata.setValue(BlockCampfire.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.position().x - this.position().x;
        double d1 = entityliving.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

