/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySnowball
extends EntityProjectileThrowable {
    public EntitySnowball(EntityTypes<? extends EntitySnowball> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntitySnowball(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.SNOWBALL, entityliving, world);
    }

    public EntitySnowball(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.SNOWBALL, d0, d1, d2, world);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SNOWBALL;
    }

    private ParticleParam getParticle() {
        ItemStack itemstack = this.getItem();
        return !itemstack.isEmpty() && !itemstack.is(this.getDefaultItem()) ? new ParticleParamItem(Particles.ITEM, itemstack) : Particles.ITEM_SNOWBALL;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 3) {
            ParticleParam particleparam = this.getParticle();
            for (int i2 = 0; i2 < 8; ++i2) {
                this.level().addParticle(particleparam, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.getEntity();
        int i2 = entity instanceof EntityBlaze ? 3 : 0;
        entity.hurt(this.damageSources().thrown(this, this.getOwner()), i2);
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

