/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityThrownTrident
extends EntityArrow {
    private static final DataWatcherObject<Byte> ID_LOYALTY = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Boolean> ID_FOIL = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BOOLEAN);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public EntityThrownTrident(EntityTypes<? extends EntityThrownTrident> entitytypes, World world) {
        super((EntityTypes<? extends EntityArrow>)entitytypes, world);
    }

    public EntityThrownTrident(World world, EntityLiving entityliving, ItemStack itemstack) {
        super(EntityTypes.TRIDENT, entityliving, world, itemstack, null);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(itemstack));
        this.entityData.set(ID_FOIL, itemstack.hasFoil());
    }

    public EntityThrownTrident(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityTypes.TRIDENT, d0, d1, d2, world, itemstack, itemstack);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(itemstack));
        this.entityData.set(ID_FOIL, itemstack.hasFoil());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(ID_LOYALTY, (byte)0);
        datawatcher_a.define(ID_FOIL, false);
    }

    @Override
    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte b0 = this.entityData.get(ID_LOYALTY);
        if (b0 > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == EntityArrow.PickupStatus.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard(EntityRemoveEvent.Cause.DROP);
            } else {
                this.setNoPhysics(true);
                Vec3D vec3d = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3d.y * 0.015 * (double)b0, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)b0;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEffects.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        return entity != null && entity.isAlive() ? !(entity instanceof EntityPlayer) || !entity.isSpectator() : false;
    }

    public boolean isFoil() {
        return this.entityData.get(ID_FOIL);
    }

    @Override
    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D vec3d, Vec3D vec3d1) {
        return this.dealtDamage ? null : super.findHitEntity(vec3d, vec3d1);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        WorldServer worldserver;
        Entity entity = movingobjectpositionentity.getEntity();
        float f2 = 8.0f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident(this, entity1 == null ? this : entity1);
        World world = this.level();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            f2 = EnchantmentManager.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, f2);
        }
        this.dealtDamage = true;
        if (entity.hurt(damagesource, f2)) {
            if (entity.getType() == EntityTypes.ENDERMAN) {
                return;
            }
            world = this.level();
            if (world instanceof WorldServer) {
                worldserver = (WorldServer)world;
                EnchantmentManager.doPostAttackEffectsWithItemSource(worldserver, entity, damagesource, this.getWeaponItem());
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.doKnockback(entityliving, damagesource);
                this.doPostHurtEffects(entityliving);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEffects.TRIDENT_HIT, 1.0f, 1.0f);
    }

    @Override
    protected void hitBlockEnchantmentEffects(WorldServer worldserver, MovingObjectPositionBlock movingobjectpositionblock, ItemStack itemstack) {
        EntityLiving entityliving1;
        Vec3D vec3d = movingobjectpositionblock.getBlockPos().clampLocationWithin(movingobjectpositionblock.getLocation());
        Entity entity = this.getOwner();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.onHitBlock(worldserver, itemstack, entityliving, this, null, vec3d, worldserver.getBlockState(movingobjectpositionblock.getBlockPos()), item -> this.kill());
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    @Override
    protected boolean tryPickup(EntityHuman entityhuman) {
        return super.tryPickup(entityhuman) || this.isNoPhysics() && this.ownedBy(entityhuman) && entityhuman.getInventory().add(this.getPickupItem());
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.TRIDENT);
    }

    @Override
    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.TRIDENT_HIT_GROUND;
    }

    @Override
    public void playerTouch(EntityHuman entityhuman) {
        if (this.ownedBy(entityhuman) || this.getOwner() == null) {
            super.playerTouch(entityhuman);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.dealtDamage = nbttagcompound.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putBoolean("DealtDamage", this.dealtDamage);
    }

    private byte getLoyaltyFromItem(ItemStack itemstack) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return (byte)MathHelper.clamp(EnchantmentManager.getTridentReturnToOwnerAcceleration(worldserver, itemstack, this), 0, 127);
        }
        return 0;
    }

    @Override
    public void tickDespawn() {
        byte b0 = this.entityData.get(ID_LOYALTY);
        if (this.pickup != EntityArrow.PickupStatus.ALLOWED || b0 <= 0) {
            super.tickDespawn();
        }
    }

    @Override
    protected float getWaterInertia() {
        return 0.99f;
    }

    @Override
    public boolean shouldRender(double d0, double d1, double d2) {
        return true;
    }
}

