/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityTippedArrow
extends EntityArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final DataWatcherObject<Integer> ID_EFFECT_COLOR = DataWatcher.defineId(EntityTippedArrow.class, DataWatcherRegistry.INT);
    private static final byte EVENT_POTION_PUFF = 0;

    public EntityTippedArrow(EntityTypes<? extends EntityTippedArrow> entitytypes, World world) {
        super((EntityTypes<? extends EntityArrow>)entitytypes, world);
    }

    public EntityTippedArrow(World world, double d0, double d1, double d2, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        super(EntityTypes.ARROW, d0, d1, d2, world, itemstack, itemstack1);
        this.updateColor();
    }

    public EntityTippedArrow(World world, EntityLiving entityliving, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        super(EntityTypes.ARROW, entityliving, world, itemstack, itemstack1);
        this.updateColor();
    }

    public PotionContents getPotionContents() {
        return this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
    }

    public void setPotionContents(PotionContents potioncontents) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, potioncontents);
        this.updateColor();
    }

    @Override
    protected void setPickupItemStack(ItemStack itemstack) {
        super.setPickupItemStack(itemstack);
        this.updateColor();
    }

    public void updateColor() {
        PotionContents potioncontents = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, potioncontents.equals(PotionContents.EMPTY) ? -1 : potioncontents.getColor());
    }

    public void addEffect(MobEffect mobeffect) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(mobeffect));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(ID_EFFECT_COLOR, -1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.getPotionContents().equals(PotionContents.EMPTY) && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent(this, (byte)0);
            this.setPickupItemStack(new ItemStack(Items.ARROW));
        }
    }

    private void makeParticle(int i2) {
        int j2 = this.getColor();
        if (j2 != -1 && i2 > 0) {
            for (int k2 = 0; k2 < i2; ++k2) {
                this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, j2), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return this.entityData.get(ID_EFFECT_COLOR);
    }

    @Override
    protected void doPostHurtEffects(EntityLiving entityliving) {
        super.doPostHurtEffects(entityliving);
        Entity entity = this.getEffectSource();
        PotionContents potioncontents = this.getPotionContents();
        if (potioncontents.potion().isPresent()) {
            for (MobEffect mobeffect : potioncontents.potion().get().value().getEffects()) {
                entityliving.addEffect(new MobEffect(mobeffect.getEffect(), Math.max(mobeffect.mapDuration(i2 -> i2 / 8), 1), mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible()), entity, EntityPotionEffectEvent.Cause.ARROW);
            }
        }
        for (MobEffect mobeffect : potioncontents.customEffects()) {
            entityliving.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.ARROW);
        }
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.ARROW);
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 0) {
            int i2 = this.getColor();
            if (i2 != -1) {
                float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
                float f22 = (float)(i2 >> 0 & 0xFF) / 255.0f;
                for (int j2 = 0; j2 < 20; ++j2) {
                    this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, f2, f1, f22), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(b0);
        }
    }
}

