/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataWatcherObject<Boolean> DATA_DANGEROUS = DataWatcher.defineId(EntityWitherSkull.class, DataWatcherRegistry.BOOLEAN);

    public EntityWitherSkull(EntityTypes<? extends EntityWitherSkull> entitytypes, World world) {
        super((EntityTypes<? extends EntityFireball>)entitytypes, world);
    }

    public EntityWitherSkull(World world, EntityLiving entityliving, Vec3D vec3d) {
        super(EntityTypes.WITHER_SKULL, entityliving, vec3d, world);
    }

    @Override
    protected float getInertia() {
        return this.isDangerous() ? 0.73f : super.getInertia();
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public float getBlockExplosionResistance(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return this.isDangerous() && EntityWither.canDestroy(iblockdata) ? Math.min(0.8f, f2) : f2;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        World world = this.level();
        if (world instanceof WorldServer) {
            boolean flag;
            EntityLiving entityliving;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = movingobjectpositionentity.getEntity();
            Entity entity1 = this.getOwner();
            if (entity1 instanceof EntityLiving) {
                entityliving = (EntityLiving)entity1;
                DamageSource damagesource = this.damageSources().witherSkull(this, entityliving);
                flag = entity.hurt(damagesource, 8.0f);
                if (flag) {
                    if (entity.isAlive()) {
                        EnchantmentManager.doPostAttackEffects(worldserver, entity, damagesource);
                    } else {
                        entityliving.heal(5.0f, EntityRegainHealthEvent.RegainReason.WITHER);
                    }
                }
            } else {
                flag = entity.hurt(this.damageSources().magic(), 5.0f);
            }
            if (flag && entity instanceof EntityLiving) {
                entityliving = (EntityLiving)entity;
                int b0 = 0;
                if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                    b0 = 10;
                } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                    b0 = 40;
                }
                if (b0 > 0) {
                    entityliving.addEffect(new MobEffect(MobEffects.WITHER, 20 * b0, 1), this.getEffectSource(), EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide) {
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f, false);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), World.a.MOB);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        return false;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_DANGEROUS, false);
    }

    public boolean isDangerous() {
        return this.entityData.get(DATA_DANGEROUS);
    }

    public void setDangerous(boolean flag) {
        this.entityData.set(DATA_DANGEROUS, flag);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putBoolean("dangerous", this.isDangerous());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setDangerous(nbttagcompound.getBoolean("dangerous"));
    }
}

