/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;
    @Nullable
    private Entity lastDeflectedBy;
    private boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> entitytypes, World world) {
        super(entitytypes, world);
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.getUUID();
            this.cachedOwner = entity;
        }
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Override
    @Nullable
    public Entity getOwner() {
        World world;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.cachedOwner = worldserver.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (this.ownerUUID != null) {
            nbttagcompound.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            nbttagcompound.putBoolean("LeftOwner", true);
        }
        nbttagcompound.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasUUID("Owner")) {
            this.ownerUUID = nbttagcompound.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = nbttagcompound.getBoolean("LeftOwner");
        this.hasBeenShot = nbttagcompound.getBoolean("HasBeenShot");
    }

    @Override
    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)entity;
            this.cachedOwner = iprojectile.cachedOwner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity12 : this.level().getEntities(this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), entity1 -> !entity1.isSpectator() && entity1.isPickable())) {
                if (entity12.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3D getMovementToShoot(double d0, double d1, double d2, float f2, float f1) {
        return new Vec3D(d0, d1, d2).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)f1), this.random.triangle(0.0, 0.0172275 * (double)f1), this.random.triangle(0.0, 0.0172275 * (double)f1)).scale(f2);
    }

    public void shoot(double d0, double d1, double d2, float f2, float f1) {
        Vec3D vec3d = this.getMovementToShoot(d0, d1, d2, f2, f1);
        this.setDeltaMovement(vec3d);
        this.hasImpulse = true;
        double d3 = vec3d.horizontalDistance();
        this.setYRot((float)(MathHelper.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(vec3d.y, d3) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity entity, float f2, float f1, float f22, float f3, float f4) {
        float f5 = -MathHelper.sin(f1 * ((float)Math.PI / 180)) * MathHelper.cos(f2 * ((float)Math.PI / 180));
        float f6 = -MathHelper.sin((f2 + f22) * ((float)Math.PI / 180));
        float f7 = MathHelper.cos(f1 * ((float)Math.PI / 180)) * MathHelper.cos(f2 * ((float)Math.PI / 180));
        this.shoot(f5, f6, f7, f3, f4);
        Vec3D vec3d = entity.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d.x, entity.onGround() ? 0.0 : vec3d.y, vec3d.z));
    }

    protected ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK || !this.hitCancelled) {
            return this.hitTargetOrDeflectSelf(movingobjectposition);
        }
        return ProjectileDeflection.NONE;
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        MovingObjectPositionEntity movingobjectpositionentity;
        Entity entity;
        ProjectileDeflection projectiledeflection;
        if (movingobjectposition.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY && (projectiledeflection = (entity = (movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition).getEntity()).deflection(this)) != ProjectileDeflection.NONE) {
            if (entity != this.lastDeflectedBy && this.deflect(projectiledeflection, entity, this.getOwner(), false)) {
                this.lastDeflectedBy = entity;
            }
            return projectiledeflection;
        }
        this.onHit(movingobjectposition);
        return ProjectileDeflection.NONE;
    }

    public boolean deflect(ProjectileDeflection projectiledeflection, @Nullable Entity entity, @Nullable Entity entity1, boolean flag) {
        if (!this.level().isClientSide) {
            projectiledeflection.deflect(this, entity, this.random);
            this.setOwner(entity1);
            this.onDeflection(entity, flag);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity entity, boolean flag) {
    }

    protected void onHit(MovingObjectPosition movingobjectposition) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = movingobjectposition.getType();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.getEntity();
            if (entity.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                iprojectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(movingobjectpositionentity);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, movingobjectposition.getLocation(), GameEvent.a.of(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition;
            this.onHitBlock(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, blockposition, GameEvent.a.of(this, this.level().getBlockState(blockposition)));
        }
    }

    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
    }

    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.level().getBlockState(movingobjectpositionblock.getBlockPos());
        iblockdata.onProjectileHit(this.level(), iblockdata, movingobjectpositionblock, this);
    }

    @Override
    public void lerpMotion(double d0, double d1, double d2) {
        this.setDeltaMovement(d0, d1, d2);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.setXRot((float)(MathHelper.atan2(d1, d3) * 57.2957763671875));
            this.setYRot((float)(MathHelper.atan2(d0, d2) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.canBeHitByProjectile()) {
            return false;
        }
        Entity entity1 = this.getOwner();
        return entity1 == null || this.leftOwner || !entity1.isPassengerOfSameVehicle(entity);
    }

    protected void updateRotation() {
        Vec3D vec3d = this.getDeltaMovement();
        double d0 = vec3d.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(vec3d.y, d0) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(vec3d.x, vec3d.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float f2, float f1) {
        while (f1 - f2 < -180.0f) {
            f2 -= 360.0f;
        }
        while (f1 - f2 >= 180.0f) {
            f2 += 360.0f;
        }
        return MathHelper.lerp(0.2f, f2, f1);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.getOwner();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? 0 : entity.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        Entity entity = this.level().getEntity(packetplayoutspawnentity.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    @Override
    public boolean mayInteract(World world, BlockPosition blockposition) {
        Entity entity = this.getOwner();
        return entity instanceof EntityHuman ? entity.mayInteract(world, blockposition) : entity == null || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(World world) {
        return this.getType().is(TagsEntity.IMPACT_PROJECTILES) && world.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = this.getDeltaMovement().x;
        double d1 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

