/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class ProjectileHelper {
    private static final float DEFAULT_ENTITY_HIT_RESULT_MARGIN = 0.3f;

    public static MovingObjectPosition getHitResultOnMoveVector(Entity var0, Predicate<Entity> var1) {
        Vec3D var2 = var0.getDeltaMovement();
        World var3 = var0.level();
        Vec3D var4 = var0.position();
        return ProjectileHelper.getHitResult(var4, var0, var1, var2, var3, 0.3f, RayTrace.BlockCollisionOption.COLLIDER);
    }

    public static MovingObjectPosition getHitResultOnMoveVector(Entity var0, Predicate<Entity> var1, RayTrace.BlockCollisionOption var2) {
        Vec3D var3 = var0.getDeltaMovement();
        World var4 = var0.level();
        Vec3D var5 = var0.position();
        return ProjectileHelper.getHitResult(var5, var0, var1, var3, var4, 0.3f, var2);
    }

    public static MovingObjectPosition getHitResultOnViewVector(Entity var0, Predicate<Entity> var1, double var2) {
        Vec3D var4 = var0.getViewVector(0.0f).scale(var2);
        World var5 = var0.level();
        Vec3D var6 = var0.getEyePosition();
        return ProjectileHelper.getHitResult(var6, var0, var1, var4, var5, 0.0f, RayTrace.BlockCollisionOption.COLLIDER);
    }

    private static MovingObjectPosition getHitResult(Vec3D var0, Entity var1, Predicate<Entity> var2, Vec3D var3, World var4, float var5, RayTrace.BlockCollisionOption var6) {
        MovingObjectPositionEntity var9;
        Vec3D var7 = var0.add(var3);
        MovingObjectPosition var8 = var4.clip(new RayTrace(var0, var7, var6, RayTrace.FluidCollisionOption.NONE, var1));
        if (((MovingObjectPosition)var8).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            var7 = var8.getLocation();
        }
        if ((var9 = ProjectileHelper.getEntityHitResult(var4, var1, var0, var7, var1.getBoundingBox().expandTowards(var3).inflate(1.0), var2, var5)) != null) {
            var8 = var9;
        }
        return var8;
    }

    @Nullable
    public static MovingObjectPositionEntity getEntityHitResult(Entity var0, Vec3D var1, Vec3D var2, AxisAlignedBB var3, Predicate<Entity> var4, double var5) {
        World var7 = var0.level();
        double var8 = var5;
        Entity var10 = null;
        Vec3D var11 = null;
        for (Entity var13 : var7.getEntities(var0, var3, var4)) {
            Vec3D var16;
            double var17;
            AxisAlignedBB var14 = var13.getBoundingBox().inflate(var13.getPickRadius());
            Optional<Vec3D> var15 = var14.clip(var1, var2);
            if (var14.contains(var1)) {
                if (!(var8 >= 0.0)) continue;
                var10 = var13;
                var11 = var15.orElse(var1);
                var8 = 0.0;
                continue;
            }
            if (!var15.isPresent() || !((var17 = var1.distanceToSqr(var16 = var15.get())) < var8) && var8 != 0.0) continue;
            if (var13.getRootVehicle() == var0.getRootVehicle()) {
                if (var8 != 0.0) continue;
                var10 = var13;
                var11 = var16;
                continue;
            }
            var10 = var13;
            var11 = var16;
            var8 = var17;
        }
        if (var10 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(var10, var11);
    }

    @Nullable
    public static MovingObjectPositionEntity getEntityHitResult(World var0, Entity var1, Vec3D var2, Vec3D var3, AxisAlignedBB var4, Predicate<Entity> var5) {
        return ProjectileHelper.getEntityHitResult(var0, var1, var2, var3, var4, var5, 0.3f);
    }

    @Nullable
    public static MovingObjectPositionEntity getEntityHitResult(World var0, Entity var1, Vec3D var2, Vec3D var3, AxisAlignedBB var4, Predicate<Entity> var5, float var6) {
        double var7 = Double.MAX_VALUE;
        Entity var9 = null;
        for (Entity var11 : var0.getEntities(var1, var4, var5)) {
            double var14;
            AxisAlignedBB var12 = var11.getBoundingBox().inflate(var6);
            Optional<Vec3D> var13 = var12.clip(var2, var3);
            if (!var13.isPresent() || !((var14 = var2.distanceToSqr(var13.get())) < var7)) continue;
            var9 = var11;
            var7 = var14;
        }
        if (var9 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(var9);
    }

    public static void rotateTowardsMovement(Entity var0, float var1) {
        Vec3D var2 = var0.getDeltaMovement();
        if (var2.lengthSqr() == 0.0) {
            return;
        }
        double var3 = var2.horizontalDistance();
        var0.setYRot((float)(MathHelper.atan2(var2.z, var2.x) * 57.2957763671875) + 90.0f);
        var0.setXRot((float)(MathHelper.atan2(var3, var2.y) * 57.2957763671875) - 90.0f);
        while (var0.getXRot() - var0.xRotO < -180.0f) {
            var0.xRotO -= 360.0f;
        }
        while (var0.getXRot() - var0.xRotO >= 180.0f) {
            var0.xRotO += 360.0f;
        }
        while (var0.getYRot() - var0.yRotO < -180.0f) {
            var0.yRotO -= 360.0f;
        }
        while (var0.getYRot() - var0.yRotO >= 180.0f) {
            var0.yRotO += 360.0f;
        }
        var0.setXRot(MathHelper.lerp(var1, var0.xRotO, var0.getXRot()));
        var0.setYRot(MathHelper.lerp(var1, var0.yRotO, var0.getYRot()));
    }

    public static EnumHand getWeaponHoldingHand(EntityLiving var0, Item var1) {
        return var0.getMainHandItem().is(var1) ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public static EntityArrow getMobArrow(EntityLiving var0, ItemStack var1, float var2, @Nullable ItemStack var3) {
        ItemArrow var4 = (ItemArrow)(var1.getItem() instanceof ItemArrow ? var1.getItem() : Items.ARROW);
        EntityArrow var5 = var4.createArrow(var0.level(), var1, var0, var3);
        var5.setBaseDamageFromMob(var2);
        return var5;
    }
}

