/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class AbstractWindCharge
extends EntityFireball
implements ItemSupplier {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.BLOCK.getTag(TagsBlock.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    public static final double JUMP_SCALE = 0.25;

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entitytypes, World world) {
        super((EntityTypes<? extends EntityFireball>)entitytypes, world);
        this.accelerationPower = 0.0;
    }

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entitytypes, World world, Entity entity, double d0, double d1, double d2) {
        super(entitytypes, d0, d1, d2, world);
        this.setOwner(entity);
        this.accelerationPower = 0.0;
    }

    AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entitytypes, double d0, double d1, double d2, Vec3D vec3d, World world) {
        super(entitytypes, d0, d1, d2, vec3d, world);
        this.accelerationPower = 0.0;
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        float f2 = this.getType().getDimensions().width() / 2.0f;
        float f1 = this.getType().getDimensions().height();
        float f22 = 0.15f;
        return new AxisAlignedBB(this.position().x - (double)f2, this.position().y - (double)0.15f, this.position().z - (double)f2, this.position().x + (double)f2, this.position().y - (double)0.15f + (double)f1, this.position().z + (double)f2);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return entity instanceof AbstractWindCharge ? false : super.canCollideWith(entity);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        return entity instanceof AbstractWindCharge ? false : (entity.getType() == EntityTypes.END_CRYSTAL ? false : super.canHitEntity(entity));
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        if (!this.level().isClientSide) {
            DamageSource damagesource;
            EntityLiving entityliving1;
            Entity entity = this.getOwner();
            EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
            EntityLiving entityliving2 = entityliving;
            Entity entity1 = movingobjectpositionentity.getEntity();
            if (entityliving2 != null) {
                entityliving2.setLastHurtMob(entity1);
            }
            if (entity1.hurt(damagesource = this.damageSources().windCharge(this, entityliving2), 1.0f) && entity1 instanceof EntityLiving) {
                EntityLiving entityliving3 = (EntityLiving)entity1;
                EnchantmentManager.doPostAttackEffects((WorldServer)this.level(), entityliving3, damagesource);
            }
            this.explode(this.position());
        }
    }

    @Override
    public void push(double d0, double d1, double d2) {
    }

    public abstract void explode(Vec3D var1);

    @Override
    protected void onHitBlock(MovingObjectPositionBlock movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        if (!this.level().isClientSide) {
            BaseBlockPosition baseblockposition = movingobjectpositionblock.getDirection().getNormal();
            Vec3D vec3d = Vec3D.atLowerCornerOf(baseblockposition).multiply(0.25, 0.25, 0.25);
            Vec3D vec3d1 = movingobjectpositionblock.getLocation().add(vec3d);
            this.explode(vec3d1);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void onHit(MovingObjectPosition movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @Nullable
    protected ParticleParam getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode(this.position());
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
        } else {
            super.tick();
        }
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        return false;
    }
}

