/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> IS_CELEBRATING = DataWatcher.defineId(EntityRaider.class, DataWatcherRegistry.BOOLEAN);
    static final Predicate<EntityItem> ALLOWED_ITEMS = entityitem -> !entityitem.hasPickUpDelay() && entityitem.isAlive() && ItemStack.matches(entityitem.getItem(), Raid.getLeaderBannerInstance(entityitem.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
    @Nullable
    protected Raid raid;
    private int wave;
    private boolean canJoinRaid;
    private int ticksOutsideRaid;

    protected EntityRaider(EntityTypes<? extends EntityRaider> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)entitytypes, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new b(this, this, this));
        this.goalSelector.addGoal(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.goalSelector.addGoal(4, new d(this, 1.05f, 1));
        this.goalSelector.addGoal(5, new c(this));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(IS_CELEBRATING, false);
    }

    public abstract void applyRaidBuffs(WorldServer var1, int var2, boolean var3);

    public boolean canJoinRaid() {
        return this.canJoinRaid;
    }

    public void setCanJoinRaid(boolean flag) {
        this.canJoinRaid = flag;
    }

    @Override
    public void aiStep() {
        if (this.level() instanceof WorldServer && this.isAlive()) {
            Raid raid = this.getCurrentRaid();
            if (this.canJoinRaid()) {
                if (raid == null) {
                    Raid raid1;
                    if (this.level().getGameTime() % 20L == 0L && (raid1 = ((WorldServer)this.level()).getRaidAt(this.blockPosition())) != null && PersistentRaid.canJoinRaid(this, raid1)) {
                        raid1.joinRaid(raid1.getGroupsSpawned(), this, null, true);
                    }
                } else {
                    EntityLiving entityliving = this.getTarget();
                    if (entityliving != null && (entityliving.getType() == EntityTypes.PLAYER || entityliving.getType() == EntityTypes.IRON_GOLEM)) {
                        this.noActionTime = 0;
                    }
                }
            }
        }
        super.aiStep();
    }

    @Override
    protected void updateNoActionTime() {
        this.noActionTime += 2;
    }

    @Override
    public void die(DamageSource damagesource) {
        if (this.level() instanceof WorldServer) {
            Entity entity = damagesource.getEntity();
            Raid raid = this.getCurrentRaid();
            if (raid != null) {
                if (this.isPatrolLeader()) {
                    raid.removeLeader(this.getWave());
                }
                if (entity != null && entity.getType() == EntityTypes.PLAYER) {
                    raid.addHeroOfTheVillage(entity);
                }
                raid.removeFromRaid(this, false);
            }
        }
        super.die(damagesource);
    }

    @Override
    public boolean canJoinPatrol() {
        return !this.hasActiveRaid();
    }

    public void setCurrentRaid(@Nullable Raid raid) {
        this.raid = raid;
    }

    @Nullable
    public Raid getCurrentRaid() {
        return this.raid;
    }

    public boolean isCaptain() {
        ItemStack itemstack = this.getItemBySlot(EnumItemSlot.HEAD);
        boolean flag = !itemstack.isEmpty() && ItemStack.matches(itemstack, Raid.getLeaderBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        boolean flag1 = this.isPatrolLeader();
        return flag && flag1;
    }

    public boolean hasRaid() {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)world;
        return this.getCurrentRaid() != null || worldserver.getRaidAt(this.blockPosition()) != null;
    }

    public boolean hasActiveRaid() {
        return this.getCurrentRaid() != null && this.getCurrentRaid().isActive();
    }

    public void setWave(int i2) {
        this.wave = i2;
    }

    public int getWave() {
        return this.wave;
    }

    public boolean isCelebrating() {
        return this.entityData.get(IS_CELEBRATING);
    }

    public void setCelebrating(boolean flag) {
        this.entityData.set(IS_CELEBRATING, flag);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt("Wave", this.wave);
        nbttagcompound.putBoolean("CanJoinRaid", this.canJoinRaid);
        if (this.raid != null) {
            nbttagcompound.putInt("RaidId", this.raid.getId());
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.wave = nbttagcompound.getInt("Wave");
        this.canJoinRaid = nbttagcompound.getBoolean("CanJoinRaid");
        if (nbttagcompound.contains("RaidId", 3)) {
            if (this.level() instanceof WorldServer) {
                this.raid = ((WorldServer)this.level()).getRaids().get(nbttagcompound.getInt("RaidId"));
            }
            if (this.raid != null) {
                this.raid.addWaveMob(this.wave, this, false);
                if (this.isPatrolLeader()) {
                    this.raid.setLeader(this.wave, this);
                }
            }
        }
    }

    @Override
    protected void pickUpItem(EntityItem entityitem) {
        boolean flag;
        ItemStack itemstack = entityitem.getItem();
        boolean bl = flag = this.hasActiveRaid() && this.getCurrentRaid().getLeader(this.getWave()) != null;
        if (this.hasActiveRaid() && !flag && ItemStack.matches(itemstack, Raid.getLeaderBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
            EnumItemSlot enumitemslot = EnumItemSlot.HEAD;
            ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
            double d0 = this.getEquipmentDropChance(enumitemslot);
            if (!itemstack1.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < d0) {
                this.spawnAtLocation(itemstack1);
            }
            this.onItemPickup(entityitem);
            this.setItemSlot(enumitemslot, itemstack);
            this.take(entityitem, itemstack.getCount());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            this.getCurrentRaid().setLeader(this.getWave(), this);
            this.setPatrolLeader(true);
        } else {
            super.pickUpItem(entityitem);
        }
    }

    @Override
    public boolean removeWhenFarAway(double d0) {
        return this.getCurrentRaid() == null ? super.removeWhenFarAway(d0) : false;
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getCurrentRaid() != null;
    }

    public int getTicksOutsideRaid() {
        return this.ticksOutsideRaid;
    }

    public void setTicksOutsideRaid(int i2) {
        this.ticksOutsideRaid = i2;
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.hasActiveRaid()) {
            this.getCurrentRaid().updateBossbar();
        }
        return super.hurt(damagesource, f2);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        this.setCanJoinRaid(this.getType() != EntityTypes.WITCH || enummobspawn != EnumMobSpawn.NATURAL);
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    public abstract SoundEffect getCelebrateSound();

    public class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T mob;

        /*
         * WARNING - Possible parameter corruption
         */
        public b(EntityRaider entityraider, T entityraider1) {
            this.mob = entityraider1;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            Raid raid = ((EntityRaider)this.mob).getCurrentRaid();
            if (((EntityRaider)this.mob).hasActiveRaid() && !((EntityRaider)this.mob).getCurrentRaid().isOver() && ((EntityMonsterPatrolling)this.mob).canBeLeader() && !ItemStack.matches(((EntityInsentient)this.mob).getItemBySlot(EnumItemSlot.HEAD), Raid.getLeaderBannerInstance(((Entity)this.mob).registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
                List<EntityItem> list;
                EntityRaider entityraider = raid.getLeader(((EntityRaider)this.mob).getWave());
                if (!(entityraider != null && entityraider.isAlive() || (list = ((Entity)this.mob).level().getEntitiesOfClass(EntityItem.class, ((Entity)this.mob).getBoundingBox().inflate(16.0, 8.0, 16.0), ALLOWED_ITEMS)).isEmpty())) {
                    return ((EntityInsentient)this.mob).getNavigation().moveTo(list.get(0), (double)1.15f);
                }
                return false;
            }
            return false;
        }

        @Override
        public void tick() {
            List<EntityItem> list;
            if (((EntityInsentient)this.mob).getNavigation().getTargetPos().closerToCenterThan(((Entity)this.mob).position(), 1.414) && !(list = ((Entity)this.mob).level().getEntitiesOfClass(EntityItem.class, ((Entity)this.mob).getBoundingBox().inflate(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty()) {
                ((EntityRaider)this.mob).pickUpItem(list.get(0));
            }
        }
    }

    private static class d
    extends PathfinderGoal {
        private final EntityRaider raider;
        private final double speedModifier;
        private BlockPosition poiPos;
        private final List<BlockPosition> visited = Lists.newArrayList();
        private final int distanceToPoi;
        private boolean stuck;

        public d(EntityRaider entityraider, double d0, int i2) {
            this.raider = entityraider;
            this.speedModifier = d0;
            this.distanceToPoi = i2;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            this.updateVisited();
            return this.isValidRaid() && this.hasSuitablePoi() && this.raider.getTarget() == null;
        }

        private boolean isValidRaid() {
            return this.raider.hasActiveRaid() && !this.raider.getCurrentRaid().isOver();
        }

        private boolean hasSuitablePoi() {
            WorldServer worldserver = (WorldServer)this.raider.level();
            BlockPosition blockposition = this.raider.blockPosition();
            Optional<BlockPosition> optional = worldserver.getPoiManager().getRandom(holder -> holder.is(PoiTypes.HOME), this::hasNotVisited, VillagePlace.Occupancy.ANY, blockposition, 48, this.raider.random);
            if (optional.isEmpty()) {
                return false;
            }
            this.poiPos = optional.get().immutable();
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return this.raider.getNavigation().isDone() ? false : this.raider.getTarget() == null && !this.poiPos.closerToCenterThan(this.raider.position(), this.raider.getBbWidth() + (float)this.distanceToPoi) && !this.stuck;
        }

        @Override
        public void stop() {
            if (this.poiPos.closerToCenterThan(this.raider.position(), this.distanceToPoi)) {
                this.visited.add(this.poiPos);
            }
        }

        @Override
        public void start() {
            super.start();
            this.raider.setNoActionTime(0);
            this.raider.getNavigation().moveTo(this.poiPos.getX(), this.poiPos.getY(), this.poiPos.getZ(), this.speedModifier);
            this.stuck = false;
        }

        @Override
        public void tick() {
            if (this.raider.getNavigation().isDone()) {
                Vec3D vec3d = Vec3D.atBottomCenterOf(this.poiPos);
                Vec3D vec3d1 = DefaultRandomPos.getPosTowards(this.raider, 16, 7, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.getPosTowards(this.raider, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.stuck = true;
                    return;
                }
                this.raider.getNavigation().moveTo(vec3d1.x, vec3d1.y, vec3d1.z, this.speedModifier);
            }
        }

        private boolean hasNotVisited(BlockPosition blockposition) {
            BlockPosition blockposition1;
            Iterator<BlockPosition> iterator = this.visited.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!Objects.equals(blockposition, blockposition1 = iterator.next()));
            return false;
        }

        private void updateVisited() {
            if (this.visited.size() > 2) {
                this.visited.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider mob;

        c(EntityRaider entityraider) {
            this.mob = entityraider;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            Raid raid = this.mob.getCurrentRaid();
            return this.mob.isAlive() && this.mob.getTarget() == null && raid != null && raid.isLoss();
        }

        @Override
        public void start() {
            this.mob.setCelebrating(true);
            super.start();
        }

        @Override
        public void stop() {
            this.mob.setCelebrating(false);
            super.stop();
        }

        @Override
        public void tick() {
            if (!this.mob.isSilent() && this.mob.random.nextInt(this.adjustedTickDelay(100)) == 0) {
                EntityRaider.this.makeSound(EntityRaider.this.getCelebrateSound());
            }
            if (!this.mob.isPassenger() && this.mob.random.nextInt(this.adjustedTickDelay(50)) == 0) {
                this.mob.getJumpControl().jump();
            }
            super.tick();
        }
    }

    protected class a
    extends PathfinderGoal {
        private final EntityRaider mob;
        private final float hostileRadiusSqr;
        public final PathfinderTargetCondition shoutTargeting = PathfinderTargetCondition.forNonCombat().range(8.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        public a(EntityRaider this$0, EntityIllagerAbstract entityillagerabstract, float f2) {
            this.mob = entityillagerabstract;
            this.hostileRadiusSqr = f2 * f2;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving entityliving = this.mob.getLastHurtByMob();
            return this.mob.getCurrentRaid() == null && this.mob.isPatrolling() && this.mob.getTarget() != null && !this.mob.isAggressive() && (entityliving == null || entityliving.getType() != EntityTypes.PLAYER);
        }

        @Override
        public void start() {
            super.start();
            this.mob.getNavigation().stop();
            List<EntityRaider> list = this.mob.level().getNearbyEntities(EntityRaider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (EntityRaider entityraider : list) {
                entityraider.setTarget(this.mob.getTarget(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        @Override
        public void stop() {
            super.stop();
            EntityLiving entityliving = this.mob.getTarget();
            if (entityliving != null) {
                List<EntityRaider> list = this.mob.level().getNearbyEntities(EntityRaider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (EntityRaider entityraider : list) {
                    entityraider.setTarget(this.mob.getTarget(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    entityraider.setAggressive(true);
                }
                this.mob.setAggressive(true);
            }
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            EntityLiving entityliving = this.mob.getTarget();
            if (entityliving != null) {
                if (this.mob.distanceToSqr(entityliving) > (double)this.hostileRadiusSqr) {
                    this.mob.getLookControl().setLookAt(entityliving, 30.0f, 30.0f);
                    if (this.mob.random.nextInt(50) == 0) {
                        this.mob.playAmbientSound();
                    }
                } else {
                    this.mob.setAggressive(true);
                }
                super.tick();
            }
        }
    }
}

