/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;

public class Raid {
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int ATTEMPT_RAID_FARTHEST = 0;
    private static final int ATTEMPT_RAID_CLOSE = 1;
    private static final int ATTEMPT_RAID_INSIDE = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 3;
    private static final IChatBaseComponent OMINOUS_BANNER_PATTERN_NAME = IChatBaseComponent.translatable("block.minecraft.ominous_banner").withStyle(EnumChatFormat.GOLD);
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final IChatBaseComponent RAID_NAME_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid");
    private static final IChatBaseComponent RAID_BAR_VICTORY_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent RAID_BAR_DEFEAT_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, EntityRaider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPosition center;
    private final WorldServer level;
    private boolean started;
    private final int id;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final BossBattleServer raidEvent = new BossBattleServer(RAID_NAME_COMPONENT, BossBattle.BarColor.RED, BossBattle.BarStyle.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    public final int numGroups;
    private Status status;
    private int celebrationTicks;
    private Optional<BlockPosition> waveSpawnPos = Optional.empty();

    public Raid(int i2, WorldServer worldserver, BlockPosition blockposition) {
        this.id = i2;
        this.level = worldserver;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = blockposition;
        this.numGroups = this.getNumGroups(worldserver.getDifficulty());
        this.status = Status.ONGOING;
    }

    public Raid(WorldServer worldserver, NBTTagCompound nbttagcompound) {
        this.level = worldserver;
        this.id = nbttagcompound.getInt("Id");
        this.started = nbttagcompound.getBoolean("Started");
        this.active = nbttagcompound.getBoolean("Active");
        this.ticksActive = nbttagcompound.getLong("TicksActive");
        this.raidOmenLevel = nbttagcompound.getInt("BadOmenLevel");
        this.groupsSpawned = nbttagcompound.getInt("GroupsSpawned");
        this.raidCooldownTicks = nbttagcompound.getInt("PreRaidTicks");
        this.postRaidTicks = nbttagcompound.getInt("PostRaidTicks");
        this.totalHealth = nbttagcompound.getFloat("TotalHealth");
        this.center = new BlockPosition(nbttagcompound.getInt("CX"), nbttagcompound.getInt("CY"), nbttagcompound.getInt("CZ"));
        this.numGroups = nbttagcompound.getInt("NumGroups");
        this.status = Status.getByName(nbttagcompound.getString("Status"));
        this.heroesOfTheVillage.clear();
        if (nbttagcompound.contains("HeroesOfTheVillage", 9)) {
            NBTTagList nbttaglist = nbttagcompound.getList("HeroesOfTheVillage", 11);
            for (NBTBase nbtbase : nbttaglist) {
                this.heroesOfTheVillage.add(GameProfileSerializer.loadUUID(nbtbase));
            }
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isVictory() {
        return this.status == Status.VICTORY;
    }

    public boolean isLoss() {
        return this.status == Status.LOSS;
    }

    public boolean isInProgress() {
        return this.status == Status.ONGOING;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<EntityRaider> getAllRaiders() {
        HashSet set = Sets.newHashSet();
        for (Set<EntityRaider> set1 : this.groupRaiderMap.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public World getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<EntityPlayer> validPlayer() {
        return entityplayer -> {
            BlockPosition blockposition = entityplayer.blockPosition();
            return entityplayer.isAlive() && this.level.getRaidAt(blockposition) == this;
        };
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet(this.raidEvent.getPlayers());
        List<EntityPlayer> list = this.level.getPlayers(this.validPlayer());
        for (EntityPlayer entityplayer : list) {
            if (set.contains(entityplayer)) continue;
            this.raidEvent.addPlayer(entityplayer);
        }
        for (EntityPlayer entityplayer : set) {
            if (list.contains(entityplayer)) continue;
            this.raidEvent.removePlayer(entityplayer);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int i2) {
        this.raidOmenLevel = i2;
    }

    public boolean absorbRaidOmen(EntityPlayer entityplayer) {
        MobEffect mobeffect = entityplayer.getEffect(MobEffects.RAID_OMEN);
        if (mobeffect == null) {
            return false;
        }
        this.raidOmenLevel += mobeffect.getAmplifier() + 1;
        this.raidOmenLevel = MathHelper.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            entityplayer.awardStat(StatisticList.RAID_TRIGGER);
            CriterionTriggers.RAID_OMEN.trigger(entityplayer);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = Status.STOPPED;
    }

    public void tick() {
        if (!this.isStopped()) {
            if (this.status == Status.ONGOING) {
                boolean flag1;
                boolean flag = this.active;
                this.active = this.level.hasChunkAt(this.center);
                if (this.level.getDifficulty() == EnumDifficulty.PEACEFUL) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.stop();
                    return;
                }
                if (flag != this.active) {
                    this.raidEvent.setVisible(this.active);
                }
                if (!this.active) {
                    return;
                }
                if (!this.level.isVillage(this.center)) {
                    this.moveRaidCenterToNearbyVillageSection();
                }
                if (!this.level.isVillage(this.center)) {
                    if (this.groupsSpawned > 0) {
                        this.status = Status.LOSS;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.stop();
                    }
                }
                ++this.ticksActive;
                if (this.ticksActive >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.stop();
                    return;
                }
                int i2 = this.getTotalRaidersAlive();
                if (i2 == 0 && this.hasMoreWaves()) {
                    if (this.raidCooldownTicks > 0) {
                        boolean flag2;
                        flag1 = this.waveSpawnPos.isPresent();
                        boolean bl = flag2 = !flag1 && this.raidCooldownTicks % 5 == 0;
                        if (flag1 && !this.level.isPositionEntityTicking(this.waveSpawnPos.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            int b0 = 0;
                            if (this.raidCooldownTicks < 100) {
                                b0 = 1;
                            } else if (this.raidCooldownTicks < 40) {
                                b0 = 2;
                            }
                            this.waveSpawnPos = this.getValidSpawnPos(b0);
                        }
                        if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                            this.updatePlayers();
                        }
                        --this.raidCooldownTicks;
                        this.raidEvent.setProgress(MathHelper.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                    } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                        this.raidCooldownTicks = 300;
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                        return;
                    }
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers();
                    this.updateRaiders();
                    if (i2 > 0) {
                        if (i2 <= 2) {
                            this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(IChatBaseComponent.translatable(RAIDERS_REMAINING, i2)));
                        } else {
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                        }
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                }
                flag1 = false;
                int j2 = 0;
                while (this.shouldSpawnGroup()) {
                    BlockPosition blockposition;
                    BlockPosition blockPosition = blockposition = this.waveSpawnPos.isPresent() ? this.waveSpawnPos.get() : this.findRandomSpawnPos(j2, 20);
                    if (blockposition != null) {
                        this.started = true;
                        this.spawnGroup(blockposition);
                        if (!flag1) {
                            this.playSound(blockposition);
                            flag1 = true;
                        }
                    } else {
                        ++j2;
                    }
                    if (j2 <= 3) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.stop();
                    break;
                }
                if (this.isStarted() && !this.hasMoreWaves() && i2 == 0) {
                    if (this.postRaidTicks < 40) {
                        ++this.postRaidTicks;
                    } else {
                        this.status = Status.VICTORY;
                        Iterator<UUID> iterator = this.heroesOfTheVillage.iterator();
                        ArrayList<Player> winners = new ArrayList<Player>();
                        while (iterator.hasNext()) {
                            UUID uuid = iterator.next();
                            Entity entity = this.level.getEntity(uuid);
                            if (!(entity instanceof EntityLiving)) continue;
                            EntityLiving entityliving = (EntityLiving)entity;
                            if (entity.isSpectator()) continue;
                            entityliving.addEffect(new MobEffect(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                            if (!(entityliving instanceof EntityPlayer)) continue;
                            EntityPlayer entityplayer = (EntityPlayer)entityliving;
                            entityplayer.awardStat(StatisticList.RAID_WIN);
                            CriterionTriggers.RAID_WIN.trigger(entityplayer);
                            winners.add(entityplayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.setDirty();
            } else if (this.isOver()) {
                ++this.celebrationTicks;
                if (this.celebrationTicks >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers();
                    this.raidEvent.setVisible(true);
                    if (this.isVictory()) {
                        this.raidEvent.setProgress(0.0f);
                        this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                    } else {
                        this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream<SectionPosition> stream = SectionPosition.cube(SectionPosition.of(this.center), 2);
        WorldServer worldserver = this.level;
        Objects.requireNonNull(this.level);
        stream.filter(worldserver::isVillage).map(SectionPosition::center).min(Comparator.comparingDouble(blockposition -> blockposition.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPosition> getValidSpawnPos(int i2) {
        for (int j2 = 0; j2 < 3; ++j2) {
            BlockPosition blockposition = this.findRandomSpawnPos(i2, 1);
            if (blockposition == null) continue;
            return Optional.of(blockposition);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        return this.hasBonusWave() ? !this.hasSpawnedBonusWave() : !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<EntityRaider>> iterator = this.groupRaiderMap.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<EntityRaider> set1 = iterator.next();
            for (EntityRaider entityraider : set1) {
                BlockPosition blockposition = entityraider.blockPosition();
                if (!entityraider.isRemoved() && entityraider.level().dimension() == this.level.dimension() && this.center.distSqr(blockposition) < 12544.0) {
                    if (entityraider.tickCount <= 600) continue;
                    if (this.level.getEntity(entityraider.getUUID()) == null) {
                        set.add(entityraider);
                    }
                    if (!this.level.isVillage(blockposition) && entityraider.getNoActionTime() > 2400) {
                        entityraider.setTicksOutsideRaid(entityraider.getTicksOutsideRaid() + 1);
                    }
                    if (entityraider.getTicksOutsideRaid() < 30) continue;
                    set.add(entityraider);
                    continue;
                }
                set.add(entityraider);
            }
        }
        for (EntityRaider entityraider1 : set) {
            this.removeFromRaid(entityraider1, true);
        }
    }

    private void playSound(BlockPosition blockposition) {
        float f2 = 13.0f;
        boolean flag = true;
        Collection<EntityPlayer> collection = this.raidEvent.getPlayers();
        long i2 = this.random.nextLong();
        for (EntityPlayer entityplayer : this.level.players()) {
            Vec3D vec3d = entityplayer.position();
            Vec3D vec3d1 = Vec3D.atCenterOf(blockposition);
            double d0 = Math.sqrt((vec3d1.x - vec3d.x) * (vec3d1.x - vec3d.x) + (vec3d1.z - vec3d.z) * (vec3d1.z - vec3d.z));
            double d1 = vec3d.x + 13.0 / d0 * (vec3d1.x - vec3d.x);
            double d2 = vec3d.z + 13.0 / d0 * (vec3d1.z - vec3d.z);
            if (!(d0 <= 64.0) && !collection.contains(entityplayer)) continue;
            entityplayer.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RAID_HORN, SoundCategory.NEUTRAL, d1, entityplayer.getY(), d2, 64.0f, 1.0f, i2));
        }
    }

    private void spawnGroup(BlockPosition blockposition) {
        boolean flag = false;
        int i2 = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyDamageScaler difficultydamagescaler = this.level.getCurrentDifficultyAt(blockposition);
        boolean flag1 = this.shouldSpawnBonusGroup();
        Wave[] araid_wave = Wave.VALUES;
        int j2 = araid_wave.length;
        EntityRaider leader = null;
        ArrayList<EntityRaider> raiders = new ArrayList<EntityRaider>();
        for (int k2 = 0; k2 < j2; ++k2) {
            EntityRaider entityraider;
            Wave raid_wave = araid_wave[k2];
            int l2 = this.getDefaultNumSpawns(raid_wave, i2, flag1) + this.getPotentialBonusSpawns(raid_wave, this.random, i2, difficultydamagescaler, flag1);
            int i1 = 0;
            for (int j1 = 0; j1 < l2 && (entityraider = raid_wave.entityType.create(this.level)) != null; ++j1) {
                if (!flag && entityraider.canBeLeader()) {
                    entityraider.setPatrolLeader(true);
                    this.setLeader(i2, entityraider);
                    flag = true;
                    leader = entityraider;
                }
                this.joinRaid(i2, entityraider, blockposition, false);
                raiders.add(entityraider);
                if (raid_wave.entityType != EntityTypes.RAVAGER) continue;
                EntityRaider entityraider1 = null;
                if (i2 == this.getNumGroups(EnumDifficulty.NORMAL)) {
                    entityraider1 = EntityTypes.PILLAGER.create(this.level);
                } else if (i2 >= this.getNumGroups(EnumDifficulty.HARD)) {
                    entityraider1 = i1 == 0 ? (EntityRaider)EntityTypes.EVOKER.create(this.level) : (EntityRaider)EntityTypes.VINDICATOR.create(this.level);
                }
                ++i1;
                if (entityraider1 == null) continue;
                this.joinRaid(i2, entityraider1, blockposition, false);
                entityraider1.moveTo(blockposition, 0.0f, 0.0f);
                entityraider1.startRiding(entityraider);
                raiders.add(entityraider);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
        CraftEventFactory.callRaidSpawnWaveEvent(this, leader, raiders);
    }

    public void joinRaid(int i2, EntityRaider entityraider, @Nullable BlockPosition blockposition, boolean flag) {
        boolean flag1 = this.addWaveMob(i2, entityraider);
        if (flag1) {
            entityraider.setCurrentRaid(this);
            entityraider.setWave(i2);
            entityraider.setCanJoinRaid(true);
            entityraider.setTicksOutsideRaid(0);
            if (!flag && blockposition != null) {
                entityraider.setPos((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.0, (double)blockposition.getZ() + 0.5);
                entityraider.finalizeSpawn(this.level, this.level.getCurrentDifficultyAt(blockposition), EnumMobSpawn.EVENT, null);
                entityraider.applyRaidBuffs(this.level, i2, false);
                entityraider.setOnGround(true);
                this.level.addFreshEntityWithPassengers(entityraider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(MathHelper.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float f2 = 0.0f;
        for (Set<EntityRaider> set : this.groupRaiderMap.values()) {
            for (EntityRaider entityraider : set) {
                f2 += entityraider.getHealth();
            }
        }
        return f2;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(EntityRaider entityraider, boolean flag) {
        boolean flag1;
        Set<EntityRaider> set = this.groupRaiderMap.get(entityraider.getWave());
        if (set != null && (flag1 = set.remove(entityraider))) {
            if (flag) {
                this.totalHealth -= entityraider.getHealth();
            }
            entityraider.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        this.level.getRaids().setDirty();
    }

    public static ItemStack getLeaderBannerInstance(HolderGetter<EnumBannerPatternType> holdergetter) {
        ItemStack itemstack = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.a().addIfRegistered(holdergetter, BannerPatterns.RHOMBUS_MIDDLE, EnumColor.CYAN).addIfRegistered(holdergetter, BannerPatterns.STRIPE_BOTTOM, EnumColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.STRIPE_CENTER, EnumColor.GRAY).addIfRegistered(holdergetter, BannerPatterns.BORDER, EnumColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.STRIPE_MIDDLE, EnumColor.BLACK).addIfRegistered(holdergetter, BannerPatterns.HALF_HORIZONTAL, EnumColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.CIRCLE_MIDDLE, EnumColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.BORDER, EnumColor.BLACK).build();
        itemstack.set(DataComponents.BANNER_PATTERNS, bannerpatternlayers);
        itemstack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        itemstack.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        return itemstack;
    }

    @Nullable
    public EntityRaider getLeader(int i2) {
        return this.groupToLeaderMap.get(i2);
    }

    @Nullable
    private BlockPosition findRandomSpawnPos(int i2, int j2) {
        int k2 = i2 == 0 ? 2 : 2 - i2;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        SpawnPlacementType spawnplacementtype = EntityPositionTypes.getPlacementType(EntityTypes.RAVAGER);
        for (int l2 = 0; l2 < j2; ++l2) {
            float f2 = this.level.random.nextFloat() * ((float)Math.PI * 2);
            int i1 = this.center.getX() + MathHelper.floor(MathHelper.cos(f2) * 32.0f * (float)k2) + this.level.random.nextInt(5);
            int j1 = this.center.getZ() + MathHelper.floor(MathHelper.sin(f2) * 32.0f * (float)k2) + this.level.random.nextInt(5);
            int k1 = this.level.getHeight(HeightMap.Type.WORLD_SURFACE, i1, j1);
            blockposition_mutableblockposition.set(i1, k1, j1);
            if (this.level.isVillage(blockposition_mutableblockposition) && i2 < 2) continue;
            boolean flag = true;
            if (!this.level.hasChunksAt(blockposition_mutableblockposition.getX() - 10, blockposition_mutableblockposition.getZ() - 10, blockposition_mutableblockposition.getX() + 10, blockposition_mutableblockposition.getZ() + 10) || !this.level.isPositionEntityTicking(blockposition_mutableblockposition) || !spawnplacementtype.isSpawnPositionOk(this.level, blockposition_mutableblockposition, EntityTypes.RAVAGER) && (!this.level.getBlockState((BlockPosition)blockposition_mutableblockposition.below()).is(Blocks.SNOW) || !this.level.getBlockState(blockposition_mutableblockposition).isAir())) continue;
            return blockposition_mutableblockposition;
        }
        return null;
    }

    private boolean addWaveMob(int i2, EntityRaider entityraider) {
        return this.addWaveMob(i2, entityraider, true);
    }

    public boolean addWaveMob(int i2, EntityRaider entityraider, boolean flag) {
        this.groupRaiderMap.computeIfAbsent(i2, integer -> Sets.newHashSet());
        Set<EntityRaider> set = this.groupRaiderMap.get(i2);
        EntityRaider entityraider1 = null;
        for (EntityRaider entityraider2 : set) {
            if (!entityraider2.getUUID().equals(entityraider.getUUID())) continue;
            entityraider1 = entityraider2;
            break;
        }
        if (entityraider1 != null) {
            set.remove(entityraider1);
            set.add(entityraider);
        }
        set.add(entityraider);
        if (flag) {
            this.totalHealth += entityraider.getHealth();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int i2, EntityRaider entityraider) {
        this.groupToLeaderMap.put(i2, entityraider);
        entityraider.setItemSlot(EnumItemSlot.HEAD, Raid.getLeaderBannerInstance(entityraider.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        entityraider.setDropChance(EnumItemSlot.HEAD, 2.0f);
    }

    public void removeLeader(int i2) {
        this.groupToLeaderMap.remove(i2);
    }

    public BlockPosition getCenter() {
        return this.center;
    }

    private void setCenter(BlockPosition blockposition) {
        this.center = blockposition;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(Wave raid_wave, int i2, boolean flag) {
        return flag ? raid_wave.spawnsPerWaveBeforeBonus[this.numGroups] : raid_wave.spawnsPerWaveBeforeBonus[i2];
    }

    private int getPotentialBonusSpawns(Wave raid_wave, RandomSource randomsource, int i2, DifficultyDamageScaler difficultydamagescaler, boolean flag) {
        int j2;
        EnumDifficulty enumdifficulty = difficultydamagescaler.getDifficulty();
        boolean flag1 = enumdifficulty == EnumDifficulty.EASY;
        boolean flag2 = enumdifficulty == EnumDifficulty.NORMAL;
        switch (raid_wave.ordinal()) {
            case 0: 
            case 2: {
                if (flag1) {
                    j2 = randomsource.nextInt(2);
                    break;
                }
                if (flag2) {
                    j2 = 1;
                    break;
                }
                j2 = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag1 || i2 <= 2 || i2 == 4) {
                    return 0;
                }
                j2 = 1;
                break;
            }
            case 4: {
                j2 = !flag1 && flag ? 1 : 0;
            }
        }
        return j2 > 0 ? randomsource.nextInt(j2 + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public NBTTagCompound save(NBTTagCompound nbttagcompound) {
        nbttagcompound.putInt("Id", this.id);
        nbttagcompound.putBoolean("Started", this.started);
        nbttagcompound.putBoolean("Active", this.active);
        nbttagcompound.putLong("TicksActive", this.ticksActive);
        nbttagcompound.putInt("BadOmenLevel", this.raidOmenLevel);
        nbttagcompound.putInt("GroupsSpawned", this.groupsSpawned);
        nbttagcompound.putInt("PreRaidTicks", this.raidCooldownTicks);
        nbttagcompound.putInt("PostRaidTicks", this.postRaidTicks);
        nbttagcompound.putFloat("TotalHealth", this.totalHealth);
        nbttagcompound.putInt("NumGroups", this.numGroups);
        nbttagcompound.putString("Status", this.status.getName());
        nbttagcompound.putInt("CX", this.center.getX());
        nbttagcompound.putInt("CY", this.center.getY());
        nbttagcompound.putInt("CZ", this.center.getZ());
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : this.heroesOfTheVillage) {
            nbttaglist.add(GameProfileSerializer.createUUID(uuid));
        }
        nbttagcompound.put("HeroesOfTheVillage", nbttaglist);
        return nbttagcompound;
    }

    public int getNumGroups(EnumDifficulty enumdifficulty) {
        switch (enumdifficulty) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int i2 = this.getRaidOmenLevel();
        return i2 == 2 ? 0.1f : (i2 == 3 ? 0.25f : (i2 == 4 ? 0.5f : (i2 == 5 ? 0.75f : 0.0f)));
    }

    public void addHeroOfTheVillage(Entity entity) {
        this.heroesOfTheVillage.add(entity.getUUID());
    }

    public Collection<EntityRaider> getRaiders() {
        return this.groupRaiderMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static enum Status {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final Status[] VALUES;

        static Status getByName(String s2) {
            for (Status raid_status : VALUES) {
                if (!s2.equalsIgnoreCase(raid_status.name())) continue;
                return raid_status;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = Status.values();
        }
    }

    private static enum Wave {
        VINDICATOR(EntityTypes.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityTypes.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityTypes.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityTypes.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityTypes.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final Wave[] VALUES;
        final EntityTypes<? extends EntityRaider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private Wave(EntityTypes entitytypes, int[] aint) {
            this.entityType = entitytypes;
            this.spawnsPerWaveBeforeBonus = aint;
        }

        static {
            VALUES = Wave.values();
        }
    }
}

