/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.InventoryHolder;

public class ChestBoat
extends EntityBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> itemStacks;
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    public ChestBoat(EntityTypes<? extends EntityBoat> entitytypes, World world) {
        super(entitytypes, world);
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
    }

    public ChestBoat(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityBoat>)EntityTypes.CHEST_BOAT, world);
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
        this.setPos(d0, d1, d2);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    @Override
    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        this.addChestVehicleSaveData(nbttagcompound, this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.readChestVehicleSaveData(nbttagcompound, this.registryAccess());
    }

    @Override
    public void destroy(DamageSource damagesource) {
        this.destroy(this.getDropItem());
        this.chestVehicleDestroyed(damagesource, this.level(), this);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (!this.level().isClientSide && entity_removalreason.shouldDestroy()) {
            InventoryUtils.dropContents(this.level(), this, (IInventory)this);
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        if (!entityhuman.isSecondaryUseActive() && (enuminteractionresult = super.interact(entityhuman, enumhand)) != EnumInteractionResult.PASS) {
            return enuminteractionresult;
        }
        if (this.canAddPassenger(entityhuman) && !entityhuman.isSecondaryUseActive()) {
            return EnumInteractionResult.PASS;
        }
        enuminteractionresult = this.interactWithContainerVehicle(entityhuman);
        if (enuminteractionresult.consumesAction()) {
            this.gameEvent(GameEvent.CONTAINER_OPEN, entityhuman);
            PiglinAI.angerNearbyPiglins(entityhuman, true);
        }
        return enuminteractionresult;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman entityhuman) {
        entityhuman.openMenu(this);
        if (!entityhuman.level().isClientSide) {
            this.gameEvent(GameEvent.CONTAINER_OPEN, entityhuman);
            PiglinAI.angerNearbyPiglins(entityhuman, true);
        }
    }

    @Override
    public Item getDropItem() {
        return switch (this.getVariant()) {
            case EntityBoat.EnumBoatType.SPRUCE -> Items.SPRUCE_CHEST_BOAT;
            case EntityBoat.EnumBoatType.BIRCH -> Items.BIRCH_CHEST_BOAT;
            case EntityBoat.EnumBoatType.JUNGLE -> Items.JUNGLE_CHEST_BOAT;
            case EntityBoat.EnumBoatType.ACACIA -> Items.ACACIA_CHEST_BOAT;
            case EntityBoat.EnumBoatType.CHERRY -> Items.CHERRY_CHEST_BOAT;
            case EntityBoat.EnumBoatType.DARK_OAK -> Items.DARK_OAK_CHEST_BOAT;
            case EntityBoat.EnumBoatType.MANGROVE -> Items.MANGROVE_CHEST_BOAT;
            case EntityBoat.EnumBoatType.BAMBOO -> Items.BAMBOO_CHEST_RAFT;
            default -> Items.OAK_CHEST_BOAT;
        };
    }

    @Override
    public void clearContent() {
        this.clearChestVehicleContent();
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    public ItemStack getItem(int i2) {
        return this.getChestVehicleItem(i2);
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        return this.removeChestVehicleItem(i2, j2);
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        return this.removeChestVehicleItemNoUpdate(i2);
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        this.setChestVehicleItem(i2, itemstack);
    }

    @Override
    public SlotAccess getSlot(int i2) {
        return this.getChestVehicleSlot(i2);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.isChestVehicleStillValid(entityhuman);
    }

    @Override
    @Nullable
    public Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
        if (this.lootTable != null && entityhuman.isSpectator()) {
            return null;
        }
        this.unpackLootTable(playerinventory.player);
        return ContainerChest.threeRows(i2, playerinventory, this);
    }

    public void unpackLootTable(@Nullable EntityHuman entityhuman) {
        this.unpackChestVehicleLootTable(entityhuman);
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable ResourceKey<LootTable> resourcekey) {
        this.lootTable = resourcekey;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long i2) {
        this.lootTableSeed = i2;
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }

    @Override
    public void stopOpen(EntityHuman entityhuman) {
        this.level().gameEvent(GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.a.of(entityhuman));
    }

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        CraftEntity entity = this.getBukkitEntity();
        if (entity instanceof InventoryHolder) {
            return (InventoryHolder)entity;
        }
        return null;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.getBukkitEntity().getLocation();
    }
}

