/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class EntityBoat
extends VehicleEntity
implements Leashable,
VariantHolder<EnumBoatType> {
    private static final DataWatcherObject<Integer> DATA_ID_TYPE = DataWatcher.defineId(EntityBoat.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_ID_PADDLE_LEFT = DataWatcher.defineId(EntityBoat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_ID_PADDLE_RIGHT = DataWatcher.defineId(EntityBoat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_ID_BUBBLE_TIME = DataWatcher.defineId(EntityBoat.class, DataWatcherRegistry.INT);
    public static final int PADDLE_LEFT = 0;
    public static final int PADDLE_RIGHT = 1;
    private static final int TIME_TO_EJECT = 60;
    private static final float PADDLE_SPEED = 0.3926991f;
    public static final double PADDLE_SOUND_TIME = 0.7853981852531433;
    public static final int BUBBLE_TIME = 60;
    private final float[] paddlePositions = new float[2];
    private float invFriction;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    public EnumStatus status;
    private EnumStatus oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;
    @Nullable
    private Leashable.a leashData;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public EntityBoat(EntityTypes<? extends EntityBoat> entitytypes, World world) {
        super(entitytypes, world);
        this.blocksBuilding = true;
    }

    public EntityBoat(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityBoat>)EntityTypes.BOAT, world);
        this.setPos(d0, d1, d2);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ID_TYPE, EnumBoatType.OAK.ordinal());
        datawatcher_a.define(DATA_ID_PADDLE_LEFT, false);
        datawatcher_a.define(DATA_ID_PADDLE_RIGHT, false);
        datawatcher_a.define(DATA_ID_BUBBLE_TIME, 0);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return EntityBoat.canVehicleCollide(this, entity);
    }

    public static boolean canVehicleCollide(Entity entity, Entity entity1) {
        return (entity1.canBeCollidedWith() || entity1.isPushable()) && !entity.isPassengerOfSameVehicle(entity1);
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle));
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity entity, EntitySize entitysize, float f2) {
        float f1 = this.getSinglePassengerXOffset();
        if (this.getPassengers().size() > 1) {
            int i2 = this.getPassengers().indexOf(entity);
            f1 = i2 == 0 ? 0.2f : -0.6f;
            if (entity instanceof EntityAnimal) {
                f1 += 0.2f;
            }
        }
        return new Vec3D(0.0, this.getVariant() == EnumBoatType.BAMBOO ? (double)(entitysize.height() * 0.8888889f) : (double)(entitysize.height() / 3.0f), f1).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public void onAboveBubbleCol(boolean flag) {
        if (!this.level().isClientSide) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = flag;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        this.level().addParticle(Particles.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
        if (this.random.nextInt(20) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat(), false);
            this.gameEvent(GameEvent.SPLASH, this.getControllingPassenger());
        }
    }

    @Override
    public void push(Entity entity) {
        if (entity instanceof EntityBoat) {
            if (entity.getBoundingBox().minY < this.getBoundingBox().maxY) {
                if (!this.isPassengerOfSameVehicle(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.push(entity);
            }
        } else if (entity.getBoundingBox().minY <= this.getBoundingBox().minY) {
            if (!this.isPassengerOfSameVehicle(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.push(entity);
        }
    }

    @Override
    public Item getDropItem() {
        return switch (this.getVariant().ordinal()) {
            case 1 -> Items.SPRUCE_BOAT;
            case 2 -> Items.BIRCH_BOAT;
            case 3 -> Items.JUNGLE_BOAT;
            case 4 -> Items.ACACIA_BOAT;
            case 5 -> Items.CHERRY_BOAT;
            case 6 -> Items.DARK_OAK_BOAT;
            case 7 -> Items.MANGROVE_BOAT;
            case 8 -> Items.BAMBOO_RAFT;
            default -> Items.OAK_BOAT;
        };
    }

    @Override
    public void animateHurt(float f2) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.lerpX = d0;
        this.lerpY = d1;
        this.lerpZ = d2;
        this.lerpYRot = f2;
        this.lerpXRot = f1;
        this.lerpSteps = 10;
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    @Override
    public void tick() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != EnumStatus.UNDER_WATER && this.status != EnumStatus.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.level().isClientSide && this.outOfControlTicks >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.tick();
        this.tickLerp();
        if (this.isControlledByLocalInstance()) {
            if (!(this.getFirstPassenger() instanceof EntityHuman)) {
                this.setPaddleState(false, false);
            }
            this.floatBoat();
            if (this.level().isClientSide) {
                this.controlBoat();
                this.level().sendPacketToServer(new PacketPlayInBoatMove(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3D.ZERO);
        }
        CraftServer server = this.level().getCraftServer();
        CraftWorld bworld = this.level().getWorld();
        Location to = CraftLocation.toBukkit(this.position(), (org.bukkit.World)bworld, this.getYRot(), this.getXRot());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.tickBubbleColumn();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.getPaddleState(i2)) {
                SoundEffect soundeffect;
                if (!this.isSilent() && (double)(this.paddlePositions[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.paddlePositions[i2] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundeffect = this.getPaddleSound()) != null) {
                    Vec3D vec3d = this.getViewVector(1.0f);
                    double d0 = i2 == 1 ? -vec3d.z : vec3d.z;
                    double d1 = i2 == 1 ? vec3d.x : -vec3d.x;
                    this.level().playSound((EntityHuman)null, this.getX() + d0, this.getY(), this.getZ() + d1, soundeffect, this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
                }
                int n2 = i2;
                this.paddlePositions[n2] = this.paddlePositions[n2] + 0.3926991f;
                continue;
            }
            this.paddlePositions[i2] = 0.0f;
        }
        this.checkInsideBlocks();
        List<Entity> list = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, -0.01f, 0.2f), IEntitySelector.pushableBy(this));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && !(this.getControllingPassenger() instanceof EntityHuman);
            for (Entity entity : list) {
                if (entity.hasPassenger(this)) continue;
                if (flag && this.getPassengers().size() < this.getMaxPassengers() && !entity.isPassenger() && this.hasEnoughSpaceFor(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman)) {
                    entity.startRiding(this);
                    continue;
                }
                this.push(entity);
            }
        }
    }

    private void tickBubbleColumn() {
        if (this.level().isClientSide) {
            int i2 = this.getBubbleTime();
            this.bubbleMultiplier = i2 > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = MathHelper.clamp(this.bubbleMultiplier, 0.0f, 1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.level().getGameTime()) * this.bubbleMultiplier;
        } else {
            int i3;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((i3 = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.setBubbleTime(0);
                    Vec3D vec3d = this.getDeltaMovement();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.setDeltaMovement(vec3d.add(0.0, -0.7, 0.0));
                        this.ejectPassengers();
                    } else {
                        this.setDeltaMovement(vec3d.x, this.hasPassenger((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.z);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEffect getPaddleSound() {
        switch (this.getStatus().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return SoundEffects.BOAT_PADDLE_WATER;
            }
            case 3: {
                return SoundEffects.BOAT_PADDLE_LAND;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public void setPaddleState(boolean flag, boolean flag1) {
        this.entityData.set(DATA_ID_PADDLE_LEFT, flag);
        this.entityData.set(DATA_ID_PADDLE_RIGHT, flag1);
    }

    public float getRowingTime(int i2, float f2) {
        return this.getPaddleState(i2) ? MathHelper.clampedLerp(this.paddlePositions[i2] - 0.3926991f, this.paddlePositions[i2], f2) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a getLeashData() {
        return this.leashData;
    }

    @Override
    public void setLeashData(@Nullable Leashable.a leashable_a) {
        this.leashData = leashable_a;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.88f * this.getEyeHeight(), this.getBbWidth() * 0.64f);
    }

    @Override
    public void elasticRangeLeashBehaviour(Entity entity, float f2) {
        Vec3D vec3d = entity.position().subtract(this.position()).normalize().scale((double)f2 - 6.0);
        Vec3D vec3d1 = this.getDeltaMovement();
        boolean flag = vec3d1.dot(vec3d) > 0.0;
        this.setDeltaMovement(vec3d1.add(vec3d.scale(flag ? (double)0.15f : (double)0.2f)));
    }

    private EnumStatus getStatus() {
        EnumStatus entityboat_enumstatus = this.isUnderwater();
        if (entityboat_enumstatus != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return entityboat_enumstatus;
        }
        if (this.checkInWater()) {
            return EnumStatus.IN_WATER;
        }
        float f2 = this.getGroundFriction();
        if (f2 > 0.0f) {
            this.landFriction = f2;
            return EnumStatus.ON_LAND;
        }
        return EnumStatus.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.ceil(axisalignedbb.maxX);
        int k2 = MathHelper.floor(axisalignedbb.maxY);
        int l2 = MathHelper.ceil(axisalignedbb.maxY - this.lastYd);
        int i1 = MathHelper.floor(axisalignedbb.minZ);
        int j1 = MathHelper.ceil(axisalignedbb.maxZ);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.set(l1, k1, i22);
                    Fluid fluid = this.level().getFluidState(blockposition_mutableblockposition);
                    if (fluid.is(TagsFluid.WATER)) {
                        f2 = Math.max(f2, fluid.getHeight(this.level(), blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.getY() + f2;
        }
        return l2 + 1;
    }

    public float getGroundFriction() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY - 0.001, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        int i2 = MathHelper.floor(axisalignedbb1.minX) - 1;
        int j2 = MathHelper.ceil(axisalignedbb1.maxX) + 1;
        int k2 = MathHelper.floor(axisalignedbb1.minY) - 1;
        int l2 = MathHelper.ceil(axisalignedbb1.maxY) + 1;
        int i1 = MathHelper.floor(axisalignedbb1.minZ) - 1;
        int j1 = MathHelper.ceil(axisalignedbb1.maxZ) + 1;
        VoxelShape voxelshape = VoxelShapes.create(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.set(l1, k22, i22);
                    IBlockData iblockdata = this.level().getBlockState(blockposition_mutableblockposition);
                    if (iblockdata.getBlock() instanceof BlockWaterLily || !VoxelShapes.joinIsNotEmpty(iblockdata.getCollisionShape(this.level(), blockposition_mutableblockposition).move(l1, k22, i22), voxelshape, OperatorBoolean.AND)) continue;
                    f2 += iblockdata.getBlock().getFriction();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.ceil(axisalignedbb.maxX);
        int k2 = MathHelper.floor(axisalignedbb.minY);
        int l2 = MathHelper.ceil(axisalignedbb.minY + 0.001);
        int i1 = MathHelper.floor(axisalignedbb.minZ);
        int j1 = MathHelper.ceil(axisalignedbb.maxZ);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.set(k1, l1, i22);
                    Fluid fluid = this.level().getFluidState(blockposition_mutableblockposition);
                    if (!fluid.is(TagsFluid.WATER)) continue;
                    float f2 = (float)l1 + fluid.getHeight(this.level(), blockposition_mutableblockposition);
                    this.waterLevel = Math.max((double)f2, this.waterLevel);
                    flag |= axisalignedbb.minY < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus isUnderwater() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        double d0 = axisalignedbb.maxY + 0.001;
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.ceil(axisalignedbb.maxX);
        int k2 = MathHelper.floor(axisalignedbb.maxY);
        int l2 = MathHelper.ceil(d0);
        int i1 = MathHelper.floor(axisalignedbb.minZ);
        int j1 = MathHelper.ceil(axisalignedbb.maxZ);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.set(k1, l1, i22);
                    Fluid fluid = this.level().getFluidState(blockposition_mutableblockposition);
                    if (!fluid.is(TagsFluid.WATER) || !(d0 < (double)((float)blockposition_mutableblockposition.getY() + fluid.getHeight(this.level(), blockposition_mutableblockposition)))) continue;
                    if (!fluid.isSource()) {
                        return EnumStatus.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.UNDER_WATER : null;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    private void floatBoat() {
        double d0 = -this.getGravity();
        double d1 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == EnumStatus.IN_AIR && this.status != EnumStatus.IN_AIR && this.status != EnumStatus.ON_LAND) {
            this.waterLevel = this.getY(1.0);
            double d2 = (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101;
            if (this.level().noCollision(this, this.getBoundingBox().move(0.0, d2 - this.getY(), 0.0))) {
                this.setPos(this.getX(), d2, this.getZ());
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                this.lastYd = 0.0;
            }
            this.status = EnumStatus.IN_WATER;
        } else {
            if (this.status == EnumStatus.IN_WATER) {
                d1 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                this.invFriction = 0.9f;
            } else if (this.status == EnumStatus.UNDER_FLOWING_WATER) {
                d0 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == EnumStatus.UNDER_WATER) {
                d1 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == EnumStatus.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == EnumStatus.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.getControllingPassenger() instanceof EntityHuman) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3D vec3d = this.getDeltaMovement();
            this.setDeltaMovement(vec3d.x * (double)this.invFriction, vec3d.y + d0, vec3d.z * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d1 > 0.0) {
                Vec3D vec3d1 = this.getDeltaMovement();
                this.setDeltaMovement(vec3d1.x, (vec3d1.y + d1 * (this.getDefaultGravity() / 0.65)) * 0.75, vec3d1.z);
            }
        }
    }

    private void controlBoat() {
        if (this.isVehicle()) {
            float f2 = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f2 += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                f2 += 0.04f;
            }
            if (this.inputDown) {
                f2 -= 0.005f;
            }
            this.setDeltaMovement(this.getDeltaMovement().add(MathHelper.sin(-this.getYRot() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * f2));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public boolean hasEnoughSpaceFor(Entity entity) {
        return entity.getBbWidth() < this.getBbWidth();
    }

    @Override
    protected void positionRider(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.positionRider(entity, entity_movefunction);
        if (!entity.getType().is(TagsEntity.CAN_TURN_IN_BOATS)) {
            entity.setYRot(entity.getYRot() + this.deltaRotation);
            entity.setYHeadRot(entity.getYHeadRot() + this.deltaRotation);
            this.clampRotation(entity);
            if (entity instanceof EntityAnimal && this.getPassengers().size() == this.getMaxPassengers()) {
                int i2 = entity.getId() % 2 == 0 ? 90 : 270;
                entity.setYBodyRot(((EntityAnimal)entity).yBodyRot + (float)i2);
                entity.setYHeadRot(entity.getYHeadRot() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving entityliving) {
        Vec3D vec3d = EntityBoat.getCollisionHorizontalEscapeVector(this.getBbWidth() * MathHelper.SQRT_OF_TWO, entityliving.getBbWidth(), entityliving.getYRot());
        double d0 = this.getX() + vec3d.x;
        double d1 = this.getZ() + vec3d.z;
        BlockPosition blockposition = BlockPosition.containing(d0, this.getBoundingBox().maxY, d1);
        BlockPosition blockposition1 = blockposition.below();
        if (!this.level().isWaterAt(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.level().getBlockFloorHeight(blockposition);
            if (DismountUtil.isBlockFloorValid(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.getY() + d2, d1));
            }
            if (DismountUtil.isBlockFloorValid(d3 = this.level().getBlockFloorHeight(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.getY() + d3, d1));
            }
            for (EntityPose entitypose : entityliving.getDismountPoses()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.canDismountTo(this.level(), vec3d1, entityliving, entitypose)) continue;
                    entityliving.setPose(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.getDismountLocationForPassenger(entityliving);
    }

    protected void clampRotation(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f2 = MathHelper.wrapDegrees(entity.getYRot() - this.getYRot());
        float f1 = MathHelper.clamp(f2, -105.0f, 105.0f);
        entity.yRotO += f1 - f2;
        entity.setYRot(entity.getYRot() + f1 - f2);
        entity.setYHeadRot(entity.getYRot());
    }

    @Override
    public void onPassengerTurned(Entity entity) {
        this.clampRotation(entity);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.writeLeashData(nbttagcompound, this.leashData);
        nbttagcompound.putString("Type", this.getVariant().getSerializedName());
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.leashData = this.readLeashData(nbttagcompound);
        if (nbttagcompound.contains("Type", 8)) {
            this.setVariant(EnumBoatType.byName(nbttagcompound.getString("Type")));
        }
    }

    @Override
    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.interact(entityhuman, enumhand);
        return enuminteractionresult != EnumInteractionResult.PASS ? enuminteractionresult : (entityhuman.isSecondaryUseActive() ? EnumInteractionResult.PASS : (this.outOfControlTicks < 60.0f ? (!this.level().isClientSide ? (entityhuman.startRiding(this) ? EnumInteractionResult.CONSUME : EnumInteractionResult.PASS) : EnumInteractionResult.SUCCESS) : EnumInteractionResult.PASS));
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (!this.level().isClientSide && entity_removalreason.shouldDestroy() && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (flag) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != EnumStatus.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.kill();
                            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                int i2;
                                for (i2 = 0; i2 < 3; ++i2) {
                                    this.spawnAtLocation(this.getVariant().getPlanks());
                                }
                                for (i2 = 0; i2 < 2; ++i2) {
                                    this.spawnAtLocation(Items.STICK);
                                }
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(TagsFluid.WATER) && d0 < 0.0) {
                this.fallDistance -= (float)d0;
            }
        }
    }

    public boolean getPaddleState(int i2) {
        return this.entityData.get(i2 == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.getControllingPassenger() != null;
    }

    private void setBubbleTime(int i2) {
        this.entityData.set(DATA_ID_BUBBLE_TIME, i2);
    }

    private int getBubbleTime() {
        return this.entityData.get(DATA_ID_BUBBLE_TIME);
    }

    public float getBubbleAngle(float f2) {
        return MathHelper.lerp(f2, this.bubbleAngleO, this.bubbleAngle);
    }

    @Override
    public void setVariant(EnumBoatType entityboat_enumboattype) {
        this.entityData.set(DATA_ID_TYPE, entityboat_enumboattype.ordinal());
    }

    @Override
    public EnumBoatType getVariant() {
        return EnumBoatType.byId(this.entityData.get(DATA_ID_TYPE));
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < this.getMaxPassengers() && !this.isEyeInFluid(TagsFluid.WATER);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        EntityLiving entityliving1;
        Entity entity = this.getFirstPassenger();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : super.getControllingPassenger();
        return entityliving;
    }

    public void setInput(boolean flag, boolean flag1, boolean flag2, boolean flag3) {
        this.inputLeft = flag;
        this.inputRight = flag1;
        this.inputUp = flag2;
        this.inputDown = flag3;
    }

    @Override
    protected IChatBaseComponent getTypeName() {
        return IChatBaseComponent.translatable(this.getDropItem().getDescriptionId());
    }

    @Override
    public boolean isUnderWater() {
        return this.status == EnumStatus.UNDER_WATER || this.status == EnumStatus.UNDER_FLOWING_WATER;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(this.getDropItem());
    }

    public static enum EnumBoatType implements INamable
    {
        OAK(Blocks.OAK_PLANKS, "oak"),
        SPRUCE(Blocks.SPRUCE_PLANKS, "spruce"),
        BIRCH(Blocks.BIRCH_PLANKS, "birch"),
        JUNGLE(Blocks.JUNGLE_PLANKS, "jungle"),
        ACACIA(Blocks.ACACIA_PLANKS, "acacia"),
        CHERRY(Blocks.CHERRY_PLANKS, "cherry"),
        DARK_OAK(Blocks.DARK_OAK_PLANKS, "dark_oak"),
        MANGROVE(Blocks.MANGROVE_PLANKS, "mangrove"),
        BAMBOO(Blocks.BAMBOO_PLANKS, "bamboo");

        private final String name;
        private final Block planks;
        public static final INamable.a<EnumBoatType> CODEC;
        private static final IntFunction<EnumBoatType> BY_ID;

        private EnumBoatType(Block block, String s2) {
            this.name = s2;
            this.planks = block;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static EnumBoatType byId(int i2) {
            return BY_ID.apply(i2);
        }

        public static EnumBoatType byName(String s2) {
            return CODEC.byName(s2, OAK);
        }

        static {
            CODEC = INamable.fromEnum(EnumBoatType::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, EnumBoatType.values(), ByIdMap.a.ZERO);
        }
    }

    public static enum EnumStatus {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

